/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.inquiry;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.bo.DataObjectRelationship;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.datadictionary.exception.UnknownBusinessClassAttributeException;
import org.kuali.kfs.krad.inquiry.Inquirable;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.DataObjectAuthorizationService;
import org.kuali.kfs.krad.service.DataObjectMetaDataService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.uif.service.impl.ViewHelperServiceImpl;
import org.kuali.kfs.krad.uif.widget.Inquiry;
import org.kuali.kfs.krad.util.ExternalizableBusinessObjectUtils;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class InquirableImpl
extends ViewHelperServiceImpl
implements Inquirable {
    private static final Logger LOG = LogManager.getLogger(InquirableImpl.class);
    protected Class<?> dataObjectClass;
    public static List<Class<?>> SUPER_CLASS_TRANSLATOR_LIST = new ArrayList();

    @Override
    public Object retrieveDataObject(Map<String, String> parameters) {
        if (this.dataObjectClass == null) {
            LOG.error("Data object class must be set in inquirable before retrieving the object");
            throw new RuntimeException("Data object class must be set in inquirable before retrieving the object");
        }
        List<String> pkPropertyNames = this.getDataObjectMetaDataService().listPrimaryKeyFieldNames(this.dataObjectClass);
        List<List<String>> alternateKeyNames = this.getAlternateKeysForClass(this.dataObjectClass);
        alternateKeyNames.add(0, pkPropertyNames);
        List<String> dataObjectKeySet = this.retrieveKeySetFromMap(alternateKeyNames, parameters);
        if (dataObjectKeySet == null || dataObjectKeySet.isEmpty()) {
            LOG.warn("Matching key set not found in request for class: " + this.getDataObjectClass());
            return null;
        }
        HashMap<String, Object> keyPropertyValues = new HashMap<String, Object>();
        for (String keyPropertyName : dataObjectKeySet) {
            String keyPropertyValue = parameters.get(keyPropertyName);
            Boolean forceUppercase = Boolean.FALSE;
            try {
                forceUppercase = this.getDataDictionaryService().getAttributeForceUppercase(this.dataObjectClass, keyPropertyName);
            }
            catch (UnknownBusinessClassAttributeException ex) {
                LOG.warn("Data object class " + this.dataObjectClass + " property " + keyPropertyName + " should probably have a DD definition.", (Throwable)ex);
            }
            if (forceUppercase.booleanValue() && keyPropertyValue != null) {
                keyPropertyValue = keyPropertyValue.toUpperCase();
            }
            if (this.getDataObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(this.dataObjectClass, keyPropertyName)) {
                try {
                    if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                        keyPropertyValue = this.getEncryptionService().decrypt(keyPropertyValue);
                    }
                }
                catch (GeneralSecurityException e) {
                    LOG.error("Data object class " + this.dataObjectClass + " property " + keyPropertyName + " should have been encrypted, but there was a problem decrypting it.", (Throwable)e);
                    throw new RuntimeException("Data object class " + this.dataObjectClass + " property " + keyPropertyName + " should have been encrypted, but there was a problem decrypting it.", e);
                }
            }
            keyPropertyValues.put(keyPropertyName, keyPropertyValue);
        }
        ExternalizableBusinessObject dataObject = null;
        ModuleService moduleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(this.getDataObjectClass());
        if (moduleService != null && moduleService.isExternalizable(this.getDataObjectClass())) {
            dataObject = moduleService.getExternalizableBusinessObject(this.getDataObjectClass().asSubclass(ExternalizableBusinessObject.class), keyPropertyValues);
        } else if (BusinessObject.class.isAssignableFrom(this.getDataObjectClass())) {
            dataObject = this.getBusinessObjectService().findByPrimaryKey(this.getDataObjectClass().asSubclass(BusinessObject.class), keyPropertyValues);
        }
        return dataObject;
    }

    protected List<String> retrieveKeySetFromMap(List<List<String>> potentialKeySets, Map<String, String> parameters) {
        List<String> foundKeySet = null;
        for (List<String> potentialKeySet : potentialKeySets) {
            boolean keySetMatch = true;
            for (String keyName : potentialKeySet) {
                if (parameters.containsKey(keyName) && !StringUtils.isBlank((CharSequence)parameters.get(keyName))) continue;
                keySetMatch = false;
            }
            if (!keySetMatch) continue;
            foundKeySet = potentialKeySet;
            break;
        }
        return foundKeySet;
    }

    protected List<List<String>> getAlternateKeysForClass(Class<?> clazz) {
        KualiModuleService kualiModuleService = this.getKualiModuleService();
        ModuleService moduleService = kualiModuleService.getResponsibleModuleService(clazz);
        ArrayList altKeys = null;
        if (moduleService != null) {
            altKeys = moduleService.listAlternatePrimaryKeyFieldNames(clazz);
        }
        return altKeys != null ? altKeys : new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildInquirableLink(Object dataObject, String propertyName, Inquiry inquiry) {
        Object documentNumber;
        String nestedPropertyName;
        Object nestedPropertyObject;
        Class inquiryObjectClass = null;
        Class objectClass = ObjectUtils.materializeClassForProxiedObject(dataObject);
        if (propertyName.equals(this.getDataObjectMetaDataService().getTitleAttribute(objectClass))) {
            inquiryObjectClass = objectClass;
        } else if (ObjectUtils.isNestedAttribute(propertyName) && ObjectUtils.isNotNull(nestedPropertyObject = ObjectUtils.getNestedValue(dataObject, nestedPropertyName = ObjectUtils.getNestedAttributePrefix(propertyName)))) {
            String nestedPropertyPrimitive = ObjectUtils.getNestedAttributePrimitive(propertyName);
            Class iterator = ObjectUtils.materializeClassForProxiedObject(nestedPropertyObject);
            if (nestedPropertyPrimitive.equals(this.getDataObjectMetaDataService().getTitleAttribute(iterator))) {
                inquiryObjectClass = iterator;
            }
        }
        DataObjectRelationship relationship = null;
        if (inquiryObjectClass == null && (relationship = this.getDataObjectMetaDataService().getDataObjectRelationship(dataObject, objectClass, propertyName, "", true, false, true)) != null) {
            inquiryObjectClass = relationship.getRelatedClass();
        }
        if (inquiryObjectClass == null) {
            inquiry.setRender(false);
            return;
        }
        if (DocumentHeader.class.isAssignableFrom(inquiryObjectClass)) {
            documentNumber = (String)ObjectUtils.getPropertyValue(dataObject, propertyName);
            if (StringUtils.isNotBlank((CharSequence)documentNumber)) {
                inquiry.getInquiryLinkField().setHrefText(this.getConfigurationService().getPropertyValueAsString("workflow.url") + "/DocHandler.do?docId=" + (String)documentNumber + "&command=displayDocSearchView");
                inquiry.getInquiryLinkField().setLinkLabel((String)documentNumber);
                inquiry.setRender(true);
            }
            return;
        }
        documentNumber = SUPER_CLASS_TRANSLATOR_LIST;
        synchronized (documentNumber) {
            for (Class clazz : SUPER_CLASS_TRANSLATOR_LIST) {
                if (!clazz.isAssignableFrom(inquiryObjectClass)) continue;
                inquiryObjectClass = clazz;
                break;
            }
        }
        if (!inquiryObjectClass.isInterface() && ExternalizableBusinessObject.class.isAssignableFrom(inquiryObjectClass)) {
            inquiryObjectClass = ExternalizableBusinessObjectUtils.determineExternalizableBusinessObjectSubInterface(inquiryObjectClass);
        }
        ArrayList<String> keys = new ArrayList<String>(this.getDataObjectMetaDataService().listPrimaryKeyFieldNames(inquiryObjectClass));
        HashMap<String, String> inquiryParameters = new HashMap<String, String>();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String keyName;
            String keyConversion = keyName = (String)iterator.next();
            if (relationship != null) {
                keyConversion = relationship.getParentAttributeForChildAttribute(keyName);
            } else if (ObjectUtils.isNestedAttribute(propertyName)) {
                String nestedAttributePrefix = ObjectUtils.getNestedAttributePrefix(propertyName);
                keyConversion = nestedAttributePrefix + "." + keyName;
            }
            inquiryParameters.put(keyConversion, keyName);
        }
        inquiry.buildInquiryLink(dataObject, propertyName, inquiryObjectClass, inquiryParameters);
    }

    @Override
    public void setDataObjectClass(Class<?> dataObjectClass) {
        this.dataObjectClass = dataObjectClass;
    }

    protected Class<?> getDataObjectClass() {
        return this.dataObjectClass;
    }

    protected ConfigurationService getConfigurationService() {
        return KRADServiceLocator.getKualiConfigurationService();
    }

    protected DataObjectMetaDataService getDataObjectMetaDataService() {
        return KRADServiceLocatorWeb.getDataObjectMetaDataService();
    }

    protected KualiModuleService getKualiModuleService() {
        return KRADServiceLocatorWeb.getKualiModuleService();
    }

    @Override
    protected DataDictionaryService getDataDictionaryService() {
        return KRADServiceLocatorWeb.getDataDictionaryService();
    }

    protected DataObjectAuthorizationService getDataObjectAuthorizationService() {
        return KRADServiceLocatorWeb.getDataObjectAuthorizationService();
    }

    protected EncryptionService getEncryptionService() {
        return CoreApiServiceLocator.getEncryptionService();
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KRADServiceLocator.getBusinessObjectService();
    }
}

