/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.inquiry.Inquirable;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.datadictionary.LookupResultAttributeDefinition;
import org.kuali.rice.kim.api.identity.Person;

public abstract class LookupSearchService {
    private static final Logger LOG = LogManager.getLogger();
    protected static String KRAD_URL_PREFIX = "kr/";
    private BusinessObjectAuthorizationService businessObjectAuthorizationService;
    private BusinessObjectDictionaryService businessObjectDictionaryService;

    public abstract Pair<Collection<? extends BusinessObjectBase>, Integer> getSearchResults(Class<? extends BusinessObjectBase> var1, MultivaluedMap<String, String> var2, int var3, int var4, String var5, boolean var6);

    public abstract List<Map<String, Object>> getActionLinks(BusinessObjectBase var1, Person var2);

    public List<LookupResultAttributeDefinition> getSearchResultsAttributes(Class classForType) {
        return this.getLookupResultAttributeDefinitionsForClass(classForType);
    }

    public boolean hasInquiry(BusinessObjectBase businessObject, LookupResultAttributeDefinition resultAttributeDefinition) {
        String url = this.inquiryUrl(businessObject, resultAttributeDefinition.getName());
        return !resultAttributeDefinition.isDisableInquiry() && !StringUtils.isEmpty((CharSequence)url);
    }

    public String inquiryUrl(BusinessObjectBase businessObject, String propertyName) {
        Inquirable inquirable;
        Class<?> businessObjectClass = businessObject.getClass();
        Class inquirableClass = this.businessObjectDictionaryService.getInquirableClass(businessObjectClass);
        if (inquirableClass != null) {
            try {
                inquirable = (Inquirable)inquirableClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                LOG.warn("Could not instantiate inquirable for class" + inquirableClass.getSimpleName());
                return "";
            }
        } else {
            inquirable = KNSServiceLocator.getKualiInquirable();
        }
        Boolean forceLookupResultFieldInquiry = this.businessObjectDictionaryService.forceLookupResultFieldInquiry(businessObjectClass, propertyName);
        forceLookupResultFieldInquiry = Boolean.TRUE.equals(forceLookupResultFieldInquiry);
        HtmlData.AnchorHtmlData inquiryData = (HtmlData.AnchorHtmlData)inquirable.getInquiryUrl(businessObject, propertyName, forceLookupResultFieldInquiry);
        if (StringUtils.isBlank((CharSequence)inquiryData.getHref())) {
            return "";
        }
        String inquiryUrl = KRAD_URL_PREFIX + inquiryData.getHref();
        String objectLabel = inquiryData.getObjectLabel();
        if (StringUtils.isNotBlank((CharSequence)objectLabel)) {
            inquiryUrl = inquiryUrl + "&title=" + objectLabel;
        }
        return inquiryUrl;
    }

    protected List<LookupResultAttributeDefinition> getLookupResultAttributeDefinitionsForClass(Class classForType) {
        return this.businessObjectDictionaryService.getLookupResultAttributeDefinitions(classForType);
    }

    public BusinessObjectAuthorizationService getBusinessObjectAuthorizationService() {
        return this.businessObjectAuthorizationService;
    }

    public void setBusinessObjectAuthorizationService(BusinessObjectAuthorizationService businessObjectAuthorizationService) {
        this.businessObjectAuthorizationService = businessObjectAuthorizationService;
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }

    public BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        return this.businessObjectDictionaryService;
    }
}

