/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.datadictionary.DocumentEntry;
import org.kuali.kfs.krad.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.krad.datadictionary.ReferenceDefinition;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.DocumentAuthorizer;
import org.kuali.kfs.krad.document.DocumentAuthorizerBase;
import org.kuali.kfs.krad.document.DocumentPresentationController;
import org.kuali.kfs.krad.document.DocumentPresentationControllerBase;
import org.kuali.kfs.krad.maintenance.Maintainable;
import org.kuali.kfs.krad.maintenance.MaintenanceDocument;
import org.kuali.kfs.krad.maintenance.MaintenanceDocumentAuthorizerBase;
import org.kuali.kfs.krad.maintenance.MaintenanceDocumentPresentationControllerBase;
import org.kuali.kfs.krad.rules.rule.BusinessRule;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.DocumentDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;

public class DocumentDictionaryServiceImpl
implements DocumentDictionaryService {
    private DataDictionaryService dataDictionaryService;

    @Override
    public String getLabel(String documentTypeName) {
        String label = null;
        DocumentType docType = this.getDocumentType(documentTypeName);
        if (docType != null) {
            label = docType.getLabel();
        }
        return label;
    }

    @Override
    public String getMaintenanceDocumentTypeName(Class dataObjectClass) {
        String documentTypeName = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(dataObjectClass);
        if (entry != null) {
            documentTypeName = entry.getDocumentTypeName();
        }
        return documentTypeName;
    }

    @Override
    public String getDescription(String documentTypeName) {
        String description = null;
        DocumentType docType = this.getDocumentType(documentTypeName);
        if (docType != null) {
            description = docType.getDescription();
        }
        return description;
    }

    @Override
    public Collection getDefaultExistenceChecks(Class dataObjectClass) {
        return this.getDefaultExistenceChecks(this.getMaintenanceDocumentTypeName(dataObjectClass));
    }

    @Override
    public Collection getDefaultExistenceChecks(Document document) {
        return this.getDefaultExistenceChecks(this.getDocumentEntry(document).getDocumentTypeName());
    }

    @Override
    public Collection getDefaultExistenceChecks(String docTypeName) {
        List<ReferenceDefinition> defaultExistenceChecks = null;
        DocumentEntry entry = this.getDocumentEntry(docTypeName);
        if (entry != null) {
            defaultExistenceChecks = entry.getDefaultExistenceChecks();
        }
        return defaultExistenceChecks;
    }

    @Override
    public Class<?> getMaintenanceDataObjectClass(String docTypeName) {
        Class<?> dataObjectClass = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(docTypeName);
        if (entry != null) {
            dataObjectClass = entry.getDataObjectClass();
        }
        return dataObjectClass;
    }

    @Override
    public Class<? extends Maintainable> getMaintainableClass(String docTypeName) {
        Class<? extends Maintainable> maintainableClass = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(docTypeName);
        if (entry != null) {
            maintainableClass = entry.getMaintainableClass();
        }
        return maintainableClass;
    }

    @Override
    public Class<? extends BusinessRule> getBusinessRulesClass(Document document) {
        Class<? extends BusinessRule> businessRulesClass = null;
        String docTypeName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        DocumentEntry entry = this.getDocumentEntry(docTypeName);
        if (entry != null) {
            businessRulesClass = entry.getBusinessRulesClass();
        }
        return businessRulesClass;
    }

    @Override
    public Boolean getAllowsCopy(Document document) {
        Boolean allowsCopy = Boolean.FALSE;
        if (document == null) {
            return false;
        }
        DocumentEntry entry = null;
        if (document instanceof MaintenanceDocument) {
            MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
            if (maintenanceDocument.getNewMaintainableObject() != null) {
                entry = this.getMaintenanceDocumentEntry(maintenanceDocument.getNewMaintainableObject().getDataObjectClass());
            }
        } else {
            entry = this.getDocumentEntry(document);
        }
        if (entry != null) {
            allowsCopy = entry.getAllowsCopy();
        }
        return allowsCopy;
    }

    @Override
    public Boolean getAllowsNewOrCopy(String docTypeName) {
        MaintenanceDocumentEntry entry;
        Boolean allowsNewOrCopy = Boolean.FALSE;
        if (docTypeName != null && (entry = this.getMaintenanceDocumentEntry(docTypeName)) != null) {
            allowsNewOrCopy = entry.getAllowsNewOrCopy();
        }
        return allowsNewOrCopy;
    }

    @Override
    public DocumentEntry getDocumentEntry(String documentTypeName) {
        if (documentTypeName == null) {
            throw new IllegalArgumentException("invalid (null) document type name");
        }
        return this.getDataDictionary().getDocumentEntry(documentTypeName);
    }

    @Override
    public DocumentEntry getDocumentEntryByClass(Class<? extends Document> documentClass) {
        DocumentEntry entry = null;
        String documentTypeName = this.getDocumentTypeByClass(documentClass);
        if (StringUtils.isNotBlank((CharSequence)documentTypeName)) {
            entry = this.getDocumentEntry(documentTypeName);
        }
        return entry;
    }

    @Override
    public MaintenanceDocumentEntry getMaintenanceDocumentEntry(String docTypeName) {
        if (StringUtils.isBlank((CharSequence)docTypeName)) {
            throw new IllegalArgumentException("invalid (blank) docTypeName");
        }
        return (MaintenanceDocumentEntry)this.getDataDictionary().getDocumentEntry(docTypeName);
    }

    @Override
    public Class<?> getDocumentClassByName(String documentTypeName) {
        Class<? extends Document> documentClass = null;
        DocumentEntry entry = this.getDocumentEntry(documentTypeName);
        if (entry != null) {
            documentClass = entry.getDocumentClass();
        }
        return documentClass;
    }

    @Override
    public String getDocumentTypeByClass(Class<? extends Document> documentClass) {
        if (documentClass == null) {
            throw new IllegalArgumentException("invalid (null) document class");
        }
        DocumentEntry entry = this.getDataDictionary().getDocumentEntry(documentClass.getName());
        if (entry != null) {
            return entry.getDocumentTypeName();
        }
        return null;
    }

    @Override
    public Boolean getAllowsRecordDeletion(Class dataObjectClass) {
        Boolean allowsRecordDeletion = Boolean.FALSE;
        MaintenanceDocumentEntry docEntry = this.getMaintenanceDocumentEntry(dataObjectClass);
        if (docEntry != null) {
            allowsRecordDeletion = docEntry.getAllowsRecordDeletion();
        }
        return allowsRecordDeletion;
    }

    @Override
    public Boolean getAllowsRecordDeletion(MaintenanceDocument document) {
        return document != null ? this.getAllowsRecordDeletion(document.getNewMaintainableObject().getDataObjectClass()) : Boolean.FALSE;
    }

    @Override
    public List<String> getLockingKeys(String docTypeName) {
        List<String> lockingKeys = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(docTypeName);
        if (entry != null) {
            lockingKeys = entry.getLockingKeyFieldNames();
        }
        return lockingKeys;
    }

    @Override
    public boolean getPreserveLockingKeysOnCopy(Class dataObjectClass) {
        boolean preserveLockingKeysOnCopy = false;
        MaintenanceDocumentEntry docEntry = this.getMaintenanceDocumentEntry(dataObjectClass);
        if (docEntry != null) {
            preserveLockingKeysOnCopy = docEntry.getPreserveLockingKeysOnCopy();
        }
        return preserveLockingKeysOnCopy;
    }

    @Override
    public DocumentAuthorizer getDocumentAuthorizer(String documentType) {
        DocumentAuthorizer documentAuthorizer;
        DataDictionary dataDictionary = this.getDataDictionaryService().getDataDictionary();
        if (StringUtils.isBlank((CharSequence)documentType)) {
            throw new IllegalArgumentException("invalid (blank) documentType");
        }
        DocumentEntry documentEntry = dataDictionary.getDocumentEntry(documentType);
        if (documentEntry == null) {
            throw new IllegalArgumentException("unknown documentType '" + documentType + "'");
        }
        Class<? extends DocumentAuthorizer> documentAuthorizerClass = documentEntry.getDocumentAuthorizerClass();
        try {
            documentAuthorizer = documentAuthorizerClass != null ? documentAuthorizerClass.newInstance() : (documentEntry instanceof MaintenanceDocumentEntry ? new MaintenanceDocumentAuthorizerBase() : new DocumentAuthorizerBase());
        }
        catch (Exception e) {
            throw new RuntimeException("unable to instantiate documentAuthorizer '" + documentAuthorizerClass.getName() + "' for doctype '" + documentType + "'", e);
        }
        return documentAuthorizer;
    }

    @Override
    public DocumentAuthorizer getDocumentAuthorizer(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("invalid (null) document");
        }
        if (document.getDocumentHeader() == null) {
            throw new IllegalArgumentException("invalid (null) document.documentHeader");
        }
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            throw new IllegalArgumentException("invalid (null) document.documentHeader.workflowDocument");
        }
        String documentType = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        return this.getDocumentAuthorizer(documentType);
    }

    @Override
    public DocumentPresentationController getDocumentPresentationController(String documentType) {
        DocumentPresentationController documentPresentationController;
        DataDictionary dataDictionary = this.getDataDictionaryService().getDataDictionary();
        if (StringUtils.isBlank((CharSequence)documentType)) {
            throw new IllegalArgumentException("invalid (blank) documentType");
        }
        DocumentEntry documentEntry = dataDictionary.getDocumentEntry(documentType);
        if (documentEntry == null) {
            throw new IllegalArgumentException("unknown documentType '" + documentType + "'");
        }
        Class<? extends DocumentPresentationController> documentPresentationControllerClass = documentEntry.getDocumentPresentationControllerClass();
        try {
            documentPresentationController = documentPresentationControllerClass != null ? documentPresentationControllerClass.newInstance() : (documentEntry instanceof MaintenanceDocumentEntry ? new MaintenanceDocumentPresentationControllerBase() : new DocumentPresentationControllerBase());
        }
        catch (Exception e) {
            throw new RuntimeException("unable to instantiate documentAuthorizer '" + documentPresentationControllerClass.getName() + "' for doctype '" + documentType + "'", e);
        }
        return documentPresentationController;
    }

    @Override
    public DocumentPresentationController getDocumentPresentationController(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("invalid (null) document");
        }
        if (document.getDocumentHeader() == null) {
            throw new IllegalArgumentException("invalid (null) document.documentHeader");
        }
        if (!document.getDocumentHeader().hasWorkflowDocument()) {
            throw new IllegalArgumentException("invalid (null) document.documentHeader.workflowDocument");
        }
        String documentType = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        return this.getDocumentPresentationController(documentType);
    }

    protected MaintenanceDocumentEntry getMaintenanceDocumentEntry(Class dataObjectClass) {
        if (dataObjectClass == null) {
            throw new IllegalArgumentException("invalid (blank) dataObjectClass");
        }
        return this.getDataDictionary().getMaintenanceDocumentEntryForBusinessObjectClass(dataObjectClass);
    }

    protected DocumentEntry getDocumentEntry(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("invalid (null) document");
        }
        return this.getDataDictionary().getDocumentEntry(document.getClass().getName());
    }

    protected DocumentType getDocumentType(String documentTypeName) {
        return KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(documentTypeName);
    }

    protected DataDictionary getDataDictionary() {
        return this.getDataDictionaryService().getDataDictionary();
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

