/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.krad.bo.DataObjectRelationship;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.dao.MaintenanceDocumentDao;
import org.kuali.kfs.krad.exception.DocumentTypeAuthorizationException;
import org.kuali.kfs.krad.maintenance.Maintainable;
import org.kuali.kfs.krad.maintenance.MaintenanceDocument;
import org.kuali.kfs.krad.maintenance.MaintenanceLock;
import org.kuali.kfs.krad.service.DataObjectAuthorizationService;
import org.kuali.kfs.krad.service.DataObjectMetaDataService;
import org.kuali.kfs.krad.service.DocumentDictionaryService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.MaintenanceDocumentService;
import org.kuali.kfs.krad.uif.util.ObjectPropertyUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.framework.persistence.jta.TransactionalNoValidationExceptionRollback;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.beans.PropertyAccessorUtils;

@TransactionalNoValidationExceptionRollback
public class MaintenanceDocumentServiceImpl
implements MaintenanceDocumentService {
    protected static final Logger LOG = LogManager.getLogger(MaintenanceDocumentServiceImpl.class);
    private MaintenanceDocumentDao maintenanceDocumentDao;
    private DataObjectAuthorizationService dataObjectAuthorizationService;
    private DocumentService documentService;
    private DataObjectMetaDataService dataObjectMetaDataService;
    private DocumentDictionaryService documentDictionaryService;
    protected BusinessObjectMetaDataService businessObjectMetaDataService;
    protected IdentityService identityService;
    protected MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;

    @Override
    public MaintenanceDocument setupNewMaintenanceDocument(String objectClassName, String documentTypeName, String maintenanceAction) {
        if (StringUtils.isEmpty((CharSequence)objectClassName) && StringUtils.isEmpty((CharSequence)documentTypeName)) {
            throw new IllegalArgumentException("Document type name or bo class not given!");
        }
        if (StringUtils.isEmpty((CharSequence)documentTypeName)) {
            try {
                documentTypeName = this.getDocumentDictionaryService().getMaintenanceDocumentTypeName(Class.forName(objectClassName));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (StringUtils.isEmpty((CharSequence)documentTypeName)) {
                throw new RuntimeException("documentTypeName is empty; does this Business Object have a maintenance document definition? " + objectClassName);
            }
        }
        if ("New".equals(maintenanceAction) || "Copy".equals(maintenanceAction)) {
            Class<?> boClass = this.getDocumentDictionaryService().getMaintenanceDataObjectClass(documentTypeName);
            boolean allowsNewOrCopy = this.getDataObjectAuthorizationService().canCreate(boClass, GlobalVariables.getUserSession().getPerson(), documentTypeName);
            if (!allowsNewOrCopy) {
                LOG.error("Document type " + documentTypeName + " does not allow new or copy actions.");
                throw new DocumentTypeAuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "newOrCopy", documentTypeName);
            }
        }
        try {
            return (MaintenanceDocument)this.getDocumentService().getNewDocument(documentTypeName);
        }
        catch (WorkflowException e) {
            LOG.error("Cannot get new maintenance document instance for doc type: " + documentTypeName, (Throwable)e);
            throw new RuntimeException("Cannot get new maintenance document instance for doc type: " + documentTypeName, e);
        }
    }

    @Override
    public void setupMaintenanceObject(MaintenanceDocument document, String maintenanceAction, Map<String, String[]> requestParameters) {
        document.getNewMaintainableObject().setMaintenanceAction(maintenanceAction);
        document.getOldMaintainableObject().setMaintenanceAction(maintenanceAction);
        if (!"New".equals(maintenanceAction) && !"newWithExisting".equals(maintenanceAction)) {
            Object oldDataObject = this.retrieveObjectForMaintenance(document, requestParameters);
            Serializable newDataObject = ObjectUtils.deepCopy((Serializable)oldDataObject);
            document.getOldMaintainableObject().setDataObject(oldDataObject);
            document.getNewMaintainableObject().setDataObject(newDataObject);
            if ("Copy".equals(maintenanceAction)) {
                this.processMaintenanceObjectForCopy(document, newDataObject, requestParameters);
            } else {
                this.checkMaintenanceActionAuthorization(document, oldDataObject, maintenanceAction, requestParameters);
            }
        }
        if ("newWithExisting".equals(maintenanceAction)) {
            Object newBO = document.getNewMaintainableObject().getDataObject();
            Map<String, String> parameters = this.buildKeyMapFromRequest(requestParameters, document.getNewMaintainableObject().getDataObjectClass());
            ObjectPropertyUtils.copyPropertiesToObject(parameters, newBO);
            if (newBO instanceof PersistableBusinessObject) {
                ((PersistableBusinessObject)newBO).refresh();
            }
            document.getNewMaintainableObject().setupNewFromExisting(document, requestParameters);
        } else if ("New".equals(maintenanceAction)) {
            document.getNewMaintainableObject().processAfterNew(document, requestParameters);
        }
    }

    protected void checkMaintenanceActionAuthorization(MaintenanceDocument document, Object oldBusinessObject, String maintenanceAction, Map<String, String[]> requestParameters) {
        boolean allowsDelete;
        if ("Edit".equals(maintenanceAction)) {
            boolean allowsEdit = this.getDataObjectAuthorizationService().canMaintain(oldBusinessObject, GlobalVariables.getUserSession().getPerson(), document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            if (!allowsEdit) {
                LOG.error("Document type " + document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName() + " does not allow edit actions.");
                throw new DocumentTypeAuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "edit", document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            }
            document.getNewMaintainableObject().processAfterEdit(document, requestParameters);
        } else if ("Delete".equals(maintenanceAction) && !(allowsDelete = this.getDataObjectAuthorizationService().canMaintain(oldBusinessObject, GlobalVariables.getUserSession().getPerson(), document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName()))) {
            LOG.error("Document type " + document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName() + " does not allow delete actions.");
            throw new DocumentTypeAuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "delete", document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        }
    }

    protected Object retrieveObjectForMaintenance(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        Map<String, String> keyMap = this.buildKeyMapFromRequest(requestParameters, document.getNewMaintainableObject().getDataObjectClass());
        Object oldDataObject = document.getNewMaintainableObject().retrieveObjectForEditOrCopy(document, keyMap);
        if (oldDataObject == null && !document.getOldMaintainableObject().isExternalBusinessObject()) {
            throw new RuntimeException("Cannot retrieve old record for maintenance document, incorrect parameters passed on maint url: " + requestParameters);
        }
        if (document.getOldMaintainableObject().isExternalBusinessObject()) {
            if (oldDataObject == null) {
                try {
                    oldDataObject = document.getOldMaintainableObject().getDataObjectClass().newInstance();
                }
                catch (Exception ex) {
                    throw new RuntimeException("External BO maintainable was null and unable to instantiate for old maintainable object.", ex);
                }
            }
            this.populateMaintenanceObjectWithCopyKeyValues(KRADUtils.translateRequestParameterMap(requestParameters), oldDataObject, document.getOldMaintainableObject());
            document.getOldMaintainableObject().prepareExternalBusinessObject((PersistableBusinessObject)oldDataObject);
            oldDataObject = document.getOldMaintainableObject().getDataObject();
        }
        return oldDataObject;
    }

    protected void processMaintenanceObjectForCopy(MaintenanceDocument document, Object maintenanceObject, Map<String, String[]> requestParameters) {
        if (!document.isFieldsClearedOnCopy()) {
            Maintainable maintainable = document.getNewMaintainableObject();
            if (!this.getDocumentDictionaryService().getPreserveLockingKeysOnCopy(maintainable.getDataObjectClass())) {
                this.clearPrimaryKeyFields(maintenanceObject, maintainable.getDataObjectClass());
            }
            this.clearUnauthorizedNewFields(document);
            maintainable.processAfterCopy(document, requestParameters);
            document.setFieldsClearedOnCopy(true);
        }
    }

    protected void clearPrimaryKeyFields(Object maintenanceObject, Class<?> dataObjectClass) {
        List<String> keyFieldNames = this.getDataObjectMetaDataService().listPrimaryKeyFieldNames(dataObjectClass);
        for (String keyFieldName : keyFieldNames) {
            ObjectPropertyUtils.setPropertyValue(maintenanceObject, keyFieldName, null);
        }
    }

    protected void clearUnauthorizedNewFields(MaintenanceDocument document) {
    }

    protected Map<String, String> buildKeyMapFromRequest(Map<String, String[]> requestParameters, Class<?> dataObjectClass) {
        List<String> keyFieldNames;
        Map<String, String> parameters = KRADUtils.translateRequestParameterMap(requestParameters);
        if (!StringUtils.isBlank((CharSequence)parameters.get("overrideKeys"))) {
            String[] overrideKeys = parameters.get("overrideKeys").split(",");
            keyFieldNames = Arrays.asList(overrideKeys);
        } else {
            keyFieldNames = this.getDataObjectMetaDataService().listPrimaryKeyFieldNames(dataObjectClass);
        }
        return KRADUtils.getParametersFromRequest(keyFieldNames, dataObjectClass, parameters);
    }

    protected void populateMaintenanceObjectWithCopyKeyValues(Map<String, String> parameters, Object oldBusinessObject, Maintainable oldMaintainableObject) {
        Map<String, String> parametersToCopy = null;
        if (!StringUtils.isBlank((CharSequence)parameters.get("cpKys"))) {
            String[] copyKeys = parameters.get("cpKys").split(",");
            List<String> keyFieldNamesToCopy = Arrays.asList(copyKeys);
            parametersToCopy = KRADUtils.getParametersFromRequest(keyFieldNamesToCopy, oldMaintainableObject.getDataObjectClass(), parameters);
        }
        if (parametersToCopy != null) {
            ObjectPropertyUtils.copyPropertiesToObject(parametersToCopy, oldBusinessObject);
        }
    }

    @Override
    public String getLockingDocumentId(MaintenanceDocument document) {
        return this.getLockingDocumentId(document.getNewMaintainableObject(), document.getDocumentNumber());
    }

    @Override
    public String getLockingDocumentId(Maintainable maintainable, String documentNumber) {
        MaintenanceLock maintenanceLock;
        String lockingDocId = null;
        List<MaintenanceLock> maintenanceLocks = maintainable.generateMaintenanceLocks();
        Iterator<MaintenanceLock> iterator = maintenanceLocks.iterator();
        while (iterator.hasNext() && !StringUtils.isNotBlank((CharSequence)(lockingDocId = this.maintenanceDocumentDao.getLockingDocumentNumber((maintenanceLock = iterator.next()).getLockingRepresentation(), documentNumber)))) {
        }
        return lockingDocId;
    }

    @Override
    public void deleteLocks(String documentNumber) {
        this.maintenanceDocumentDao.deleteLocks(documentNumber);
    }

    @Override
    public void storeLocks(List<MaintenanceLock> maintenanceLocks) {
        this.maintenanceDocumentDao.storeLocks(maintenanceLocks);
    }

    @Override
    public Map<String, String> resolvePrincipalNamesToPrincipalIds(BusinessObject businessObject, Map<String, String> fieldValues) {
        if (fieldValues == null) {
            return null;
        }
        if (businessObject == null) {
            return fieldValues;
        }
        StringBuffer resolvedPrincipalIdPropertyName = new StringBuffer();
        Map<String, String> processedFieldValues = this.getNonPersonSearchCriteria(businessObject, fieldValues);
        for (String propertyName : fieldValues.keySet()) {
            String principalName;
            if (!StringUtils.isBlank((CharSequence)fieldValues.get(propertyName)) && this.isPersonProperty(businessObject, propertyName)) {
                BusinessObject targetBusinessObject;
                String personReferenceObjectPropertyName;
                int lastPropertyIndex = PropertyAccessorUtils.getLastNestedPropertySeparatorIndex((String)propertyName);
                String personPropertyName = lastPropertyIndex != -1 ? StringUtils.substring((String)propertyName, (int)(lastPropertyIndex + 1)) : propertyName;
                if (!StringUtils.equals((CharSequence)"principalName", (CharSequence)personPropertyName)) continue;
                Class<?> targetBusinessObjectClass = null;
                resolvedPrincipalIdPropertyName.setLength(0);
                String string = personReferenceObjectPropertyName = lastPropertyIndex != -1 ? StringUtils.substring((String)propertyName, (int)0, (int)lastPropertyIndex) : "";
                if (ObjectUtils.isNestedAttribute(personReferenceObjectPropertyName)) {
                    String targetBusinessObjectPropertyName = ObjectUtils.getNestedAttributePrefix(personReferenceObjectPropertyName);
                    targetBusinessObject = (BusinessObject)ObjectUtils.getPropertyValue(businessObject, targetBusinessObjectPropertyName);
                    if (targetBusinessObject != null) {
                        targetBusinessObjectClass = targetBusinessObject.getClass();
                        resolvedPrincipalIdPropertyName.append(targetBusinessObjectPropertyName).append(".");
                    } else {
                        LOG.error("Could not find target property '" + propertyName + "' in class " + businessObject.getClass().getName() + ". Property value was null.");
                    }
                } else {
                    targetBusinessObjectClass = businessObject.getClass();
                    targetBusinessObject = businessObject;
                }
                if (targetBusinessObjectClass != null) {
                    int lastIndex = PropertyAccessorUtils.getLastNestedPropertySeparatorIndex((String)personReferenceObjectPropertyName);
                    String propName = lastIndex != -1 ? StringUtils.substring((String)personReferenceObjectPropertyName, (int)(lastIndex + 1)) : personReferenceObjectPropertyName;
                    DataObjectRelationship rel = this.getBusinessObjectMetaDataService().getBusinessObjectRelationship(targetBusinessObject, propName);
                    if (rel != null) {
                        String sourcePrimitivePropertyName = rel.getParentAttributeForChildAttribute("principalId");
                        resolvedPrincipalIdPropertyName.append(sourcePrimitivePropertyName);
                        String principalName2 = fieldValues.get(propertyName);
                        Principal principal = this.getIdentityService().getPrincipalByPrincipalName(principalName2);
                        if (principal != null) {
                            processedFieldValues.put(resolvedPrincipalIdPropertyName.toString(), principal.getPrincipalId());
                            continue;
                        }
                        processedFieldValues.put(resolvedPrincipalIdPropertyName.toString(), null);
                        try {
                            ObjectUtils.setObjectProperty(targetBusinessObject, resolvedPrincipalIdPropertyName.toString(), null);
                            ObjectUtils.setObjectProperty(targetBusinessObject, propName, null);
                            ObjectUtils.setObjectProperty(targetBusinessObject, propName + ".principalName", principalName2);
                        }
                        catch (Exception ex) {
                            LOG.error("Unable to blank out the person object after finding that the person with the given principalName does not exist.", (Throwable)ex);
                        }
                        continue;
                    }
                    LOG.error("Missing relationship for " + propName + " on " + targetBusinessObjectClass.getName());
                    continue;
                }
                processedFieldValues.put(resolvedPrincipalIdPropertyName.toString(), null);
                continue;
            }
            if (!propertyName.endsWith(".principalName") || !StringUtils.isNotEmpty((CharSequence)(principalName = fieldValues.get(propertyName)))) continue;
            String containerPropertyName = propertyName;
            if (containerPropertyName.startsWith("add.")) {
                containerPropertyName = StringUtils.substringAfter((String)propertyName, (String)"add.");
            }
            if (PropertyAccessorUtils.isNestedOrIndexedProperty((String)containerPropertyName)) {
                String collectionName = StringUtils.substringBefore((String)containerPropertyName, (String)".");
                Class collectionBusinessObjectClass = this.getMaintenanceDocumentDictionaryService().getCollectionBusinessObjectClass(this.getMaintenanceDocumentDictionaryService().getDocumentTypeName(businessObject.getClass()), collectionName);
                if (collectionBusinessObjectClass != null) {
                    List<DataObjectRelationship> relationships = this.getBusinessObjectMetaDataService().getBusinessObjectRelationships(collectionBusinessObjectClass);
                    for (DataObjectRelationship rel : relationships) {
                        String currRelatedPersonPrincipalId;
                        String parentAttribute = rel.getParentAttributeForChildAttribute("principalId");
                        if (parentAttribute == null) continue;
                        processedFieldValues.remove(propertyName);
                        String fieldPrefix = StringUtils.substringBeforeLast((String)StringUtils.substringBeforeLast((String)propertyName, (String)".principalName"), (String)".");
                        String relatedPrincipalIdPropertyName = fieldPrefix + "." + parentAttribute;
                        if ("extension".equals(StringUtils.substringAfterLast((String)fieldPrefix, (String)".")) && "extension".equals(StringUtils.substringBefore((String)parentAttribute, (String)"."))) {
                            relatedPrincipalIdPropertyName = fieldPrefix + "." + StringUtils.substringAfter((String)parentAttribute, (String)".");
                        }
                        if (!StringUtils.isBlank((CharSequence)(currRelatedPersonPrincipalId = processedFieldValues.get(relatedPrincipalIdPropertyName)))) continue;
                        Principal principal = this.getIdentityService().getPrincipalByPrincipalName(principalName);
                        if (principal != null) {
                            processedFieldValues.put(relatedPrincipalIdPropertyName, principal.getPrincipalId());
                            continue;
                        }
                        processedFieldValues.put(relatedPrincipalIdPropertyName, null);
                    }
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Unable to determine class for collection referenced as part of property: " + containerPropertyName + " on " + businessObject.getClass().getName());
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Non-nested property ending with 'principalName': " + containerPropertyName + " on " + businessObject.getClass().getName());
        }
        return processedFieldValues;
    }

    protected Map<String, String> getNonPersonSearchCriteria(Object bo, Map<String, String> fieldValues) {
        HashMap<String, String> nonUniversalUserSearchCriteria = new HashMap<String, String>();
        for (String propertyName : fieldValues.keySet()) {
            if (this.isPersonProperty(bo, propertyName)) continue;
            nonUniversalUserSearchCriteria.put(propertyName, fieldValues.get(propertyName));
        }
        return nonUniversalUserSearchCriteria;
    }

    protected boolean isPersonProperty(Object bo, String propertyName) {
        block4: {
            try {
                if (PropertyAccessorUtils.isNestedOrIndexedProperty((String)propertyName) && !StringUtils.contains((CharSequence)propertyName, (CharSequence)"add.")) {
                    int lastIndex = PropertyAccessorUtils.getLastNestedPropertySeparatorIndex((String)propertyName);
                    String propertyTypeName = lastIndex != -1 ? StringUtils.substring((String)propertyName, (int)0, (int)lastIndex) : "";
                    Class type = PropertyUtils.getPropertyType((Object)bo, (String)propertyTypeName);
                    if (type != null) {
                        return Person.class.isAssignableFrom(type);
                    }
                    LOG.warn("Unable to determine type of nested property: " + bo.getClass().getName() + " / " + propertyName);
                }
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("Unable to determine if property on " + bo.getClass().getName() + " to a person object: " + propertyName, (Throwable)ex);
            }
        }
        return false;
    }

    public MaintenanceDocumentDao getMaintenanceDocumentDao() {
        return this.maintenanceDocumentDao;
    }

    public void setMaintenanceDocumentDao(MaintenanceDocumentDao maintenanceDocumentDao) {
        this.maintenanceDocumentDao = maintenanceDocumentDao;
    }

    protected DataObjectAuthorizationService getDataObjectAuthorizationService() {
        if (this.dataObjectAuthorizationService == null) {
            this.dataObjectAuthorizationService = KRADServiceLocatorWeb.getDataObjectAuthorizationService();
        }
        return this.dataObjectAuthorizationService;
    }

    public void setDataObjectAuthorizationService(DataObjectAuthorizationService dataObjectAuthorizationService) {
        this.dataObjectAuthorizationService = dataObjectAuthorizationService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected DataObjectMetaDataService getDataObjectMetaDataService() {
        if (this.dataObjectMetaDataService == null) {
            this.dataObjectMetaDataService = KRADServiceLocatorWeb.getDataObjectMetaDataService();
        }
        return this.dataObjectMetaDataService;
    }

    public void setDataObjectMetaDataService(DataObjectMetaDataService dataObjectMetaDataService) {
        this.dataObjectMetaDataService = dataObjectMetaDataService;
    }

    public DocumentDictionaryService getDocumentDictionaryService() {
        if (this.documentDictionaryService == null) {
            this.documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return this.documentDictionaryService;
    }

    public void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        this.documentDictionaryService = documentDictionaryService;
    }

    public BusinessObjectMetaDataService getBusinessObjectMetaDataService() {
        if (this.businessObjectMetaDataService == null) {
            this.businessObjectMetaDataService = KNSServiceLocator.getBusinessObjectMetaDataService();
        }
        return this.businessObjectMetaDataService;
    }

    public void setBusinessObjectMetaDataService(BusinessObjectMetaDataService businessObjectMetaDataService) {
        this.businessObjectMetaDataService = businessObjectMetaDataService;
    }

    public IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KimApiServiceLocator.getIdentityService();
        }
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        if (this.maintenanceDocumentDictionaryService == null) {
            this.maintenanceDocumentDictionaryService = KNSServiceLocator.getMaintenanceDocumentDictionaryService();
        }
        return this.maintenanceDocumentDictionaryService;
    }

    public void setMaintenanceDocumentDictionaryService(MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService) {
        this.maintenanceDocumentDictionaryService = maintenanceDocumentDictionaryService;
    }
}

