/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.service.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.service.impl.RemoteModuleServiceBase;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class ModuleServiceBase
extends RemoteModuleServiceBase
implements ModuleService {
    protected static final Logger LOG = LogManager.getLogger(ModuleServiceBase.class);
    protected BusinessObjectService businessObjectService;
    protected BusinessObjectDictionaryService businessObjectDictionaryService;

    @Override
    public <T extends ExternalizableBusinessObject> T getExternalizableBusinessObject(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        Class<T> implementationClass = this.getExternalizableBusinessObjectImplementation(businessObjectClass);
        ExternalizableBusinessObject businessObject = (ExternalizableBusinessObject)this.getBusinessObjectService().findByPrimaryKey(implementationClass, fieldValues);
        return (T)businessObject;
    }

    @Override
    public <T extends ExternalizableBusinessObject> List<T> getExternalizableBusinessObjectsList(Class<T> externalizableBusinessObjectClass, Map<String, Object> fieldValues) {
        Class<T> implementationClass = this.getExternalizableBusinessObjectImplementation(externalizableBusinessObjectClass);
        return (List)this.getBusinessObjectService().findMatching(implementationClass, fieldValues);
    }

    @Override
    @Deprecated
    public String getExternalizableBusinessObjectInquiryUrl(Class inquiryBusinessObjectClass, Map<String, String[]> parameters) {
        if (!this.isExternalizable(inquiryBusinessObjectClass)) {
            return "";
        }
        Class implementationClass = this.getExternalizableBusinessObjectImplementation(inquiryBusinessObjectClass);
        if (implementationClass == null) {
            LOG.error("Can't find ExternalizableBusinessObject implementation class for " + inquiryBusinessObjectClass.getName());
            throw new RuntimeException("Can't find ExternalizableBusinessObject implementation class for interface " + inquiryBusinessObjectClass.getName());
        }
        String businessObjectClassAttribute = implementationClass.getName();
        return UrlFactory.parameterizeUrl(this.getInquiryUrl(inquiryBusinessObjectClass), this.getUrlParameters(businessObjectClassAttribute, parameters));
    }

    @Override
    @Deprecated
    protected String getInquiryUrl(Class inquiryBusinessObjectClass) {
        String riceBaseUrl;
        String potentialUrlAddition = "";
        if (this.goToCentralRiceForInquiry()) {
            riceBaseUrl = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("kr.url");
        } else {
            riceBaseUrl = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url");
            potentialUrlAddition = "kr/";
        }
        String inquiryUrl = riceBaseUrl;
        if (!inquiryUrl.endsWith("/")) {
            inquiryUrl = inquiryUrl + "/";
        }
        return inquiryUrl + potentialUrlAddition + "inquiry.do";
    }

    @Override
    public boolean isExternalizableBusinessObjectLookupable(Class boClass) {
        return this.getBusinessObjectDictionaryService().isLookupable(boClass);
    }

    @Override
    public boolean isExternalizableBusinessObjectInquirable(Class boClass) {
        return this.getBusinessObjectDictionaryService().isInquirable(boClass);
    }

    @Override
    @Deprecated
    public String getExternalizableBusinessObjectLookupUrl(Class inquiryBusinessObjectClass, Map<String, String> parameters) {
        String riceBaseUrl;
        Properties urlParameters = new Properties();
        String potentialUrlAddition = "";
        if (this.goToCentralRiceForInquiry()) {
            riceBaseUrl = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("kr.url");
        } else {
            riceBaseUrl = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url");
            potentialUrlAddition = "kr/";
        }
        String lookupUrl = riceBaseUrl;
        if (!lookupUrl.endsWith("/")) {
            lookupUrl = lookupUrl + "/";
        }
        lookupUrl = parameters.containsKey("multipleValues") ? lookupUrl + potentialUrlAddition + "multipleValueLookup.do" : lookupUrl + potentialUrlAddition + "lookup.do";
        for (String paramName : parameters.keySet()) {
            urlParameters.put(paramName, parameters.get(paramName));
        }
        Class clazz = this.getExternalizableBusinessObjectImplementation(inquiryBusinessObjectClass);
        urlParameters.put("businessObjectClassName", clazz == null ? "" : clazz.getName());
        return UrlFactory.parameterizeUrl(lookupUrl, urlParameters);
    }

    protected BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        if (this.businessObjectDictionaryService == null) {
            this.businessObjectDictionaryService = KNSServiceLocator.getBusinessObjectDictionaryService();
        }
        return this.businessObjectDictionaryService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    @Override
    public boolean goToCentralRiceForInquiry() {
        return false;
    }

    @Override
    protected String getBaseLookupUrl() {
        if (this.goToCentralRiceForInquiry()) {
            return RemoteModuleServiceBase.BaseLookupUrlsHolder.remoteKradBaseLookupUrl;
        }
        return RemoteModuleServiceBase.BaseLookupUrlsHolder.localKradBaseLookupUrl;
    }

    protected RunMode getRunMode(String module) {
        String propertyName = module + ".mode";
        String runMode = ConfigContext.getCurrentContextConfig().getProperty(propertyName);
        if (StringUtils.isBlank((CharSequence)runMode)) {
            throw new ConfigurationException("Failed to determine run mode for module '" + module + "'.  Please be sure to set configuration parameter '" + propertyName + "'");
        }
        return RunMode.valueOf((String)runMode.toUpperCase());
    }
}

