/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.layout;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.uif.component.DataBinding;
import org.kuali.kfs.krad.uif.container.CollectionGroup;
import org.kuali.kfs.krad.uif.control.Control;
import org.kuali.kfs.krad.uif.control.ValueConfiguredControl;
import org.kuali.kfs.krad.uif.field.Field;
import org.kuali.kfs.krad.uif.field.InputField;
import org.kuali.kfs.krad.util.KRADUtils;

public final class CollectionLayoutUtils {
    private CollectionLayoutUtils() {
    }

    public static void prepareSelectFieldForLine(Field selectField, CollectionGroup collectionGroup, String lineBindingPath, Object line) {
        String selectPropertyName = collectionGroup.getSelectPropertyName();
        if (StringUtils.isNotBlank((CharSequence)selectPropertyName)) {
            if (selectPropertyName.startsWith("#form.")) {
                selectPropertyName = StringUtils.removeStart((String)selectPropertyName, (String)"#form.");
                ((DataBinding)((Object)selectField)).getBindingInfo().setBindingName(selectPropertyName);
                ((DataBinding)((Object)selectField)).getBindingInfo().setBindToForm(true);
                CollectionLayoutUtils.setControlValueToLineIdentifier(selectField, line);
            } else {
                ((DataBinding)((Object)selectField)).getBindingInfo().setBindingName(selectPropertyName);
                ((DataBinding)((Object)selectField)).getBindingInfo().setBindByNamePrefix(lineBindingPath);
            }
        } else {
            String collectionLineKey = KRADUtils.translateToMapSafeKey(collectionGroup.getBindingInfo().getBindingPath());
            String selectBindingPath = "selectedCollectionLines['" + collectionLineKey + "']";
            ((DataBinding)((Object)selectField)).getBindingInfo().setBindingName(selectBindingPath);
            ((DataBinding)((Object)selectField)).getBindingInfo().setBindToForm(true);
            CollectionLayoutUtils.setControlValueToLineIdentifier(selectField, line);
        }
    }

    protected static void setControlValueToLineIdentifier(Field selectField, Object line) {
        if (selectField instanceof InputField) {
            Control selectControl = ((InputField)selectField).getControl();
            selectControl.addStyleClass("kr-select-line");
            if (selectControl instanceof ValueConfiguredControl) {
                String lineIdentifier = KRADServiceLocatorWeb.getDataObjectMetaDataService().getDataObjectIdentifierString(line);
                ((ValueConfiguredControl)((Object)selectControl)).setValue(lineIdentifier);
            }
        }
    }
}

