/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.modifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.component.Ordered;
import org.kuali.kfs.krad.uif.container.Group;
import org.kuali.kfs.krad.uif.field.DataField;
import org.kuali.kfs.krad.uif.field.HeaderField;
import org.kuali.kfs.krad.uif.modifier.ComparableInfo;
import org.kuali.kfs.krad.uif.modifier.ComponentModifierBase;
import org.kuali.kfs.krad.uif.util.ComponentUtils;
import org.kuali.kfs.krad.uif.util.ObjectPropertyUtils;
import org.kuali.kfs.krad.uif.view.View;

public class CompareFieldCreateModifier
extends ComponentModifierBase {
    private static final long serialVersionUID = -6285531580512330188L;
    private int defaultOrderSequence = 1;
    private boolean generateCompareHeaders = true;
    private HeaderField headerFieldPrototype;
    private List<ComparableInfo> comparables = new ArrayList<ComparableInfo>();

    @Override
    public void performInitialization(View view, Object model, Component component) {
        super.performInitialization(view, model, component);
        if (this.headerFieldPrototype != null) {
            view.getViewHelperService().performComponentInitialization(view, model, this.headerFieldPrototype);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void performModification(View view, Object model, Component component) {
        if (component != null && !(component instanceof Group)) {
            throw new IllegalArgumentException("Compare field initializer only support Group components, found type: " + component.getClass());
        }
        if (component == null) {
            return;
        }
        ArrayList<Object> comparisonItems = new ArrayList<Object>();
        List<? extends Ordered> groupComparables = ComponentUtils.sort(this.comparables, this.defaultOrderSequence);
        HashMap<String, Object> context = new HashMap<String, Object>(view.getContext());
        context.put("component", component);
        for (ComparableInfo comparableInfo : groupComparables) {
            KRADServiceLocatorWeb.getExpressionEvaluatorService().evaluateObjectExpressions(comparableInfo, model, context);
        }
        if (this.isGenerateCompareHeaders()) {
            for (ComparableInfo comparableInfo : groupComparables) {
                HeaderField compareHeaderField = ComponentUtils.copy(this.headerFieldPrototype, comparableInfo.getIdSuffix());
                compareHeaderField.setHeaderText(comparableInfo.getHeaderText());
                comparisonItems.add(compareHeaderField);
            }
        }
        boolean performValueChangeComparison = false;
        Object var8_12 = null;
        for (ComparableInfo comparableInfo : groupComparables) {
            if (!comparableInfo.isCompareToForValueChange()) continue;
            performValueChangeComparison = true;
            String string = comparableInfo.getBindingObjectPath();
        }
        Group group = (Group)component;
        for (Component component2 : group.getItems()) {
            int defaultSuffix = 0;
            for (ComparableInfo comparableInfo : groupComparables) {
                String idSuffix = comparableInfo.getIdSuffix();
                if (StringUtils.isBlank((CharSequence)idSuffix)) {
                    idSuffix = "_comp" + defaultSuffix;
                }
                Component compareItem = ComponentUtils.copy(component2, idSuffix);
                ComponentUtils.setComponentPropertyDeep(compareItem, "bindingInfo.bindingObjectPath", comparableInfo.getBindingObjectPath());
                if (comparableInfo.isReadOnly()) {
                    compareItem.setReadOnly(true);
                    compareItem.getPropertyExpressions().remove("readOnly");
                }
                if (performValueChangeComparison && comparableInfo.isHighlightValueChange() && !comparableInfo.isCompareToForValueChange()) {
                    void var8_13;
                    this.performValueComparison(group, compareItem, model, (String)var8_13);
                }
                comparisonItems.add(compareItem);
                ++defaultSuffix;
            }
        }
        group.setItems(comparisonItems);
    }

    protected void performValueComparison(Group group, Component compareItem, Object model, String compareValueObjectBindingPath) {
        List<DataField> itemFields = ComponentUtils.getComponentsOfTypeDeep(compareItem, DataField.class);
        for (DataField field : itemFields) {
            String fieldBindingPath = field.getBindingInfo().getBindingPath();
            Object fieldValue = ObjectPropertyUtils.getPropertyValue(model, fieldBindingPath);
            String compareBindingPath = StringUtils.replaceOnce((String)fieldBindingPath, (String)field.getBindingInfo().getBindingObjectPath(), (String)compareValueObjectBindingPath);
            Object compareValue = ObjectPropertyUtils.getPropertyValue(model, compareBindingPath);
            boolean valueChanged = false;
            if (fieldValue != null || compareValue != null) {
                if (fieldValue == null || compareValue == null) {
                    valueChanged = true;
                } else {
                    boolean bl = valueChanged = !fieldValue.equals(compareValue);
                }
            }
            if (!valueChanged) continue;
            String onReadyScript = "showChangeIcon('" + field.getId() + "');";
            HeaderField headerField = group.getHeader();
            onReadyScript = onReadyScript + "showChangeIconOnHeader('" + headerField.getId() + "');";
            field.setOnDocumentReadyScript(onReadyScript);
        }
    }

    protected String getIdSuffix(ComparableInfo comparable, int index) {
        String idSuffix = comparable.getIdSuffix();
        if (StringUtils.isBlank((CharSequence)idSuffix)) {
            idSuffix = "_" + index;
        }
        return idSuffix;
    }

    @Override
    public Set<Class<? extends Component>> getSupportedComponents() {
        HashSet<Class<? extends Component>> components = new HashSet<Class<? extends Component>>();
        components.add(Group.class);
        return components;
    }

    @Override
    public List<Component> getComponentPrototypes() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(this.headerFieldPrototype);
        return components;
    }

    public int getDefaultOrderSequence() {
        return this.defaultOrderSequence;
    }

    public void setDefaultOrderSequence(int defaultOrderSequence) {
        this.defaultOrderSequence = defaultOrderSequence;
    }

    public boolean isGenerateCompareHeaders() {
        return this.generateCompareHeaders;
    }

    public void setGenerateCompareHeaders(boolean generateCompareHeaders) {
        this.generateCompareHeaders = generateCompareHeaders;
    }

    public HeaderField getHeaderFieldPrototype() {
        return this.headerFieldPrototype;
    }

    public void setHeaderFieldPrototype(HeaderField headerFieldPrototype) {
        this.headerFieldPrototype = headerFieldPrototype;
    }

    public List<ComparableInfo> getComparables() {
        return this.comparables;
    }

    public void setComparables(List<ComparableInfo> comparables) {
        this.comparables = comparables;
    }
}

