/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.service.impl;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.inquiry.Inquirable;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.uif.UifConstants;
import org.kuali.kfs.krad.uif.service.ViewDictionaryService;
import org.kuali.kfs.krad.uif.util.ViewModelUtils;
import org.kuali.kfs.krad.uif.view.LookupView;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.springframework.beans.PropertyValues;

public class ViewDictionaryServiceImpl
implements ViewDictionaryService {
    private DataDictionaryService dataDictionaryService;

    @Override
    public Inquirable getInquirable(Class<?> dataObjectClass, String viewName) {
        Inquirable inquirable = null;
        if (StringUtils.isBlank((CharSequence)viewName)) {
            viewName = "default";
        }
        HashMap<String, String> indexKey = new HashMap<String, String>();
        indexKey.put("viewName", viewName);
        indexKey.put("dataObjectClassName", dataObjectClass.getName());
        PropertyValues propertyValues = this.getDataDictionary().getViewPropertiesByType(UifConstants.ViewType.INQUIRY, indexKey);
        String viewHelperServiceClassName = ViewModelUtils.getStringValFromPVs(propertyValues, "viewHelperServiceClassName");
        if (StringUtils.isNotBlank((CharSequence)viewHelperServiceClassName)) {
            try {
                inquirable = (Inquirable)ObjectUtils.newInstance(Class.forName(viewHelperServiceClassName));
            }
            catch (ClassNotFoundException e) {
                throw new RiceRuntimeException("Unable to find class for inquirable classname: " + viewHelperServiceClassName, (Throwable)e);
            }
        }
        return inquirable;
    }

    @Override
    public boolean isInquirable(Class<?> dataObjectClass) {
        HashMap<String, String> indexKey = new HashMap<String, String>();
        indexKey.put("viewName", "default");
        indexKey.put("dataObjectClassName", dataObjectClass.getName());
        return this.getDataDictionary().viewByTypeExist(UifConstants.ViewType.INQUIRY, indexKey);
    }

    @Override
    public boolean isLookupable(Class<?> dataObjectClass) {
        HashMap<String, String> indexKey = new HashMap<String, String>();
        indexKey.put("viewName", "default");
        indexKey.put("dataObjectClassName", dataObjectClass.getName());
        return this.getDataDictionary().viewByTypeExist(UifConstants.ViewType.LOOKUP, indexKey);
    }

    @Override
    public boolean isMaintainable(Class<?> dataObjectClass) {
        HashMap<String, String> indexKey = new HashMap<String, String>();
        indexKey.put("viewName", "default");
        indexKey.put("dataObjectClassName", dataObjectClass.getName());
        return this.getDataDictionary().viewByTypeExist(UifConstants.ViewType.MAINTENANCE, indexKey);
    }

    @Override
    public Integer getResultSetLimitForLookup(Class<?> dataObjectClass) {
        LookupView lookupView = null;
        List<View> lookupViews = this.getDataDictionary().getViewsForType(UifConstants.ViewType.LOOKUP);
        for (View view : lookupViews) {
            LookupView lView = (LookupView)view;
            if (!StringUtils.equals((CharSequence)lView.getDataObjectClassName().getName(), (CharSequence)dataObjectClass.getName())) continue;
            if (lookupView != null) {
                if (!StringUtils.equals((CharSequence)lView.getViewName(), (CharSequence)"default")) continue;
                lookupView = lView;
                continue;
            }
            lookupView = lView;
        }
        if (lookupView != null) {
            return lookupView.getResultSetLimit();
        }
        return null;
    }

    protected DataDictionary getDataDictionary() {
        return this.getDataDictionaryService().getDataDictionary();
    }

    protected DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

