/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.datadictionary.validation.constraint.BaseConstraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.CaseConstraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.MustOccurConstraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.PrerequisiteConstraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.SimpleConstraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.kfs.krad.datadictionary.validation.constraint.WhenConstraint;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.uif.control.TextControl;
import org.kuali.kfs.krad.uif.field.InputField;
import org.kuali.kfs.krad.uif.util.ScriptUtils;
import org.kuali.kfs.krad.uif.view.FormView;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public final class ClientValidationUtils {
    private static int methodKey = 0;
    private static List<List<String>> mustOccursPathNames;
    public static final String LABEL_KEY_SPLIT_PATTERN = ",";
    public static final String PREREQ_MSG_KEY = "prerequisite";
    public static final String POSTREQ_MSG_KEY = "postrequisite";
    public static final String MUSTOCCURS_MSG_KEY = "mustOccurs";
    public static final String GENERIC_FIELD_MSG_KEY = "general.genericFieldName";
    public static final String ALL_MSG_KEY = "general.all";
    public static final String ATMOST_MSG_KEY = "general.atMost";
    public static final String AND_MSG_KEY = "general.and";
    public static final String OR_MSG_KEY = "general.or";
    private static ConfigurationService configService;

    private ClientValidationUtils() {
    }

    public static String generateMessageFromLabelKey(List<String> params, String labelKey) {
        String message = "NO MESSAGE";
        if (StringUtils.isNotEmpty((CharSequence)labelKey)) {
            message = configService.getPropertyValueAsString(labelKey);
            if (params != null && !params.isEmpty() && StringUtils.isNotEmpty((CharSequence)message)) {
                message = MessageFormat.format(message, params.toArray());
            }
        }
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = labelKey;
        }
        if (message.contains("\"")) {
            message = message.replace("\"", "&quot;");
        }
        if (message.contains("'")) {
            message = message.replace("'", "&#39;");
        }
        if (message.contains("\\")) {
            message = message.replace("\\", "&#92;");
        }
        return message;
    }

    public static String generateValidatorMessagesOption() {
        String mOption = "";
        String keyValuePairs = "";
        for (ValidationMessageKeys element : EnumSet.allOf(ValidationMessageKeys.class)) {
            String key = element.toString();
            String message = configService.getPropertyValueAsString("validation." + key);
            if (!StringUtils.isNotEmpty((CharSequence)message)) continue;
            keyValuePairs = keyValuePairs + "\n" + key + ": '" + message + "',";
        }
        if (StringUtils.isNotEmpty((CharSequence)(keyValuePairs = StringUtils.removeEnd((String)keyValuePairs, (String)LABEL_KEY_SPLIT_PATTERN)))) {
            mOption = "{" + keyValuePairs + "}";
        }
        return mOption;
    }

    public static String getRegexMethod(InputField field, ValidCharactersConstraint validCharactersConstraint) {
        String message = ClientValidationUtils.generateMessageFromLabelKey(validCharactersConstraint.getValidationMessageParams(), validCharactersConstraint.getLabelKey());
        String key = "validChar-" + field.getBindingInfo().getBindingPath() + methodKey;
        String regex = validCharactersConstraint.getValue();
        if (regex.contains("\\\\")) {
            regex = regex.replaceAll("\\\\", "\\\\\\\\");
        }
        if (regex.contains("/")) {
            regex = regex.replace("/", "\\/");
        }
        return "\njQuery.validator.addMethod(\"" + ScriptUtils.escapeName(key) + "\", function(value, element) {\n return this.optional(element) || /" + regex + "/.test(value);}, \"" + message + "\");";
    }

    public static String getRegexMethodWithBooleanCheck(InputField field, ValidCharactersConstraint validCharactersConstraint) {
        String message = ClientValidationUtils.generateMessageFromLabelKey(validCharactersConstraint.getValidationMessageParams(), validCharactersConstraint.getLabelKey());
        String key = "validChar-" + field.getBindingInfo().getBindingPath() + methodKey;
        String regex = validCharactersConstraint.getValue();
        if (regex.contains("\\\\")) {
            regex = regex.replaceAll("\\\\", "\\\\\\\\");
        }
        if (regex.contains("/")) {
            regex = regex.replace("/", "\\/");
        }
        return "\njQuery.validator.addMethod(\"" + ScriptUtils.escapeName(key) + "\", function(value, element, doCheck) {\n if(doCheck === false){return true;}else{return this.optional(element) || /" + regex + "/.test(value);}}, \"" + message + "\");";
    }

    public static void processCaseConstraint(InputField field, View view, CaseConstraint constraint, String andedCase) {
        if (constraint.getOperator() == null) {
            constraint.setOperator("equals");
        }
        String operator = "==";
        if (constraint.getOperator().equalsIgnoreCase("not_equals") || constraint.getOperator().equalsIgnoreCase("not_equal")) {
            operator = "!=";
        } else if (constraint.getOperator().equalsIgnoreCase("greater_than_equal")) {
            operator = ">=";
        } else if (constraint.getOperator().equalsIgnoreCase("less_than_equal")) {
            operator = "<=";
        } else if (constraint.getOperator().equalsIgnoreCase("greater_than")) {
            operator = ">";
        } else if (constraint.getOperator().equalsIgnoreCase("less_than")) {
            operator = "<";
        } else if (constraint.getOperator().equalsIgnoreCase("has_value")) {
            operator = "";
        }
        field.getControl().addStyleClass("dependsOn-" + ScriptUtils.escapeName(constraint.getPropertyName()));
        if (constraint.getWhenConstraint() != null && !constraint.getWhenConstraint().isEmpty()) {
            String fieldPath = constraint.getPropertyName();
            for (WhenConstraint wc : constraint.getWhenConstraint()) {
                ClientValidationUtils.processWhenConstraint(field, view, constraint, wc, ScriptUtils.escapeName(fieldPath), operator, andedCase);
            }
        }
    }

    private static void processWhenConstraint(InputField field, View view, CaseConstraint caseConstraint, WhenConstraint wc, String fieldPath, String operator, String andedCase) {
        String ruleString = "";
        String booleanStatement = "";
        if (wc.getValues() != null) {
            String caseStr = "";
            if (!caseConstraint.isCaseSensitive()) {
                caseStr = ".toUpperCase()";
            }
            for (int i = 0; i < wc.getValues().size(); ++i) {
                booleanStatement = operator.isEmpty() ? (wc.getValues().get(i) instanceof String && ((String)wc.getValues().get(i)).equalsIgnoreCase("false") ? booleanStatement + "(coerceValue('" + fieldPath + "') == '')" : booleanStatement + "(coerceValue('" + fieldPath + "') != '')") : booleanStatement + "(coerceValue('" + fieldPath + "')" + caseStr + " " + operator + " \"" + wc.getValues().get(i) + "\"" + caseStr + ")";
                if (i + 1 == wc.getValues().size()) continue;
                booleanStatement = booleanStatement + " || ";
            }
        }
        if (andedCase != null) {
            booleanStatement = "(" + booleanStatement + ") && (" + andedCase + ")";
        }
        if (wc.getConstraint() != null && StringUtils.isNotEmpty((CharSequence)booleanStatement)) {
            ruleString = ClientValidationUtils.createRule(field, wc.getConstraint(), booleanStatement, view);
        }
        if (StringUtils.isNotEmpty((CharSequence)ruleString)) {
            ClientValidationUtils.addScriptToPage(view, field, ruleString);
        }
    }

    public static void addScriptToPage(View view, InputField field, String script) {
        String prefixScript = "";
        if (field.getOnDocumentReadyScript() != null) {
            prefixScript = field.getOnDocumentReadyScript();
        }
        field.setOnDocumentReadyScript(prefixScript + "\nrunValidationScript(function(){" + script + "});");
    }

    private static List<String> parseOutFields(String statement) {
        String[] splits;
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String s : splits = StringUtils.splitByWholeSeparator((String)statement, (String)"coerceValue('")) {
            String fieldName = StringUtils.substringBefore((String)s, (String)"'");
            fieldNames.add(fieldName);
        }
        return fieldNames;
    }

    private static String createRule(InputField field, Constraint constraint, String booleanStatement, View view) {
        String rule = "";
        int constraintCount = 0;
        if (constraint instanceof BaseConstraint && ((BaseConstraint)constraint).getApplyClientSide().booleanValue()) {
            if (constraint instanceof SimpleConstraint) {
                if (((SimpleConstraint)constraint).getRequired() != null && ((SimpleConstraint)constraint).getRequired().booleanValue()) {
                    rule = rule + "required: function(element){\nreturn (" + booleanStatement + ");}";
                    String showIndicatorScript = "";
                    for (String checkedField : ClientValidationUtils.parseOutFields(booleanStatement)) {
                        showIndicatorScript = showIndicatorScript + "setupShowReqIndicatorCheck('" + checkedField + "', '" + field.getBindingInfo().getBindingPath() + "', function(){\nreturn (" + booleanStatement + ");});\n";
                    }
                    ClientValidationUtils.addScriptToPage(view, field, showIndicatorScript);
                    ++constraintCount;
                }
                if (((SimpleConstraint)constraint).getMinLength() != null) {
                    if (constraintCount > 0) {
                        rule = rule + ",\n";
                    }
                    rule = rule + "minLengthConditional: [" + ((SimpleConstraint)constraint).getMinLength() + ", function(){return " + booleanStatement + ";}]";
                    ++constraintCount;
                }
                if (((SimpleConstraint)constraint).getMaxLength() != null) {
                    if (constraintCount > 0) {
                        rule = rule + ",\n";
                    }
                    rule = rule + "maxLengthConditional: [" + ((SimpleConstraint)constraint).getMaxLength() + ", function(){return " + booleanStatement + ";}]";
                    ++constraintCount;
                }
                if (((SimpleConstraint)constraint).getExclusiveMin() != null) {
                    if (constraintCount > 0) {
                        rule = rule + ",\n";
                    }
                    rule = rule + "minExclusive: [" + ((SimpleConstraint)constraint).getExclusiveMin() + ", function(){return " + booleanStatement + ";}]";
                    ++constraintCount;
                }
                if (((SimpleConstraint)constraint).getInclusiveMax() != null) {
                    if (constraintCount > 0) {
                        rule = rule + ",\n";
                    }
                    rule = rule + "maxInclusive: [" + ((SimpleConstraint)constraint).getInclusiveMax() + ", function(){return " + booleanStatement + ";}]";
                    ++constraintCount;
                }
                rule = "jq('[name=\"" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "\"]').rules(\"add\", {" + rule + "\n});";
            } else if (constraint instanceof ValidCharactersConstraint) {
                String regexMethod = "";
                String methodName = "";
                if (StringUtils.isNotEmpty((CharSequence)((ValidCharactersConstraint)constraint).getValue())) {
                    regexMethod = ClientValidationUtils.getRegexMethodWithBooleanCheck(field, (ValidCharactersConstraint)constraint) + "\n";
                    methodName = "validChar-" + field.getBindingInfo().getBindingPath() + methodKey;
                    ++methodKey;
                } else if (StringUtils.isNotEmpty((CharSequence)((ValidCharactersConstraint)constraint).getLabelKey())) {
                    methodName = ((ValidCharactersConstraint)constraint).getLabelKey();
                }
                if (StringUtils.isNotEmpty((CharSequence)methodName)) {
                    rule = regexMethod + "jq('[name=\"" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "\"]').rules(\"add\", {\n\"" + methodName + "\" : function(element){return (" + booleanStatement + ");}\n});";
                }
            } else if (constraint instanceof PrerequisiteConstraint) {
                ClientValidationUtils.processPrerequisiteConstraint(field, (PrerequisiteConstraint)constraint, view, booleanStatement);
            } else if (constraint instanceof CaseConstraint) {
                ClientValidationUtils.processCaseConstraint(field, view, (CaseConstraint)constraint, booleanStatement);
            } else if (constraint instanceof MustOccurConstraint) {
                ClientValidationUtils.processMustOccurConstraint(field, view, (MustOccurConstraint)constraint, booleanStatement);
            }
        }
        return rule;
    }

    public static void processPrerequisiteConstraint(InputField field, PrerequisiteConstraint constraint, View view) {
        ClientValidationUtils.processPrerequisiteConstraint(field, constraint, view, "true");
    }

    public static void processPrerequisiteConstraint(InputField field, PrerequisiteConstraint constraint, View view, String booleanStatement) {
        if (constraint != null && constraint.getApplyClientSide().booleanValue()) {
            String dependsClass = "dependsOn-" + ScriptUtils.escapeName(constraint.getPropertyName());
            String addClass = "jq('[name=\"" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "\"]').addClass('" + dependsClass + "');jq('[name=\"" + ScriptUtils.escapeName(constraint.getPropertyName()) + "\"]').addClass('dependsOn-" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "');";
            ClientValidationUtils.addScriptToPage(view, field, addClass + ClientValidationUtils.getPrerequisiteStatement(field, view, constraint, booleanStatement) + ClientValidationUtils.getPostrequisiteStatement(field, constraint, booleanStatement));
            String showIndicatorScript = "setupShowReqIndicatorCheck('" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "', '" + ScriptUtils.escapeName(constraint.getPropertyName()) + "', function(){\nreturn (coerceValue('" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "') && " + booleanStatement + ");});\n";
            ClientValidationUtils.addScriptToPage(view, field, showIndicatorScript);
        }
    }

    private static String getPrerequisiteStatement(InputField field, View view, PrerequisiteConstraint constraint, String booleanStatement) {
        InputField requiredField;
        String message = StringUtils.isEmpty((CharSequence)constraint.getLabelKey()) ? configService.getPropertyValueAsString("validation.prerequisite") : ClientValidationUtils.generateMessageFromLabelKey(constraint.getValidationMessageParams(), constraint.getLabelKey());
        message = StringUtils.isEmpty((CharSequence)message) ? "prerequisite - No message" : ((requiredField = (InputField)view.getViewIndex().getDataFieldByPath(constraint.getPropertyName())) != null && StringUtils.isNotEmpty((CharSequence)requiredField.getLabel()) ? MessageFormat.format(message, requiredField.getLabel()) : MessageFormat.format(message, configService.getPropertyValueAsString(GENERIC_FIELD_MSG_KEY)));
        String methodName = "prConstraint-" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + ++methodKey;
        String addClass = "jq('[name=\"" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "\"]').addClass('" + methodName + "');\n";
        String method = "\njQuery.validator.addMethod(\"" + methodName + "\", function(value, element) {\n if(" + booleanStatement + "){ return (this.optional(element) || (coerceValue('" + ScriptUtils.escapeName(constraint.getPropertyName()) + "')));}else{return true;} }, \"" + message + "\");";
        return "if(occursBefore('" + ScriptUtils.escapeName(constraint.getPropertyName()) + "','" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "')){" + addClass + method + "}";
    }

    private static String getPostrequisiteStatement(InputField field, PrerequisiteConstraint constraint, String booleanStatement) {
        String message = StringUtils.isEmpty((CharSequence)constraint.getLabelKey()) ? configService.getPropertyValueAsString("validation.postrequisite") : ClientValidationUtils.generateMessageFromLabelKey(constraint.getValidationMessageParams(), constraint.getLabelKey());
        if (StringUtils.isEmpty((CharSequence)constraint.getLabelKey())) {
            message = StringUtils.isNotEmpty((CharSequence)field.getLabel()) ? MessageFormat.format(message, field.getLabel()) : MessageFormat.format(message, configService.getPropertyValueAsString(GENERIC_FIELD_MSG_KEY));
        }
        String function = "function(element){\nreturn (coerceValue('" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "') && " + booleanStatement + ");}";
        return "\nelse if(occursBefore('" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "','" + ScriptUtils.escapeName(constraint.getPropertyName()) + "')){\njq('[name=\"" + ScriptUtils.escapeName(constraint.getPropertyName()) + "\"]').rules(\"add\", { required: \n" + function + ", \nmessages: {\nrequired: \"" + message + "\"}});}\n";
    }

    public static void processMustOccurConstraint(InputField field, View view, MustOccurConstraint mc, String booleanStatement) {
        mustOccursPathNames = new ArrayList<List<String>>();
        String methodName = "moConstraint-" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + ++methodKey;
        String method = "\njQuery.validator.addMethod(\"" + methodName + "\", function(value, element) {\n if(" + booleanStatement + "){return (this.optional(element) || (" + ClientValidationUtils.getMustOccurStatement(field, mc) + "));}else{return true;}}, \"" + ClientValidationUtils.getMustOccursMessage(view, mc) + "\");";
        String rule = method + "jq('[name=\"" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "\"]').rules(\"add\", {\n\"" + methodName + "\": function(element){return (" + booleanStatement + ");}\n});";
        ClientValidationUtils.addScriptToPage(view, field, rule);
    }

    private static String getMustOccurStatement(InputField field, MustOccurConstraint constraint) {
        String statement = "";
        ArrayList<String> attributePaths = new ArrayList<String>();
        if (constraint != null && constraint.getApplyClientSide().booleanValue()) {
            String array = "[";
            if (constraint.getPrerequisiteConstraints() != null) {
                for (int i = 0; i < constraint.getPrerequisiteConstraints().size(); ++i) {
                    field.getControl().addStyleClass("dependsOn-" + constraint.getPrerequisiteConstraints().get(i).getPropertyName());
                    array = array + "'" + ScriptUtils.escapeName(constraint.getPrerequisiteConstraints().get(i).getPropertyName()) + "'";
                    attributePaths.add(constraint.getPrerequisiteConstraints().get(i).getPropertyName());
                    if (i + 1 == constraint.getPrerequisiteConstraints().size()) continue;
                    array = array + LABEL_KEY_SPLIT_PATTERN;
                }
            }
            array = array + "]";
            statement = "mustOccurTotal(" + array + ", " + constraint.getMin() + ", " + constraint.getMax() + ")";
            if (constraint.getMin() != null) {
                attributePaths.add(constraint.getMin().toString());
            } else {
                attributePaths.add(null);
            }
            if (constraint.getMax() != null) {
                attributePaths.add(constraint.getMax().toString());
            } else {
                attributePaths.add(null);
            }
            mustOccursPathNames.add(attributePaths);
            if (StringUtils.isEmpty((CharSequence)statement)) {
                statement = "0";
            }
            if (constraint.getMustOccurConstraints() != null) {
                for (MustOccurConstraint mc : constraint.getMustOccurConstraints()) {
                    statement = "mustOccurCheck(" + statement + " + " + ClientValidationUtils.getMustOccurStatement(field, mc) + ", " + constraint.getMin() + ", " + constraint.getMax() + ")";
                }
            } else {
                statement = "mustOccurCheck(" + statement + ", " + constraint.getMin() + ", " + constraint.getMax() + ")";
            }
        }
        return statement;
    }

    private static String getMustOccursMessage(View view, MustOccurConstraint constraint) {
        String message = "";
        if (StringUtils.isNotEmpty((CharSequence)constraint.getLabelKey())) {
            message = ClientValidationUtils.generateMessageFromLabelKey(constraint.getValidationMessageParams(), constraint.getLabelKey());
        } else {
            String and = configService.getPropertyValueAsString(AND_MSG_KEY);
            String or = configService.getPropertyValueAsString(OR_MSG_KEY);
            String all = configService.getPropertyValueAsString(ALL_MSG_KEY);
            String atMost = configService.getPropertyValueAsString(ATMOST_MSG_KEY);
            String genericLabel = configService.getPropertyValueAsString(GENERIC_FIELD_MSG_KEY);
            String mustOccursMsg = configService.getPropertyValueAsString("validation.mustOccurs");
            String statement = "";
            for (int i = 0; i < mustOccursPathNames.size(); ++i) {
                String andedString = "";
                List<String> paths = mustOccursPathNames.get(i);
                if (!paths.isEmpty()) {
                    String min = paths.get(paths.size() - 2);
                    String max = paths.get(paths.size() - 1);
                    for (int j = 0; j < paths.size() - 2; ++j) {
                        InputField field = (InputField)view.getViewIndex().getDataFieldByPath(paths.get(j).trim());
                        String label = genericLabel;
                        if (field != null && StringUtils.isNotEmpty((CharSequence)field.getLabel())) {
                            label = field.getLabel();
                        }
                        if (min.equals(max)) {
                            if (j == 0) {
                                andedString = label;
                                continue;
                            }
                            if (j == paths.size() - 3) {
                                andedString = andedString + " " + and + " " + label;
                                continue;
                            }
                            andedString = andedString + ", " + label;
                            continue;
                        }
                        andedString = andedString + "<li>" + label + "</li>";
                    }
                    if (min.equals(max)) {
                        andedString = "<li>" + andedString + "</li>";
                    }
                    andedString = "<ul>" + andedString + "</ul>";
                    if (StringUtils.isNotEmpty((CharSequence)min) && StringUtils.isNotEmpty((CharSequence)max) && !min.equals(max)) {
                        andedString = MessageFormat.format(mustOccursMsg, min + "-" + max) + "<br/>" + andedString;
                    } else if (StringUtils.isNotEmpty((CharSequence)min) && StringUtils.isNotEmpty((CharSequence)max) && min.equals(max) && i == 0) {
                        andedString = MessageFormat.format(mustOccursMsg, all) + "<br/>" + andedString;
                    } else if (StringUtils.isNotEmpty((CharSequence)min)) {
                        andedString = MessageFormat.format(mustOccursMsg, min) + "<br/>" + andedString;
                    } else if (StringUtils.isNotEmpty((CharSequence)max)) {
                        andedString = MessageFormat.format(mustOccursMsg, atMost + " " + max) + "<br/>" + andedString;
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)andedString)) continue;
                statement = i == 0 ? andedString : statement + or.toUpperCase() + andedString;
            }
            if (StringUtils.isNotEmpty((CharSequence)statement)) {
                message = statement;
            }
        }
        return message;
    }

    public static void processAndApplyConstraints(InputField field, View view) {
        methodKey = 0;
        if (view instanceof FormView && ((FormView)view).isValidateClientSide()) {
            if (field.getSimpleConstraint() != null && field.getSimpleConstraint().getApplyClientSide().booleanValue()) {
                String rule;
                if (field.getRequired() != null && field.getRequired().booleanValue()) {
                    field.getControl().addStyleClass("required");
                }
                if (field.getExclusiveMin() != null) {
                    if (field.getControl() instanceof TextControl && ((TextControl)field.getControl()).getDatePicker() != null) {
                        ((TextControl)field.getControl()).getDatePicker().getComponentOptions().put("minDate", field.getExclusiveMin());
                    } else {
                        rule = "jq('[name=\"" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "\"]').rules(\"add\", {\n minExclusive: [" + field.getExclusiveMin() + "]});";
                        ClientValidationUtils.addScriptToPage(view, field, rule);
                    }
                }
                if (field.getInclusiveMax() != null) {
                    if (field.getControl() instanceof TextControl && ((TextControl)field.getControl()).getDatePicker() != null) {
                        ((TextControl)field.getControl()).getDatePicker().getComponentOptions().put("maxDate", field.getInclusiveMax());
                    } else {
                        rule = "jq('[name=\"" + ScriptUtils.escapeName(field.getBindingInfo().getBindingPath()) + "\"]').rules(\"add\", {\n maxInclusive: [" + field.getInclusiveMax() + "]});";
                        ClientValidationUtils.addScriptToPage(view, field, rule);
                    }
                }
            }
            if (field.getValidCharactersConstraint() != null && field.getValidCharactersConstraint().getApplyClientSide().booleanValue()) {
                if (StringUtils.isNotEmpty((CharSequence)field.getValidCharactersConstraint().getValue())) {
                    ClientValidationUtils.addScriptToPage(view, field, ClientValidationUtils.getRegexMethod(field, field.getValidCharactersConstraint()));
                    field.getControl().addStyleClass("validChar-" + field.getBindingInfo().getBindingPath() + methodKey);
                    ++methodKey;
                } else if (StringUtils.isNotEmpty((CharSequence)field.getValidCharactersConstraint().getLabelKey())) {
                    field.getControl().addStyleClass(field.getValidCharactersConstraint().getLabelKey());
                }
            }
            if (field.getCaseConstraint() != null && field.getCaseConstraint().getApplyClientSide().booleanValue()) {
                ClientValidationUtils.processCaseConstraint(field, view, field.getCaseConstraint(), null);
            }
            if (field.getDependencyConstraints() != null) {
                for (PrerequisiteConstraint prc : field.getDependencyConstraints()) {
                    ClientValidationUtils.processPrerequisiteConstraint(field, prc, view);
                }
            }
            if (field.getMustOccurConstraints() != null) {
                for (MustOccurConstraint mc : field.getMustOccurConstraints()) {
                    ClientValidationUtils.processMustOccurConstraint(field, view, mc, "true");
                }
            }
        }
    }

    static {
        configService = KRADServiceLocator.getKualiConfigurationService();
    }

    public static enum ValidationMessageKeys {
        REQUIRED("required"),
        MIN_EXCLUSIVE("minExclusive"),
        MAX_INCLUSIVE("maxInclusive"),
        MIN_LENGTH("minLengthConditional"),
        MAX_LENGTH("maxLengthConditional");

        private final String name;

        private ValidationMessageKeys(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static boolean contains(String name) {
            for (ValidationMessageKeys element : EnumSet.allOf(ValidationMessageKeys.class)) {
                if (!element.toString().equalsIgnoreCase(name)) continue;
                return true;
            }
            return false;
        }
    }
}

