/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.kfs.krad.keyvalues.KeyValuesFinder;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.uif.UifConstants;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.container.CollectionGroup;
import org.kuali.kfs.krad.uif.container.Group;
import org.kuali.kfs.krad.uif.container.LinkGroup;
import org.kuali.kfs.krad.uif.container.NavigationGroup;
import org.kuali.kfs.krad.uif.container.PageGroup;
import org.kuali.kfs.krad.uif.container.TabGroup;
import org.kuali.kfs.krad.uif.container.TreeGroup;
import org.kuali.kfs.krad.uif.control.CheckboxControl;
import org.kuali.kfs.krad.uif.control.CheckboxGroupControl;
import org.kuali.kfs.krad.uif.control.Control;
import org.kuali.kfs.krad.uif.control.ControlBase;
import org.kuali.kfs.krad.uif.control.FileControl;
import org.kuali.kfs.krad.uif.control.HiddenControl;
import org.kuali.kfs.krad.uif.control.MultiValueControl;
import org.kuali.kfs.krad.uif.control.RadioGroupControl;
import org.kuali.kfs.krad.uif.control.SelectControl;
import org.kuali.kfs.krad.uif.control.SizedControl;
import org.kuali.kfs.krad.uif.control.TextAreaControl;
import org.kuali.kfs.krad.uif.control.TextControl;
import org.kuali.kfs.krad.uif.field.ActionField;
import org.kuali.kfs.krad.uif.field.BlankField;
import org.kuali.kfs.krad.uif.field.DataField;
import org.kuali.kfs.krad.uif.field.ErrorsField;
import org.kuali.kfs.krad.uif.field.FieldGroup;
import org.kuali.kfs.krad.uif.field.GenericField;
import org.kuali.kfs.krad.uif.field.HeaderField;
import org.kuali.kfs.krad.uif.field.IframeField;
import org.kuali.kfs.krad.uif.field.ImageField;
import org.kuali.kfs.krad.uif.field.InputField;
import org.kuali.kfs.krad.uif.field.LabelField;
import org.kuali.kfs.krad.uif.field.LinkField;
import org.kuali.kfs.krad.uif.field.MessageField;
import org.kuali.kfs.krad.uif.util.ComponentUtils;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.rice.core.api.uif.RemotableAbstractWidget;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableCheckbox;
import org.kuali.rice.core.api.uif.RemotableCheckboxGroup;
import org.kuali.rice.core.api.uif.RemotableControlContract;
import org.kuali.rice.core.api.uif.RemotableDatepicker;
import org.kuali.rice.core.api.uif.RemotableHiddenInput;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.core.api.uif.RemotableRadioButtonGroup;
import org.kuali.rice.core.api.uif.RemotableSelect;
import org.kuali.rice.core.api.uif.RemotableSelectGroup;
import org.kuali.rice.core.api.uif.RemotableTextExpand;
import org.kuali.rice.core.api.uif.RemotableTextInput;
import org.kuali.rice.core.api.uif.RemotableTextarea;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

public final class ComponentFactory {
    protected static final String TEXT_CONTROL = "Uif-TextControl";
    protected static final String CHECKBOX_CONTROL = "Uif-CheckboxControl";
    protected static final String HIDDEN_CONTROL = "Uif-HiddenControl";
    protected static final String TEXTAREA_CONTROL = "Uif-TextAreaControl";
    protected static final String SELECT_CONTROL = "Uif-DropdownControl";
    protected static final String CHECKBOX_GROUP_CONTROL = "Uif-VerticalCheckboxesControl";
    protected static final String CHECKBOX_GROUP_CONTROL_HORIZONTAL = "Uif-HorizontalCheckboxesControl";
    protected static final String RADIO_GROUP_CONTROL = "Uif-VerticalRadioControl";
    protected static final String RADIO_GROUP_CONTROL_HORIZONTAL = "Uif-HorizontalRadioControl";
    protected static final String FILE_CONTROL = "Uif-FileControl";
    protected static final String DATE_CONTROL = "Uif-DateControl";
    protected static final String USER_CONTROL = "Uif-KimPersonControl";
    protected static final String GROUP_CONTROL = "Uif-KimGroupControl";
    protected static final String DATA_FIELD = "Uif-DataField";
    protected static final String INPUT_FIELD = "Uif-InputField";
    protected static final String ERRORS_FIELD = "Uif-FieldValidationMessages";
    protected static final String ACTION_FIELD = "Uif-PrimaryActionButton";
    protected static final String ACTION_LINK_FIELD = "Uif-ActionLink";
    protected static final String LINK_FIELD = "Uif-Link";
    protected static final String IFRAME_FIELD = "Uif-IframeField";
    protected static final String IMAGE_FIELD = "Uif-ImageField";
    protected static final String BLANK_FIELD = "Uif-EmptyField";
    protected static final String GENERIC_FIELD = "Uif-CustomTemplateField";
    protected static final String LABEL_FIELD = "Uif-Label";
    protected static final String MESSAGE_FIELD = "Uif-MessageField";
    protected static final String FIELD_GROUP = "Uif-VerticalFieldGroup";
    protected static final String HORIZONTAL_FIELD_GROUP = "Uif-HorizontalFieldGroup";
    protected static final String GROUP = "Uif-BoxSection";
    protected static final String PAGE_GROUP = "Uif-Page";
    protected static final String GROUP_GRID_LAYOUT = "Uif-GridSection";
    protected static final String GROUP_BODY_ONLY = "Uif-BoxGroup";
    protected static final String GROUP_GRID_BODY_ONLY = "Uif-GridGroup";
    protected static final String TAB_GROUP = "Uif-TabSection";
    protected static final String NAVIGATION_GROUP = "Uif-NavigationGroupBase";
    protected static final String TREE_GROUP = "Uif-TreeSection";
    protected static final String LINK_GROUP = "Uif-LinkGroup";
    protected static final String COLLECTION_GROUP = "Uif-StackedCollectionSection";
    protected static final String COLLECTION_GROUP_TABLE_LAYOUT = "Uif-TableCollectionSection";
    protected static final String LIST_GROUP = "Uif-ListCollectionSection";
    protected static final String HEADER = "Uif-HeaderFieldBase";
    protected static final String FOOTER = "Uif-FooterBase";
    protected static final String FOOTER_SAVECLOSECANCEL = "Uif-FormFooter";

    private ComponentFactory() {
    }

    public static Component getNewInstanceForRefresh(View view, String id) {
        Component origComponent = view.getViewIndex().getComponentById(id);
        if (origComponent == null) {
            throw new RuntimeException(id + " not found in view index try setting p:persistInSession=\"true\" in xml");
        }
        Component component = view.getViewIndex().getInitialComponentStates().containsKey(origComponent.getFactoryId()) ? view.getViewIndex().getInitialComponentStates().get(origComponent.getFactoryId()) : (Component)KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryObject(origComponent.getFactoryId());
        if (component != null) {
            component = ComponentUtils.copyObject(component);
            component.setId(origComponent.getFactoryId());
        }
        return component;
    }

    public static Component getNewComponentInstance(String beanId) {
        Component component = (Component)KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryObject(beanId);
        component.setId(null);
        component.setFactoryId(null);
        return component;
    }

    public static TextControl getTextControl() {
        return (TextControl)ComponentFactory.getNewComponentInstance(TEXT_CONTROL);
    }

    public static TextAreaControl getTextAreaControl() {
        return (TextAreaControl)ComponentFactory.getNewComponentInstance(TEXTAREA_CONTROL);
    }

    public static CheckboxControl getCheckboxControl() {
        return (CheckboxControl)ComponentFactory.getNewComponentInstance(CHECKBOX_CONTROL);
    }

    public static HiddenControl getHiddenControl() {
        return (HiddenControl)ComponentFactory.getNewComponentInstance(HIDDEN_CONTROL);
    }

    public static SelectControl getSelectControl() {
        return (SelectControl)ComponentFactory.getNewComponentInstance(SELECT_CONTROL);
    }

    public static CheckboxGroupControl getCheckboxGroupControl() {
        return (CheckboxGroupControl)ComponentFactory.getNewComponentInstance(CHECKBOX_GROUP_CONTROL);
    }

    public static CheckboxGroupControl getCheckboxGroupControlHorizontal() {
        return (CheckboxGroupControl)ComponentFactory.getNewComponentInstance(CHECKBOX_GROUP_CONTROL_HORIZONTAL);
    }

    public static RadioGroupControl getRadioGroupControl() {
        return (RadioGroupControl)ComponentFactory.getNewComponentInstance(RADIO_GROUP_CONTROL);
    }

    public static RadioGroupControl getRadioGroupControlHorizontal() {
        return (RadioGroupControl)ComponentFactory.getNewComponentInstance(RADIO_GROUP_CONTROL_HORIZONTAL);
    }

    public static FileControl getFileControl() {
        return (FileControl)ComponentFactory.getNewComponentInstance(FILE_CONTROL);
    }

    public static TextControl getDateControl() {
        return (TextControl)ComponentFactory.getNewComponentInstance(DATE_CONTROL);
    }

    public static TextControl getUserControl() {
        return (TextControl)ComponentFactory.getNewComponentInstance(USER_CONTROL);
    }

    public static TextControl getGroupControl() {
        return (TextControl)ComponentFactory.getNewComponentInstance(GROUP_CONTROL);
    }

    public static DataField getDataField() {
        return (DataField)ComponentFactory.getNewComponentInstance(DATA_FIELD);
    }

    public static DataField getDataField(String propertyName, String label) {
        DataField field = (DataField)ComponentFactory.getNewComponentInstance(DATA_FIELD);
        field.setPropertyName(propertyName);
        field.setLabel(label);
        return field;
    }

    public static InputField getInputField() {
        return (InputField)ComponentFactory.getNewComponentInstance(INPUT_FIELD);
    }

    public static InputField getInputField(String propertyName, String label) {
        InputField field = (InputField)ComponentFactory.getNewComponentInstance(INPUT_FIELD);
        field.setPropertyName(propertyName);
        field.setLabel(label);
        return field;
    }

    public static InputField getInputField(String propertyName, String label, UifConstants.ControlType controlType) {
        InputField field = (InputField)ComponentFactory.getNewComponentInstance(INPUT_FIELD);
        field.setPropertyName(propertyName);
        field.setLabel(label);
        field.setControl(ComponentFactory.getControl(controlType));
        return field;
    }

    public static InputField getInputField(String propertyName, String label, UifConstants.ControlType controlType, String defaultValue) {
        InputField field = (InputField)ComponentFactory.getNewComponentInstance(INPUT_FIELD);
        field.setPropertyName(propertyName);
        field.setLabel(label);
        field.setControl(ComponentFactory.getControl(controlType));
        field.setDefaultValue(defaultValue);
        return field;
    }

    public static InputField getInputField(String propertyName, String label, UifConstants.ControlType controlType, Class<? extends KeyValuesFinder> optionsFinderClass) {
        InputField field = (InputField)ComponentFactory.getNewComponentInstance(INPUT_FIELD);
        field.setPropertyName(propertyName);
        field.setLabel(label);
        field.setControl(ComponentFactory.getControl(controlType));
        field.setOptionsFinderClass(optionsFinderClass);
        return field;
    }

    public static InputField getInputField(String propertyName, String label, UifConstants.ControlType controlType, List<KeyValue> options) {
        InputField field = (InputField)ComponentFactory.getNewComponentInstance(INPUT_FIELD);
        field.setPropertyName(propertyName);
        field.setLabel(label);
        Control control = ComponentFactory.getControl(controlType);
        if (!(control instanceof MultiValueControl)) {
            throw new RuntimeException("Control is not instance of multi-value control, cannot set options");
        }
        ((MultiValueControl)((Object)control)).setOptions(options);
        return field;
    }

    public static InputField getInputField(String propertyName, String label, UifConstants.ControlType controlType, int size, int maxLength, int minLength) {
        InputField field = (InputField)ComponentFactory.getNewComponentInstance(INPUT_FIELD);
        field.setPropertyName(propertyName);
        field.setLabel(label);
        Control control = ComponentFactory.getControl(controlType);
        if (!(control instanceof SizedControl)) {
            throw new RuntimeException("Control does not support the size property");
        }
        ((SizedControl)((Object)control)).setSize(size);
        field.setMaxLength(maxLength);
        field.setMinLength(minLength);
        return field;
    }

    public static InputField translateRemotableField(RemotableAttributeField remotableField) {
        InputField inputField = ComponentFactory.getInputField();
        inputField.setPropertyName(remotableField.getName());
        inputField.setShortLabel(remotableField.getShortLabel());
        inputField.setLabel(remotableField.getLongLabel());
        inputField.setHelpSummary(remotableField.getHelpSummary());
        inputField.setHelpDescription(remotableField.getHelpDescription());
        inputField.setConstraintText(remotableField.getConstraintText());
        inputField.setPerformUppercase(remotableField.isForceUpperCase());
        inputField.setMinLength(remotableField.getMinLength());
        inputField.setMaxLength(remotableField.getMaxLength());
        if (remotableField.getMinValue() != null) {
            inputField.setExclusiveMin(remotableField.getMinValue().toString());
        }
        if (remotableField.getMaxValue() != null) {
            inputField.setInclusiveMax(remotableField.getMaxValue().toString());
        }
        inputField.setRequired(remotableField.isRequired());
        if (remotableField.getDefaultValues() != null && !remotableField.getDefaultValues().isEmpty()) {
            inputField.setDefaultValue((String)remotableField.getDefaultValues().iterator().next());
        }
        if (StringUtils.isNotBlank((CharSequence)remotableField.getRegexConstraint())) {
            ValidCharactersConstraint constraint = new ValidCharactersConstraint();
            constraint.setValue(remotableField.getRegexConstraint());
            inputField.setValidCharactersConstraint(constraint);
        }
        RemotableDatepicker remotableDatepicker = null;
        RemotableTextExpand remotableTextExpand = null;
        RemotableQuickFinder remotableQuickFinder = null;
        for (RemotableAbstractWidget remoteWidget : remotableField.getWidgets()) {
            if (remoteWidget instanceof RemotableDatepicker) {
                remotableDatepicker = (RemotableDatepicker)remoteWidget;
                continue;
            }
            if (remoteWidget instanceof RemotableTextExpand) {
                remotableTextExpand = (RemotableTextExpand)remoteWidget;
                continue;
            }
            if (!(remoteWidget instanceof RemotableQuickFinder)) continue;
            remotableQuickFinder = (RemotableQuickFinder)remoteWidget;
        }
        if (remotableQuickFinder != null) {
            inputField.getFieldLookup().setBaseLookupUrl(remotableQuickFinder.getBaseLookupUrl());
            inputField.getFieldLookup().setDataObjectClassName(remotableQuickFinder.getDataObjectClass());
            inputField.getFieldLookup().setLookupParameters(remotableQuickFinder.getLookupParameters());
            inputField.getFieldLookup().setFieldConversions(remotableQuickFinder.getFieldConversions());
        }
        if (remotableField.getControl() != null) {
            ControlBase control = null;
            RemotableControlContract remotableControl = remotableField.getControl();
            if (remotableControl instanceof RemotableHiddenInput) {
                control = ComponentFactory.getHiddenControl();
            } else if (remotableControl instanceof RemotableRadioButtonGroup) {
                RemotableRadioButtonGroup remotableRadioButtonGroup = (RemotableRadioButtonGroup)remotableControl;
                control = ComponentFactory.getRadioGroupControl();
                ((RadioGroupControl)control).setOptions(ComponentFactory.buildKeyValuePairs(remotableRadioButtonGroup.getKeyLabels()));
            } else if (remotableControl instanceof RemotableSelect) {
                RemotableSelect remotableSelect = (RemotableSelect)remotableControl;
                control = ComponentFactory.getSelectControl();
                HashMap<String, String> keyLabels = new HashMap();
                if (remotableSelect.getGroups() != null && !remotableSelect.getGroups().isEmpty()) {
                    for (RemotableSelectGroup remotableSelectGroup : remotableSelect.getGroups()) {
                        keyLabels.putAll(remotableSelectGroup.getKeyLabels());
                    }
                } else {
                    keyLabels = remotableSelect.getKeyLabels();
                }
                ((SelectControl)control).setOptions(ComponentFactory.buildKeyValuePairs(keyLabels));
                if (remotableSelect.getSize() != null) {
                    ((SelectControl)control).setSize(remotableSelect.getSize());
                }
                ((SelectControl)control).setMultiple(remotableSelect.isMultiple());
            } else if (remotableControl instanceof RemotableCheckboxGroup) {
                RemotableCheckboxGroup remotableCheckboxGroup = (RemotableCheckboxGroup)remotableControl;
                control = ComponentFactory.getCheckboxGroupControl();
                ((CheckboxGroupControl)control).setOptions(ComponentFactory.buildKeyValuePairs(remotableCheckboxGroup.getKeyLabels()));
            } else if (remotableControl instanceof RemotableCheckbox) {
                control = ComponentFactory.getCheckboxControl();
            } else if (remotableControl instanceof RemotableTextarea) {
                RemotableTextarea remotableTextarea = (RemotableTextarea)remotableControl;
                control = ComponentFactory.getTextAreaControl();
                if (remotableTextExpand != null) {
                    ((TextAreaControl)control).setTextExpand(true);
                }
                ((TextAreaControl)control).setRows(remotableTextarea.getRows());
                ((TextAreaControl)control).setCols(remotableTextarea.getCols());
                ((TextAreaControl)control).setWatermarkText(remotableTextarea.getWatermark());
            } else if (remotableControl instanceof RemotableTextInput) {
                RemotableTextInput remotableTextInput = (RemotableTextInput)remotableControl;
                control = remotableDatepicker != null ? ComponentFactory.getDateControl() : ComponentFactory.getTextControl();
                if (remotableTextExpand != null) {
                    ((TextAreaControl)control).setTextExpand(true);
                }
                ((TextControl)control).setSize(remotableTextInput.getSize());
                ((TextControl)control).setWatermarkText(remotableTextInput.getWatermark());
            }
            inputField.setControl(control);
        }
        return inputField;
    }

    public static List<InputField> translateRemotableFields(List<RemotableAttributeField> remotableFields) {
        ArrayList<InputField> inputFields = new ArrayList<InputField>();
        for (RemotableAttributeField remotableField : remotableFields) {
            inputFields.add(ComponentFactory.translateRemotableField(remotableField));
        }
        return inputFields;
    }

    protected static List<KeyValue> buildKeyValuePairs(Map<String, String> optionsMap) {
        ArrayList<KeyValue> options = new ArrayList<KeyValue>();
        for (Map.Entry<String, String> optionEntry : optionsMap.entrySet()) {
            ConcreteKeyValue keyValue = new ConcreteKeyValue(optionEntry.getKey(), optionEntry.getValue());
            options.add((KeyValue)keyValue);
        }
        return options;
    }

    protected static Control getControl(UifConstants.ControlType controlType) {
        ControlBase control = null;
        switch (controlType) {
            case CHECKBOX: {
                control = ComponentFactory.getCheckboxControl();
                break;
            }
            case CHECKBOXGROUP: {
                control = ComponentFactory.getCheckboxGroupControl();
                break;
            }
            case FILE: {
                control = ComponentFactory.getFileControl();
                break;
            }
            case GROUP: {
                control = ComponentFactory.getGroupControl();
                break;
            }
            case HIDDEN: {
                control = ComponentFactory.getHiddenControl();
                break;
            }
            case RADIOGROUP: {
                control = ComponentFactory.getRadioGroupControl();
                break;
            }
            case SELECT: {
                control = ComponentFactory.getSelectControl();
                break;
            }
            case TEXTAREA: {
                control = ComponentFactory.getTextAreaControl();
                break;
            }
            case TEXT: {
                control = ComponentFactory.getTextControl();
                break;
            }
            case USER: {
                control = ComponentFactory.getUserControl();
                break;
            }
        }
        return control;
    }

    public static ErrorsField getErrorsField() {
        return (ErrorsField)ComponentFactory.getNewComponentInstance(ERRORS_FIELD);
    }

    public static ActionField getActionField() {
        return (ActionField)ComponentFactory.getNewComponentInstance(ACTION_FIELD);
    }

    public static ActionField getActionLinkField() {
        return (ActionField)ComponentFactory.getNewComponentInstance(ACTION_LINK_FIELD);
    }

    public static LinkField getLinkField() {
        return (LinkField)ComponentFactory.getNewComponentInstance(LINK_FIELD);
    }

    public static IframeField getIframeField() {
        return (IframeField)ComponentFactory.getNewComponentInstance(IFRAME_FIELD);
    }

    public static ImageField getImageField() {
        return (ImageField)ComponentFactory.getNewComponentInstance(IMAGE_FIELD);
    }

    public static BlankField getBlankField() {
        return (BlankField)ComponentFactory.getNewComponentInstance(BLANK_FIELD);
    }

    public static GenericField getGenericField() {
        return (GenericField)ComponentFactory.getNewComponentInstance(GENERIC_FIELD);
    }

    public static LabelField getLabelField() {
        return (LabelField)ComponentFactory.getNewComponentInstance(LABEL_FIELD);
    }

    public static MessageField getMessageField() {
        return (MessageField)ComponentFactory.getNewComponentInstance(MESSAGE_FIELD);
    }

    public static FieldGroup getFieldGroup() {
        return (FieldGroup)ComponentFactory.getNewComponentInstance(FIELD_GROUP);
    }

    public static FieldGroup getHorizontalFieldGroup() {
        return (FieldGroup)ComponentFactory.getNewComponentInstance(HORIZONTAL_FIELD_GROUP);
    }

    public static Group getGroup() {
        return (Group)ComponentFactory.getNewComponentInstance(GROUP);
    }

    public static PageGroup getPageGroup() {
        return (PageGroup)ComponentFactory.getNewComponentInstance(PAGE_GROUP);
    }

    public static Group getGroupGridLayout() {
        return (Group)ComponentFactory.getNewComponentInstance(GROUP_GRID_LAYOUT);
    }

    public static Group getGroupBodyOnly() {
        return (Group)ComponentFactory.getNewComponentInstance(GROUP_BODY_ONLY);
    }

    public static Group getGroupGridBodyOnly() {
        return (Group)ComponentFactory.getNewComponentInstance(GROUP_GRID_BODY_ONLY);
    }

    public static TabGroup getTabGroup() {
        return (TabGroup)ComponentFactory.getNewComponentInstance(TAB_GROUP);
    }

    public static NavigationGroup getNavigationGroup() {
        return (NavigationGroup)ComponentFactory.getNewComponentInstance(NAVIGATION_GROUP);
    }

    public static TreeGroup getTreeGroup() {
        return (TreeGroup)ComponentFactory.getNewComponentInstance(TREE_GROUP);
    }

    public static LinkGroup getLinkGroup() {
        return (LinkGroup)ComponentFactory.getNewComponentInstance(LINK_GROUP);
    }

    public static CollectionGroup getCollectionGroup() {
        return (CollectionGroup)ComponentFactory.getNewComponentInstance(COLLECTION_GROUP);
    }

    public static CollectionGroup getCollectionGroupTableLayout() {
        return (CollectionGroup)ComponentFactory.getNewComponentInstance(COLLECTION_GROUP_TABLE_LAYOUT);
    }

    public static CollectionGroup getListGroup() {
        return (CollectionGroup)ComponentFactory.getNewComponentInstance(LIST_GROUP);
    }

    public static HeaderField getHeader() {
        return (HeaderField)ComponentFactory.getNewComponentInstance(HEADER);
    }

    public static Group getFooter() {
        return (Group)ComponentFactory.getNewComponentInstance(FOOTER);
    }

    public static Group getFooterSaveCloseCancel() {
        return (Group)ComponentFactory.getNewComponentInstance(FOOTER_SAVECLOSECANCEL);
    }
}

