/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.uif.component.BindingInfo;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.container.CollectionGroup;
import org.kuali.kfs.krad.uif.field.DataField;
import org.kuali.kfs.krad.uif.layout.LayoutManager;
import org.kuali.kfs.krad.uif.util.ObjectPropertyUtils;
import org.kuali.kfs.krad.uif.view.View;

public final class ExpressionUtils {
    private ExpressionUtils() {
    }

    public static void adjustPropertyExpressions(View view, Object object) {
        if (object == null) {
            return;
        }
        Map<Object, Object> propertyExpressions = new HashMap();
        if (Component.class.isAssignableFrom(object.getClass())) {
            propertyExpressions = ((Component)object).getPropertyExpressions();
        } else if (LayoutManager.class.isAssignableFrom(object.getClass())) {
            propertyExpressions = ((LayoutManager)object).getPropertyExpressions();
        } else if (BindingInfo.class.isAssignableFrom(object.getClass())) {
            propertyExpressions = ((BindingInfo)object).getPropertyExpressions();
        }
        HashMap<String, String> adjustedPropertyExpressions = new HashMap<String, String>();
        for (Map.Entry<Object, Object> propertyExpression : propertyExpressions.entrySet()) {
            boolean expressionMoved;
            String propertyName = (String)propertyExpression.getKey();
            String expression = (String)propertyExpression.getValue();
            if (StringUtils.contains((CharSequence)propertyName, (CharSequence)".") && (expressionMoved = ExpressionUtils.moveNestedPropertyExpression(object, propertyName, expression))) continue;
            String adjustedExpression = ExpressionUtils.replaceBindingPrefixes(view, object, expression);
            adjustedPropertyExpressions.put(propertyName, adjustedExpression);
        }
        ObjectPropertyUtils.setPropertyValue(object, "propertyExpressions", adjustedPropertyExpressions);
    }

    public static String replaceBindingPrefixes(View view, Object object, String expression) {
        String adjustedExpression = StringUtils.replace((String)expression, (String)"#form.", (String)"");
        if (object instanceof DataField) {
            BindingInfo bindingInfo = ((DataField)object).getBindingInfo();
            String fieldPath = bindingInfo.getBindingPath();
            fieldPath = StringUtils.removeEnd((String)fieldPath, (String)("." + bindingInfo.getBindingName()));
            adjustedExpression = StringUtils.replace((String)adjustedExpression, (String)"#fp.", (String)(fieldPath + "."));
        } else {
            adjustedExpression = StringUtils.replace((String)adjustedExpression, (String)"#fp.", (String)"");
        }
        adjustedExpression = StringUtils.isNotBlank((CharSequence)view.getDefaultBindingObjectPath()) ? StringUtils.replace((String)adjustedExpression, (String)"#dp.", (String)(view.getDefaultBindingObjectPath() + ".")) : StringUtils.replace((String)adjustedExpression, (String)"#dp.", (String)"");
        if (adjustedExpression.contains("#lp.") && object instanceof Component) {
            String linePath = ExpressionUtils.getLinePathPrefixValue((Component)object);
            adjustedExpression = StringUtils.replace((String)adjustedExpression, (String)"#lp.", (String)(linePath + "."));
        }
        if (adjustedExpression.contains("#np.") && object instanceof Component) {
            String nodePath = "";
            Map<String, Object> context = ((Component)object).getContext();
            if (context.containsKey("nodePath")) {
                nodePath = (String)context.get("nodePath");
            }
            adjustedExpression = StringUtils.replace((String)adjustedExpression, (String)"#np.", (String)(nodePath + "."));
        }
        return adjustedExpression;
    }

    protected static String getLinePathPrefixValue(Component component) {
        String linePath = "";
        CollectionGroup collectionGroup = (CollectionGroup)component.getContext().get("collectionGroup");
        if (collectionGroup == null) {
            return linePath;
        }
        Object indexObj = component.getContext().get("index");
        if (indexObj != null) {
            int index = (Integer)indexObj;
            boolean addLine = false;
            Object addLineObj = component.getContext().get("isAddLine");
            if (addLineObj != null) {
                addLine = (Boolean)addLineObj;
            }
            linePath = addLine ? collectionGroup.getAddLineBindingInfo().getBindingPath() : collectionGroup.getBindingInfo().getBindingPath() + "[" + index + "]";
        }
        return linePath;
    }

    protected static boolean moveNestedPropertyExpression(Object object, String propertyName, String expression) {
        boolean moved = false;
        String parentPropertyName = StringUtils.substringBeforeLast((String)propertyName, (String)".");
        String propertyNameInParent = StringUtils.substringAfterLast((String)propertyName, (String)".");
        Object parentObject = ObjectPropertyUtils.getPropertyValue(object, parentPropertyName);
        if (parentObject != null && ObjectPropertyUtils.isReadableProperty(parentObject, "propertyExpressions") && (parentObject instanceof Component || parentObject instanceof LayoutManager || parentObject instanceof BindingInfo)) {
            HashMap<String, String> propertyExpressions = (HashMap<String, String>)ObjectPropertyUtils.getPropertyValue(parentObject, "propertyExpressions");
            if (propertyExpressions == null) {
                propertyExpressions = new HashMap<String, String>();
            }
            propertyExpressions.put(propertyNameInParent, expression);
            ObjectPropertyUtils.setPropertyValue(parentObject, "propertyExpressions", propertyExpressions);
            moved = true;
        }
        return moved;
    }

    public static String parseExpression(String exp, List<String> controlNames) {
        if ((exp = exp.trim()).startsWith("@{") && (exp = StringUtils.removeStart((String)exp, (String)"@{")).endsWith("}")) {
            exp = StringUtils.removeEnd((String)exp, (String)"}");
        }
        exp = StringUtils.replace((String)exp, (String)"!=", (String)" != ");
        exp = StringUtils.replace((String)exp, (String)"==", (String)" == ");
        exp = StringUtils.replace((String)exp, (String)">", (String)" > ");
        exp = StringUtils.replace((String)exp, (String)"<", (String)" < ");
        exp = StringUtils.replace((String)exp, (String)"<=", (String)" <= ");
        String conditionJs = exp = StringUtils.replace((String)exp, (String)">=", (String)" >= ");
        String stack = "";
        boolean expectingSingleQuote = false;
        boolean ignoreNext = false;
        for (int i = 0; i < exp.length(); ++i) {
            char c = exp.charAt(i);
            if (!(expectingSingleQuote || ignoreNext || c != '(' && c != ' ' && c != ')')) {
                ExpressionUtils.evaluateCurrentStack(stack.trim(), controlNames);
                stack = "";
                continue;
            }
            if (!ignoreNext && c == '\'') {
                stack = stack + c;
                expectingSingleQuote = !expectingSingleQuote;
                continue;
            }
            if (c == '\\') {
                stack = stack + c;
                ignoreNext = !ignoreNext;
                continue;
            }
            stack = stack + c;
            ignoreNext = false;
        }
        if (StringUtils.isNotEmpty((CharSequence)stack)) {
            ExpressionUtils.evaluateCurrentStack(stack.trim(), controlNames);
        }
        if ((conditionJs = conditionJs.replaceAll("\\s(?i:ne)\\s", " != ").replaceAll("\\s(?i:eq)\\s", " == ").replaceAll("\\s(?i:gt)\\s", " > ").replaceAll("\\s(?i:lt)\\s", " < ").replaceAll("\\s(?i:lte)\\s", " <= ").replaceAll("\\s(?i:gte)\\s", " >= ").replaceAll("\\s(?i:and)\\s", " && ").replaceAll("\\s(?i:or)\\s", " || ").replaceAll("\\s(?i:not)\\s", " != ").replaceAll("\\s(?i:null)\\s?", " '' ").replaceAll("\\s?(?i:#empty)\\((.*?)\\)", "isValueEmpty($1)")).contains("matches")) {
            conditionJs = conditionJs.replaceAll("\\s+(?i:matches)\\s+'.*'", ".match(/$0/) != null ");
            conditionJs = conditionJs.replaceAll("\\(/\\s+(?i:matches)\\s+'", "(/");
            conditionJs = conditionJs.replaceAll("'\\s*/\\)", "/)");
        }
        for (String propertyName : controlNames) {
            conditionJs = conditionJs.replace(propertyName, "coerceValue(\"" + propertyName + "\")");
        }
        return conditionJs;
    }

    public static void evaluateCurrentStack(String stack, List<String> controlNames) {
        if (!(!StringUtils.isNotBlank((CharSequence)stack) || "==".equals(stack) || "!=".equals(stack) || ">".equals(stack) || "<".equals(stack) || ">=".equals(stack) || "<=".equals(stack) || "ne".equalsIgnoreCase(stack) || "eq".equalsIgnoreCase(stack) || "gt".equalsIgnoreCase(stack) || "lt".equalsIgnoreCase(stack) || "lte".equalsIgnoreCase(stack) || "gte".equalsIgnoreCase(stack) || "matches".equalsIgnoreCase(stack) || "null".equalsIgnoreCase(stack) || "false".equalsIgnoreCase(stack) || "true".equalsIgnoreCase(stack) || "and".equalsIgnoreCase(stack) || "or".equalsIgnoreCase(stack) || stack.contains("#empty") || stack.startsWith("'") || stack.endsWith("'"))) {
            boolean isNumber = false;
            if (StringUtils.isNumeric((CharSequence)stack.substring(0, 1)) || stack.substring(0, 1).equals("-")) {
                try {
                    Double.parseDouble(stack);
                    isNumber = true;
                }
                catch (NumberFormatException e) {
                    isNumber = false;
                }
            }
            if (!isNumber && !controlNames.contains(stack)) {
                controlNames.add(stack);
            }
        }
    }
}

