/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.util;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.uif.field.DataField;
import org.kuali.kfs.krad.uif.util.ObjectPropertyUtils;
import org.kuali.kfs.krad.uif.view.View;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.TypedStringValue;

public final class ViewModelUtils {
    private ViewModelUtils() {
    }

    public static Class<?> getPropertyTypeByClassAndView(View view, String propertyPath) {
        Class<?> propertyType = null;
        if (StringUtils.isBlank((CharSequence)propertyPath)) {
            return null;
        }
        Class<?> modelClass = view.getFormClass();
        String modelProperty = propertyPath;
        int bestMatchLength = 0;
        String flattenedPropertyPath = propertyPath.replaceAll("\\[.+\\]", "");
        Map<String, Class<?>> modelClasses = view.getAbstractTypeClasses();
        for (String path : modelClasses.keySet()) {
            if (StringUtils.equals((CharSequence)path, (CharSequence)flattenedPropertyPath)) {
                propertyType = modelClasses.get(path);
                break;
            }
            if (!flattenedPropertyPath.startsWith(path) || path.length() <= bestMatchLength) continue;
            bestMatchLength = path.length();
            modelClass = modelClasses.get(path);
            modelProperty = StringUtils.removeStart((String)flattenedPropertyPath, (String)path);
            modelProperty = StringUtils.removeStart((String)modelProperty, (String)".");
        }
        if (propertyType == null) {
            propertyType = ObjectPropertyUtils.getPropertyType(modelClass, modelProperty);
        }
        return propertyType;
    }

    public static String getParentObjectPath(DataField field) {
        String parentObjectPath = "";
        String objectPath = field.getBindingInfo().getBindingObjectPath();
        String propertyPrefix = field.getBindingInfo().getBindByNamePrefix();
        if (!field.getBindingInfo().isBindToForm() && StringUtils.isNotBlank((CharSequence)objectPath)) {
            parentObjectPath = objectPath;
        }
        if (StringUtils.isNotBlank((CharSequence)propertyPrefix)) {
            if (StringUtils.isNotBlank((CharSequence)parentObjectPath)) {
                parentObjectPath = parentObjectPath + ".";
            }
            parentObjectPath = parentObjectPath + propertyPrefix;
        }
        return parentObjectPath;
    }

    public static Class<?> getParentObjectClassForMetadata(View view, DataField field) {
        String parentObjectPath = ViewModelUtils.getParentObjectPath(field);
        return ViewModelUtils.getPropertyTypeByClassAndView(view, parentObjectPath);
    }

    public static Class<?> getParentObjectClassForMetadata(View view, Object model, DataField field) {
        String parentObjectPath = ViewModelUtils.getParentObjectPath(field);
        return ViewModelUtils.getObjectClassForMetadata(view, model, parentObjectPath);
    }

    public static Class<?> getObjectClassForMetadata(View view, Object model, String propertyPath) {
        Object parentObject = ObjectPropertyUtils.getPropertyValue(model, propertyPath);
        if (parentObject != null) {
            return parentObject.getClass();
        }
        return ViewModelUtils.getPropertyTypeByClassAndView(view, propertyPath);
    }

    public static Object getParentObjectForMetadata(View view, Object model, DataField field) {
        Object parentObject = model;
        String parentObjectPath = ViewModelUtils.getParentObjectPath(field);
        if (StringUtils.isNotBlank((CharSequence)parentObjectPath) && ((parentObject = ObjectPropertyUtils.getPropertyValue(model, parentObjectPath)) == null || Collection.class.isAssignableFrom(parentObject.getClass()) || Map.class.isAssignableFrom(parentObject.getClass()))) {
            try {
                Class<?> parentObjectClass = ViewModelUtils.getPropertyTypeByClassAndView(view, parentObjectPath);
                if (parentObjectClass != null) {
                    parentObject = parentObjectClass.newInstance();
                }
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return parentObject;
    }

    public static String getStringValFromPVs(PropertyValues propertyValues, String propertyName) {
        String propertyValue = null;
        if (propertyValues != null && propertyValues.contains(propertyName)) {
            Object pvValue = propertyValues.getPropertyValue(propertyName).getValue();
            if (pvValue instanceof TypedStringValue) {
                TypedStringValue typedStringValue = (TypedStringValue)pvValue;
                propertyValue = typedStringValue.getValue();
            } else if (pvValue instanceof String) {
                propertyValue = (String)pvValue;
            }
        }
        return propertyValue;
    }
}

