/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.uif.widget;

import java.security.GeneralSecurityException;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.uif.component.BindingInfo;
import org.kuali.kfs.krad.uif.component.Component;
import org.kuali.kfs.krad.uif.field.DataField;
import org.kuali.kfs.krad.uif.field.LinkField;
import org.kuali.kfs.krad.uif.util.LookupInquiryUtils;
import org.kuali.kfs.krad.uif.util.ObjectPropertyUtils;
import org.kuali.kfs.krad.uif.util.ViewModelUtils;
import org.kuali.kfs.krad.uif.view.View;
import org.kuali.kfs.krad.uif.widget.WidgetBase;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.web.format.Formatter;

public class Inquiry
extends WidgetBase {
    private static final long serialVersionUID = -2154388007867302901L;
    private static final Logger LOG = LogManager.getLogger(Inquiry.class);
    public static final String INQUIRY_TITLE_PREFIX = "title.inquiry.url.value.prependtext";
    private String baseInquiryUrl;
    private String dataObjectClassName;
    private String viewName;
    private Map<String, String> inquiryParameters = new HashMap<String, String>();
    private boolean forceInquiry = false;
    private LinkField inquiryLinkField;

    @Override
    public void performFinalize(View view, Object model, Component parent) {
        super.performFinalize(view, model, parent);
        if (!this.isRender() || !this.isReadOnly()) {
            return;
        }
        this.setRender(false);
        DataField field = (DataField)parent;
        Object propertyValue = ObjectPropertyUtils.getPropertyValue(model, field.getBindingInfo().getBindingPath());
        if (propertyValue == null || StringUtils.isBlank((CharSequence)propertyValue.toString())) {
            return;
        }
        this.setupLink(view, model, field);
    }

    public void setupLink(View view, Object model, DataField field) {
        String propertyName = field.getBindingInfo().getBindingName();
        if (StringUtils.isNotBlank((CharSequence)this.getDataObjectClassName()) && this.getInquiryParameters() != null && !this.getInquiryParameters().isEmpty()) {
            Class<?> inquiryObjectClass;
            try {
                inquiryObjectClass = Class.forName(this.getDataObjectClassName());
            }
            catch (ClassNotFoundException e) {
                LOG.error("Unable to get class for: " + this.getDataObjectClassName());
                throw new RuntimeException(e);
            }
            this.updateInquiryParameters(field.getBindingInfo());
            this.buildInquiryLink(model, propertyName, inquiryObjectClass, this.getInquiryParameters());
        } else {
            Object parentObject = ViewModelUtils.getParentObjectForMetadata(view, model, field);
            view.getViewHelperService().buildInquiryLink(parentObject, propertyName, this);
        }
    }

    public void updateInquiryParameters(BindingInfo bindingInfo) {
        HashMap<String, String> adjustedInquiryParameters = new HashMap<String, String>();
        for (String fromField : this.inquiryParameters.keySet()) {
            String toField = this.inquiryParameters.get(fromField);
            String adjustedFromFieldPath = bindingInfo.getPropertyAdjustedBindingPath(fromField);
            adjustedInquiryParameters.put(adjustedFromFieldPath, toField);
        }
        this.inquiryParameters = adjustedInquiryParameters;
    }

    public void buildInquiryLink(Object dataObject, String propertyName, Class<?> inquiryObjectClass, Map<String, String> inquiryParms) {
        Properties urlParameters = new Properties();
        urlParameters.put("dataObjectClassName", inquiryObjectClass.getName());
        urlParameters.put("methodToCall", "start");
        for (Map.Entry<String, String> inquiryParameter : inquiryParms.entrySet()) {
            String parameterName = inquiryParameter.getKey();
            Object parameterValue = ObjectPropertyUtils.getPropertyValue(dataObject, parameterName);
            if (parameterValue == null) {
                parameterValue = "";
            } else if (parameterValue instanceof Date) {
                if (Formatter.findFormatter(parameterValue.getClass()) != null) {
                    Formatter formatter = Formatter.getFormatter(parameterValue.getClass());
                    parameterValue = formatter.format(parameterValue);
                }
            } else {
                parameterValue = parameterValue.toString();
            }
            if (KRADServiceLocatorWeb.getDataObjectAuthorizationService().attributeValueNeedsToBeEncryptedOnFormsAndLinks(inquiryObjectClass, inquiryParameter.getValue())) {
                try {
                    if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                        parameterValue = CoreApiServiceLocator.getEncryptionService().encrypt(parameterValue);
                    }
                }
                catch (GeneralSecurityException e) {
                    LOG.error("Exception while trying to encrypted value for inquiry framework.", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            urlParameters.put(inquiryParameter.getValue(), parameterValue);
        }
        ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(inquiryObjectClass);
        String inquiryUrl = responsibleModuleService != null && responsibleModuleService.isExternalizable(inquiryObjectClass) ? responsibleModuleService.getExternalizableDataObjectLookupUrl(inquiryObjectClass, urlParameters) : UrlFactory.parameterizeUrl(this.getBaseInquiryUrl(), urlParameters);
        this.getInquiryLinkField().setHrefText(inquiryUrl);
        String linkTitle = this.createTitleText(inquiryObjectClass);
        linkTitle = LookupInquiryUtils.getLinkTitleText(linkTitle, inquiryObjectClass, this.getInquiryParameters());
        this.getInquiryLinkField().setTitle(linkTitle);
        this.setRender(true);
    }

    public String createTitleText(Class<?> dataObjectClass) {
        String objectLabel;
        String titleText = "";
        String titlePrefixProp = KRADServiceLocator.getKualiConfigurationService().getPropertyValueAsString(INQUIRY_TITLE_PREFIX);
        if (StringUtils.isNotBlank((CharSequence)titlePrefixProp)) {
            titleText = titleText + titlePrefixProp + " ";
        }
        if (StringUtils.isNotBlank((CharSequence)(objectLabel = KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getDataObjectEntry(dataObjectClass.getName()).getObjectLabel()))) {
            titleText = titleText + objectLabel + " ";
        }
        return titleText;
    }

    @Override
    public List<Component> getComponentsForLifecycle() {
        List<Component> components = super.getComponentsForLifecycle();
        components.add(this.getInquiryLinkField());
        return components;
    }

    public String getBaseInquiryUrl() {
        return this.baseInquiryUrl;
    }

    public void setBaseInquiryUrl(String baseInquiryUrl) {
        this.baseInquiryUrl = baseInquiryUrl;
    }

    public String getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(String dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public boolean isForceInquiry() {
        return this.forceInquiry;
    }

    public void setForceInquiry(boolean forceInquiry) {
        this.forceInquiry = forceInquiry;
    }

    public Map<String, String> getInquiryParameters() {
        return this.inquiryParameters;
    }

    public void setInquiryParameters(Map<String, String> inquiryParameters) {
        this.inquiryParameters = inquiryParameters;
    }

    public LinkField getInquiryLinkField() {
        return this.inquiryLinkField;
    }

    public void setInquiryLinkField(LinkField inquiryLinkField) {
        this.inquiryLinkField = inquiryLinkField;
    }
}

