/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.util;

import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.apache.commons.beanutils.PropertyUtils;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;

public final class DataTypeUtil {
    private DataTypeUtil() {
    }

    public static String determineFieldDataType(Class<? extends BusinessObject> businessObjectClass, String attributeName) {
        Class attributeClass = DataTypeUtil.thieveAttributeClassFromBusinessObjectClass(businessObjectClass, attributeName);
        return DataTypeUtil.determineDataType(attributeClass);
    }

    public static String determineDataType(Class<?> attributeClass) {
        if (DataTypeUtil.isStringy(attributeClass)) {
            return "string";
        }
        if (DataTypeUtil.isDecimaltastic(attributeClass)) {
            return "float";
        }
        if (DataTypeUtil.isDateLike(attributeClass)) {
            return "datetime";
        }
        if (DataTypeUtil.isIntsy(attributeClass)) {
            return "long";
        }
        if (DataTypeUtil.isBooleanable(attributeClass)) {
            return "boolean";
        }
        return "string";
    }

    public static boolean isStringy(Class clazz) {
        return String.class.isAssignableFrom(clazz);
    }

    public static boolean isDateLike(Class clazz) {
        return Date.class.isAssignableFrom(clazz);
    }

    public static boolean isDecimaltastic(Class clazz) {
        return Double.class.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) || clazz.equals(Double.TYPE) || clazz.equals(Float.TYPE) || BigDecimal.class.isAssignableFrom(clazz) || KualiDecimal.class.isAssignableFrom(clazz);
    }

    public static boolean isIntsy(Class clazz) {
        return Integer.class.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz) || clazz.equals(Integer.TYPE) || clazz.equals(Long.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Byte.TYPE);
    }

    public static boolean isBooleanable(Class clazz) {
        return Boolean.class.isAssignableFrom(clazz) || clazz.equals(Boolean.TYPE);
    }

    private static Class thieveAttributeClassFromBusinessObjectClass(Class<? extends BusinessObject> boClass, String attributeKey) {
        for (PropertyDescriptor prop : PropertyUtils.getPropertyDescriptors(boClass)) {
            if (!prop.getName().equals(attributeKey)) continue;
            return prop.getPropertyType();
        }
        return null;
    }
}

