/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.web.bind;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;

public class UifBooleanEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = -6333792216543862346L;
    private static final String TRUE_VALUES = "/true/yes/y/on/1/";
    private static final String FALSE_VALUES = "/false/no/n/off/0/";
    private static final String TRUE_VALUE = "true";
    private static final String FALSE_VALUE = "false";

    @Override
    public String getAsText() {
        if (this.getValue() == null) {
            return "";
        }
        if (((Boolean)this.getValue()).booleanValue()) {
            return TRUE_VALUE;
        }
        return FALSE_VALUE;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        String input = null;
        if (text != null) {
            input = "/" + text.toLowerCase() + "/";
            if (TRUE_VALUES.contains(input)) {
                this.setValue(Boolean.TRUE);
            } else if (FALSE_VALUES.contains(input)) {
                this.setValue(Boolean.FALSE);
            } else {
                input = null;
            }
        }
        if (input == null) {
            throw new IllegalArgumentException("Invalid boolean input: " + text);
        }
    }
}

