/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.document;

import com.thoughtworks.xstream.core.BaseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Transient;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.struts.upload.FormFile;
import org.kuali.kfs.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.krad.bo.DocumentAttachment;
import org.kuali.kfs.krad.bo.GlobalBusinessObject;
import org.kuali.kfs.krad.bo.MultiDocumentAttachment;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableAttachment;
import org.kuali.kfs.krad.bo.PersistableAttachmentBase;
import org.kuali.kfs.krad.bo.PersistableAttachmentList;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.WorkflowAttributes;
import org.kuali.kfs.krad.datadictionary.WorkflowProperties;
import org.kuali.kfs.krad.document.DocumentBase;
import org.kuali.kfs.krad.document.SessionDocument;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.maintenance.MaintenanceUtils;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.kfs.krad.service.DocumentDictionaryService;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.MaintenanceDocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.NoteType;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.documentserializer.PropertySerializabilityEvaluator;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MaintenanceDocumentBase
extends DocumentBase
implements MaintenanceDocument,
SessionDocument {
    private static final Logger LOG = LogManager.getLogger();
    public static final String OLD_MAINTAINABLE_TAG_NAME = "oldMaintainableObject";
    public static final String NEW_MAINTAINABLE_TAG_NAME = "newMaintainableObject";
    public static final String MAINTENANCE_ACTION_TAG_NAME = "maintenanceAction";
    public static final String NOTES_TAG_NAME = "notes";
    @Transient
    private static transient DocumentDictionaryService documentDictionaryService;
    @Transient
    private static transient DocumentHeaderService documentHeaderService;
    @Transient
    private static transient DocumentService documentService;
    @Transient
    protected transient FormFile fileAttachment;
    @Transient
    private static transient MaintenanceDocumentService maintenanceDocumentService;
    @Transient
    protected Maintainable oldMaintainableObject;
    @Transient
    protected Maintainable newMaintainableObject;
    protected String xmlDocumentContents;
    @Transient
    protected boolean fieldsClearedOnCopy = false;
    @Transient
    protected boolean displayTopicFieldInNotes = false;
    @Transient
    protected String attachmentPropertyName;
    @Transient
    protected String attachmentListPropertyName;
    @Transient
    protected String attachmentCollectionName;
    protected DocumentAttachment attachment;
    protected List<MultiDocumentAttachment> attachments;

    public MaintenanceDocumentBase() {
    }

    public MaintenanceDocumentBase(String documentTypeName) {
        this();
        Class<? extends Maintainable> clazz = this.getDocumentDictionaryService().getMaintainableClass(documentTypeName);
        try {
            this.oldMaintainableObject = clazz.newInstance();
            this.newMaintainableObject = clazz.newInstance();
            Class<?> dataObjectClazz = this.getDocumentDictionaryService().getMaintenanceDataObjectClass(documentTypeName);
            this.oldMaintainableObject.setDataObject(dataObjectClazz.newInstance());
            this.oldMaintainableObject.setDataObjectClass(dataObjectClazz);
            this.newMaintainableObject.setDataObject(dataObjectClazz.newInstance());
            this.newMaintainableObject.setDataObjectClass(dataObjectClazz);
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.error("Unable to initialize maintainables of type " + clazz.getName());
            throw new RuntimeException("Unable to initialize maintainables of type " + clazz.getName());
        }
    }

    @Override
    public PersistableBusinessObject getDocumentBusinessObject() {
        return (PersistableBusinessObject)this.getDocumentDataObject();
    }

    @Override
    public boolean isOldBusinessObjectInDocument() {
        boolean isOldBusinessObjectInExistence = this.getOldMaintainableObject() == null || this.getOldMaintainableObject().getBusinessObject() == null ? false : this.getOldMaintainableObject().isOldBusinessObjectInDocument();
        return isOldBusinessObjectInExistence;
    }

    public FormFile getFileAttachment() {
        return this.fileAttachment;
    }

    public void setFileAttachment(FormFile fileAttachment) {
        this.fileAttachment = fileAttachment;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void populateDocumentAttachment() {
        this.refreshAttachment();
        if (this.fileAttachment != null && StringUtils.isNotEmpty((CharSequence)this.fileAttachment.getFileName())) {
            if (this.attachment == null) {
                this.attachment = new DocumentAttachment();
            }
            try {
                byte[] fileContents = this.fileAttachment.getFileData();
                if (fileContents.length <= 0) return;
                this.attachment.setFileName(this.fileAttachment.getFileName());
                this.attachment.setContentType(this.fileAttachment.getContentType());
                this.attachment.setAttachmentContent(this.fileAttachment.getFileData());
                PersistableAttachment boAttachment = (PersistableAttachment)this.newMaintainableObject.getDataObject();
                boAttachment.setAttachmentContent(null);
                this.attachment.setDocumentNumber(this.getDocumentNumber());
                return;
            }
            catch (IOException e) {
                LOG.error("Error while populating the Document Attachment", (Throwable)e);
                throw new RuntimeException("Could not populate DocumentAttachment object", e);
            }
        } else {
            PersistableAttachment boAttachment = (PersistableAttachment)this.newMaintainableObject.getDataObject();
            if (this.attachment != null || boAttachment == null || boAttachment.getAttachmentContent() == null) return;
            DocumentAttachment newAttachment = new DocumentAttachment();
            newAttachment.setDocumentNumber(this.getDocumentNumber());
            newAttachment.setAttachmentContent(boAttachment.getAttachmentContent());
            newAttachment.setContentType(boAttachment.getContentType());
            newAttachment.setFileName(boAttachment.getFileName());
            boAttachment.setAttachmentContent(null);
            this.attachment = newAttachment;
        }
    }

    public void populateAttachmentForBO() {
        this.refreshAttachment();
        PersistableAttachment boAttachment = (PersistableAttachment)this.newMaintainableObject.getDataObject();
        if (ObjectUtils.isNotNull(this.getAttachmentPropertyName())) {
            String attachmentPropNm = this.getAttachmentPropertyName();
            String attachmentPropNmSetter = "get" + attachmentPropNm.substring(0, 1).toUpperCase() + attachmentPropNm.substring(1);
            if (boAttachment.getFileName() == null) {
                try {
                    Method[] methods;
                    for (Method method : methods = boAttachment.getClass().getMethods()) {
                        if (!method.getName().equals(attachmentPropNmSetter)) continue;
                        FormFile attachmentFromBusinessObject = (FormFile)boAttachment.getClass().getDeclaredMethod(attachmentPropNmSetter, new Class[0]).invoke((Object)boAttachment, new Object[0]);
                        if (attachmentFromBusinessObject != null) {
                            boAttachment.setFileName(attachmentFromBusinessObject.getFileName());
                            boAttachment.setContentType(attachmentFromBusinessObject.getContentType());
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    LOG.error("Not able to get the attachment " + e.getMessage());
                    throw new RuntimeException("Not able to get the attachment " + e.getMessage());
                }
            }
        }
        if (boAttachment.getFileName() == null && this.attachment != null && this.attachment.getFileName() != null) {
            boAttachment.setAttachmentContent(null);
            boAttachment.setFileName(this.attachment.getFileName());
            boAttachment.setContentType(this.attachment.getContentType());
        }
    }

    public void populateAttachmentBeforeSave() {
        PersistableAttachment boAttachment = (PersistableAttachment)this.newMaintainableObject.getDataObject();
        if (this.attachment != null && this.attachment.getAttachmentContent() != null) {
            boAttachment.setAttachmentContent(this.attachment.getAttachmentContent());
        } else {
            boAttachment.setAttachmentContent(null);
            boAttachment.setFileName(null);
            boAttachment.setContentType(null);
        }
    }

    public void populateBoAttachmentListBeforeSave() {
        String key;
        PersistableAttachmentList boAttachments = (PersistableAttachmentList)this.newMaintainableObject.getDataObject();
        if (CollectionUtils.isEmpty(this.attachments)) {
            boAttachments.setAttachments(Collections.emptyList());
            return;
        }
        HashMap<String, MultiDocumentAttachment> files = new HashMap<String, MultiDocumentAttachment>();
        for (MultiDocumentAttachment multiAttach : this.attachments) {
            key = multiAttach.getFileName() + "|" + multiAttach.getContentType();
            files.put(key, multiAttach);
        }
        if (CollectionUtils.isNotEmpty(boAttachments.getAttachments())) {
            for (PersistableAttachment attach : boAttachments.getAttachments()) {
                key = attach.getFileName() + "|" + attach.getContentType();
                if (!files.containsKey(key)) continue;
                attach.setAttachmentContent(((MultiDocumentAttachment)files.get(key)).getAttachmentContent());
                files.remove(key);
            }
        }
    }

    public void populateAttachmentListForBO() {
        this.refreshAttachmentList();
        PersistableAttachmentList boAttachments = (PersistableAttachmentList)this.newMaintainableObject.getDataObject();
        if (ObjectUtils.isNotNull(this.getAttachmentListPropertyName())) {
            String attachmentPropNm = this.getAttachmentListPropertyName();
            String attachmentPropNmSetter = "get" + attachmentPropNm.substring(0, 1).toUpperCase() + attachmentPropNm.substring(1);
            for (PersistableAttachment persistableAttachment : boAttachments.getAttachments()) {
                if (persistableAttachment.getFileName() != null) continue;
                try {
                    FormFile attachmentFromBusinessObject = (FormFile)persistableAttachment.getClass().getDeclaredMethod(attachmentPropNmSetter, new Class[0]).invoke((Object)persistableAttachment, new Object[0]);
                    if (attachmentFromBusinessObject == null) continue;
                    persistableAttachment.setFileName(attachmentFromBusinessObject.getFileName());
                    persistableAttachment.setContentType(attachmentFromBusinessObject.getContentType());
                }
                catch (Exception e) {
                    LOG.error("Not able to get the attachment " + e.getMessage());
                    throw new RuntimeException("Not able to get the attachment " + e.getMessage());
                }
            }
        }
        if (CollectionUtils.isEmpty(boAttachments.getAttachments()) && CollectionUtils.isNotEmpty(this.attachments)) {
            ArrayList<PersistableAttachment> attachmentList = new ArrayList<PersistableAttachment>();
            for (MultiDocumentAttachment multiAttach : this.attachments) {
                PersistableAttachment persistableAttachment;
                if (multiAttach.getAttachmentContent().length <= 0) continue;
                persistableAttachment = this.convertDocToBoAttachment(multiAttach, false);
                attachmentList.add(persistableAttachment);
            }
            boAttachments.setAttachments(attachmentList);
        }
    }

    private PersistableAttachment convertDocToBoAttachment(MultiDocumentAttachment multiAttach, boolean copyFile) {
        PersistableAttachmentBase persistableAttachment = new PersistableAttachmentBase();
        if (copyFile && multiAttach.getAttachmentContent() != null) {
            persistableAttachment.setAttachmentContent(multiAttach.getAttachmentContent());
        }
        persistableAttachment.setFileName(multiAttach.getFileName());
        persistableAttachment.setContentType(multiAttach.getContentType());
        return persistableAttachment;
    }

    public void populateDocumentAttachmentList() {
        this.refreshAttachmentList();
        String attachmentPropNm = this.getAttachmentListPropertyName();
        String attachmentPropNmSetter = "get" + attachmentPropNm.substring(0, 1).toUpperCase() + attachmentPropNm.substring(1);
        PersistableAttachmentList boAttachmentList = (PersistableAttachmentList)this.newMaintainableObject.getDataObject();
        if (CollectionUtils.isNotEmpty(boAttachmentList.getAttachments())) {
            HashMap<String, MultiDocumentAttachment> md5Hashes = new HashMap<String, MultiDocumentAttachment>();
            if (CollectionUtils.isNotEmpty(this.attachments)) {
                for (MultiDocumentAttachment currentAttachment : this.attachments) {
                    md5Hashes.put(DigestUtils.md5Hex((byte[])currentAttachment.getAttachmentContent()), currentAttachment);
                }
            }
            this.attachments = new ArrayList<MultiDocumentAttachment>();
            for (PersistableAttachment persistableAttachment : boAttachmentList.getAttachments()) {
                try {
                    FormFile attachmentFromBusinessObject = (FormFile)persistableAttachment.getClass().getDeclaredMethod(attachmentPropNmSetter, new Class[0]).invoke((Object)persistableAttachment, new Object[0]);
                    if (attachmentFromBusinessObject != null) {
                        String md5Hex = DigestUtils.md5Hex((InputStream)attachmentFromBusinessObject.getInputStream());
                        if (md5Hashes.containsKey(md5Hex)) {
                            String newFileName = attachmentFromBusinessObject.getFileName();
                            MultiDocumentAttachment multiAttach = (MultiDocumentAttachment)md5Hashes.get(md5Hex);
                            if (multiAttach.getFileName().equals(newFileName)) {
                                this.attachments.add(multiAttach);
                            } else {
                                multiAttach.setFileName(attachmentFromBusinessObject.getFileName());
                                multiAttach.setContentType(attachmentFromBusinessObject.getContentType());
                                this.attachments.add(multiAttach);
                            }
                            md5Hashes.remove(md5Hex);
                            continue;
                        }
                        MultiDocumentAttachment attach = new MultiDocumentAttachment();
                        attach.setFileName(attachmentFromBusinessObject.getFileName());
                        attach.setContentType(attachmentFromBusinessObject.getContentType());
                        attach.setAttachmentContent(attachmentFromBusinessObject.getFileData());
                        attach.setDocumentNumber(this.getDocumentNumber());
                        this.attachments.add(attach);
                        continue;
                    }
                    if (persistableAttachment.getFileName() == null || persistableAttachment.getAttachmentContent() == null) continue;
                    MultiDocumentAttachment attach = new MultiDocumentAttachment();
                    attach.setFileName(persistableAttachment.getFileName());
                    attach.setContentType(persistableAttachment.getContentType());
                    attach.setAttachmentContent(persistableAttachment.getAttachmentContent());
                    attach.setDocumentNumber(this.getDocumentNumber());
                    persistableAttachment.setAttachmentContent(null);
                    this.attachments.add(attach);
                }
                catch (Exception e) {
                    LOG.error("Not able to get the attachment " + e.getMessage());
                    throw new RuntimeException("Not able to get the attachment " + e.getMessage());
                }
            }
        }
    }

    public String getAttachmentPropertyName() {
        return this.attachmentPropertyName;
    }

    public void setAttachmentPropertyName(String attachmentPropertyName) {
        this.attachmentPropertyName = attachmentPropertyName;
    }

    public String getAttachmentListPropertyName() {
        return this.attachmentListPropertyName;
    }

    public void setAttachmentListPropertyName(String attachmentListPropertyName) {
        this.attachmentListPropertyName = attachmentListPropertyName;
    }

    public String getAttachmentCollectionName() {
        return this.attachmentCollectionName;
    }

    public void setAttachmentCollectionName(String attachmentCollectionName) {
        this.attachmentCollectionName = attachmentCollectionName;
    }

    @Override
    public String getDocumentTitle() {
        String documentTitle = this.newMaintainableObject.getDocumentTitle(this);
        if (StringUtils.isNotBlank((CharSequence)documentTitle)) {
            return documentTitle;
        }
        String className = this.newMaintainableObject.getDataObject().getClass().getName();
        String truncatedClassName = className.substring(className.lastIndexOf(46) + 1);
        documentTitle = this.isOldDataObjectInDocument() ? "Edit " : "New ";
        documentTitle = documentTitle + truncatedClassName + " - ";
        documentTitle = documentTitle + this.getDocumentHeader().getDocumentDescription() + " ";
        return documentTitle;
    }

    protected boolean isOldMaintainableInDocument(Document xmlDocument) {
        boolean isOldMaintainableInExistence = false;
        if (xmlDocument.getElementsByTagName(OLD_MAINTAINABLE_TAG_NAME).getLength() > 0) {
            isOldMaintainableInExistence = true;
        }
        return isOldMaintainableInExistence;
    }

    @Override
    public boolean isOldDataObjectInDocument() {
        boolean isOldBusinessObjectInExistence = this.oldMaintainableObject == null || this.oldMaintainableObject.getDataObject() == null ? false : this.oldMaintainableObject.isOldDataObjectInDocument();
        return isOldBusinessObjectInExistence;
    }

    @Override
    public boolean isNew() {
        return MaintenanceUtils.isMaintenanceDocumentCreatingNewRecord(this.newMaintainableObject.getMaintenanceAction());
    }

    @Override
    public boolean isEdit() {
        return "Edit".equalsIgnoreCase(this.newMaintainableObject.getMaintenanceAction());
    }

    @Override
    public boolean isNewWithExisting() {
        return "newWithExisting".equalsIgnoreCase(this.newMaintainableObject.getMaintenanceAction());
    }

    @Override
    public void populateMaintainablesFromXmlDocumentContents() {
        if (!StringUtils.isEmpty((CharSequence)this.xmlDocumentContents)) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document xmlDocument = builder.parse(new InputSource(new StringReader(this.xmlDocumentContents)));
                String documentTypeName = KewApiServiceLocator.getWorkflowDocumentService().getDocument(this.getDocumentNumber()).getDocumentTypeName();
                Class<? extends Maintainable> maintainableClass = this.getDocumentDictionaryService().getMaintainableClass(documentTypeName);
                if (this.isOldMaintainableInDocument(xmlDocument)) {
                    this.oldMaintainableObject = maintainableClass.newInstance();
                    Object dataObject = this.getDataObjectFromXML(OLD_MAINTAINABLE_TAG_NAME);
                    String oldMaintenanceAction = this.getMaintenanceAction(xmlDocument, OLD_MAINTAINABLE_TAG_NAME);
                    this.oldMaintainableObject.setMaintenanceAction(oldMaintenanceAction);
                    this.oldMaintainableObject.setDataObject(dataObject);
                    this.oldMaintainableObject.setDataObjectClass(dataObject.getClass());
                }
                this.newMaintainableObject = maintainableClass.newInstance();
                Object bo = this.getDataObjectFromXML(NEW_MAINTAINABLE_TAG_NAME);
                this.newMaintainableObject.setDataObject(bo);
                this.newMaintainableObject.setDataObjectClass(bo.getClass());
                String newMaintenanceAction = this.getMaintenanceAction(xmlDocument, NEW_MAINTAINABLE_TAG_NAME);
                this.newMaintainableObject.setMaintenanceAction(newMaintenanceAction);
                if (this.newMaintainableObject.isNotesEnabled()) {
                    List<Note> notes = this.getNotesFromXml(NOTES_TAG_NAME);
                    this.setNotes(notes);
                }
            }
            catch (IOException | IllegalAccessException | InstantiationException | ParserConfigurationException | SAXException e) {
                LOG.error("Error while parsing document contents", (Throwable)e);
                throw new RuntimeException("Could not load document contents from xml", e);
            }
        }
    }

    protected String getMaintenanceAction(Document xmlDocument, String oldOrNewElementName) {
        if (StringUtils.isBlank((CharSequence)oldOrNewElementName)) {
            throw new IllegalArgumentException("oldOrNewElementName may not be blank, null, or empty-string.");
        }
        String maintenanceAction = null;
        NodeList rootChildren = xmlDocument.getDocumentElement().getChildNodes();
        for (int i = 0; i < rootChildren.getLength(); ++i) {
            Node rootChild = rootChildren.item(i);
            if (!oldOrNewElementName.equalsIgnoreCase(rootChild.getNodeName())) continue;
            NodeList maintChildren = rootChild.getChildNodes();
            for (int j = 0; j < maintChildren.getLength(); ++j) {
                Node maintChild = maintChildren.item(j);
                if (!MAINTENANCE_ACTION_TAG_NAME.equalsIgnoreCase(maintChild.getNodeName())) continue;
                maintenanceAction = maintChild.getChildNodes().item(0).getNodeValue();
            }
        }
        return maintenanceAction;
    }

    private List<Note> getNotesFromXml(String notesTagName) {
        List notes;
        String notesXml = StringUtils.substringBetween((String)this.xmlDocumentContents, (String)("<" + notesTagName + ">"), (String)("</" + notesTagName + ">"));
        if (StringUtils.isBlank((CharSequence)notesXml)) {
            return Collections.emptyList();
        }
        try {
            notes = (List)KRADServiceLocator.getXmlObjectSerializerService().fromXml(notesXml);
            if (notes == null) {
                return Collections.emptyList();
            }
        }
        catch (BaseException e) {
            String convertedXml = KRADServiceLocatorWeb.getMaintainableXMLConversionService().transformMaintainableNoteXML(notesXml);
            return (List)KRADServiceLocator.getXmlObjectSerializerService().fromXml(convertedXml);
        }
        return notes;
    }

    protected Object getDataObjectFromXML(String maintainableTagName) {
        String maintXml = StringUtils.substringBetween((String)this.xmlDocumentContents, (String)("<" + maintainableTagName + ">"), (String)("</" + maintainableTagName + ">"));
        try {
            boolean ignoreMissingFields = false;
            String classAndDocTypeNames = ConfigContext.getCurrentContextConfig().getProperty("rice.krad.bos.ignoreMissingFieldsOnDeserialize");
            if (!StringUtils.isEmpty((CharSequence)classAndDocTypeNames)) {
                String classNameOnXML = StringUtils.substringBetween((String)this.xmlDocumentContents, (String)("<" + maintainableTagName + "><"), (String)">");
                String classNamesNoSpaces = this.removeSpacesAround(classAndDocTypeNames);
                String[] classAndDocTypeNamesList = StringUtils.split((String)classNamesNoSpaces, (String)",");
                String originalDocTypeId = this.getDocumentHeader().getWorkflowDocument().getDocumentTypeId();
                DocumentType docType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeById(originalDocTypeId);
                while (docType != null && !ignoreMissingFields) {
                    for (String classNameOrDocTypeName : classAndDocTypeNamesList) {
                        if (!docType.getName().equalsIgnoreCase(classNameOrDocTypeName) && !classNameOnXML.equalsIgnoreCase(classNameOrDocTypeName)) continue;
                        ignoreMissingFields = true;
                        break;
                    }
                    if (!StringUtils.isEmpty((CharSequence)docType.getParentId())) {
                        docType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeById(docType.getParentId());
                        continue;
                    }
                    docType = null;
                }
            }
            if (!ignoreMissingFields) {
                return KRADServiceLocator.getXmlObjectSerializerService().fromXml(maintXml);
            }
            return KRADServiceLocator.getXmlObjectSerializerIgnoreMissingFieldsService().fromXml(maintXml);
        }
        catch (BaseException e) {
            String convertedXml = KRADServiceLocatorWeb.getMaintainableXMLConversionService().transformMaintainableXML(maintXml);
            return KRADServiceLocator.getXmlObjectSerializerService().fromXml(convertedXml);
        }
    }

    private String removeSpacesAround(String csv) {
        if (csv == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (String value : csv.split(",")) {
            if ("".equals(value.trim())) continue;
            result.append(value.trim());
            result.append(",");
        }
        int i = result.lastIndexOf(",");
        if (i != -1) {
            result.deleteCharAt(i);
        }
        return result.toString();
    }

    @Override
    public void populateXmlDocumentContentsFromMaintainables() {
        StringBuilder docContentBuffer = new StringBuilder();
        docContentBuffer.append("<maintainableDocumentContents maintainableImplClass=\"").append(this.newMaintainableObject.getClass().getName()).append("\">");
        if (this.getNewMaintainableObject().isNotesEnabled()) {
            docContentBuffer.append("<notes>");
            ArrayList<Note> noteList = new ArrayList<Note>(this.getNotes());
            docContentBuffer.append(KRADServiceLocator.getXmlObjectSerializerService().toXml(noteList));
            docContentBuffer.append("</notes>");
        }
        if (this.oldMaintainableObject != null && this.oldMaintainableObject.getDataObject() != null) {
            docContentBuffer.append("<oldMaintainableObject>");
            Object oldBo = this.oldMaintainableObject.getDataObject();
            if (oldBo instanceof PersistableBusinessObject) {
                ObjectUtils.materializeAllSubObjects((PersistableBusinessObject)oldBo);
            }
            docContentBuffer.append(KRADServiceLocator.getBusinessObjectSerializerService().serializeBusinessObjectToXml(oldBo));
            docContentBuffer.append("<maintenanceAction>");
            docContentBuffer.append(this.oldMaintainableObject.getMaintenanceAction());
            docContentBuffer.append("</maintenanceAction>\n");
            docContentBuffer.append("</oldMaintainableObject>");
        }
        docContentBuffer.append("<newMaintainableObject>");
        Object newBo = this.newMaintainableObject.getDataObject();
        if (newBo instanceof PersistableBusinessObject) {
            ObjectUtils.materializeAllSubObjects((PersistableBusinessObject)newBo);
        }
        docContentBuffer.append(KRADServiceLocator.getBusinessObjectSerializerService().serializeBusinessObjectToXml(newBo));
        docContentBuffer.append("<maintenanceAction>");
        docContentBuffer.append(this.newMaintainableObject.getMaintenanceAction());
        docContentBuffer.append("</maintenanceAction>\n");
        docContentBuffer.append("</newMaintainableObject>");
        docContentBuffer.append("</maintainableDocumentContents>");
        this.xmlDocumentContents = docContentBuffer.toString();
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        String documentNumber;
        super.doRouteStatusChange(statusChangeEvent);
        WorkflowDocument workflowDocument = this.getDocumentHeader().getWorkflowDocument();
        this.getNewMaintainableObject().doRouteStatusChange(this.getDocumentHeader());
        if (workflowDocument.isProcessed()) {
            documentNumber = this.getDocumentHeader().getDocumentNumber();
            this.newMaintainableObject.setDocumentNumber(documentNumber);
            if (this.newMaintainableObject.getDataObject() instanceof PersistableAttachment) {
                this.populateAttachmentBeforeSave();
            }
            if (this.newMaintainableObject.getDataObject() instanceof PersistableAttachmentList) {
                this.populateBoAttachmentListBeforeSave();
            }
            this.newMaintainableObject.saveBusinessObject();
            if (!this.getDocumentService().saveDocumentNotes(this)) {
                throw new IllegalStateException("Failed to save document notes, this means that the note target was not ready for notes to be attached when it should have been.");
            }
            this.deleteDocumentAttachment();
            this.deleteDocumentAttachmentList();
            this.getMaintenanceDocumentService().deleteLocks(documentNumber);
            if (this.checkAllowsRecordDeletion() && this.checkMaintenanceAction() && this.checkDeletePermission(this.newMaintainableObject.getDataObject())) {
                this.newMaintainableObject.deleteDataObject();
            }
        }
        if (workflowDocument.isCanceled() || workflowDocument.isDisapproved() || workflowDocument.isRecalled() || workflowDocument.isException()) {
            this.deleteDocumentAttachment();
            this.deleteDocumentAttachmentList();
            documentNumber = this.getDocumentHeader().getDocumentNumber();
            this.getMaintenanceDocumentService().deleteLocks(documentNumber);
        }
    }

    @Override
    public List<String> getWorkflowEngineDocumentIdsToLock() {
        if (this.newMaintainableObject != null) {
            return this.newMaintainableObject.getWorkflowEngineDocumentIdsToLock();
        }
        return Collections.emptyList();
    }

    @Override
    public void prepareForSave() {
        if (this.newMaintainableObject != null) {
            this.newMaintainableObject.prepareForSave();
        }
    }

    @Override
    public void prepareForSave(KualiDocumentEvent event) {
        super.prepareForSave(event);
        if (this.newMaintainableObject.getDataObject() instanceof PersistableAttachment) {
            this.populateDocumentAttachment();
            this.populateAttachmentForBO();
            if (this.oldMaintainableObject.getDataObject() instanceof PersistableAttachment) {
                ((PersistableAttachment)this.oldMaintainableObject.getDataObject()).setAttachmentContent(null);
            }
        }
        if (this.newMaintainableObject.getDataObject() instanceof PersistableAttachmentList) {
            this.populateDocumentAttachmentList();
            this.populateAttachmentListForBO();
            if (this.oldMaintainableObject.getDataObject() instanceof PersistableAttachmentList) {
                for (PersistableAttachment pa : ((PersistableAttachmentList)this.oldMaintainableObject.getDataObject()).getAttachments()) {
                    pa.setAttachmentContent(null);
                }
            }
        }
        this.populateXmlDocumentContentsFromMaintainables();
    }

    @Override
    public void processAfterRetrieve() {
        super.processAfterRetrieve();
        this.populateMaintainablesFromXmlDocumentContents();
        if (this.oldMaintainableObject != null) {
            this.oldMaintainableObject.setDocumentNumber(this.documentNumber);
        }
        if (this.newMaintainableObject != null) {
            this.newMaintainableObject.setDocumentNumber(this.documentNumber);
            this.newMaintainableObject.processAfterRetrieve();
            if (this.newMaintainableObject.getDataObject() instanceof PersistableAttachment) {
                this.populateAttachmentForBO();
            }
            if (this.newMaintainableObject.getDataObject() instanceof PersistableAttachmentList) {
                this.populateAttachmentListForBO();
            }
            this.checkForLockingDocument(false);
        }
    }

    @Override
    public Maintainable getNewMaintainableObject() {
        return this.newMaintainableObject;
    }

    @Override
    public void setNewMaintainableObject(Maintainable newMaintainableObject) {
        this.newMaintainableObject = newMaintainableObject;
    }

    @Override
    public Maintainable getOldMaintainableObject() {
        return this.oldMaintainableObject;
    }

    @Override
    public void setOldMaintainableObject(Maintainable oldMaintainableObject) {
        this.oldMaintainableObject = oldMaintainableObject;
    }

    @Override
    public void setDocumentNumber(String documentNumber) {
        super.setDocumentNumber(documentNumber);
        this.oldMaintainableObject.setDocumentNumber(documentNumber);
        this.newMaintainableObject.setDocumentNumber(documentNumber);
    }

    @Override
    public final boolean isFieldsClearedOnCopy() {
        return this.fieldsClearedOnCopy;
    }

    @Override
    public final void setFieldsClearedOnCopy(boolean fieldsClearedOnCopy) {
        this.fieldsClearedOnCopy = fieldsClearedOnCopy;
    }

    @Override
    public String getXmlDocumentContents() {
        return this.xmlDocumentContents;
    }

    @Override
    public void setXmlDocumentContents(String xmlDocumentContents) {
        this.xmlDocumentContents = xmlDocumentContents;
    }

    @Override
    public boolean getAllowsCopy() {
        return this.getDocumentDictionaryService().getAllowsCopy(this);
    }

    @Override
    public boolean getDisplayTopicFieldInNotes() {
        return this.displayTopicFieldInNotes;
    }

    @Override
    public void setDisplayTopicFieldInNotes(boolean displayTopicFieldInNotes) {
        this.displayTopicFieldInNotes = displayTopicFieldInNotes;
    }

    @Override
    public String serializeDocumentToXml() {
        String tempXmlDocumentContents = this.xmlDocumentContents;
        this.xmlDocumentContents = null;
        String xmlForWorkflow = super.serializeDocumentToXml();
        this.xmlDocumentContents = tempXmlDocumentContents;
        return xmlForWorkflow;
    }

    protected void refreshAttachment() {
        if (ObjectUtils.isNull(this.attachment)) {
            boolean isProxy;
            this.refreshReferenceObject("attachment");
            boolean bl = isProxy = this.attachment != null && ProxyHelper.isProxy((Object)this.attachment);
            if (isProxy && ProxyHelper.getRealObject((Object)this.attachment) == null) {
                this.attachment = null;
            }
        }
    }

    protected void refreshAttachmentList() {
        if (ObjectUtils.isNull(this.attachments)) {
            boolean isProxy;
            this.refreshReferenceObject("attachments");
            boolean bl = isProxy = this.attachments != null && ProxyHelper.isProxy(this.attachments);
            if (isProxy && ProxyHelper.getRealObject(this.attachments) == null) {
                this.attachments = null;
            }
        }
    }

    public void deleteDocumentAttachment() {
        KRADServiceLocator.getBusinessObjectService().delete(this.attachment);
        this.attachment = null;
    }

    public void deleteDocumentAttachmentList() {
        if (CollectionUtils.isNotEmpty(this.attachments)) {
            KRADServiceLocator.getBusinessObjectService().delete(this.attachments);
            this.attachments = null;
        }
    }

    @Override
    public void validateBusinessRules(KualiDocumentEvent event) {
        boolean isValid;
        if (GlobalVariables.getMessageMap().hasErrors()) {
            this.logErrors();
            throw new ValidationException("errors occurred before business rule");
        }
        this.checkForLockingDocument(true);
        if (this.newMaintainableObject != null && this.newMaintainableObject.isLockable()) {
            PersistableBusinessObject pbObject = KRADServiceLocator.getBusinessObjectService().retrieve(this.newMaintainableObject.getPersistableBusinessObject());
            Long pbObjectVerNbr = ObjectUtils.isNull(pbObject) ? null : pbObject.getVersionNumber();
            Long newObjectVerNbr = this.newMaintainableObject.getPersistableBusinessObject().getVersionNumber();
            if (pbObjectVerNbr != null && !pbObjectVerNbr.equals(newObjectVerNbr)) {
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.version.mismatch", new String[0]);
                throw new ValidationException("Version mismatch between the local business object and the database business object");
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("invoking rules engine on document " + this.getDocumentNumber());
        }
        if (!(isValid = KRADServiceLocatorWeb.getKualiRuleService().applyRules(event))) {
            this.logErrors();
            throw new ValidationException("business rule evaluation failed");
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            this.logErrors();
            if (!(event instanceof SaveDocumentEvent)) {
                throw new ValidationException("Unreported errors occurred during business rule evaluation (rule developer needs to put meaningful error messages into global ErrorMap)");
            }
        }
        LOG.debug("validation completed");
    }

    protected void checkForLockingDocument(boolean throwExceptionIfLocked) {
        MaintenanceUtils.checkForLockingDocument(this, throwExceptionIfLocked);
    }

    @Override
    public void postProcessSave(KualiDocumentEvent event) {
        PersistableBusinessObject bo;
        if (this.getNewMaintainableObject().getDataObject() instanceof PersistableBusinessObject && (bo = (PersistableBusinessObject)this.getNewMaintainableObject().getDataObject()) instanceof GlobalBusinessObject) {
            KRADServiceLocator.getBusinessObjectService().save(bo);
        }
        if (!(event instanceof SaveDocumentEvent)) {
            this.getMaintenanceDocumentService().deleteLocks(this.getDocumentNumber());
            this.getMaintenanceDocumentService().storeLocks(this.getNewMaintainableObject().generateMaintenanceLocks());
        }
    }

    @Override
    public Object getDocumentDataObject() {
        return this.getNewMaintainableObject().getDataObject();
    }

    @Override
    public PersistableBusinessObject getNoteTarget() {
        if (this.getNewMaintainableObject() == null) {
            throw new IllegalStateException("Failed to acquire the note target.  The new maintainable object on this document is null.");
        }
        if (this.getNewMaintainableObject().isNotesEnabled()) {
            return (PersistableBusinessObject)this.getDocumentDataObject();
        }
        return super.getNoteTarget();
    }

    @Override
    public NoteType getNoteType() {
        if (this.getNewMaintainableObject().isNotesEnabled()) {
            return NoteType.BUSINESS_OBJECT;
        }
        return super.getNoteType();
    }

    @Override
    public PropertySerializabilityEvaluator getDocumentPropertySerizabilityEvaluator() {
        String docTypeName = "";
        if (this.newMaintainableObject != null) {
            docTypeName = this.getDocumentDictionaryService().getMaintenanceDocumentTypeName(this.newMaintainableObject.getDataObjectClass());
        } else if (this.getDocumentHeader() != null && this.getDocumentHeader().getWorkflowDocument() != null) {
            docTypeName = this.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        }
        if (!StringUtils.isBlank((CharSequence)docTypeName)) {
            MaintenanceDocumentEntry documentEntry = this.getDocumentDictionaryService().getMaintenanceDocumentEntry(docTypeName);
            if (documentEntry != null) {
                WorkflowProperties workflowProperties = documentEntry.getWorkflowProperties();
                WorkflowAttributes workflowAttributes = documentEntry.getWorkflowAttributes();
                return this.createPropertySerializabilityEvaluator(workflowProperties, workflowAttributes);
            }
            LOG.error("Unable to obtain DD DocumentEntry for document type: '" + docTypeName + "'");
        } else {
            LOG.error("Unable to obtain document type name for this document: " + this);
        }
        LOG.error("Returning null for the PropertySerializabilityEvaluator");
        return null;
    }

    public DocumentAttachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(DocumentAttachment attachment) {
        this.attachment = attachment;
    }

    public List<MultiDocumentAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<MultiDocumentAttachment> attachments) {
        this.attachments = attachments;
    }

    @Override
    protected void postRemove() {
        super.postRemove();
        this.getDocumentHeaderService().deleteDocumentHeader(this.getDocumentHeader());
    }

    @Override
    protected void postLoad() {
        super.postLoad();
        this.setDocumentHeader(this.getDocumentHeaderService().getDocumentHeaderById(this.getDocumentNumber()));
    }

    @Override
    protected void prePersist() {
        super.prePersist();
        this.getDocumentHeaderService().saveDocumentHeader(this.getDocumentHeader());
    }

    @Override
    protected void preUpdate() {
        super.preUpdate();
        this.getDocumentHeaderService().saveDocumentHeader(this.getDocumentHeader());
    }

    public boolean isSessionDocument() {
        return SessionDocument.class.isAssignableFrom(this.getClass());
    }

    protected DocumentDictionaryService getDocumentDictionaryService() {
        if (documentDictionaryService == null) {
            documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return documentDictionaryService;
    }

    protected MaintenanceDocumentService getMaintenanceDocumentService() {
        if (maintenanceDocumentService == null) {
            maintenanceDocumentService = KRADServiceLocatorWeb.getMaintenanceDocumentService();
        }
        return maintenanceDocumentService;
    }

    protected DocumentHeaderService getDocumentHeaderService() {
        if (documentHeaderService == null) {
            documentHeaderService = KRADServiceLocatorWeb.getDocumentHeaderService();
        }
        return documentHeaderService;
    }

    protected DocumentService getDocumentService() {
        if (documentService == null) {
            documentService = KRADServiceLocatorWeb.getDocumentService();
        }
        return documentService;
    }

    protected boolean checkAllowsRecordDeletion() {
        Boolean allowsRecordDeletion = KRADServiceLocatorWeb.getDocumentDictionaryService().getAllowsRecordDeletion(this.getNewMaintainableObject().getDataObjectClass());
        if (allowsRecordDeletion != null) {
            return allowsRecordDeletion;
        }
        return false;
    }

    protected boolean checkMaintenanceAction() {
        return this.getNewMaintainableObject().getMaintenanceAction().equals("Delete");
    }

    protected boolean checkDeletePermission(Object dataObject) {
        boolean allowsMaintain = false;
        String maintDocTypeName = KRADServiceLocatorWeb.getDocumentDictionaryService().getMaintenanceDocumentTypeName(dataObject.getClass());
        if (StringUtils.isNotBlank((CharSequence)maintDocTypeName)) {
            allowsMaintain = KRADServiceLocatorWeb.getDataObjectAuthorizationService().canMaintain(dataObject, GlobalVariables.getUserSession().getPerson(), maintDocTypeName);
        }
        return allowsMaintain;
    }
}

