/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.document.authorization;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizerBase;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizer;
import org.kuali.kfs.krad.service.DocumentDictionaryService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.rice.kim.api.identity.Person;

public class MaintenanceDocumentAuthorizerBase
extends DocumentAuthorizerBase
implements MaintenanceDocumentAuthorizer {
    protected static transient DocumentDictionaryService documentDictionaryService;

    @Override
    public boolean canCreate(Class boClass, Person user) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("documentTypeName", MaintenanceDocumentAuthorizerBase.getDocumentDictionaryService().getMaintenanceDocumentTypeName(boClass));
        permissionDetails.put("maintenanceAction", "New");
        return !this.permissionExistsByTemplate("KR-NS", "Create / Maintain Record(s)", permissionDetails) || MaintenanceDocumentAuthorizerBase.getPermissionService().isAuthorizedByTemplate(user.getPrincipalId(), "KR-NS", "Create / Maintain Record(s)", permissionDetails, new HashMap());
    }

    @Override
    public boolean canMaintain(Object dataObject, Person user) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>(2);
        permissionDetails.put("documentTypeName", MaintenanceDocumentAuthorizerBase.getDocumentDictionaryService().getMaintenanceDocumentTypeName(dataObject.getClass()));
        permissionDetails.put("maintenanceAction", "Edit");
        return !this.permissionExistsByTemplate("KR-NS", "Create / Maintain Record(s)", permissionDetails) || this.isAuthorizedByTemplate(dataObject, "KR-NS", "Create / Maintain Record(s)", user.getPrincipalId(), permissionDetails, null);
    }

    @Override
    public boolean canCreateOrMaintain(MaintenanceDocument maintenanceDocument, Person user) {
        return !this.permissionExistsByTemplate(maintenanceDocument, "KR-NS", "Create / Maintain Record(s)") || this.isAuthorizedByTemplate(maintenanceDocument, "KR-NS", "Create / Maintain Record(s)", user.getPrincipalId());
    }

    @Override
    public Set<String> getSecurePotentiallyHiddenSectionIds() {
        return new HashSet<String>();
    }

    @Override
    public Set<String> getSecurePotentiallyReadOnlySectionIds() {
        return new HashSet<String>();
    }

    @Override
    protected void addRoleQualification(Object dataObject, Map<String, String> attributes) {
        MaintenanceDocument maintDoc;
        super.addRoleQualification(dataObject, attributes);
        if (dataObject instanceof MaintenanceDocument && (maintDoc = (MaintenanceDocument)dataObject).getNewMaintainableObject() != null) {
            attributes.putAll(KRADUtils.getNamespaceAndComponentSimpleName(maintDoc.getNewMaintainableObject().getDataObjectClass()));
        }
    }

    @Override
    protected void addPermissionDetails(Object dataObject, Map<String, String> attributes) {
        MaintenanceDocument maintDoc;
        super.addPermissionDetails(dataObject, attributes);
        if (dataObject instanceof MaintenanceDocument && (maintDoc = (MaintenanceDocument)dataObject).getNewMaintainableObject() != null) {
            attributes.putAll(KRADUtils.getNamespaceAndComponentSimpleName(maintDoc.getNewMaintainableObject().getDataObjectClass()));
            attributes.put("maintenanceAction", maintDoc.getNewMaintainableObject().getMaintenanceAction());
        }
    }

    protected static DocumentDictionaryService getDocumentDictionaryService() {
        if (documentDictionaryService == null) {
            documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return documentDictionaryService;
    }
}

