/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.inquiry;

import java.security.GeneralSecurityException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.datadictionary.FieldDefinition;
import org.kuali.kfs.kns.datadictionary.InquiryCollectionDefinition;
import org.kuali.kfs.kns.datadictionary.InquirySectionDefinition;
import org.kuali.kfs.kns.inquiry.Inquirable;
import org.kuali.kfs.kns.inquiry.InquiryRestrictions;
import org.kuali.kfs.kns.lookup.CollectionIncomplete;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.util.InactiveRecordsHidingUtils;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.kns.web.ui.SectionBridge;
import org.kuali.kfs.krad.bo.DataObjectRelationship;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.datadictionary.AttributeSecurity;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.ExternalizableBusinessObjectUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.encryption.EncryptionService;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class KualiInquirableImpl
implements Inquirable {
    private static final Logger LOG = LogManager.getLogger(KualiInquirableImpl.class);
    protected LookupService lookupService;
    protected BusinessObjectAuthorizationService businessObjectAuthorizationService;
    protected BusinessObjectDictionaryService businessObjectDictionaryService;
    protected BusinessObjectMetaDataService businessObjectMetaDataService;
    protected PersistenceStructureService persistenceStructureService;
    protected EncryptionService encryptionService;
    protected static BusinessObjectService businessObjectService;
    protected DocumentHeaderService documentHeaderService;
    protected DocumentTypeService documentTypeService;
    protected Class<?> businessObjectClass;
    protected Map<String, Boolean> inactiveRecordDisplay = new HashMap<String, Boolean>();
    public static final String INQUIRY_TITLE_PREFIX = "title.inquiry.url.value.prependtext";
    public static List<Class<?>> SUPER_CLASS_TRANSLATOR_LIST;

    public Object retrieveDataObject(Map fieldValues) {
        if (this.getBusinessObjectClass() == null) {
            LOG.error("Data object class not set in inquirable.");
            throw new RuntimeException("Data object class not set in inquirable.");
        }
        CollectionIncomplete searchResults = null;
        ModuleService moduleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(this.getBusinessObjectClass());
        if (moduleService != null && moduleService.isExternalizable(this.getBusinessObjectClass())) {
            Object bo = moduleService.getExternalizableBusinessObject(this.getBusinessObjectClass(), fieldValues);
            if (bo != null) {
                ArrayList list = new ArrayList(1);
                list.add(bo);
                searchResults = new CollectionIncomplete(list, 1L);
            }
        } else {
            searchResults = (CollectionIncomplete)this.getLookupService().findCollectionBySearch(this.getBusinessObjectClass(), fieldValues);
        }
        BusinessObject foundObject = null;
        if (searchResults != null && searchResults.size() > 0) {
            foundObject = (BusinessObject)searchResults.get(0);
        }
        return foundObject;
    }

    @Override
    @Deprecated
    public BusinessObject getBusinessObject(Map fieldValues) {
        return (BusinessObject)this.retrieveDataObject(fieldValues);
    }

    @Override
    @Deprecated
    public List<Section> getSections(BusinessObject bo) {
        ArrayList<Section> sections = new ArrayList<Section>();
        if (this.getBusinessObjectClass() == null) {
            LOG.error("Business object class not set in inquirable.");
            throw new RuntimeException("Business object class not set in inquirable.");
        }
        InquiryRestrictions inquiryRestrictions = KNSServiceLocator.getBusinessObjectAuthorizationService().getInquiryRestrictions(bo, GlobalVariables.getUserSession().getPerson());
        List<InquirySectionDefinition> inquirySections = this.getBusinessObjectDictionaryService().getInquirySections(this.getBusinessObjectClass());
        for (InquirySectionDefinition inquirySection : inquirySections) {
            if (!inquiryRestrictions.isHiddenSectionId(inquirySection.getId())) {
                Section section = SectionBridge.toSection(this, inquirySection, bo, inquiryRestrictions);
                sections.add(section);
            }
            for (FieldDefinition fieldDefinition : inquirySection.getInquiryFields()) {
                if (fieldDefinition instanceof InquiryCollectionDefinition) {
                    this.logCollectionAccess((InquiryCollectionDefinition)fieldDefinition, inquiryRestrictions, bo);
                    continue;
                }
                String propertyName = fieldDefinition.getName();
                KNSServiceLocator.getSecurityLoggingService().logFieldAccess(bo, propertyName, null, inquiryRestrictions, true, null);
            }
        }
        return sections;
    }

    protected void logCollectionAccess(InquiryCollectionDefinition collectionDefinition, InquiryRestrictions inquiryRestrictions, BusinessObject bo) {
        if (collectionDefinition.getInquiryFields() != null) {
            for (FieldDefinition fieldDefinition : collectionDefinition.getInquiryFields()) {
                KNSServiceLocator.getSecurityLoggingService().logFieldAccess(bo, fieldDefinition.getName(), null, inquiryRestrictions, true, null);
            }
        }
        if (collectionDefinition.getInquiryCollections() != null) {
            for (InquiryCollectionDefinition subCollectionDefinition : collectionDefinition.getInquiryCollections()) {
                this.logCollectionAccess(subCollectionDefinition, inquiryRestrictions, bo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HtmlData getInquiryUrl(BusinessObject businessObject, String attributeName, boolean forceInquiry) {
        try {
            Object documentNumber;
            if (PropertyUtils.isReadable((Object)businessObject, (String)attributeName)) {
                String fieldValue;
                Object objFieldValue = ObjectUtils.getPropertyValue(businessObject, attributeName);
                String string = fieldValue = objFieldValue == null ? "" : objFieldValue.toString();
                if (StringUtils.containsOnly((CharSequence)fieldValue, (String)"-")) {
                    return new HtmlData.AnchorHtmlData();
                }
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            HtmlData.AnchorHtmlData hRef = new HtmlData.AnchorHtmlData("", "");
            parameters.put("methodToCall", "start");
            Class inquiryBusinessObjectClass = null;
            String attributeRefName = "";
            boolean doesNestedReferenceHaveOwnPrimitiveReference = false;
            BusinessObject nestedBusinessObject = null;
            Class businessObjectClass = ObjectUtils.materializeClassForProxiedObject(businessObject);
            if (attributeName.equals(this.getBusinessObjectDictionaryService().getTitleAttribute(businessObjectClass))) {
                inquiryBusinessObjectClass = businessObjectClass;
            } else if (ObjectUtils.isNestedAttribute(attributeName)) {
                String nestedReferenceName = ObjectUtils.getNestedAttributePrefix(attributeName);
                Object nestedReferenceObject = ObjectUtils.getNestedValue(businessObject, nestedReferenceName);
                if (ObjectUtils.isNotNull(nestedReferenceObject) && nestedReferenceObject instanceof BusinessObject) {
                    nestedBusinessObject = (BusinessObject)nestedReferenceObject;
                    String string = ObjectUtils.getNestedAttributePrimitive(attributeName);
                    Class nestedBusinessObjectClass = ObjectUtils.materializeClassForProxiedObject(nestedBusinessObject);
                    if (string.equals(this.getBusinessObjectDictionaryService().getTitleAttribute(nestedBusinessObjectClass))) {
                        inquiryBusinessObjectClass = nestedBusinessObjectClass;
                        doesNestedReferenceHaveOwnPrimitiveReference = false;
                    } else {
                        Map primitiveReference = LookupUtils.getPrimitiveReference(nestedBusinessObject, string);
                        if (primitiveReference != null && !primitiveReference.isEmpty()) {
                            attributeRefName = (String)primitiveReference.keySet().iterator().next();
                            inquiryBusinessObjectClass = (Class)primitiveReference.get(attributeRefName);
                            doesNestedReferenceHaveOwnPrimitiveReference = true;
                        } else {
                            inquiryBusinessObjectClass = ObjectUtils.materializeClassForProxiedObject(nestedBusinessObject);
                            doesNestedReferenceHaveOwnPrimitiveReference = false;
                        }
                    }
                }
            } else {
                Map primitiveReference = LookupUtils.getPrimitiveReference(businessObject, attributeName);
                if (primitiveReference != null && !primitiveReference.isEmpty()) {
                    attributeRefName = (String)primitiveReference.keySet().iterator().next();
                    inquiryBusinessObjectClass = (Class)primitiveReference.get(attributeRefName);
                }
            }
            if (inquiryBusinessObjectClass != null && DocumentHeader.class.isAssignableFrom(inquiryBusinessObjectClass)) {
                documentNumber = (String)ObjectUtils.getPropertyValue(businessObject, attributeName);
                if (!StringUtils.isBlank((CharSequence)documentNumber)) {
                    HashMap<String, Object> documentParameters = new HashMap<String, Object>();
                    documentParameters.put("docId", documentNumber);
                    documentParameters.put("command", "displayDocSearchView");
                    DocumentHeader documentHeader = this.getDocumentHeaderService().getDocumentHeaderById((String)documentNumber);
                    String documentTypeName = documentHeader.getWorkflowDocument().getDocumentTypeName();
                    DocumentType docType = this.getDocumentTypeService().getDocumentTypeByName(documentTypeName);
                    String url = UrlFactory.parameterizeUrl(docType.getResolvedDocumentHandlerUrl(), (Map<String, String>)documentParameters);
                    hRef.setHref(url);
                }
                return hRef;
            }
            if (inquiryBusinessObjectClass == null || this.getBusinessObjectDictionaryService().isInquirable(inquiryBusinessObjectClass) == null || !this.getBusinessObjectDictionaryService().isInquirable(inquiryBusinessObjectClass).booleanValue()) {
                return hRef;
            }
            documentNumber = SUPER_CLASS_TRANSLATOR_LIST;
            synchronized (documentNumber) {
                for (Class clazz : SUPER_CLASS_TRANSLATOR_LIST) {
                    if (!clazz.isAssignableFrom(inquiryBusinessObjectClass)) continue;
                    inquiryBusinessObjectClass = clazz;
                    break;
                }
            }
            if (!inquiryBusinessObjectClass.isInterface() && ExternalizableBusinessObject.class.isAssignableFrom(inquiryBusinessObjectClass)) {
                inquiryBusinessObjectClass = ExternalizableBusinessObjectUtils.determineExternalizableBusinessObjectSubInterface(inquiryBusinessObjectClass);
            }
            parameters.put("businessObjectClassName", inquiryBusinessObjectClass.getName());
            ArrayList<String> keys = new ArrayList<String>(this.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(inquiryBusinessObjectClass));
            DataObjectRelationship dataObjectRelationship = null;
            if (attributeRefName != null && !"".equals(attributeRefName) && (dataObjectRelationship = this.getBusinessObjectMetaDataService().getBusinessObjectRelationship(businessObject, attributeRefName)) != null && dataObjectRelationship.getParentToChildReferences() != null) {
                keys.addAll(dataObjectRelationship.getParentToChildReferences().values());
            }
            if (this.getPersistenceStructureService().listFieldNames(businessObject.getClass()).contains("versionNumber")) {
                keys.add("versionNumber");
            }
            HashMap<String, String> fieldList = new HashMap<String, String>();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String key;
                String string;
                String keyConversion = string = (key = (String)iterator.next());
                if (ObjectUtils.isNestedAttribute(attributeName)) {
                    if (doesNestedReferenceHaveOwnPrimitiveReference) {
                        String nestedAttributePrefix = ObjectUtils.getNestedAttributePrefix(attributeName);
                        String foreignKeyFieldName = this.getBusinessObjectMetaDataService().getForeignKeyFieldName(nestedBusinessObject.getClass(), attributeRefName, string);
                        if (foreignKeyFieldName.isEmpty() && string.equalsIgnoreCase("versionNumber")) break;
                        keyConversion = nestedAttributePrefix + "." + foreignKeyFieldName;
                    } else {
                        keyConversion = ObjectUtils.getNestedAttributePrefix(attributeName) + "." + string;
                    }
                } else if (dataObjectRelationship != null) {
                    DualHashBidiMap bidiMap = new DualHashBidiMap(dataObjectRelationship.getParentToChildReferences());
                    keyConversion = (String)bidiMap.getKey((Object)string);
                }
                Object keyValue = null;
                if (keyConversion != null) {
                    keyValue = ObjectUtils.getPropertyValue(businessObject, keyConversion);
                }
                if (keyValue == null) {
                    keyValue = "";
                } else if (keyValue instanceof Date) {
                    if (Formatter.findFormatter(keyValue.getClass()) != null) {
                        Formatter formatter = Formatter.getFormatter(keyValue.getClass());
                        keyValue = formatter.format(keyValue);
                    }
                } else {
                    keyValue = keyValue.toString();
                }
                AttributeSecurity attributeSecurity = this.getDataDictionaryService().getAttributeSecurity(businessObject.getClass().getName(), string);
                if (attributeSecurity != null && attributeSecurity.hasRestrictionThatRemovesValueFromUI()) {
                    try {
                        if (CoreApiServiceLocator.getEncryptionService().isEnabled()) {
                            keyValue = this.getEncryptionService().encrypt(keyValue);
                        }
                    }
                    catch (GeneralSecurityException e) {
                        LOG.error("Exception while trying to encrypted value for inquiry framework.", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                parameters.put(string, keyValue.toString());
                fieldList.put(string, keyValue.toString());
            }
            return this.getHyperLink(inquiryBusinessObjectClass, fieldList, UrlFactory.parameterizeUrl("inquiry.do", parameters));
        }
        catch (Exception ex) {
            LOG.debug("Unable to determine inquiry link for BO Class: " + businessObject.getClass() + " and property " + attributeName, (Throwable)ex);
            return new HtmlData.AnchorHtmlData();
        }
    }

    @Deprecated
    protected HtmlData.AnchorHtmlData getHyperLink(Class inquiryClass, Map<String, String> fieldList, String inquiryUrl) {
        HtmlData.AnchorHtmlData a = new HtmlData.AnchorHtmlData(inquiryUrl, "");
        a.setObjectLabel(this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(inquiryClass.getName()).getObjectLabel());
        a.setTitle(HtmlData.getTitleText(this.createTitleText(inquiryClass), inquiryClass, fieldList));
        return a;
    }

    @Deprecated
    protected HtmlData.AnchorHtmlData getHyperLink(Class inquiryClass, Map<String, String> fieldList, String inquiryUrl, String displayText) {
        HtmlData.AnchorHtmlData a = new HtmlData.AnchorHtmlData(inquiryUrl, "", displayText);
        a.setTitle(HtmlData.AnchorHtmlData.getTitleText(this.getKualiConfigurationService().getPropertyValueAsString(INQUIRY_TITLE_PREFIX) + " " + this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(inquiryClass.getName()).getObjectLabel() + " ", inquiryClass, fieldList));
        return a;
    }

    @Deprecated
    protected String createTitleText(Class<?> dataObjectClass) {
        String objectLabel;
        String titleText = "";
        String titlePrefixProp = this.getKualiConfigurationService().getPropertyValueAsString(INQUIRY_TITLE_PREFIX);
        if (StringUtils.isNotBlank((CharSequence)titlePrefixProp)) {
            titleText = titleText + titlePrefixProp + " ";
        }
        if (StringUtils.isNotBlank((CharSequence)(objectLabel = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(dataObjectClass.getName()).getObjectLabel()))) {
            titleText = titleText + objectLabel + " ";
        }
        return titleText;
    }

    @Override
    @Deprecated
    public void addAdditionalSections(List columns, BusinessObject bo) {
    }

    @Override
    @Deprecated
    public String getHtmlMenuBar() {
        return this.getBusinessObjectDictionaryService().getLookupMenuBar(this.getBusinessObjectClass());
    }

    @Override
    @Deprecated
    public String getTitle() {
        return this.getBusinessObjectDictionaryService().getInquiryTitle(this.getBusinessObjectClass());
    }

    @Override
    @Deprecated
    public void setBusinessObjectClass(Class businessObjectClass) {
        this.businessObjectClass = businessObjectClass;
    }

    @Deprecated
    public Class getBusinessObjectClass() {
        return this.businessObjectClass;
    }

    @Override
    @Deprecated
    public Map<String, Boolean> getInactiveRecordDisplay() {
        return this.inactiveRecordDisplay;
    }

    @Override
    @Deprecated
    public boolean getShowInactiveRecords(String collectionName) {
        return InactiveRecordsHidingUtils.getShowInactiveRecords(this.inactiveRecordDisplay, collectionName);
    }

    @Override
    @Deprecated
    public void setShowInactiveRecords(String collectionName, boolean showInactive) {
        InactiveRecordsHidingUtils.setShowInactiveRecords(this.inactiveRecordDisplay, collectionName, showInactive);
    }

    protected LookupService getLookupService() {
        if (this.lookupService == null) {
            this.lookupService = KRADServiceLocatorWeb.getLookupService();
        }
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    protected BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        if (this.businessObjectDictionaryService == null) {
            this.businessObjectDictionaryService = KNSServiceLocator.getBusinessObjectDictionaryService();
        }
        return this.businessObjectDictionaryService;
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }

    protected PersistenceStructureService getPersistenceStructureService() {
        if (this.persistenceStructureService == null) {
            this.persistenceStructureService = KRADServiceLocator.getPersistenceStructureService();
        }
        return this.persistenceStructureService;
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }

    protected EncryptionService getEncryptionService() {
        if (this.encryptionService == null) {
            this.encryptionService = CoreApiServiceLocator.getEncryptionService();
        }
        return this.encryptionService;
    }

    public void setEncryptionService(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    protected ConfigurationService getKualiConfigurationService() {
        return KRADServiceLocator.getKualiConfigurationService();
    }

    protected BusinessObjectMetaDataService getBusinessObjectMetaDataService() {
        if (this.businessObjectMetaDataService == null) {
            this.businessObjectMetaDataService = KNSServiceLocator.getBusinessObjectMetaDataService();
        }
        return this.businessObjectMetaDataService;
    }

    public void setBusinessObjectMetaDataService(BusinessObjectMetaDataService businessObjectMetaDataService) {
        this.businessObjectMetaDataService = businessObjectMetaDataService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (businessObjectService == null) {
            businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return businessObjectService;
    }

    protected BusinessObjectAuthorizationService getBusinessObjectAuthorizationService() {
        if (this.businessObjectAuthorizationService == null) {
            this.businessObjectAuthorizationService = KNSServiceLocator.getBusinessObjectAuthorizationService();
        }
        return this.businessObjectAuthorizationService;
    }

    protected DocumentHeaderService getDocumentHeaderService() {
        if (this.documentHeaderService == null) {
            this.documentHeaderService = KRADServiceLocatorWeb.getDocumentHeaderService();
        }
        return this.documentHeaderService;
    }

    protected DocumentTypeService getDocumentTypeService() {
        if (this.documentTypeService == null) {
            this.documentTypeService = KewApiServiceLocator.getDocumentTypeService();
        }
        return this.documentTypeService;
    }

    public void setBusinessObjectAuthorizationService(BusinessObjectAuthorizationService businessObjectAuthorizationService) {
        this.businessObjectAuthorizationService = businessObjectAuthorizationService;
    }

    @Deprecated
    protected HtmlData.AnchorHtmlData getInquiryUrlForPrimaryKeys(Class clazz, Object businessObject, List<String> primaryKeys, String displayText) {
        if (businessObject == null) {
            return new HtmlData.AnchorHtmlData("", "");
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("methodToCall", "start");
        parameters.put("businessObjectClassName", clazz.getName());
        HashMap<String, String> fieldList = new HashMap<String, String>();
        for (String primaryKey : primaryKeys) {
            String titleAttributeValue = (String)ObjectUtils.getPropertyValue(businessObject, primaryKey);
            parameters.put(primaryKey, titleAttributeValue);
            fieldList.put(primaryKey, titleAttributeValue);
        }
        if (StringUtils.isEmpty((CharSequence)displayText)) {
            return this.getHyperLink(clazz, fieldList, UrlFactory.parameterizeUrl("inquiry.do", parameters));
        }
        return this.getHyperLink(clazz, fieldList, UrlFactory.parameterizeUrl("inquiry.do", parameters), displayText);
    }

    protected DataDictionaryService getDataDictionaryService() {
        return KNSServiceLocator.getDataDictionaryService();
    }

    static {
        SUPER_CLASS_TRANSLATOR_LIST = new ArrayList();
    }
}

