/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableFieldDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.kfs.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.datadictionary.ReferenceDefinition;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.valuefinder.DefaultValueFinder;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;

@Deprecated
public class MaintenanceDocumentDictionaryService {
    private static final Logger LOG = LogManager.getLogger();
    private DataDictionaryService dataDictionaryService;

    protected DocumentType getDocumentType(String documentTypeName) {
        return KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(documentTypeName);
    }

    public String getMaintenanceLabel(String docTypeName) {
        String label = null;
        DocumentType docType = this.getDocumentType(docTypeName);
        if (docType != null) {
            label = docType.getLabel();
        }
        return label;
    }

    public String getMaintenanceDescription(String docTypeName) {
        String description = null;
        DocumentType docType = this.getDocumentType(docTypeName);
        if (docType != null) {
            description = docType.getDescription();
        }
        return description;
    }

    @Deprecated
    public Class getMaintainableClass(String docTypeName) {
        Class<? extends Maintainable> maintainableClass = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(docTypeName);
        if (entry != null) {
            LOG.debug("supplying a generic Rule to insure basic validation");
            maintainableClass = entry.getMaintainableClass();
        }
        return maintainableClass;
    }

    public Class getDataObjectClass(String docTypeName) {
        Class<?> dataObjectClass = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(docTypeName);
        if (entry != null) {
            dataObjectClass = entry.getDataObjectClass();
        }
        return dataObjectClass;
    }

    public String getDocumentTypeName(Class businessObjectClass) {
        String documentTypeName = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(businessObjectClass);
        if (entry != null) {
            documentTypeName = entry.getDocumentTypeName();
        }
        return documentTypeName;
    }

    @Deprecated
    public List<MaintainableSectionDefinition> getMaintainableSections(String docTypeName) {
        List<MaintainableSectionDefinition> sections = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(docTypeName);
        if (entry != null) {
            sections = entry.getMaintainableSections();
        }
        return sections;
    }

    public Collection getDefaultExistenceChecks(Class businessObjectClass) {
        return this.getDefaultExistenceChecks(this.getDocumentTypeName(businessObjectClass));
    }

    public Collection getDefaultExistenceChecks(String docTypeName) {
        List<ReferenceDefinition> defaultExistenceChecks = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(docTypeName);
        if (entry != null) {
            defaultExistenceChecks = entry.getDefaultExistenceChecks();
        }
        return defaultExistenceChecks;
    }

    public List getLockingKeys(String docTypeName) {
        List<String> lockingKeys = null;
        MaintenanceDocumentEntry entry = this.getMaintenanceDocumentEntry(docTypeName);
        if (entry != null) {
            lockingKeys = entry.getLockingKeyFieldNames();
        }
        return lockingKeys;
    }

    public MaintenanceDocumentEntry getMaintenanceDocumentEntry(String docTypeName) {
        if (StringUtils.isBlank((CharSequence)docTypeName)) {
            throw new IllegalArgumentException("invalid (blank) docTypeName");
        }
        return (MaintenanceDocumentEntry)this.getDataDictionary().getDocumentEntry(docTypeName);
    }

    public MaintenanceDocumentEntry getMaintenanceDocumentEntry(Class businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("invalid (blank) dataObjectClass");
        }
        return this.getDataDictionary().getMaintenanceDocumentEntryForBusinessObjectClass(businessObjectClass);
    }

    @Deprecated
    public String getFieldDefaultValue(Class boClass, String fieldName) {
        if (boClass == null) {
            throw new IllegalArgumentException("The boClass parameter value specified was null. A valid class representing the boClass must be specified.");
        }
        return this.getFieldDefaultValue(this.getDocumentTypeName(boClass), fieldName);
    }

    @Deprecated
    public String getFieldDefaultValue(String docTypeName, String fieldName) {
        if (StringUtils.isBlank((CharSequence)docTypeName)) {
            throw new IllegalArgumentException("The docTypeName parameter value specified was blank, whitespace, or null.  A valid string representing the docTypeName must be specified.");
        }
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new IllegalArgumentException("The fieldName parameter value specified was blank, whitespace, or null.  A valid string representing the fieldName must be specified.");
        }
        List<MaintainableSectionDefinition> sections = this.getMaintainableSections(docTypeName);
        for (MaintainableSectionDefinition sectionObject : sections) {
            MaintainableSectionDefinition section = sectionObject;
            List<MaintainableItemDefinition> fields = section.getMaintainableItems();
            String defaultValue = this.getFieldDefaultValue(fields, fieldName);
            if (defaultValue == null) continue;
            return defaultValue;
        }
        return null;
    }

    private String getFieldDefaultValue(Collection maintainableFields, String fieldName) {
        for (Object maintainableField : maintainableFields) {
            MaintainableFieldDefinition field;
            MaintainableItemDefinition item = (MaintainableItemDefinition)maintainableField;
            if (!(item instanceof MaintainableFieldDefinition) || !(field = (MaintainableFieldDefinition)item).getName().endsWith(fieldName)) continue;
            if (StringUtils.isNotBlank((CharSequence)field.getDefaultValue())) {
                return field.getDefaultValue();
            }
            if (field.getDefaultValueFinder() != null) {
                DefaultValueFinder defaultValueFinder = field.getDefaultValueFinder();
                if (defaultValueFinder == null) continue;
                return defaultValueFinder.getDefaultValue();
            }
            return null;
        }
        return null;
    }

    @Deprecated
    public String getCollectionFieldDefaultValue(String docTypeName, String collectionName, String fieldName) {
        if (StringUtils.isBlank((CharSequence)docTypeName)) {
            throw new IllegalArgumentException("The docTypeName parameter value specified was blank, whitespace, or null.  A valid string representing the docTypeName must be specified.");
        }
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new IllegalArgumentException("The fieldName parameter value specified was blank, whitespace, or null.  A valid string representing the fieldName must be specified.");
        }
        if (StringUtils.isBlank((CharSequence)collectionName)) {
            throw new IllegalArgumentException("The collectionName parameter value specified was null. A valid string representing the collectionName must be specified.");
        }
        MaintainableCollectionDefinition coll = this.getMaintainableCollection(docTypeName, collectionName);
        if (coll != null) {
            List<MaintainableFieldDefinition> collectionFields = coll.getMaintainableFields();
            return this.getFieldDefaultValue(collectionFields, fieldName);
        }
        return null;
    }

    public Boolean getAllowsCopy(MaintenanceDocument document) {
        MaintenanceDocumentEntry entry;
        Boolean allowsCopy = Boolean.FALSE;
        if (document != null && document.getNewMaintainableObject() != null && (entry = this.getMaintenanceDocumentEntry(document.getNewMaintainableObject().getDataObjectClass())) != null) {
            allowsCopy = entry.getAllowsCopy();
        }
        return allowsCopy;
    }

    public Boolean getAllowsNewOrCopy(String docTypeName) {
        MaintenanceDocumentEntry entry;
        Boolean allowsNewOrCopy = Boolean.FALSE;
        if (docTypeName != null && (entry = this.getMaintenanceDocumentEntry(docTypeName)) != null) {
            allowsNewOrCopy = entry.getAllowsNewOrCopy();
        }
        return allowsNewOrCopy;
    }

    @Deprecated
    public MaintainableItemDefinition getMaintainableItem(String docTypeName, String itemName) {
        if (StringUtils.isBlank((CharSequence)docTypeName)) {
            throw new IllegalArgumentException("The docTypeName parameter value specified was blank, whitespace, or null.  A valid string representing the docTypeName must be specified.");
        }
        if (StringUtils.isBlank((CharSequence)itemName)) {
            throw new IllegalArgumentException("The itemName parameter value specified was blank, whitespace, or null.  A valid string representing the itemName must be specified.");
        }
        String[] subItems = StringUtils.split((String)itemName, (String)".");
        List<MaintainableSectionDefinition> sections = this.getMaintainableSections(docTypeName);
        for (MaintainableSectionDefinition section : sections) {
            List<MaintainableItemDefinition> fields = section.getMaintainableItems();
            for (MaintainableItemDefinition item : fields) {
                if (item.getName().equals(itemName)) {
                    return item;
                }
                if (!(item instanceof MaintainableCollectionDefinition)) continue;
                MaintainableCollectionDefinition col = (MaintainableCollectionDefinition)item;
                if (subItems.length <= 1 || !StringUtils.equals((CharSequence)col.getName(), (CharSequence)subItems[0])) continue;
                for (MaintainableCollectionDefinition subCol : col.getMaintainableCollections()) {
                    if (!subCol.getName().equals(subItems[1])) continue;
                    return subCol;
                }
            }
        }
        return null;
    }

    public MaintainableFieldDefinition getMaintainableField(String docTypeName, String fieldName) {
        MaintainableItemDefinition item = this.getMaintainableItem(docTypeName, fieldName);
        if (item instanceof MaintainableFieldDefinition) {
            return (MaintainableFieldDefinition)item;
        }
        return null;
    }

    @Deprecated
    public MaintainableCollectionDefinition getMaintainableCollection(String docTypeName, String collectionName) {
        MaintainableItemDefinition item;
        if (StringUtils.contains((CharSequence)collectionName, (CharSequence)"[")) {
            collectionName = StringUtils.substringBefore((String)collectionName, (String)"[") + StringUtils.substringAfter((String)collectionName, (String)"]");
        }
        if ((item = this.getMaintainableItem(docTypeName, collectionName)) instanceof MaintainableCollectionDefinition) {
            return (MaintainableCollectionDefinition)item;
        }
        return null;
    }

    @Deprecated
    public Class getCollectionBusinessObjectClass(String docTypeName, String collectionName) {
        MaintainableCollectionDefinition coll = this.getMaintainableCollection(docTypeName, collectionName);
        if (coll != null) {
            return coll.getBusinessObjectClass();
        }
        return null;
    }

    @Deprecated
    public List<MaintainableCollectionDefinition> getMaintainableCollections(String docTypeName) {
        ArrayList<MaintainableCollectionDefinition> collections = new ArrayList<MaintainableCollectionDefinition>();
        List<MaintainableSectionDefinition> sections = this.getMaintainableSections(docTypeName);
        Iterator<MaintainableSectionDefinition> iterator = sections.iterator();
        while (iterator.hasNext()) {
            MaintainableSectionDefinition sectionObj;
            MaintainableSectionDefinition section = sectionObj = iterator.next();
            List<MaintainableItemDefinition> fields = section.getMaintainableItems();
            for (MaintainableItemDefinition item : fields) {
                if (!(item instanceof MaintainableCollectionDefinition)) continue;
                collections.add((MaintainableCollectionDefinition)item);
            }
        }
        return collections;
    }

    @Deprecated
    public List<MaintainableCollectionDefinition> getMaintainableCollections(MaintainableCollectionDefinition parentCollection) {
        ArrayList<MaintainableCollectionDefinition> collections = new ArrayList<MaintainableCollectionDefinition>();
        List<MaintainableCollectionDefinition> colls = parentCollection.getMaintainableCollections();
        for (MaintainableCollectionDefinition coll : colls) {
            collections.add(coll);
            collections.addAll(this.getMaintainableCollections(coll));
        }
        return collections;
    }

    @Deprecated
    public void validateMaintenanceRequiredFields(MaintenanceDocument document) {
        Maintainable newMaintainableObject = document.getNewMaintainableObject();
        if (newMaintainableObject == null) {
            LOG.error("New maintainable is null");
            throw new RuntimeException("New maintainable is null");
        }
        List<MaintainableSectionDefinition> maintainableSectionDefinitions = this.getMaintainableSections(this.getDocumentTypeName(newMaintainableObject.getDataObjectClass()));
        for (MaintainableSectionDefinition maintainableSectionDefinition : maintainableSectionDefinitions) {
            for (MaintainableItemDefinition maintainableItemDefinition : maintainableSectionDefinition.getMaintainableItems()) {
                if (maintainableItemDefinition instanceof MaintainableFieldDefinition) {
                    this.validateMaintainableFieldRequiredFields((MaintainableFieldDefinition)maintainableItemDefinition, newMaintainableObject.getBusinessObject(), maintainableItemDefinition.getName());
                    continue;
                }
                if (!(maintainableItemDefinition instanceof MaintainableCollectionDefinition)) continue;
                this.validateMaintainableCollectionsRequiredFields(newMaintainableObject.getBusinessObject(), (MaintainableCollectionDefinition)maintainableItemDefinition);
            }
        }
    }

    private void validateMaintainableFieldRequiredFields(MaintainableFieldDefinition maintainableFieldDefinition, PersistableBusinessObject businessObject, String fieldName) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new IllegalArgumentException("invalid fieldName parameter.");
        }
        if (maintainableFieldDefinition.isRequired() && !maintainableFieldDefinition.isUnconditionallyReadOnly()) {
            try {
                String personProperty;
                Object obj = ObjectUtils.getNestedValue(businessObject, fieldName);
                if (obj == null || StringUtils.isBlank((CharSequence)obj.toString())) {
                    String attributeLabel = this.dataDictionaryService.getAttributeLabel(businessObject.getClass(), fieldName);
                    String shortLabel = this.dataDictionaryService.getAttributeShortLabel(businessObject.getClass(), fieldName);
                    GlobalVariables.getMessageMap().putError(fieldName, "error.required", attributeLabel + " (" + shortLabel + ")");
                } else if (fieldName.endsWith(".principalName") && StringUtils.isNotBlank((CharSequence)(personProperty = ObjectUtils.getNestedAttributePrefix(fieldName))) && StringUtils.isBlank((CharSequence)((String)ObjectUtils.getNestedValue(businessObject, personProperty + ".entityId")))) {
                    String attributeLabel = this.dataDictionaryService.getAttributeLabel(businessObject.getClass(), fieldName);
                    GlobalVariables.getMessageMap().putError(fieldName, "error.existence", attributeLabel);
                }
            }
            catch (Exception ex) {
                LOG.error("unable to read property during doc required field checks", (Throwable)ex);
            }
        }
    }

    private MaintainableCollectionDefinition getCollectionDefinition(String docTypeName, String collectionName) {
        String currentCollection = collectionName;
        String nestedCollections = "";
        if (StringUtils.contains((CharSequence)collectionName, (CharSequence)"[")) {
            currentCollection = StringUtils.substringBefore((String)collectionName, (String)"[");
            nestedCollections = StringUtils.substringAfter((String)collectionName, (String)".");
        }
        List<MaintainableSectionDefinition> maintainableSectionDefinitions = this.getMaintainableSections(docTypeName);
        for (MaintainableSectionDefinition maintainableSectionDefinition : maintainableSectionDefinitions) {
            for (MaintainableItemDefinition maintainableItemDefinition : maintainableSectionDefinition.getMaintainableItems()) {
                if (!(maintainableItemDefinition instanceof MaintainableCollectionDefinition) || !maintainableItemDefinition.getName().equals(currentCollection)) continue;
                if (StringUtils.isBlank((CharSequence)nestedCollections)) {
                    return (MaintainableCollectionDefinition)maintainableItemDefinition;
                }
                return this.getCollectionDefinition((MaintainableCollectionDefinition)maintainableItemDefinition, nestedCollections);
            }
        }
        return null;
    }

    private MaintainableCollectionDefinition getCollectionDefinition(MaintainableCollectionDefinition collectionDef, String collectionName) {
        String currentCollection = collectionName;
        String nestedCollections = "";
        if (StringUtils.contains((CharSequence)collectionName, (CharSequence)"[")) {
            currentCollection = StringUtils.substringBefore((String)collectionName, (String)"[");
            nestedCollections = StringUtils.substringAfter((String)collectionName, (String)".");
        }
        for (MaintainableCollectionDefinition maintainableCollectionDefinition : collectionDef.getMaintainableCollections()) {
            if (!maintainableCollectionDefinition.getName().equals(currentCollection)) continue;
            if (StringUtils.isBlank((CharSequence)nestedCollections)) {
                return maintainableCollectionDefinition;
            }
            return this.getCollectionDefinition(maintainableCollectionDefinition, nestedCollections);
        }
        return null;
    }

    @Deprecated
    public void validateMaintainableCollectionsAddLineRequiredFields(MaintenanceDocument document, PersistableBusinessObject businessObject, String collectionName) {
        MaintainableCollectionDefinition def = this.getCollectionDefinition(this.getDocumentTypeName(businessObject.getClass()), collectionName);
        if (def != null) {
            this.validateMaintainableCollectionsAddLineRequiredFields(document, collectionName, def, 0);
        }
    }

    private void validateMaintainableCollectionsAddLineRequiredFields(MaintenanceDocument document, String collectionName, MaintainableCollectionDefinition maintainableCollectionDefinition, int depth) {
        if (depth == 0) {
            GlobalVariables.getMessageMap().addToErrorPath("add");
        }
        PersistableBusinessObject element = document.getNewMaintainableObject().getNewCollectionLine(collectionName);
        GlobalVariables.getMessageMap().addToErrorPath(collectionName);
        for (MaintainableFieldDefinition maintainableFieldDefinition : maintainableCollectionDefinition.getMaintainableFields()) {
            String fieldName = maintainableFieldDefinition.getName();
            this.validateMaintainableFieldRequiredFields(maintainableFieldDefinition, element, fieldName);
        }
        GlobalVariables.getMessageMap().removeFromErrorPath(collectionName);
        if (depth == 0) {
            GlobalVariables.getMessageMap().removeFromErrorPath("add");
        }
    }

    private void validateMaintainableCollectionsRequiredFields(PersistableBusinessObject businessObject, MaintainableCollectionDefinition maintainableCollectionDefinition) {
        String collectionName = maintainableCollectionDefinition.getName();
        Collection collection = (Collection)ObjectUtils.getPropertyValue(businessObject, collectionName);
        if (collection != null && !collection.isEmpty()) {
            for (MaintainableFieldDefinition maintainableFieldDefinition : maintainableCollectionDefinition.getMaintainableFields()) {
                int pos = 0;
                String fieldName = maintainableFieldDefinition.getName();
                for (PersistableBusinessObject element : collection) {
                    String parentName = collectionName + "[" + pos++ + "]";
                    GlobalVariables.getMessageMap().addToErrorPath(parentName);
                    this.validateMaintainableFieldRequiredFields(maintainableFieldDefinition, element, fieldName);
                    GlobalVariables.getMessageMap().removeFromErrorPath(parentName);
                }
            }
            GlobalVariables.getMessageMap().addToErrorPath(collectionName);
            for (MaintainableCollectionDefinition nestedMaintainableCollectionDefinition : maintainableCollectionDefinition.getMaintainableCollections()) {
                for (PersistableBusinessObject element : collection) {
                    this.validateMaintainableCollectionsRequiredFields(element, nestedMaintainableCollectionDefinition);
                }
            }
            GlobalVariables.getMessageMap().removeFromErrorPath(collectionName);
        }
    }

    public void validateMaintainableCollectionsForDuplicateEntries(MaintenanceDocument document) {
        Maintainable newMaintainableObject = document.getNewMaintainableObject();
        if (newMaintainableObject == null) {
            LOG.error("New maintainable is null");
            throw new RuntimeException("New maintainable is null");
        }
        List<MaintainableSectionDefinition> maintainableSectionDefinitions = this.getMaintainableSections(this.getDocumentTypeName(newMaintainableObject.getDataObjectClass()));
        for (MaintainableSectionDefinition maintainableSectionDefinition : maintainableSectionDefinitions) {
            for (MaintainableItemDefinition maintainableItemDefinition : maintainableSectionDefinition.getMaintainableItems()) {
                if (!(maintainableItemDefinition instanceof MaintainableCollectionDefinition)) continue;
                this.validateMaintainableCollectionsForDuplicateEntries(newMaintainableObject.getBusinessObject(), (MaintainableCollectionDefinition)maintainableItemDefinition);
            }
        }
    }

    private void validateMaintainableCollectionsForDuplicateEntries(PersistableBusinessObject businessObject, MaintainableCollectionDefinition maintainableCollectionDefinition) {
        String collectionName = maintainableCollectionDefinition.getName();
        if (maintainableCollectionDefinition.dissallowDuplicateKey()) {
            Class<?> maintainableBusinessObjectClass = businessObject.getClass();
            Collection collection = (Collection)ObjectUtils.getPropertyValue(businessObject, collectionName);
            if (collection != null && !collection.isEmpty()) {
                String propertyName = maintainableCollectionDefinition.getAttributeToHighlightOnDuplicateKey();
                String label = this.dataDictionaryService.getCollectionLabel(maintainableBusinessObjectClass, collectionName);
                String shortLabel = this.dataDictionaryService.getCollectionShortLabel(maintainableBusinessObjectClass, collectionName);
                int pos = 0;
                for (PersistableBusinessObject element : collection) {
                    String pathToElement = collectionName + "[" + pos++ + "]";
                    if (ObjectUtils.countObjectsWithIdentitcalKey(collection, element) <= 1) continue;
                    GlobalVariables.getMessageMap().addToErrorPath(pathToElement);
                    GlobalVariables.getMessageMap().putError(propertyName, "error.duplicate.element", label, shortLabel);
                    GlobalVariables.getMessageMap().removeFromErrorPath(pathToElement);
                }
                GlobalVariables.getMessageMap().addToErrorPath(collectionName);
                for (MaintainableCollectionDefinition nestedMaintainableCollectionDefinition : maintainableCollectionDefinition.getMaintainableCollections()) {
                    for (PersistableBusinessObject element : collection) {
                        this.validateMaintainableCollectionsForDuplicateEntries(element, nestedMaintainableCollectionDefinition);
                    }
                }
                GlobalVariables.getMessageMap().removeFromErrorPath(collectionName);
            }
        }
    }

    public boolean getPreserveLockingKeysOnCopy(Class businessObjectClass) {
        boolean preserveLockingKeysOnCopy = false;
        MaintenanceDocumentEntry docEntry = this.getMaintenanceDocumentEntry(businessObjectClass);
        if (docEntry != null) {
            preserveLockingKeysOnCopy = docEntry.getPreserveLockingKeysOnCopy();
        }
        return preserveLockingKeysOnCopy;
    }

    public Boolean getAllowsRecordDeletion(Class businessObjectClass) {
        Boolean allowsRecordDeletion = Boolean.FALSE;
        MaintenanceDocumentEntry docEntry = this.getMaintenanceDocumentEntry(businessObjectClass);
        if (docEntry != null) {
            allowsRecordDeletion = docEntry.getAllowsRecordDeletion();
        }
        return allowsRecordDeletion;
    }

    public Boolean getAllowsRecordDeletion(MaintenanceDocument document) {
        return document != null ? this.getAllowsRecordDeletion(document.getNewMaintainableObject().getDataObjectClass()) : Boolean.FALSE;
    }

    @Deprecated
    public Boolean translateCodes(Class businessObjectClass) {
        boolean translateCodes = false;
        MaintenanceDocumentEntry docEntry = this.getMaintenanceDocumentEntry(businessObjectClass);
        if (docEntry != null) {
            translateCodes = docEntry.isTranslateCodes();
        }
        return translateCodes;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    private DataDictionary getDataDictionary() {
        return this.dataDictionaryService.getDataDictionary();
    }
}

