/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.service.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.authorization.BusinessObjectAuthorizer;
import org.kuali.kfs.kns.bo.authorization.InquiryOrMaintenanceDocumentAuthorizer;
import org.kuali.kfs.kns.bo.authorization.InquiryOrMaintenanceDocumentPresentationController;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.datadictionary.FieldDefinition;
import org.kuali.kfs.kns.datadictionary.InquiryCollectionDefinition;
import org.kuali.kfs.kns.datadictionary.InquirySectionDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.kfs.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictionsBase;
import org.kuali.kfs.kns.document.authorization.InquiryOrMaintenanceDocumentRestrictions;
import org.kuali.kfs.kns.document.authorization.InquiryOrMaintenanceDocumentRestrictionsBase;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentAuthorizer;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentPresentationController;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentRestrictions;
import org.kuali.kfs.kns.document.authorization.MaintenanceDocumentRestrictionsBase;
import org.kuali.kfs.kns.inquiry.InquiryAuthorizer;
import org.kuali.kfs.kns.inquiry.InquiryPresentationController;
import org.kuali.kfs.kns.inquiry.InquiryRestrictions;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.krad.bo.DataObjectAuthorizer;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.DocumentAuthorizer;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.impl.DataObjectAuthorizationServiceImpl;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;

public class BusinessObjectAuthorizationServiceImpl
extends DataObjectAuthorizationServiceImpl
implements BusinessObjectAuthorizationService {
    private PermissionService permissionService;
    private BusinessObjectDictionaryService businessObjectDictionaryService;
    private MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;
    private ConfigurationService kualiConfigurationService;

    @Override
    public BusinessObjectRestrictions getLookupResultRestrictions(Object dataObject, Person user) {
        BusinessObjectRestrictionsBase businessObjectRestrictions = new BusinessObjectRestrictionsBase();
        this.considerBusinessObjectFieldUnmaskAuthorization(dataObject, user, businessObjectRestrictions, "", null);
        return businessObjectRestrictions;
    }

    @Override
    public InquiryRestrictions getInquiryRestrictions(BusinessObject businessObject, Person user) {
        InquiryOrMaintenanceDocumentRestrictionsBase inquiryRestrictions = new InquiryOrMaintenanceDocumentRestrictionsBase();
        BusinessObjectEntry businessObjectEntry = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(businessObject.getClass().getName());
        InquiryPresentationController inquiryPresentationController = this.getBusinessObjectDictionaryService().getInquiryPresentationController(businessObject.getClass());
        InquiryAuthorizer inquiryAuthorizer = this.getBusinessObjectDictionaryService().getInquiryAuthorizer(businessObject.getClass());
        this.considerBusinessObjectFieldUnmaskAuthorization(businessObject, user, inquiryRestrictions, "", null);
        this.considerBusinessObjectFieldViewAuthorization(businessObjectEntry, businessObject, null, user, inquiryAuthorizer, inquiryRestrictions, "");
        this.considerInquiryOrMaintenanceDocumentPresentationController(inquiryPresentationController, businessObject, inquiryRestrictions);
        this.considerInquiryOrMaintenanceDocumentAuthorizer(inquiryAuthorizer, businessObject, user, inquiryRestrictions);
        for (InquirySectionDefinition inquirySectionDefinition : businessObjectEntry.getInquiryDefinition().getInquirySections()) {
            List<FieldDefinition> inquiryFields;
            if (inquirySectionDefinition.getInquiryCollections() != null) {
                this.addInquirableItemRestrictions(inquirySectionDefinition.getInquiryCollections().values(), inquiryAuthorizer, inquiryRestrictions, businessObject, businessObject, "", user);
            }
            if ((inquiryFields = inquirySectionDefinition.getInquiryFields()) == null) continue;
            for (FieldDefinition fieldDefinition : inquiryFields) {
                this.addInquirableItemRestrictions(inquiryFields, inquiryAuthorizer, inquiryRestrictions, businessObject, businessObject, "", user);
            }
        }
        return inquiryRestrictions;
    }

    @Override
    public MaintenanceDocumentRestrictions getMaintenanceDocumentRestrictions(MaintenanceDocument maintenanceDocument, Person user) {
        MaintenanceDocumentRestrictionsBase maintenanceDocumentRestrictions = new MaintenanceDocumentRestrictionsBase();
        BusinessObjectEntry businessObjectEntry = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(maintenanceDocument.getNewMaintainableObject().getDataObject().getClass().getName());
        MaintenanceDocumentPresentationController maintenanceDocumentPresentationController = (MaintenanceDocumentPresentationController)this.getDocumentHelperService().getDocumentPresentationController(maintenanceDocument);
        MaintenanceDocumentAuthorizer maintenanceDocumentAuthorizer = (MaintenanceDocumentAuthorizer)((Object)this.getDocumentHelperService().getDocumentAuthorizer(maintenanceDocument));
        this.considerBusinessObjectFieldUnmaskAuthorization(maintenanceDocument.getNewMaintainableObject().getDataObject(), user, maintenanceDocumentRestrictions, "", maintenanceDocument);
        this.considerBusinessObjectFieldViewAuthorization(businessObjectEntry, maintenanceDocument.getNewMaintainableObject().getDataObject(), null, user, maintenanceDocumentAuthorizer, maintenanceDocumentRestrictions, "");
        this.considerBusinessObjectFieldModifyAuthorization(businessObjectEntry, maintenanceDocument.getNewMaintainableObject().getDataObject(), null, user, maintenanceDocumentAuthorizer, maintenanceDocumentRestrictions, "");
        this.considerCustomButtonFieldAuthorization(businessObjectEntry, maintenanceDocument.getNewMaintainableObject().getDataObject(), null, user, maintenanceDocumentAuthorizer, maintenanceDocumentRestrictions, "");
        this.considerInquiryOrMaintenanceDocumentPresentationController(maintenanceDocumentPresentationController, maintenanceDocument, maintenanceDocumentRestrictions);
        this.considerInquiryOrMaintenanceDocumentAuthorizer(maintenanceDocumentAuthorizer, maintenanceDocument, user, maintenanceDocumentRestrictions);
        this.considerMaintenanceDocumentPresentationController(maintenanceDocumentPresentationController, maintenanceDocument, maintenanceDocumentRestrictions);
        this.considerMaintenanceDocumentAuthorizer(maintenanceDocumentAuthorizer, maintenanceDocument, user, maintenanceDocumentRestrictions);
        MaintenanceDocumentEntry maintenanceDocumentEntry = this.getMaintenanceDocumentDictionaryService().getMaintenanceDocumentEntry(maintenanceDocument.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        for (MaintainableSectionDefinition maintainableSectionDefinition : maintenanceDocumentEntry.getMaintainableSections()) {
            this.addMaintainableItemRestrictions(maintainableSectionDefinition.getMaintainableItems(), maintenanceDocumentAuthorizer, maintenanceDocumentRestrictions, maintenanceDocument, maintenanceDocument.getNewMaintainableObject().getBusinessObject(), "", user);
        }
        return maintenanceDocumentRestrictions;
    }

    protected void considerBusinessObjectFieldUnmaskAuthorization(Object dataObject, Person user, BusinessObjectRestrictions businessObjectRestrictions, String propertyPrefix, Document document) {
        BusinessObjectEntry objectEntry = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(dataObject.getClass().getName());
        Document permissionTarget = dataObject instanceof BusinessObject ? (BusinessObject)dataObject : document;
        for (String attributeName : objectEntry.getAttributeNames()) {
            AttributeDefinition attributeDefinition = objectEntry.getAttributeDefinition(attributeName);
            if (attributeDefinition.getAttributeSecurity() == null) continue;
            if (attributeDefinition.getAttributeSecurity().isMask() && !this.canFullyUnmaskFieldForBusinessObject(user, dataObject.getClass(), attributeName, permissionTarget, document)) {
                businessObjectRestrictions.addFullyMaskedField(propertyPrefix + attributeName, attributeDefinition.getAttributeSecurity().getMaskFormatter());
            }
            if (!attributeDefinition.getAttributeSecurity().isPartialMask() || this.canPartiallyUnmaskFieldForBusinessObject(user, dataObject.getClass(), attributeName, permissionTarget, document)) continue;
            businessObjectRestrictions.addPartiallyMaskedField(propertyPrefix + attributeName, attributeDefinition.getAttributeSecurity().getPartialMaskFormatter());
        }
    }

    protected boolean canFullyUnmaskFieldForBusinessObject(Person user, Class<?> dataObjectClass, String fieldName, BusinessObject businessObject, Document document) {
        if (this.isNonProductionEnvAndUnmaskingTurnedOff()) {
            return false;
        }
        if (user == null || StringUtils.isEmpty((CharSequence)user.getPrincipalId())) {
            return false;
        }
        DataObjectAuthorizer authorizer = null;
        Document boForAuthorization = null;
        if (document != null) {
            authorizer = this.findDocumentAuthorizerForBusinessObject(document);
            boForAuthorization = document;
        }
        if (authorizer == null) {
            authorizer = this.findDocumentAuthorizerForBusinessObject(businessObject);
            if (authorizer == null) {
                authorizer = this.findInquiryAuthorizerForBusinessObject(businessObject);
            }
            boForAuthorization = businessObject;
        }
        if (authorizer == null) {
            return this.getPermissionService().isAuthorizedByTemplate(user.getPrincipalId(), "KR-NS", "Full Unmask Field", new HashMap<String, String>(this.getFieldPermissionDetails(dataObjectClass, fieldName)), Collections.emptyMap());
        }
        return authorizer.isAuthorizedByTemplate(boForAuthorization, "KR-NS", "Full Unmask Field", user.getPrincipalId(), this.getFieldPermissionDetails(dataObjectClass, fieldName), Collections.emptyMap());
    }

    protected boolean canPartiallyUnmaskFieldForBusinessObject(Person user, Class<?> dataObjectClass, String fieldName, BusinessObject businessObject, Document document) {
        if (this.isNonProductionEnvAndUnmaskingTurnedOff()) {
            return false;
        }
        if (user == null || StringUtils.isEmpty((CharSequence)user.getPrincipalId())) {
            return false;
        }
        DataObjectAuthorizer authorizer = null;
        Document boForAuthorization = null;
        if (document != null) {
            authorizer = this.findDocumentAuthorizerForBusinessObject(document);
            boForAuthorization = document;
        }
        if (authorizer == null) {
            authorizer = this.findDocumentAuthorizerForBusinessObject(businessObject);
            if (authorizer == null) {
                authorizer = this.findInquiryAuthorizerForBusinessObject(businessObject);
            }
            boForAuthorization = businessObject;
        }
        if (authorizer == null) {
            return this.getPermissionService().isAuthorizedByTemplate(user.getPrincipalId(), "KR-NS", "Partial Unmask Field", new HashMap<String, String>(this.getFieldPermissionDetails(dataObjectClass, fieldName)), Collections.emptyMap());
        }
        return authorizer.isAuthorizedByTemplate(boForAuthorization, "KR-NS", "Partial Unmask Field", user.getPrincipalId(), this.getFieldPermissionDetails(dataObjectClass, fieldName), Collections.emptyMap());
    }

    protected DocumentAuthorizer findDocumentAuthorizerForBusinessObject(BusinessObject businessObject) {
        if (businessObject == null) {
            return null;
        }
        if (businessObject instanceof Document) {
            return this.getDocumentHelperService().getDocumentAuthorizer((Document)businessObject);
        }
        String maintDocType = this.getMaintenanceDocumentDictionaryService().getDocumentTypeName(businessObject.getClass());
        if (StringUtils.isBlank((CharSequence)maintDocType)) {
            return null;
        }
        return this.getDocumentHelperService().getDocumentAuthorizer(maintDocType);
    }

    protected DataObjectAuthorizer findInquiryAuthorizerForBusinessObject(BusinessObject businessObject) {
        if (businessObject == null) {
            return null;
        }
        BusinessObjectEntry boEntry = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(businessObject.getClass().getName());
        if (boEntry != null && boEntry.getInquiryDefinition() != null && boEntry.getInquiryDefinition().getAuthorizerClass() != null) {
            try {
                return (DataObjectAuthorizer)((Object)boEntry.getInquiryDefinition().getAuthorizerClass().newInstance());
            }
            catch (IllegalAccessException | InstantiationException ie) {
                throw new RuntimeException("Could not instantiate authorizer for inquiry of " + businessObject.getClass().getName(), ie);
            }
        }
        return null;
    }

    protected void considerBusinessObjectFieldViewAuthorization(BusinessObjectEntry businessObjectEntry, Object primaryDataObject, BusinessObject collectionItemBusinessObject, Person user, BusinessObjectAuthorizer businessObjectAuthorizer, InquiryOrMaintenanceDocumentRestrictions inquiryOrMaintenanceDocumentRestrictions, String propertyPrefix) {
        for (String attributeName : businessObjectEntry.getAttributeNames()) {
            AttributeDefinition attributeDefinition = businessObjectEntry.getAttributeDefinition(attributeName);
            if (attributeDefinition.getAttributeSecurity() == null || !attributeDefinition.getAttributeSecurity().isHide()) continue;
            HashMap<String, String> collectionItemPermissionDetails = new HashMap<String, String>();
            HashMap<String, String> collectionItemRoleQualifications = null;
            if (ObjectUtils.isNotNull(collectionItemBusinessObject)) {
                collectionItemPermissionDetails.putAll(this.getFieldPermissionDetails(collectionItemBusinessObject, attributeName));
                collectionItemPermissionDetails.putAll(businessObjectAuthorizer.getCollectionItemPermissionDetails(collectionItemBusinessObject));
                collectionItemRoleQualifications = new HashMap<String, String>(businessObjectAuthorizer.getCollectionItemRoleQualifications(collectionItemBusinessObject));
            } else {
                collectionItemPermissionDetails.putAll(this.getFieldPermissionDetails(primaryDataObject, attributeName));
            }
            if (businessObjectAuthorizer.isAuthorizedByTemplate(primaryDataObject, "KR-NS", "View Inquiry or Maintenance Document Field", user.getPrincipalId(), collectionItemPermissionDetails, collectionItemRoleQualifications)) continue;
            inquiryOrMaintenanceDocumentRestrictions.addHiddenField(propertyPrefix + attributeName);
        }
    }

    protected void considerBusinessObjectFieldModifyAuthorization(BusinessObjectEntry businessObjectEntry, Object primaryDataObject, BusinessObject collectionItemBusinessObject, Person user, BusinessObjectAuthorizer businessObjectAuthorizer, MaintenanceDocumentRestrictions maintenanceDocumentRestrictions, String propertyPrefix) {
        for (String attributeName : businessObjectEntry.getAttributeNames()) {
            AttributeDefinition attributeDefinition = businessObjectEntry.getAttributeDefinition(attributeName);
            if (attributeDefinition.getAttributeSecurity() == null) continue;
            HashMap<String, String> collectionItemPermissionDetails = new HashMap<String, String>();
            HashMap<String, String> collectionItemRoleQualifications = null;
            if (ObjectUtils.isNotNull(collectionItemBusinessObject)) {
                collectionItemPermissionDetails.putAll(this.getFieldPermissionDetails(collectionItemBusinessObject, attributeName));
                collectionItemPermissionDetails.putAll(businessObjectAuthorizer.getCollectionItemPermissionDetails(collectionItemBusinessObject));
                collectionItemRoleQualifications = new HashMap<String, String>(businessObjectAuthorizer.getCollectionItemRoleQualifications(collectionItemBusinessObject));
            } else {
                collectionItemPermissionDetails.putAll(this.getFieldPermissionDetails(primaryDataObject, attributeName));
            }
            if (!attributeDefinition.getAttributeSecurity().isReadOnly() || businessObjectAuthorizer.isAuthorizedByTemplate(primaryDataObject, "KR-NS", "Modify Maintenance Document Field", user.getPrincipalId(), collectionItemPermissionDetails, collectionItemRoleQualifications)) continue;
            maintenanceDocumentRestrictions.addReadOnlyField(propertyPrefix + attributeName);
        }
    }

    protected void considerCustomButtonFieldAuthorization(BusinessObjectEntry businessObjectEntry, Object primaryDataObject, BusinessObject collectionItemBusinessObject, Person user, BusinessObjectAuthorizer businessObjectAuthorizer, MaintenanceDocumentRestrictions maintenanceDocumentRestrictions, String propertyPrefix) {
        for (String attributeName : businessObjectEntry.getAttributeNames()) {
            AttributeDefinition attributeDefinition = businessObjectEntry.getAttributeDefinition(attributeName);
            if (attributeDefinition.getControl() == null || !attributeDefinition.getControl().isButton()) continue;
            HashMap<String, String> collectionItemPermissionDetails = new HashMap<String, String>();
            HashMap<String, String> collectionItemRoleQualifications = null;
            if (ObjectUtils.isNotNull(collectionItemBusinessObject)) {
                collectionItemPermissionDetails.putAll(this.getButtonFieldPermissionDetails(collectionItemBusinessObject, attributeName));
                collectionItemPermissionDetails.putAll(businessObjectAuthorizer.getCollectionItemPermissionDetails(collectionItemBusinessObject));
                collectionItemRoleQualifications = new HashMap<String, String>(businessObjectAuthorizer.getCollectionItemRoleQualifications(collectionItemBusinessObject));
            } else {
                collectionItemPermissionDetails.putAll(this.getButtonFieldPermissionDetails(primaryDataObject, attributeName));
            }
            if (businessObjectAuthorizer.isAuthorizedByTemplate(primaryDataObject, "KR-NS", "Perform Custom Maintenance Document Function", user.getPrincipalId(), collectionItemPermissionDetails, collectionItemRoleQualifications)) continue;
            maintenanceDocumentRestrictions.addHiddenField(propertyPrefix + attributeName);
        }
    }

    protected void considerInquiryOrMaintenanceDocumentPresentationController(InquiryOrMaintenanceDocumentPresentationController businessObjectPresentationController, BusinessObject businessObject, InquiryOrMaintenanceDocumentRestrictions inquiryOrMaintenanceDocumentRestrictions) {
        for (String attributeName : businessObjectPresentationController.getConditionallyHiddenPropertyNames(businessObject)) {
            inquiryOrMaintenanceDocumentRestrictions.addHiddenField(attributeName);
        }
        for (String sectionId : businessObjectPresentationController.getConditionallyHiddenSectionIds(businessObject)) {
            inquiryOrMaintenanceDocumentRestrictions.addHiddenSectionId(sectionId);
        }
    }

    protected void considerInquiryOrMaintenanceDocumentAuthorizer(InquiryOrMaintenanceDocumentAuthorizer authorizer, BusinessObject businessObject, Person user, InquiryOrMaintenanceDocumentRestrictions restrictions) {
        for (String sectionId : authorizer.getSecurePotentiallyHiddenSectionIds()) {
            HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
            additionalPermissionDetails.put("sectionId", sectionId);
            if (authorizer.isAuthorizedByTemplate(businessObject, "KR-NS", "View Inquiry or Maintenance Document Section", user.getPrincipalId(), additionalPermissionDetails, null)) continue;
            restrictions.addHiddenSectionId(sectionId);
        }
    }

    protected void considerMaintenanceDocumentPresentationController(MaintenanceDocumentPresentationController presentationController, MaintenanceDocument document, MaintenanceDocumentRestrictions restrictions) {
        for (String attributeName : presentationController.getConditionallyReadOnlyPropertyNames(document)) {
            restrictions.addReadOnlyField(attributeName);
        }
        for (String sectionId : presentationController.getConditionallyReadOnlySectionIds(document)) {
            restrictions.addReadOnlySectionId(sectionId);
        }
    }

    protected void considerMaintenanceDocumentAuthorizer(MaintenanceDocumentAuthorizer authorizer, MaintenanceDocument document, Person user, MaintenanceDocumentRestrictions restrictions) {
        for (String sectionId : authorizer.getSecurePotentiallyReadOnlySectionIds()) {
            HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
            additionalPermissionDetails.put("sectionId", sectionId);
            if (authorizer.isAuthorizedByTemplate(document, "KR-NS", "Modify Maintenance Document Section", user.getPrincipalId(), additionalPermissionDetails, null)) continue;
            restrictions.addReadOnlySectionId(sectionId);
        }
    }

    protected void addInquirableItemRestrictions(Collection sectionDefinitions, InquiryAuthorizer authorizer, InquiryRestrictions restrictions, BusinessObject primaryBusinessObject, BusinessObject businessObject, String propertyPrefix, Person user) {
        for (Object inquirableItemDefinition : sectionDefinitions) {
            if (!(inquirableItemDefinition instanceof InquiryCollectionDefinition)) continue;
            InquiryCollectionDefinition inquiryCollectionDefinition = (InquiryCollectionDefinition)inquirableItemDefinition;
            BusinessObjectEntry collectionBusinessObjectEntry = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(inquiryCollectionDefinition.getBusinessObjectClass().getName());
            try {
                Collection collection = (Collection)PropertyUtils.getProperty((Object)businessObject, (String)inquiryCollectionDefinition.getName());
                int i = 0;
                for (BusinessObject collectionItemBusinessObject : collection) {
                    String newPropertyPrefix = propertyPrefix + inquiryCollectionDefinition.getName() + "[" + i + "].";
                    this.considerBusinessObjectFieldUnmaskAuthorization(collectionItemBusinessObject, user, restrictions, newPropertyPrefix, null);
                    this.considerBusinessObjectFieldViewAuthorization(collectionBusinessObjectEntry, primaryBusinessObject, collectionItemBusinessObject, user, authorizer, restrictions, newPropertyPrefix);
                    this.addInquirableItemRestrictions(inquiryCollectionDefinition.getInquiryCollections(), authorizer, restrictions, primaryBusinessObject, collectionItemBusinessObject, newPropertyPrefix, user);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to resolve collection property: " + businessObject.getClass() + ":" + inquiryCollectionDefinition.getName(), e);
            }
        }
    }

    protected void addMaintainableItemRestrictions(List<? extends MaintainableItemDefinition> itemDefinitions, MaintenanceDocumentAuthorizer authorizer, MaintenanceDocumentRestrictions restrictions, MaintenanceDocument maintenanceDocument, BusinessObject businessObject, String propertyPrefix, Person user) {
        for (MaintainableItemDefinition maintainableItemDefinition : itemDefinitions) {
            if (!(maintainableItemDefinition instanceof MaintainableCollectionDefinition)) continue;
            try {
                MaintainableCollectionDefinition maintainableCollectionDefinition = (MaintainableCollectionDefinition)maintainableItemDefinition;
                Collection collection = (Collection)ObjectUtils.getNestedValue(businessObject, maintainableItemDefinition.getName());
                BusinessObjectEntry collectionBusinessObjectEntry = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(maintainableCollectionDefinition.getBusinessObjectClass().getName());
                if (!CollectionUtils.isNotEmpty((Collection)collection)) continue;
                int i = 0;
                for (BusinessObject collectionBusinessObject : collection) {
                    String newPropertyPrefix = propertyPrefix + maintainableItemDefinition.getName() + "[" + i + "].";
                    this.considerBusinessObjectFieldUnmaskAuthorization(collectionBusinessObject, user, restrictions, newPropertyPrefix, maintenanceDocument);
                    this.considerBusinessObjectFieldViewAuthorization(collectionBusinessObjectEntry, maintenanceDocument, collectionBusinessObject, user, authorizer, restrictions, newPropertyPrefix);
                    this.considerBusinessObjectFieldModifyAuthorization(collectionBusinessObjectEntry, maintenanceDocument, collectionBusinessObject, user, authorizer, restrictions, newPropertyPrefix);
                    this.considerCustomButtonFieldAuthorization(collectionBusinessObjectEntry, maintenanceDocument, collectionBusinessObject, user, authorizer, restrictions, newPropertyPrefix);
                    this.addMaintainableItemRestrictions(((MaintainableCollectionDefinition)maintainableItemDefinition).getMaintainableCollections(), authorizer, restrictions, maintenanceDocument, collectionBusinessObject, newPropertyPrefix, user);
                    this.addMaintainableItemRestrictions(((MaintainableCollectionDefinition)maintainableItemDefinition).getMaintainableFields(), authorizer, restrictions, maintenanceDocument, collectionBusinessObject, newPropertyPrefix, user);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to resolve collection property: " + businessObject.getClass() + ":" + maintainableItemDefinition.getName(), e);
            }
        }
    }

    @Override
    public boolean canFullyUnmaskField(Person user, Class<?> dataObjectClass, String fieldName, Document document) {
        return this.canFullyUnmaskFieldForBusinessObject(user, dataObjectClass, fieldName, document, null);
    }

    @Override
    public boolean canPartiallyUnmaskField(Person user, Class<?> dataObjectClass, String fieldName, Document document) {
        return this.canPartiallyUnmaskFieldForBusinessObject(user, dataObjectClass, fieldName, document, null);
    }

    protected Map<String, String> getFieldPermissionDetails(Class<?> dataObjectClass, String attributeName) {
        try {
            return this.getFieldPermissionDetails(dataObjectClass.newInstance(), attributeName);
        }
        catch (Exception e) {
            throw new RuntimeException("The getPermissionDetails method of BusinessObjectAuthorizationServiceImpl was unable to instantiate the dataObjectClass" + dataObjectClass, e);
        }
    }

    protected Map<String, String> getFieldPermissionDetails(Object dataObject, String attributeName) {
        Map<String, String> permissionDetails = KRADUtils.getNamespaceAndComponentSimpleName(dataObject.getClass());
        permissionDetails.put("propertyName", attributeName);
        return permissionDetails;
    }

    protected Map<String, String> getButtonFieldPermissionDetails(Object businessObject, String attributeName) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        if (attributeName.contains(".")) {
            permissionDetails.put("buttonName", attributeName);
        } else {
            permissionDetails.put("buttonName", attributeName);
        }
        return permissionDetails;
    }

    private PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KimApiServiceLocator.getPermissionService();
        }
        return this.permissionService;
    }

    private BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        if (this.businessObjectDictionaryService == null) {
            this.businessObjectDictionaryService = KNSServiceLocator.getBusinessObjectDictionaryService();
        }
        return this.businessObjectDictionaryService;
    }

    private MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        if (this.maintenanceDocumentDictionaryService == null) {
            this.maintenanceDocumentDictionaryService = KNSServiceLocator.getMaintenanceDocumentDictionaryService();
        }
        return this.maintenanceDocumentDictionaryService;
    }

    private ConfigurationService getKualiConfigurationService() {
        if (this.kualiConfigurationService == null) {
            this.kualiConfigurationService = KRADServiceLocator.getKualiConfigurationService();
        }
        return this.kualiConfigurationService;
    }

    @Override
    public boolean isNonProductionEnvAndUnmaskingTurnedOff() {
        ConfigurationService configurationService = this.getKualiConfigurationService();
        return !configurationService.getPropertyValueAsString("production.environment.code").equalsIgnoreCase(this.getKualiConfigurationService().getPropertyValueAsString("environment")) && !configurationService.getPropertyValueAsBoolean("enable.nonproduction.data.unmasking");
    }

    protected DocumentHelperService getDocumentHelperService() {
        return KNSServiceLocator.getDocumentHelperService();
    }
}

