/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.kns.web.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.datadictionary.CollectionDefinitionI;
import org.kuali.kfs.kns.datadictionary.FieldDefinition;
import org.kuali.kfs.kns.datadictionary.FieldDefinitionI;
import org.kuali.kfs.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableFieldDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.kfs.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.kfs.kns.datadictionary.control.ControlDefinition;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.service.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.kns.util.FieldUtils;
import org.kuali.kfs.kns.util.MaintenanceUtils;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.keyvalues.KeyValuesFinder;
import org.kuali.kfs.krad.keyvalues.PersistableBusinessObjectValuesFinder;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.krad.bo.BusinessObject;

@Deprecated
public final class FieldBridge {
    private static final Logger LOG = LogManager.getLogger(FieldBridge.class);
    private static DataDictionaryService dataDictionaryService;
    private static PersistenceStructureService persistenceStructureService;
    private static BusinessObjectDictionaryService businessObjectDictionaryService;
    private static MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;

    private FieldBridge() {
    }

    public static void setupField(Field field, FieldDefinitionI definition, Set<String> conditionallyRequiredMaintenanceFields) {
        if (definition instanceof MaintainableFieldDefinition) {
            MaintainableFieldDefinition maintainableFieldDefinition = (MaintainableFieldDefinition)definition;
            field.setFieldRequired(maintainableFieldDefinition.isRequired());
            field.setReadOnly(maintainableFieldDefinition.isUnconditionallyReadOnly());
            field.setNewLookup(maintainableFieldDefinition.isNewLookup());
            if (maintainableFieldDefinition.isLookupReadOnly()) {
                field.setFieldType("lookupreadonly");
            }
            if (StringUtils.isNotBlank((CharSequence)maintainableFieldDefinition.getWebUILeaveFieldFunction())) {
                field.setWebOnBlurHandler(maintainableFieldDefinition.getWebUILeaveFieldFunction());
            }
            if (StringUtils.isNotBlank((CharSequence)maintainableFieldDefinition.getWebUILeaveFieldCallbackFunction())) {
                field.setWebOnBlurHandlerCallback(maintainableFieldDefinition.getWebUILeaveFieldCallbackFunction());
            }
            if (maintainableFieldDefinition.getWebUILeaveFieldFunctionParameters() != null) {
                field.setWebUILeaveFieldFunctionParameters(maintainableFieldDefinition.getWebUILeaveFieldFunctionParameters());
            }
            if (StringUtils.isNotBlank((CharSequence)maintainableFieldDefinition.getAlternateDisplayAttributeName())) {
                field.setAlternateDisplayPropertyName(maintainableFieldDefinition.getAlternateDisplayAttributeName());
            }
            if (StringUtils.isNotBlank((CharSequence)maintainableFieldDefinition.getAdditionalDisplayAttributeName())) {
                field.setAdditionalDisplayPropertyName(maintainableFieldDefinition.getAdditionalDisplayAttributeName());
            }
            if (conditionallyRequiredMaintenanceFields != null && conditionallyRequiredMaintenanceFields.contains(field.getPropertyName())) {
                field.setFieldRequired(true);
            }
            if (((MaintainableFieldDefinition)definition).isTriggerOnChange()) {
                field.setTriggerOnChange(true);
            }
        }
    }

    public static void populateFieldFromBusinessObject(Field field, BusinessObject bo) {
        String propValue;
        if (bo == null) {
            throw new RuntimeException("Inquiry Business object is null.");
        }
        field.setReadOnly(true);
        Formatter formatter = field.getFormatter();
        String propertyName = field.getPropertyName();
        ControlDefinition fieldControl = FieldBridge.getDataDictionaryService().getAttributeControlDefinition(bo.getClass(), propertyName);
        Object prop = ObjectUtils.getPropertyValue(bo, field.getPropertyName());
        if (fieldControl != null && fieldControl.isSelect() && StringUtils.isBlank((CharSequence)field.getAdditionalDisplayPropertyName()) && StringUtils.isBlank((CharSequence)field.getAlternateDisplayPropertyName())) {
            KeyValuesFinder finder = fieldControl.getValuesFinder();
            if (formatter != null) {
                prop = ObjectUtils.getFormattedPropertyValue(bo, propertyName, formatter);
            }
            propValue = FieldBridge.lookupFinderValue(fieldControl, prop, finder);
        } else {
            propValue = ObjectUtils.getFormattedPropertyValue(bo, field.getPropertyName(), formatter);
        }
        field.setPropertyValue(propValue);
        if (StringUtils.isNotBlank((CharSequence)field.getAlternateDisplayPropertyName())) {
            String alternatePropertyValue = ObjectUtils.getFormattedPropertyValueUsingDataDictionary(bo, field.getAlternateDisplayPropertyName());
            field.setAlternateDisplayPropertyValue(alternatePropertyValue);
        }
        if (StringUtils.isNotBlank((CharSequence)field.getAdditionalDisplayPropertyName())) {
            String additionalPropertyValue = ObjectUtils.getFormattedPropertyValueUsingDataDictionary(bo, field.getAdditionalDisplayPropertyName());
            field.setAdditionalDisplayPropertyValue(additionalPropertyValue);
        }
        if (fieldControl != null && fieldControl.isKualiUser()) {
            try {
                Object personName;
                Object principalId;
                if (StringUtils.isNotBlank((CharSequence)field.getUniversalIdAttributeName()) && (principalId = ObjectUtils.getNestedValue(bo, field.getUniversalIdAttributeName())) != null) {
                    field.setUniversalIdValue(principalId.toString());
                }
                if (StringUtils.isNotBlank((CharSequence)field.getPersonNameAttributeName()) && (personName = ObjectUtils.getNestedValue(bo, field.getPersonNameAttributeName())) != null) {
                    field.setPersonNameValue(personName.toString());
                }
            }
            catch (Exception ex) {
                LOG.warn("Unable to get principal ID or person name property in FieldBridge.", (Throwable)ex);
            }
        }
        if (fieldControl != null && fieldControl.isFile() && "file".equals(field.getFieldType())) {
            Object fileName = ObjectUtils.getNestedValue(bo, "fileName");
            Object fileType = ObjectUtils.getNestedValue(bo, "contentType");
            field.setImageSrc(WebUtils.getAttachmentImageForUrl((String)fileType));
            field.setPropertyValue(fileName);
        }
        FieldUtils.setInquiryURL(field, bo, propertyName);
    }

    private static String lookupFinderValue(ControlDefinition fieldControl, Object prop, KeyValuesFinder finder) {
        List<KeyValue> keyValues;
        String propValue;
        if (finder instanceof PersistableBusinessObjectValuesFinder) {
            ((PersistableBusinessObjectValuesFinder)finder).setBusinessObjectClass(ClassLoaderUtils.getClass((String)fieldControl.getBusinessObjectClass()));
            ((PersistableBusinessObjectValuesFinder)finder).setKeyAttributeName(fieldControl.getKeyAttribute());
            ((PersistableBusinessObjectValuesFinder)finder).setLabelAttributeName(fieldControl.getLabelAttribute());
            if (fieldControl.getIncludeBlankRow() != null) {
                ((PersistableBusinessObjectValuesFinder)finder).setIncludeBlankRow(fieldControl.getIncludeBlankRow());
            }
            ((PersistableBusinessObjectValuesFinder)finder).setIncludeKeyInDescription(fieldControl.getIncludeKeyInLabel());
        }
        if ((propValue = FieldBridge.getPropertyValueFromList(prop, keyValues = finder.getKeyValues())) == null) {
            propValue = FieldBridge.lookupInactiveFinderValue(prop, finder);
        }
        return propValue;
    }

    private static String lookupInactiveFinderValue(Object property, KeyValuesFinder finder) {
        List<KeyValue> keyValues = finder.getKeyValues(false);
        return FieldBridge.getPropertyValueFromList(property, keyValues);
    }

    private static String getPropertyValueFromList(Object property, List<KeyValue> keyValues) {
        String propertyValue = null;
        if (property != null) {
            for (KeyValue element2 : keyValues) {
                KeyValue element = element2;
                if (!element.getKey().equals(property.toString())) continue;
                propertyValue = element.getValue();
                break;
            }
        }
        return propertyValue;
    }

    protected static boolean isMaintenanceFieldLevelHelpEnabled(Maintainable m, MaintainableFieldDefinition fieldDefinition) {
        if (fieldDefinition == null) {
            return false;
        }
        return fieldDefinition.isShowFieldLevelHelp() != null && fieldDefinition.isShowFieldLevelHelp() != false;
    }

    protected static boolean isMaintenanceFieldLevelHelpDisabled(Maintainable m, MaintainableFieldDefinition fieldDefinition) {
        return !FieldBridge.isMaintenanceFieldLevelHelpEnabled(m, fieldDefinition);
    }

    public static Field toField(MaintainableItemDefinition id, MaintainableSectionDefinition sd, BusinessObject o, Maintainable m, Section s, List<String> displayedFieldNames, Set<String> conditionallyRequiredMaintenanceFields) {
        Field field = new Field();
        if (id instanceof MaintainableFieldDefinition) {
            MaintainableFieldDefinition maintainableFieldDefinition = (MaintainableFieldDefinition)id;
            field = FieldUtils.getPropertyField(o.getClass(), maintainableFieldDefinition.getName(), false);
            boolean translateCodes = FieldBridge.getMaintenanceDocumentDictionaryService().translateCodes(o.getClass());
            if (translateCodes) {
                FieldUtils.setAdditionalDisplayPropertyForCodes(o.getClass(), field.getPropertyName(), field);
            }
            FieldBridge.setupField(field, maintainableFieldDefinition, conditionallyRequiredMaintenanceFields);
            MaintenanceUtils.setFieldQuickfinder(o, field.getPropertyName(), maintainableFieldDefinition, field, displayedFieldNames, m);
            MaintenanceUtils.setFieldDirectInquiry(o, field.getPropertyName(), maintainableFieldDefinition, field, displayedFieldNames);
            field.setFieldLevelHelpEnabled(FieldBridge.isMaintenanceFieldLevelHelpEnabled(m, maintainableFieldDefinition));
            field.setFieldLevelHelpDisabled(FieldBridge.isMaintenanceFieldLevelHelpDisabled(m, maintainableFieldDefinition));
            field.setFieldLevelHelpUrl(maintainableFieldDefinition.getFieldLevelHelpUrl());
        }
        return field;
    }

    public static Field toField(FieldDefinition d, BusinessObject o, Section s) {
        String additionalDisplayPropertyName;
        Field field = FieldUtils.getPropertyField(o.getClass(), d.getAttributeName(), false);
        FieldUtils.setInquiryURL(field, o, field.getPropertyName());
        String alternateDisplayPropertyName = FieldBridge.getBusinessObjectDictionaryService().getInquiryFieldAlternateDisplayAttributeName(o.getClass(), d.getAttributeName());
        if (StringUtils.isNotBlank((CharSequence)alternateDisplayPropertyName)) {
            field.setAlternateDisplayPropertyName(alternateDisplayPropertyName);
        }
        if (StringUtils.isNotBlank((CharSequence)(additionalDisplayPropertyName = FieldBridge.getBusinessObjectDictionaryService().getInquiryFieldAdditionalDisplayAttributeName(o.getClass(), d.getAttributeName())))) {
            field.setAdditionalDisplayPropertyName(additionalDisplayPropertyName);
        } else {
            boolean translateCodes = FieldBridge.getBusinessObjectDictionaryService().tranlateCodesInInquiry(o.getClass());
            if (translateCodes) {
                FieldUtils.setAdditionalDisplayPropertyForCodes(o.getClass(), d.getAttributeName(), field);
            }
        }
        FieldBridge.populateFieldFromBusinessObject(field, o);
        return field;
    }

    public static List<Field> getNewFormFields(CollectionDefinitionI collectionDefinition, BusinessObject o, Maintainable m, List<String> displayedFieldNames, Set<String> conditionallyRequiredMaintenanceFields, StringBuffer containerRowErrorKey, String parents, boolean hideAdd, int numberOfColumns) {
        PersistableBusinessObject collBO;
        LOG.debug("getNewFormFields");
        String collName = collectionDefinition.getName();
        List<Field> collFields = new ArrayList<Field>();
        try {
            List<? extends FieldDefinitionI> collectionFields = collectionDefinition.getFields();
            collBO = m.getNewCollectionLine(parents + collName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("newBO for add line: " + collBO);
            }
            for (FieldDefinitionI fieldDefinitionI : collectionFields) {
                Field collField = FieldUtils.getPropertyField(collectionDefinition.getBusinessObjectClass(), fieldDefinitionI.getName(), false);
                if (fieldDefinitionI instanceof MaintainableFieldDefinition) {
                    FieldBridge.setupField(collField, fieldDefinitionI, conditionallyRequiredMaintenanceFields);
                }
                String[] nameParts = StringUtils.split((String)collField.getPropertyName(), (String)".");
                String fieldErrorKey = "document.newMaintainableObject.add.";
                fieldErrorKey = fieldErrorKey + collName + ".";
                for (String namePart : nameParts) {
                    fieldErrorKey = fieldErrorKey + namePart;
                    containerRowErrorKey.append(fieldErrorKey);
                    fieldErrorKey = fieldErrorKey + ".";
                    containerRowErrorKey.append(",");
                }
                BusinessObject collectionBoInstance = collectionDefinition.getBusinessObjectClass().newInstance();
                FieldUtils.setInquiryURL(collField, collectionBoInstance, fieldDefinitionI.getName());
                if (collectionDefinition instanceof MaintainableCollectionDefinition) {
                    MaintenanceUtils.setFieldQuickfinder(collectionBoInstance, parents + collectionDefinition.getName(), true, 0, fieldDefinitionI.getName(), collField, displayedFieldNames, m, (MaintainableFieldDefinition)fieldDefinitionI);
                    MaintenanceUtils.setFieldDirectInquiry(collectionBoInstance, parents + collectionDefinition.getName(), true, 0, fieldDefinitionI.getName(), collField, displayedFieldNames, m, (MaintainableFieldDefinition)fieldDefinitionI);
                } else {
                    LookupUtils.setFieldQuickfinder(collectionBoInstance, parents + collectionDefinition.getName(), true, 0, fieldDefinitionI.getName(), collField, displayedFieldNames, m);
                    LookupUtils.setFieldDirectInquiry(collectionBoInstance, fieldDefinitionI.getName(), collField);
                }
                collFields.add(collField);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.error("Unable to create instance of object class" + e.getMessage());
            throw new RuntimeException("Unable to create instance of object class" + e.getMessage());
        }
        collFields = FieldUtils.populateFieldsFromBusinessObject(collFields, collBO);
        for (Field field : collFields) {
            field.setPropertyName("add." + parents + collectionDefinition.getName() + "." + field.getPropertyName());
        }
        LOG.debug("Error Key for section " + collectionDefinition.getName() + " : " + containerRowErrorKey.toString());
        collFields = FieldBridge.constructContainerField(collectionDefinition, parents, o, hideAdd, numberOfColumns, collName, collFields);
        return collFields;
    }

    public static List<Field> getNewFormFields(MaintainableCollectionDefinition collectionDefinition, BusinessObject o, Maintainable m, List<String> displayedFieldNames, Set<String> conditionallyRequiredMaintenanceFields, StringBuffer containerRowErrorKey, int numberOfColumns) {
        String parent = "";
        return FieldBridge.getNewFormFields(collectionDefinition, o, m, displayedFieldNames, conditionallyRequiredMaintenanceFields, containerRowErrorKey, parent, false, numberOfColumns);
    }

    public static List<Field> constructContainerField(CollectionDefinitionI collectionDefinition, String parents, BusinessObject o, boolean hideAdd, int numberOfColumns, String collName, List<Field> collFields) {
        String collectionLabel = FieldBridge.getDataDictionaryService().getCollectionLabel(o.getClass(), collectionDefinition.getName());
        String collectionElementLabel = collectionDefinition.getSummaryTitle();
        if (StringUtils.isEmpty((CharSequence)collectionElementLabel)) {
            collectionElementLabel = FieldBridge.getDataDictionaryService().getCollectionElementLabel(o.getClass().getName(), collectionDefinition.getName(), collectionDefinition.getBusinessObjectClass());
        }
        Field containerField = FieldUtils.constructContainerField(collName, collectionLabel, collFields, numberOfColumns);
        if (StringUtils.isNotEmpty((CharSequence)collectionElementLabel)) {
            containerField.setContainerElementName(collectionElementLabel);
        }
        collFields = new ArrayList<Field>();
        collFields.add(containerField);
        if (!hideAdd && collectionDefinition.getIncludeAddLine()) {
            Field field = new Field();
            String addButtonName = "methodToCall.addLine." + parents + collectionDefinition.getName() + "." + "(!!" + collectionDefinition.getBusinessObjectClass().getName() + "!!)";
            field.setPropertyName(addButtonName);
            field.setFieldType("imagesubmit");
            field.setStyleClass("btn btn-green");
            field.setFieldLabel("Add Line");
            field.setFieldShortLabel("Add");
            containerField.getContainerRows().add(new Row(field));
        }
        if (collectionDefinition instanceof MaintainableCollectionDefinition && FieldUtils.isCollectionMultipleLookupEnabled((MaintainableCollectionDefinition)collectionDefinition)) {
            FieldUtils.modifyFieldToSupportMultipleValueLookups(containerField, parents, (MaintainableCollectionDefinition)collectionDefinition);
        }
        return collFields;
    }

    public static DataDictionaryService getDataDictionaryService() {
        if (dataDictionaryService == null) {
            dataDictionaryService = KNSServiceLocator.getDataDictionaryService();
        }
        return dataDictionaryService;
    }

    public static PersistenceStructureService getPersistenceStructureService() {
        if (persistenceStructureService == null) {
            persistenceStructureService = KRADServiceLocator.getPersistenceStructureService();
        }
        return persistenceStructureService;
    }

    public static BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        if (businessObjectDictionaryService == null) {
            businessObjectDictionaryService = KNSServiceLocator.getBusinessObjectDictionaryService();
        }
        return businessObjectDictionaryService;
    }

    public static MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        if (maintenanceDocumentDictionaryService == null) {
            maintenanceDocumentDictionaryService = KNSServiceLocator.getMaintenanceDocumentDictionaryService();
        }
        return maintenanceDocumentDictionaryService;
    }
}

