/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.bo;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectExtension;
import org.kuali.kfs.krad.service.KRADServiceLocator;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Versioned;

@MappedSuperclass
public abstract class PersistableBusinessObjectBase
extends BusinessObjectBase
implements PersistableBusinessObject,
PersistenceBrokerAware,
Versioned,
GloballyUnique {
    private static final long serialVersionUID = 1451642350593233282L;
    private static final Logger LOG = LogManager.getLogger(PersistableBusinessObjectBase.class);
    @Version
    @Column(name="VER_NBR")
    protected Long versionNumber;
    @Column(name="OBJ_ID")
    private String objectId;
    @Column(name="LAST_UPDT_TS")
    private Timestamp lastUpdatedTimestamp;
    @Transient
    private boolean newCollectionRecord;
    @Transient
    protected PersistableBusinessObjectExtension extension;
    private static transient PersistenceService persistenceService;
    private static transient PersistenceStructureService persistenceStructureService;
    private static transient DataDictionaryService dataDictionaryService;

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    @Override
    public void setVersionNumber(Long versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    @Override
    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    @Override
    public Timestamp getLastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    @Override
    public void setLastUpdatedTimestamp(Timestamp lastUpdatedTimestamp) {
        this.lastUpdatedTimestamp = lastUpdatedTimestamp;
    }

    @Override
    public boolean isNewCollectionRecord() {
        return this.newCollectionRecord;
    }

    @Override
    public void setNewCollectionRecord(boolean isNewCollectionRecord) {
        this.newCollectionRecord = isNewCollectionRecord;
    }

    public final void afterDelete(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.postRemove();
    }

    @PostRemove
    protected void postRemove() {
    }

    public final void afterInsert(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.postPersist();
    }

    @PostPersist
    protected void postPersist() {
    }

    public final void afterLookup(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.postLoad();
    }

    @PostLoad
    protected void postLoad() {
    }

    public final void afterUpdate(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.postUpdate();
    }

    @PostUpdate
    protected void postUpdate() {
    }

    public final void beforeDelete(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.preRemove();
    }

    @PreRemove
    protected void preRemove() {
    }

    public final void beforeInsert(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.setObjectId(null);
        this.prePersist();
    }

    @PrePersist
    protected void prePersist() {
        this.updateModifyDate();
        this.generateAndSetObjectIdIfNeeded();
    }

    public final void beforeUpdate(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.preUpdate();
    }

    @PreUpdate
    protected void preUpdate() {
        this.updateModifyDate();
        this.generateAndSetObjectIdIfNeeded();
    }

    private void generateAndSetObjectIdIfNeeded() {
        if (StringUtils.isEmpty((CharSequence)this.getObjectId())) {
            this.setObjectId(UUID.randomUUID().toString());
        }
    }

    private void updateModifyDate() {
        this.lastUpdatedTimestamp = CoreApiServiceLocator.getDateTimeService().getCurrentTimestamp();
    }

    public void refresh() {
        PersistableBusinessObjectBase.getPersistenceService().retrieveNonKeyFields(this);
    }

    @Override
    public void refreshNonUpdateableReferences() {
        PersistableBusinessObjectBase.getPersistenceService().refreshAllNonUpdatingReferences(this);
    }

    @Override
    public void refreshReferenceObject(String referenceObjectName) {
        if (StringUtils.isNotBlank((CharSequence)referenceObjectName) && !StringUtils.equals((CharSequence)referenceObjectName, (CharSequence)"extension")) {
            PersistenceStructureService pss = PersistableBusinessObjectBase.getPersistenceStructureService();
            if (pss.hasReference(this.getClass(), referenceObjectName) || pss.hasCollection(this.getClass(), referenceObjectName)) {
                PersistableBusinessObjectBase.getPersistenceService().retrieveReferenceObject(this, referenceObjectName);
            } else {
                LOG.warn("refreshReferenceObject() called with non-reference property: " + referenceObjectName);
            }
        }
    }

    @Override
    public List<Collection<PersistableBusinessObject>> buildListOfDeletionAwareLists() {
        return new ArrayList<Collection<PersistableBusinessObject>>();
    }

    @Override
    public void linkEditableUserFields() {
    }

    @Override
    public PersistableBusinessObjectExtension getExtension() {
        if (this.extension == null && PersistableBusinessObjectBase.getPersistenceStructureService().isPersistable(this.getClass())) {
            try {
                Class<? extends PersistableBusinessObjectExtension> extensionClass = PersistableBusinessObjectBase.getPersistenceStructureService().getBusinessObjectAttributeClass(this.getClass(), "extension");
                if (extensionClass != null) {
                    this.extension = extensionClass.newInstance();
                }
            }
            catch (Exception ex) {
                LOG.error("unable to create extension object", (Throwable)ex);
            }
        }
        return this.extension;
    }

    @Override
    public void setExtension(PersistableBusinessObjectExtension extension) {
        this.extension = extension;
    }

    protected static PersistenceService getPersistenceService() {
        if (persistenceService == null) {
            persistenceService = KRADServiceLocator.getPersistenceService();
        }
        return persistenceService;
    }

    protected static PersistenceStructureService getPersistenceStructureService() {
        if (persistenceStructureService == null) {
            persistenceStructureService = KRADServiceLocator.getPersistenceStructureService();
        }
        return persistenceStructureService;
    }

    protected static DataDictionaryService getDataDictionaryService() {
        if (dataDictionaryService == null) {
            dataDictionaryService = KNSServiceLocator.getDataDictionaryService();
        }
        return dataDictionaryService;
    }
}

