/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class NumericStringValueComparator
implements Serializable,
Comparator {
    static final long serialVersionUID = 3449202365486147519L;
    private static final NumericStringValueComparator theInstance = new NumericStringValueComparator();

    public static NumericStringValueComparator getInstance() {
        return theInstance;
    }

    public int compare(Object o1, Object o2) {
        KualiDecimal k2;
        KualiDecimal k1;
        if (null == o1 || null == o2) {
            return null == o1 && null == o2 ? 0 : (null == o1 ? -1 : 1);
        }
        String numericCompare1 = (String)o1;
        String numericCompare2 = (String)o2;
        numericCompare1 = StringUtils.replace((String)numericCompare1, (String)",", (String)"");
        numericCompare1 = StringUtils.replace((String)numericCompare1, (String)"$", (String)"");
        numericCompare1 = StringUtils.replace((String)numericCompare1, (String)"&nbsp;", (String)"");
        numericCompare2 = StringUtils.replace((String)numericCompare2, (String)",", (String)"");
        numericCompare2 = StringUtils.replace((String)numericCompare2, (String)"$", (String)"");
        numericCompare2 = StringUtils.replace((String)numericCompare2, (String)"&nbsp;", (String)"");
        if (StringUtils.contains((CharSequence)numericCompare1, (CharSequence)"(")) {
            numericCompare1 = StringUtils.replace((String)numericCompare1, (String)"(", (String)"");
            numericCompare1 = StringUtils.replace((String)numericCompare1, (String)")", (String)"");
            numericCompare1 = "-" + numericCompare1;
        }
        if (StringUtils.contains((CharSequence)numericCompare2, (CharSequence)"(")) {
            numericCompare2 = StringUtils.replace((String)numericCompare2, (String)"(", (String)"");
            numericCompare2 = StringUtils.replace((String)numericCompare2, (String)")", (String)"");
            numericCompare2 = "-" + numericCompare2;
        }
        boolean invalidValue = false;
        try {
            k1 = new KualiDecimal(numericCompare1);
        }
        catch (Throwable t) {
            k1 = KualiDecimal.ZERO;
            invalidValue = true;
        }
        try {
            k2 = new KualiDecimal(numericCompare2);
        }
        catch (Throwable t) {
            k2 = KualiDecimal.ZERO;
            invalidValue = true;
        }
        if (invalidValue) {
            return numericCompare1.compareTo(numericCompare2);
        }
        double d1 = k1.doubleValue();
        double d2 = k2.doubleValue();
        return Double.compare(d1, d2);
    }
}

