/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.krad.service.KRADServiceLocatorInternal;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.framework.config.module.ModuleConfigurer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SmartApplicationListener;

public class KRADConfigurer
extends ModuleConfigurer
implements SmartApplicationListener {
    private DataSource applicationDataSource;
    private static final String KRAD_SPRING_BEANS_PATH = "classpath:org/kuali/kfs/krad/config/KRADSpringBeans.xml";
    private static final String KNS_SPRING_BEANS_PATH = "classpath:org/kuali/kfs/kns/config/KNSSpringBeans.xml";
    private static final String CORE_SERVICE_SPRING_BEANS_PATH = "classpath:org/kuali/kfs/coreservice/config/CoreServiceLocalSpringBeans.xml";

    public KRADConfigurer() {
        super("kr");
        this.setValidRunModes(Arrays.asList(RunMode.LOCAL));
    }

    public void addAdditonalToConfig() {
        this.configureDataSource();
    }

    public List<String> getPrimarySpringFiles() {
        ArrayList<String> springFileLocations = new ArrayList<String>();
        springFileLocations.add(CORE_SERVICE_SPRING_BEANS_PATH);
        springFileLocations.add(KRAD_SPRING_BEANS_PATH);
        springFileLocations.add(KNS_SPRING_BEANS_PATH);
        return springFileLocations;
    }

    public List<String> getAdditionalSpringFiles() {
        String files = ConfigContext.getCurrentContextConfig().getProperty("fin." + this.getModuleName() + ".additionalSpringFiles");
        return files == null ? Collections.emptyList() : this.parseFileList(files);
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof ContextRefreshedEvent) {
            this.loadDataDictionary();
            this.publishDataDictionaryComponents();
        }
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> aClass) {
        return true;
    }

    public boolean supportsSourceType(Class<?> aClass) {
        return true;
    }

    public int getOrder() {
        return -1000;
    }

    protected void loadDataDictionary() {
        if (this.isLoadDataDictionary()) {
            this.LOG.info("KRAD Configurer - Loading DD");
            DataDictionaryService dds = KNSServiceLocator.getDataDictionaryService();
            if (dds == null) {
                dds = (DataDictionaryService)GlobalResourceLoader.getService((String)"cf.dataDictionaryService");
            }
            dds.getDataDictionary().parseDataDictionaryConfigurationFiles(false);
            if (this.isValidateDataDictionary()) {
                this.LOG.info("KRAD Configurer - Validating DD");
                dds.getDataDictionary().validateDD();
            }
            dds.getDataDictionary().performBeanOverrides();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishDataDictionaryComponents() {
        if (this.isComponentPublishingEnabled()) {
            long delay = this.getComponentPublishingDelay();
            this.LOG.info("Publishing of Data Dictionary components is enabled, scheduling publish after " + delay + " millisecond delay");
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
            try {
                scheduler.schedule(() -> {
                    long start = System.currentTimeMillis();
                    this.LOG.info("Executing scheduled Data Dictionary component publishing...");
                    try {
                        KRADServiceLocatorInternal.getDataDictionaryComponentPublisherService().publishAllComponents();
                    }
                    catch (RuntimeException e) {
                        this.LOG.error("Failed to publish data dictionary components.", (Throwable)e);
                        throw e;
                    }
                    finally {
                        long end = System.currentTimeMillis();
                        this.LOG.info("... finished scheduled execution of Data Dictionary component publishing.  Took " + (end - start) + " milliseconds");
                    }
                }, delay, TimeUnit.MILLISECONDS);
            }
            finally {
                scheduler.shutdown();
            }
        }
    }

    public boolean hasWebInterface() {
        return true;
    }

    public boolean shouldRenderWebInterface() {
        return true;
    }

    public boolean isLoadDataDictionary() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty("load.data.dictionary", true);
    }

    public boolean isValidateDataDictionary() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty("validate.data.dictionary", false);
    }

    public boolean isComponentPublishingEnabled() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.krad.componentPublishing.enabled", false);
    }

    public long getComponentPublishingDelay() {
        return ConfigContext.getCurrentContextConfig().getNumericProperty("rice.krad.componentPublishing.delay", 0L);
    }

    protected void configureDataSource() {
        if (this.getApplicationDataSource() != null) {
            ConfigContext.getCurrentContextConfig().putObject("kradApplication.datasource", (Object)this.getApplicationDataSource());
        }
    }

    public DataSource getApplicationDataSource() {
        return this.applicationDataSource;
    }

    public void setApplicationDataSource(DataSource applicationDataSource) {
        this.applicationDataSource = applicationDataSource;
    }
}

