/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.datadictionary.CollectionDefinition;
import org.kuali.kfs.krad.datadictionary.RelationshipDefinition;
import org.kuali.kfs.krad.datadictionary.exception.DuplicateEntryException;
import org.kuali.kfs.krad.exception.ValidationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;

public abstract class DataDictionaryEntry
implements Serializable,
InitializingBean {
    protected List<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
    protected List<CollectionDefinition> collections = new ArrayList<CollectionDefinition>();
    protected List<RelationshipDefinition> relationships = new ArrayList<RelationshipDefinition>();
    protected Map<String, AttributeDefinition> attributeMap = new LinkedHashMap<String, AttributeDefinition>();
    protected Map<String, CollectionDefinition> collectionMap = new LinkedHashMap<String, CollectionDefinition>();
    protected Map<String, RelationshipDefinition> relationshipMap = new LinkedHashMap<String, RelationshipDefinition>();

    public abstract String getJstlKey();

    public abstract String getFullClassName();

    public abstract Class<?> getEntryClass();

    public AttributeDefinition getAttributeDefinition(String attributeName) {
        if (StringUtils.isBlank((CharSequence)attributeName)) {
            throw new IllegalArgumentException("invalid (blank) attributeName");
        }
        return this.attributeMap.get(attributeName);
    }

    public List<AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    public CollectionDefinition getCollectionDefinition(String collectionName) {
        if (StringUtils.isBlank((CharSequence)collectionName)) {
            throw new IllegalArgumentException("invalid (blank) collectionName");
        }
        return this.collectionMap.get(collectionName);
    }

    public List<CollectionDefinition> getCollections() {
        return this.collections;
    }

    public RelationshipDefinition getRelationshipDefinition(String relationshipName) {
        if (StringUtils.isBlank((CharSequence)relationshipName)) {
            throw new IllegalArgumentException("invalid (blank) relationshipName");
        }
        return this.relationshipMap.get(relationshipName);
    }

    public List<RelationshipDefinition> getRelationships() {
        return this.relationships;
    }

    public void completeValidation() {
        for (AttributeDefinition attributeDefinition : this.attributes) {
            attributeDefinition.completeValidation(this.getEntryClass(), null);
        }
        for (CollectionDefinition collectionDefinition : this.collections) {
            collectionDefinition.completeValidation((Class)this.getEntryClass(), (Class)null);
        }
        for (RelationshipDefinition relationshipDefinition : this.relationships) {
            relationshipDefinition.completeValidation((Class)this.getEntryClass(), (Class)null);
        }
    }

    public void setAttributes(List<AttributeDefinition> attributes) {
        this.attributeMap.clear();
        for (AttributeDefinition attribute : attributes) {
            if (attribute == null) {
                throw new IllegalArgumentException("invalid (null) attributeDefinition");
            }
            String attributeName = attribute.getName();
            if (StringUtils.isBlank((CharSequence)attributeName)) {
                throw new ValidationException("invalid (blank) attributeName");
            }
            if (this.attributeMap.containsKey(attributeName)) {
                throw new DuplicateEntryException("attribute '" + attributeName + "' already defined as an Attribute for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.collectionMap.containsKey(attributeName)) {
                throw new DuplicateEntryException("attribute '" + attributeName + "' already defined as a Collection for class '" + this.getEntryClass().getName() + "'");
            }
            this.attributeMap.put(attributeName, attribute);
        }
        this.attributes = attributes;
    }

    public void setCollections(List<CollectionDefinition> collections) {
        this.collectionMap.clear();
        for (CollectionDefinition collection : collections) {
            if (collection == null) {
                throw new IllegalArgumentException("invalid (null) collectionDefinition");
            }
            String collectionName = collection.getName();
            if (StringUtils.isBlank((CharSequence)collectionName)) {
                throw new ValidationException("invalid (blank) collectionName");
            }
            if (this.collectionMap.containsKey(collectionName)) {
                throw new DuplicateEntryException("collection '" + collectionName + "' already defined for class '" + this.getEntryClass().getName() + "'");
            }
            if (this.attributeMap.containsKey(collectionName)) {
                throw new DuplicateEntryException("collection '" + collectionName + "' already defined as an Attribute for class '" + this.getEntryClass().getName() + "'");
            }
            this.collectionMap.put(collectionName, collection);
        }
        this.collections = collections;
    }

    public void setRelationships(List<RelationshipDefinition> relationships) {
        this.relationships = relationships;
    }

    public Set<String> getCollectionNames() {
        return this.collectionMap.keySet();
    }

    public Set<String> getAttributeNames() {
        return this.attributeMap.keySet();
    }

    public Set<String> getRelationshipNames() {
        return this.relationshipMap.keySet();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.relationships != null) {
            this.relationshipMap.clear();
            for (RelationshipDefinition relationship : this.relationships) {
                if (relationship == null) {
                    throw new IllegalArgumentException("invalid (null) relationshipDefinition");
                }
                String relationshipName = relationship.getObjectAttributeName();
                if (StringUtils.isBlank((CharSequence)relationshipName)) {
                    throw new ValidationException("invalid (blank) relationshipName");
                }
                relationship.setSourceClass(this.getEntryClass());
                this.relationshipMap.put(relationshipName, relationship);
            }
        }
    }

    private AttributeDefinition copyAttributeDefinition(AttributeDefinition attrDefToCopy) {
        AttributeDefinition attrDefCopy = new AttributeDefinition();
        try {
            BeanUtils.copyProperties((Object)attrDefToCopy, (Object)attrDefCopy, (String[])new String[]{"formatterClass"});
            attrDefCopy.setRequired(attrDefToCopy.isRequired());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attrDefCopy;
    }
}

