/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.datadictionary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.datadictionary.DocumentEntry;
import org.kuali.kfs.kns.datadictionary.MaintenanceDocumentEntry;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntry;
import org.kuali.kfs.krad.datadictionary.DataDictionaryIndex;
import org.kuali.kfs.krad.datadictionary.DataDictionaryMapper;
import org.kuali.kfs.krad.datadictionary.InactivationBlockingMetadata;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.ModuleService;

public class DataDictionaryIndexMapper
implements DataDictionaryMapper {
    private static final Logger LOG = LogManager.getLogger(DataDictionaryIndexMapper.class);

    @Override
    public Set<InactivationBlockingMetadata> getAllInactivationBlockingMetadatas(DataDictionaryIndex index, Class<?> blockedClass) {
        return index.getInactivationBlockersForClass().get(blockedClass);
    }

    @Override
    public List<String> getBusinessObjectClassNames(DataDictionaryIndex index) {
        ArrayList<String> classNames = new ArrayList<String>(index.getBusinessObjectEntries().keySet());
        return Collections.unmodifiableList(classNames);
    }

    @Override
    public Map<String, BusinessObjectEntry> getBusinessObjectEntries(DataDictionaryIndex index) {
        return index.getBusinessObjectEntries();
    }

    @Override
    public BusinessObjectEntry getBusinessObjectEntryForConcreteClass(DataDictionaryIndex ddIndex, String className) {
        int index;
        if (StringUtils.isBlank((CharSequence)className)) {
            throw new IllegalArgumentException("invalid (blank) className");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("calling getBusinessObjectEntry '" + className + "'");
        }
        if ((index = className.indexOf("$$")) >= 0) {
            className = className.substring(0, index);
        }
        return ddIndex.getBusinessObjectEntries().get(className);
    }

    @Override
    public DataDictionaryEntry getDictionaryObjectEntry(DataDictionaryIndex ddIndex, String className) {
        DataDictionaryEntry entry;
        int index;
        if (StringUtils.isBlank((CharSequence)className)) {
            throw new IllegalArgumentException("invalid (blank) className");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("calling getDictionaryObjectEntry '" + className + "'");
        }
        if ((index = className.indexOf("$$")) >= 0) {
            className = className.substring(0, index);
        }
        if ((entry = ddIndex.getEntriesByJstlKey().get(className)) == null) {
            entry = this.getBusinessObjectEntry(ddIndex, className);
        }
        if (entry == null) {
            entry = this.getDocumentEntry(ddIndex, className);
        }
        return entry;
    }

    @Override
    public BusinessObjectEntry getBusinessObjectEntry(DataDictionaryIndex index, String className) {
        BusinessObjectEntry entry = this.getBusinessObjectEntryForConcreteClass(index, className);
        if (entry == null) {
            try {
                Class<?> boClass = Class.forName(className);
                ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(boClass);
                if (responsibleModuleService != null && responsibleModuleService.isExternalizable(boClass)) {
                    return responsibleModuleService.getExternalizableBusinessObjectDictionaryEntry(boClass);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return null;
        }
        return entry;
    }

    @Override
    public Map<String, DocumentEntry> getDocumentEntries(DataDictionaryIndex index) {
        return Collections.unmodifiableMap(index.getDocumentEntries());
    }

    @Override
    public DocumentEntry getDocumentEntry(DataDictionaryIndex index, String documentTypeDDKey) {
        DocumentEntry de;
        if (StringUtils.isBlank((CharSequence)documentTypeDDKey)) {
            throw new IllegalArgumentException("invalid (blank) documentTypeName");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("calling getDocumentEntry by documentTypeName '" + documentTypeDDKey + "'");
        }
        if ((de = index.getDocumentEntries().get(documentTypeDDKey)) == null) {
            try {
                Class<?> clazz = Class.forName(documentTypeDDKey);
                de = index.getDocumentEntriesByBusinessObjectClass().get(clazz);
                if (de == null) {
                    de = index.getDocumentEntriesByMaintainableClass().get(clazz);
                }
            }
            catch (ClassNotFoundException ex) {
                LOG.warn("Unable to find document entry for key: " + documentTypeDDKey);
            }
        }
        return de;
    }

    @Override
    public String getDocumentTypeName(DataDictionaryIndex index, String documentTypeName) {
        return null;
    }

    @Override
    public MaintenanceDocumentEntry getMaintenanceDocumentEntryForBusinessObjectClass(DataDictionaryIndex index, Class<?> businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) dataObjectClass");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("calling getDocumentEntry by dataObjectClass '" + businessObjectClass + "'");
        }
        return (MaintenanceDocumentEntry)index.getDocumentEntriesByBusinessObjectClass().get(businessObjectClass);
    }
}

