/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.keyvalues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

public class MapValuesFinder
implements KeyValuesFinder {
    private Map<String, String> keyValues;

    public MapValuesFinder(Map<String, String> keyValues) {
        this.setKeyValues(keyValues);
    }

    public void setKeyValues(Map<String, String> keyValues) {
        if (keyValues == null) {
            throw new IllegalArgumentException("keyValues was null");
        }
        this.keyValues = Collections.unmodifiableMap(new HashMap<String, String>(keyValues));
    }

    @Override
    public List<KeyValue> getKeyValues() {
        ArrayList<ConcreteKeyValue> list = new ArrayList<ConcreteKeyValue>();
        for (Map.Entry<String, String> entry : this.keyValues.entrySet()) {
            list.add(new ConcreteKeyValue(entry));
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public List<KeyValue> getKeyValues(boolean includeActiveOnly) {
        return this.getKeyValues();
    }

    @Override
    public Map<String, String> getKeyLabelMap() {
        return this.keyValues;
    }

    @Override
    public String getKeyLabel(String key) {
        return this.keyValues.get(key);
    }
}

