/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.kim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.kim.permission.PermissionTypeServiceBase;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.impl.permission.PermissionBo;

public class DocumentTypePermissionTypeServiceImpl
extends PermissionTypeServiceBase {
    protected transient DocumentTypeService documentTypeService;

    @Override
    protected List<String> getRequiredAttributes() {
        return Collections.singletonList("documentTypeName");
    }

    @Override
    protected boolean isCheckRequiredAttributes() {
        return true;
    }

    @Override
    protected List<Permission> performPermissionMatches(Map<String, String> requestedDetails, List<Permission> permissionsList) {
        HashSet<String> permissionDocTypeNames = new HashSet<String>(permissionsList.size());
        for (Permission permission : permissionsList) {
            PermissionBo bo = PermissionBo.from((Permission)permission);
            String docTypeName = (String)bo.getDetails().get("documentTypeName");
            if (!StringUtils.isNotBlank((CharSequence)docTypeName)) continue;
            permissionDocTypeNames.add(docTypeName);
        }
        DocumentType docType = this.getDocumentTypeService().getDocumentTypeByName(requestedDetails.get("documentTypeName"));
        String matchingDocTypeName = this.getClosestParentDocumentTypeName(docType, permissionDocTypeNames);
        ArrayList<Permission> matchingPermissions = new ArrayList<Permission>();
        for (Permission kpi : permissionsList) {
            PermissionBo bo = PermissionBo.from((Permission)kpi);
            String docTypeName = (String)bo.getDetails().get("documentTypeName");
            if ((!StringUtils.isEmpty((CharSequence)matchingDocTypeName) || !StringUtils.equals((CharSequence)docTypeName, (CharSequence)"*")) && (!StringUtils.isNotEmpty((CharSequence)matchingDocTypeName) || !matchingDocTypeName.equals(docTypeName))) continue;
            matchingPermissions.add(kpi);
        }
        return matchingPermissions;
    }

    @Override
    protected DocumentTypeService getDocumentTypeService() {
        if (this.documentTypeService == null) {
            this.documentTypeService = KewApiServiceLocator.getDocumentTypeService();
        }
        return this.documentTypeService;
    }

    @Override
    public void setDocumentTypeService(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }
}

