/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.bo.Attachment;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.service.AttachmentService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.WritableResource;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AmazonS3AttachmentServiceImpl
implements AttachmentService {
    private static final Logger LOG = LogManager.getLogger();
    private ResourceLoader resourceLoader;
    private String bucketName;
    private AmazonS3 amazonS3;
    protected BusinessObjectService businessObjectService;

    @Override
    public Attachment getAttachmentByNoteId(Long noteId) {
        if (noteId == null) {
            return null;
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("noteIdentifier", noteId.toString());
        return this.businessObjectService.findByPrimaryKey(Attachment.class, values);
    }

    @Override
    public Attachment createAttachment(GloballyUnique parent, String uploadedFileName, String mimeType, int fileSize, InputStream fileContents, String attachmentTypeCode) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting to create attachment for document: " + parent.getObjectId());
        }
        if (parent == null) {
            throw new IllegalArgumentException("invalid (null or uninitialized) document");
        }
        if (StringUtils.isBlank((CharSequence)uploadedFileName)) {
            throw new IllegalArgumentException("invalid (blank) fileName");
        }
        if (StringUtils.isBlank((CharSequence)mimeType)) {
            throw new IllegalArgumentException("invalid (blank) mimeType");
        }
        if (fileSize <= 0) {
            throw new IllegalArgumentException("invalid (non-positive) fileSize");
        }
        if (fileContents == null) {
            throw new IllegalArgumentException("invalid (null) inputStream");
        }
        String uniqueFileNameGuid = UUID.randomUUID().toString();
        TransferManager manager = new TransferManager(this.amazonS3);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType(mimeType);
        metadata.setContentDisposition("attachment; filename=" + URLEncoder.encode(uploadedFileName, "UTF-8"));
        metadata.setContentLength((long)fileSize);
        Upload upload = manager.upload(this.bucketName, uniqueFileNameGuid, fileContents, metadata);
        try {
            upload.waitForCompletion();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Failed to upload file to s3", e);
        }
        Attachment attachment = new Attachment();
        attachment.setAttachmentIdentifier(uniqueFileNameGuid);
        attachment.setAttachmentFileName(uploadedFileName);
        attachment.setAttachmentFileSize(Long.valueOf(fileSize));
        attachment.setAttachmentMimeTypeCode(mimeType);
        attachment.setAttachmentTypeCode(attachmentTypeCode);
        if (LOG.isDebugEnabled()) {
            LOG.debug("finished creating attachment for document: " + parent.getObjectId());
        }
        return attachment;
    }

    @Override
    public void moveAttachmentWherePending(Note note) {
    }

    @Override
    public void deletePendingAttachmentsModifiedBefore(long modificationTime) {
    }

    @Override
    public void deleteAttachmentContents(Attachment attachment) {
        if (attachment.getNote() == null) {
            throw new RuntimeException("Attachment.note must be set in order to delete the attachment");
        }
        this.amazonS3.deleteObject(this.bucketName, attachment.getAttachmentIdentifier());
    }

    @Override
    public InputStream retrieveAttachmentContents(Attachment attachment) throws IOException {
        return this.findAttachmentResource(this.s3Url(attachment.getAttachmentIdentifier())).getInputStream();
    }

    private String s3Url(String uniqueFileNameGuid) {
        if (StringUtils.isBlank((CharSequence)this.bucketName)) {
            throw new IllegalStateException("No bucket name available.");
        }
        if (StringUtils.isBlank((CharSequence)uniqueFileNameGuid)) {
            throw new IllegalArgumentException("GUID cannot be null.");
        }
        return this.generateS3Prefix() + uniqueFileNameGuid;
    }

    private String generateS3Prefix() {
        return "s3://" + this.bucketName + "/";
    }

    private WritableResource findAttachmentResource(String url) {
        if (url == null) {
            throw new IllegalArgumentException("Given attachment url was null");
        }
        return (WritableResource)this.resourceLoader.getResource(url);
    }

    @Required
    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Required
    @Autowired
    public void setAmazonS3(AmazonS3 amazonS3) {
        this.amazonS3 = amazonS3;
    }

    @Required
    @Autowired
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

