/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.DataObjectRelationship;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntry;
import org.kuali.kfs.krad.datadictionary.PrimitiveAttributeDefinition;
import org.kuali.kfs.krad.datadictionary.RelationshipDefinition;
import org.kuali.kfs.krad.datadictionary.SupportAttributeDefinition;
import org.kuali.kfs.krad.service.DataObjectMetaDataService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.ObjectPropertyUtils;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.beans.BeanWrapper;

public class DataObjectMetaDataServiceImpl
implements DataObjectMetaDataService {
    private DataDictionaryService dataDictionaryService;
    private KualiModuleService kualiModuleService;
    private PersistenceStructureService persistenceStructureService;

    @Override
    public List<String> listPrimaryKeyFieldNames(Class<?> clazz) {
        if (this.persistenceStructureService.isPersistable(clazz)) {
            return this.persistenceStructureService.listPrimaryKeyFieldNames(clazz);
        }
        ModuleService responsibleModuleService = this.getKualiModuleService().getResponsibleModuleService(clazz);
        if (responsibleModuleService != null && responsibleModuleService.isExternalizable(clazz)) {
            return responsibleModuleService.listPrimaryKeyFieldNames(clazz);
        }
        List<String> pks = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(clazz.getName()).getPrimaryKeys();
        if (pks != null && !pks.isEmpty()) {
            return pks;
        }
        return new ArrayList<String>();
    }

    @Override
    public Map<String, ?> getPrimaryKeyFieldValues(Object dataObject) {
        return this.getPrimaryKeyFieldValues(dataObject, false);
    }

    @Override
    public Map<String, ?> getPrimaryKeyFieldValues(Object dataObject, boolean sortFieldNames) {
        AbstractMap keyValueMap = sortFieldNames ? new TreeMap() : new HashMap();
        BeanWrapper wrapper = ObjectPropertyUtils.wrapObject(dataObject);
        List<String> fields = this.listPrimaryKeyFieldNames(dataObject.getClass());
        for (String fieldName : fields) {
            keyValueMap.put(fieldName, wrapper.getPropertyValue(fieldName));
        }
        return keyValueMap;
    }

    @Override
    public boolean equalsByPrimaryKeys(Object do1, Object do2) {
        boolean equal = true;
        if (do1 == null && do2 == null) {
            equal = true;
        } else if (do1 == null || do2 == null) {
            equal = false;
        } else if (!do1.getClass().getName().equals(do2.getClass().getName())) {
            equal = false;
        } else {
            Map<String, ?> do1Keys = this.getPrimaryKeyFieldValues(do1);
            Map<String, ?> do2Keys = this.getPrimaryKeyFieldValues(do2);
            for (String keyName : do1Keys.keySet()) {
                if (do1Keys.get(keyName) != null && do2Keys.get(keyName) != null) {
                    if (do1Keys.get(keyName).toString().equals(do2Keys.get(keyName).toString())) continue;
                    equal = false;
                    continue;
                }
                equal = false;
            }
        }
        return equal;
    }

    @Override
    public DataObjectRelationship getDataObjectRelationship(Object dataObject, Class<?> dataObjectClass, String attributeName, String attributePrefix, boolean keysOnly, boolean supportsLookup, boolean supportsInquiry) {
        RelationshipDefinition ddReference = this.getDictionaryRelationship(dataObjectClass, attributeName);
        return this.getDataObjectRelationship(ddReference, dataObject, dataObjectClass, attributeName, attributePrefix, keysOnly, supportsLookup, supportsInquiry);
    }

    protected DataObjectRelationship getDataObjectRelationship(RelationshipDefinition ddReference, Object dataObject, Class<?> dataObjectClass, String attributeName, String attributePrefix, boolean keysOnly, boolean supportsLookup, boolean supportsInquiry) {
        DataObjectRelationship relationship = null;
        if (ObjectUtils.isNestedAttribute(attributeName)) {
            Object nestedObject;
            if (ddReference != null) {
                relationship = this.populateRelationshipFromDictionaryReference(dataObjectClass, ddReference, attributePrefix, keysOnly);
                return relationship;
            }
            String localPrefix = StringUtils.substringBefore((String)attributeName, (String)".");
            String localAttributeName = StringUtils.substringAfter((String)attributeName, (String)".");
            if (dataObject == null) {
                dataObject = ObjectUtils.createNewObjectFromClass(dataObjectClass);
            }
            Class<?> nestedClass = (nestedObject = ObjectPropertyUtils.getPropertyValue(dataObject, localPrefix)) == null ? ObjectPropertyUtils.getPropertyType(dataObject, localPrefix) : nestedObject.getClass();
            String fullPrefix = localPrefix;
            if (StringUtils.isNotBlank((CharSequence)attributePrefix)) {
                fullPrefix = attributePrefix + "." + localPrefix;
            }
            relationship = this.getDataObjectRelationship(nestedObject, nestedClass, localAttributeName, fullPrefix, keysOnly, supportsLookup, supportsInquiry);
            return relationship;
        }
        int maxSize = Integer.MAX_VALUE;
        if (this.getPersistenceStructureService().isPersistable(dataObjectClass)) {
            Map<String, DataObjectRelationship> rels = this.getPersistenceStructureService().getRelationshipMetadata(dataObjectClass, attributeName, attributePrefix);
            if (rels.size() > 0) {
                for (DataObjectRelationship rel : rels.values()) {
                    if (rel.getParentToChildReferences().size() >= maxSize) continue;
                    maxSize = rel.getParentToChildReferences().size();
                    relationship = rel;
                }
            }
        } else {
            ModuleService moduleService = this.getKualiModuleService().getResponsibleModuleService(dataObjectClass);
            if (moduleService != null && moduleService.isExternalizable(dataObjectClass)) {
                relationship = this.getRelationshipMetadata(dataObjectClass, attributeName, attributePrefix);
                return relationship;
            }
        }
        if (ddReference != null && ddReference.getPrimitiveAttributes().size() < maxSize) {
            relationship = this.populateRelationshipFromDictionaryReference(dataObjectClass, ddReference, null, keysOnly);
        }
        return relationship;
    }

    @Override
    public RelationshipDefinition getDictionaryRelationship(Class<?> c, String attributeName) {
        DataDictionaryEntry entryBase = this.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(c.getName());
        if (entryBase == null) {
            return null;
        }
        RelationshipDefinition relationship = null;
        List<RelationshipDefinition> ddRelationships = entryBase.getRelationships();
        int minKeys = Integer.MAX_VALUE;
        block0: for (RelationshipDefinition def : ddRelationships) {
            if (def.getPrimitiveAttributes().size() == 1) {
                for (PrimitiveAttributeDefinition primitive : def.getPrimitiveAttributes()) {
                    if (!primitive.getSourceName().equals(attributeName) && !def.getObjectAttributeName().equals(attributeName)) continue;
                    relationship = def;
                    minKeys = 1;
                    continue block0;
                }
                continue;
            }
            if (def.getPrimitiveAttributes().size() >= minKeys) continue;
            for (PrimitiveAttributeDefinition primitive : def.getPrimitiveAttributes()) {
                if (!primitive.getSourceName().equals(attributeName) && !def.getObjectAttributeName().equals(attributeName)) continue;
                relationship = def;
                minKeys = def.getPrimitiveAttributes().size();
                continue block0;
            }
        }
        if (relationship == null) {
            for (RelationshipDefinition def : ddRelationships) {
                if (!def.hasIdentifier() || !def.getIdentifier().getSourceName().equals(attributeName)) continue;
                relationship = def;
            }
        }
        return relationship;
    }

    protected DataObjectRelationship populateRelationshipFromDictionaryReference(Class<?> dataObjectClass, RelationshipDefinition ddReference, String attributePrefix, boolean keysOnly) {
        DataObjectRelationship relationship = new DataObjectRelationship(dataObjectClass, ddReference.getObjectAttributeName(), ddReference.getTargetClass());
        for (PrimitiveAttributeDefinition primitiveAttributeDefinition : ddReference.getPrimitiveAttributes()) {
            if (StringUtils.isNotBlank((CharSequence)attributePrefix)) {
                relationship.getParentToChildReferences().put(attributePrefix + "." + primitiveAttributeDefinition.getSourceName(), primitiveAttributeDefinition.getTargetName());
                continue;
            }
            relationship.getParentToChildReferences().put(primitiveAttributeDefinition.getSourceName(), primitiveAttributeDefinition.getTargetName());
        }
        if (!keysOnly) {
            for (SupportAttributeDefinition supportAttributeDefinition : ddReference.getSupportAttributes()) {
                if (StringUtils.isNotBlank((CharSequence)attributePrefix)) {
                    relationship.getParentToChildReferences().put(attributePrefix + "." + supportAttributeDefinition.getSourceName(), supportAttributeDefinition.getTargetName());
                    if (!supportAttributeDefinition.isIdentifier()) continue;
                    relationship.setUserVisibleIdentifierKey(attributePrefix + "." + supportAttributeDefinition.getSourceName());
                    continue;
                }
                relationship.getParentToChildReferences().put(supportAttributeDefinition.getSourceName(), supportAttributeDefinition.getTargetName());
                if (!supportAttributeDefinition.isIdentifier()) continue;
                relationship.setUserVisibleIdentifierKey(supportAttributeDefinition.getSourceName());
            }
        }
        return relationship;
    }

    protected DataObjectRelationship getRelationshipMetadata(Class<?> dataObjectClass, String attributeName, String attributePrefix) {
        RelationshipDefinition relationshipDefinition = this.getDictionaryRelationship(dataObjectClass, attributeName);
        if (relationshipDefinition == null) {
            return null;
        }
        DataObjectRelationship dataObjectRelationship = new DataObjectRelationship(relationshipDefinition.getSourceClass(), relationshipDefinition.getObjectAttributeName(), relationshipDefinition.getTargetClass());
        if (!StringUtils.isEmpty((CharSequence)attributePrefix)) {
            attributePrefix = attributePrefix + ".";
        }
        List<PrimitiveAttributeDefinition> primitives = relationshipDefinition.getPrimitiveAttributes();
        for (PrimitiveAttributeDefinition primitiveAttributeDefinition : primitives) {
            dataObjectRelationship.getParentToChildReferences().put(attributePrefix + primitiveAttributeDefinition.getSourceName(), primitiveAttributeDefinition.getTargetName());
        }
        return dataObjectRelationship;
    }

    @Override
    public String getTitleAttribute(Class<?> dataObjectClass) {
        String titleAttribute = null;
        BusinessObjectEntry entry = this.getBusinessObjectEntry(dataObjectClass);
        if (entry != null) {
            titleAttribute = entry.getTitleAttribute();
        }
        return titleAttribute;
    }

    @Override
    public boolean areNotesSupported(Class<?> dataObjectClass) {
        boolean hasNotesSupport = false;
        BusinessObjectEntry entry = this.getBusinessObjectEntry(dataObjectClass);
        if (entry != null) {
            hasNotesSupport = entry.isBoNotesEnabled();
        }
        return hasNotesSupport;
    }

    @Override
    public String getDataObjectIdentifierString(Object dataObject) {
        String identifierString = "";
        if (dataObject == null) {
            identifierString = "Null";
            return identifierString;
        }
        Class<?> dataObjectClass = dataObject.getClass();
        if (PersistableBusinessObject.class.isAssignableFrom(dataObjectClass)) {
            String objectId = (String)ObjectPropertyUtils.getPropertyValue(dataObject, "objectId");
            if (StringUtils.isBlank((CharSequence)objectId)) {
                objectId = UUID.randomUUID().toString();
                ObjectPropertyUtils.setPropertyValue(dataObject, "objectId", objectId);
            }
            identifierString = objectId;
        } else {
            Map<String, ?> primaryKeyFieldValues = this.getPrimaryKeyFieldValues(dataObject, true);
            for (Map.Entry<String, ?> primaryKeyValue : primaryKeyFieldValues.entrySet()) {
                identifierString = primaryKeyValue.getValue() == null ? identifierString + "Null" : identifierString + primaryKeyValue.getValue();
                identifierString = identifierString + ":";
            }
            identifierString = StringUtils.removeEnd((String)identifierString, (String)":");
        }
        return identifierString;
    }

    @Override
    public List<DataObjectRelationship> getDataObjectRelationships(Class<?> dataObjectClass) {
        DataDictionaryEntry ddEntry;
        if (dataObjectClass == null) {
            return null;
        }
        Map<String, Class> referenceClasses = null;
        if (PersistableBusinessObject.class.isAssignableFrom(dataObjectClass) && this.getPersistenceStructureService().isPersistable(dataObjectClass)) {
            referenceClasses = this.getPersistenceStructureService().listReferenceObjectFields(dataObjectClass);
        }
        List<Object> ddRelationships = (ddEntry = this.getDataDictionaryService().getDataDictionary().getDictionaryObjectEntry(dataObjectClass.getName())) == null ? new ArrayList() : ddEntry.getRelationships();
        ArrayList<DataObjectRelationship> relationships = new ArrayList<DataObjectRelationship>();
        if (referenceClasses != null) {
            for (Map.Entry entry : referenceClasses.entrySet()) {
                Map fkToPkRefs = this.getPersistenceStructureService().getForeignKeysForReference(dataObjectClass, (String)entry.getKey());
                DataObjectRelationship rel = new DataObjectRelationship(dataObjectClass, (String)entry.getKey(), (Class)entry.getValue());
                for (Map.Entry ref : fkToPkRefs.entrySet()) {
                    rel.getParentToChildReferences().put((String)ref.getKey(), (String)ref.getValue());
                }
                relationships.add(rel);
            }
        }
        for (RelationshipDefinition relationshipDefinition : ddRelationships) {
            DataObjectRelationship rel = new DataObjectRelationship(dataObjectClass, relationshipDefinition.getObjectAttributeName(), relationshipDefinition.getTargetClass());
            for (PrimitiveAttributeDefinition def : relationshipDefinition.getPrimitiveAttributes()) {
                rel.getParentToChildReferences().put(def.getSourceName(), def.getTargetName());
            }
            relationships.add(rel);
        }
        return relationships;
    }

    protected BusinessObjectEntry getBusinessObjectEntry(Class businessObjectClass) {
        this.validateBusinessObjectClass(businessObjectClass);
        return this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(businessObjectClass.getName());
    }

    protected void validateBusinessObjectClass(Class businessObjectClass) {
        if (businessObjectClass == null) {
            throw new IllegalArgumentException("invalid (null) dataObjectClass");
        }
        if (!BusinessObject.class.isAssignableFrom(businessObjectClass)) {
            throw new IllegalArgumentException("class '" + businessObjectClass.getName() + "' is not a descendant of BusinessObject");
        }
    }

    protected DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    protected KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    protected PersistenceStructureService getPersistenceStructureService() {
        return this.persistenceStructureService;
    }

    public void setPersistenceStructureService(PersistenceStructureService persistenceStructureService) {
        this.persistenceStructureService = persistenceStructureService;
    }
}

