/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.service.impl;

import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.ReferenceByXPathMarshallingStrategy;
import com.thoughtworks.xstream.core.TreeMarshaller;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.path.PathTracker;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.service.SerializerService;
import org.kuali.kfs.krad.service.XmlObjectSerializerService;
import org.kuali.kfs.krad.util.DateTimeConverter;
import org.kuali.kfs.krad.util.documentserializer.AlwaysTruePropertySerializibilityEvaluator;
import org.kuali.kfs.krad.util.documentserializer.PropertySerializabilityEvaluator;
import org.kuali.kfs.krad.util.documentserializer.PropertyType;
import org.kuali.kfs.krad.util.documentserializer.SerializationState;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.AutoPopulatingList;

public abstract class SerializerServiceBase
implements SerializerService {
    protected PersistenceService persistenceService;
    protected XmlObjectSerializerService xmlObjectSerializerService;
    protected XStream xstream;
    protected ThreadLocal<PropertySerializabilityEvaluator> evaluators = new ThreadLocal();
    protected ThreadLocal<Map<String, SerializationState>> pathToSerializationState;
    protected ThreadLocal<PathTracker> currentPathTracker = new ThreadLocal();

    public SerializerServiceBase() {
        this.pathToSerializationState = new ThreadLocal();
        this.xstream = new XStream((ReflectionProvider)new ProxyAndStateAwareJavaReflectionProvider());
        this.xstream.setMarshallingStrategy((MarshallingStrategy)new PathTrackerSmugglingMarshallingStrategy(this.currentPathTracker));
        this.xstream.registerConverter((Converter)new ProxyConverter(this.xstream.getMapper(), this.xstream.getReflectionProvider()));
        try {
            Class<?> objListProxyClass = Class.forName("org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl");
            this.xstream.addDefaultImplementation(ArrayList.class, objListProxyClass);
            this.xstream.addDefaultImplementation(AutoPopulatingList.class, objListProxyClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.xstream.registerConverter((Converter)new AutoPopulatingListConverter(this.xstream.getMapper()));
        this.xstream.registerConverter((SingleValueConverter)new DateTimeConverter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> String doSerialization(PropertySerializabilityEvaluator evaluator, T object, Serializer<T> serializer) {
        try {
            this.evaluators.set(evaluator);
            this.pathToSerializationState.set(new HashMap());
            this.currentPathTracker.set(null);
            String string = serializer.serialize(object);
            return string;
        }
        finally {
            this.evaluators.set(null);
            this.pathToSerializationState.set(null);
            this.currentPathTracker.set(null);
        }
    }

    public String serializeBusinessObjectToXml(Object businessObject) {
        PropertySerializabilityEvaluator propertySerizabilityEvaluator = this.getPropertySerizabilityEvaluator(businessObject);
        return this.doSerialization(propertySerizabilityEvaluator, businessObject, object -> {
            String xml = propertySerizabilityEvaluator instanceof AlwaysTruePropertySerializibilityEvaluator ? this.getXmlObjectSerializerService().toXml(object) : this.xstream.toXML(object);
            return xml;
        });
    }

    protected boolean ignoreField(Field field) {
        return false;
    }

    protected abstract PropertySerializabilityEvaluator getPropertySerizabilityEvaluator(Object var1);

    protected PathTracker getCurrentPathTracker() {
        PathTracker pathTracker = this.currentPathTracker.get();
        if (pathTracker == null) {
            throw new IllegalStateException("No XStream PathTracker is bound to the current thread");
        }
        return pathTracker;
    }

    private String parseParentPath(String pathString) {
        int indexOfLastSlash = pathString.lastIndexOf("/");
        if (indexOfLastSlash == -1) {
            throw new IllegalArgumentException("Expected a path");
        }
        return pathString.substring(0, indexOfLastSlash);
    }

    private SerializationState determineSerializationState(String pathString) {
        if (this.pathToSerializationState.get().isEmpty()) {
            this.pathToSerializationState.get().put(pathString, new SerializationState());
        }
        return this.searchSerializationState(pathString, pathString);
    }

    private SerializationState searchSerializationState(String pathString, String originalPath) {
        if (StringUtils.isBlank((CharSequence)pathString)) {
            throw new IllegalStateException("Failed to find existing SerializationState for path: " + originalPath);
        }
        SerializationState state = this.pathToSerializationState.get().get(pathString);
        return state != null ? state : this.searchSerializationState(this.parseParentPath(pathString), originalPath);
    }

    private void registerSerializationStateForField(SerializationState state, String fieldName, PropertyType propertyType, String parentPath) {
        String path = parentPath + "/" + fieldName;
        if (this.pathToSerializationState.get().get(path) == null) {
            SerializationState newState = new SerializationState(state);
            newState.addSerializedProperty(fieldName, propertyType);
            this.pathToSerializationState.get().put(path, newState);
        }
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    protected XmlObjectSerializerService getXmlObjectSerializerService() {
        return this.xmlObjectSerializerService;
    }

    @Required
    public void setXmlObjectSerializerService(XmlObjectSerializerService xmlObjectSerializerService) {
        this.xmlObjectSerializerService = xmlObjectSerializerService;
    }

    private static class PathTrackerSmugglingMarshallingStrategy
    extends ReferenceByXPathMarshallingStrategy {
        private final ThreadLocal<PathTracker> pathTrackerThreadLocal;

        PathTrackerSmugglingMarshallingStrategy(ThreadLocal<PathTracker> pathTrackerThreadLocal) {
            super(ReferenceByXPathMarshallingStrategy.RELATIVE);
            this.pathTrackerThreadLocal = pathTrackerThreadLocal;
        }

        protected TreeMarshaller createMarshallingContext(HierarchicalStreamWriter writer, ConverterLookup converterLookup, Mapper mapper) {
            TreeMarshaller treeMarshaller = super.createMarshallingContext(writer, converterLookup, mapper);
            this.smugglePathTracker(treeMarshaller);
            return treeMarshaller;
        }

        private void smugglePathTracker(TreeMarshaller treeMarshaller) {
            try {
                PathTracker pathTracker = (PathTracker)FieldUtils.readField((Object)treeMarshaller, (String)"pathTracker", (boolean)true);
                if (pathTracker == null) {
                    throw new IllegalStateException("The pathTracker on xstream marshaller is null");
                }
                this.pathTrackerThreadLocal.set(pathTracker);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public class AutoPopulatingListConverter
    extends CollectionConverter {
        public AutoPopulatingListConverter(Mapper mapper) {
            super(mapper);
        }

        public boolean canConvert(Class clazz) {
            return clazz.equals(AutoPopulatingList.class);
        }
    }

    public class ProxyAndStateAwareJavaReflectionProvider
    extends PureJavaReflectionProvider {
        public void visitSerializableFields(Object object, ReflectionProvider.Visitor visitor) {
            PathTracker pathTracker = SerializerServiceBase.this.getCurrentPathTracker();
            PropertySerializabilityEvaluator evaluator = SerializerServiceBase.this.evaluators.get();
            String currentPath = pathTracker.getPath().toString();
            SerializationState state = SerializerServiceBase.this.determineSerializationState(currentPath);
            Iterator iterator = this.fieldDictionary.serializableFieldsFor(object.getClass());
            while (iterator.hasNext()) {
                Object value;
                Field field = (Field)iterator.next();
                if (!this.fieldModifiersSupported(field) || SerializerServiceBase.this.ignoreField(field)) continue;
                this.validateFieldAccess(field);
                this.initializeField(object, field);
                try {
                    value = field.get(object);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new ObjectAccessException("Could not get field " + field.getClass() + "." + field.getName(), (Throwable)e);
                }
                if (!evaluator.isPropertySerializable(state, object, field.getName(), value)) continue;
                if (value != null && ProxyHelper.isProxy((Object)value)) {
                    value = SerializerServiceBase.this.getPersistenceService().resolveProxy(value);
                }
                PropertyType propertyType = evaluator.determinePropertyType(value);
                SerializerServiceBase.this.registerSerializationStateForField(state, field.getName(), propertyType, currentPath);
                visitor.visit(field.getName(), field.getType(), field.getDeclaringClass(), value);
            }
        }

        protected void initializeField(Object object, Field field) {
        }
    }

    public class ProxyConverter
    extends ReflectionConverter {
        public ProxyConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
            super(mapper, reflectionProvider);
        }

        public boolean canConvert(Class clazz) {
            return clazz.getName().contains("CGLIB") || clazz.getName().equals("org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl");
        }

        public void marshal(Object obj, HierarchicalStreamWriter writer, MarshallingContext context) {
            if (obj.getClass().getName().equals("org.apache.ojb.broker.core.proxy.ListProxyDefaultImpl")) {
                List proxiedList = (List)obj;
                ArrayList copiedList = new ArrayList(proxiedList);
                context.convertAnother(copiedList);
            } else {
                super.marshal(SerializerServiceBase.this.getPersistenceService().resolveProxy(obj), writer, context);
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return null;
        }
    }

    protected static interface Serializer<T> {
        public String serialize(T var1);
    }
}

