/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.util.documentserializer;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.krad.util.documentserializer.PropertySerializabilityMetadata;

public class PropertySerializerTrieNode
implements PropertySerializabilityMetadata {
    private String pathString;
    private String propertyNameComponent;
    private PropertySerializabilityMetadata.PropertySerializability propertySerializability;
    private List<PropertySerializerTrieNode> childNodes;

    public PropertySerializerTrieNode(String pathString, String propertyNameComponent) {
        this.pathString = pathString;
        this.propertyNameComponent = propertyNameComponent;
        this.childNodes = null;
        this.propertySerializability = PropertySerializabilityMetadata.PropertySerializability.SERIALIZE_OBJECT;
    }

    public void addChildNode(PropertySerializerTrieNode child) {
        if (this.childNodes == null) {
            this.childNodes = new ArrayList<PropertySerializerTrieNode>();
        }
        this.childNodes.add(child);
    }

    public String getPropertyNameComponent() {
        return this.propertyNameComponent;
    }

    public PropertySerializerTrieNode getChildNode(String propertyNameComponent) {
        if (this.childNodes == null) {
            return null;
        }
        for (PropertySerializerTrieNode childNode : this.childNodes) {
            if (!childNode.getPropertyNameComponent().equals(propertyNameComponent)) continue;
            return childNode;
        }
        return null;
    }

    @Override
    public PropertySerializabilityMetadata getSerializableChildProperty(String propertyNameComponent) {
        return this.getChildNode(propertyNameComponent);
    }

    @Override
    public String getPathString() {
        return this.pathString;
    }

    @Override
    public PropertySerializabilityMetadata.PropertySerializability getPropertySerializability() {
        return this.propertySerializability;
    }

    public void setPropertySerializabilityToObjectAndAllPrimitives() {
        this.propertySerializability = PropertySerializabilityMetadata.PropertySerializability.SERIALIZE_OBJECT_AND_ALL_PRIMITIVES;
    }
}

