/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.krad.workflow.attribute;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.role.QualifierResolver;

public abstract class QualifierResolverBase
implements QualifierResolver {
    private static final Logger LOG = LogManager.getLogger(QualifierResolverBase.class);
    protected static final String KIM_ATTRIBUTE_DOCUMENT_TYPE_NAME = "documentTypeName";
    protected static final String KIM_ATTRIBUTE_DOCUMENT_NUMBER = "documentNumber";
    protected static final String KIM_ATTRIBUTE_ROUTE_LEVEL_NAME = "routeNodeName";
    private static DocumentService documentService;

    protected Document getDocument(RouteContext context) {
        String documentID = this.getDocumentId(context);
        if (documentID != null) {
            try {
                return this.getDocumentService().getByDocumentHeaderIdSessionless(documentID);
            }
            catch (WorkflowException e) {
                LOG.error("Unable to retrieve document with system user.", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    protected String getDocumentId(RouteContext context) {
        return context.getNodeInstance().getDocumentId();
    }

    public DocumentService getDocumentService() {
        if (documentService == null) {
            documentService = KRADServiceLocatorWeb.getDocumentService();
        }
        return documentService;
    }

    protected void decorateWithCommonQualifiers(List<Map<String, String>> qualifiers, RouteContext context, String customDocTypeName) {
        for (Map<String, String> qualifier : qualifiers) {
            this.addCommonQualifiersToMap(qualifier, context, customDocTypeName);
        }
    }

    protected void addCommonQualifiersToMap(Map<String, String> qualifier, RouteContext context, String customDocTypeName) {
        qualifier.put(KIM_ATTRIBUTE_DOCUMENT_NUMBER, context.getDocument().getDocumentId());
        if (!qualifier.containsKey(KIM_ATTRIBUTE_DOCUMENT_TYPE_NAME)) {
            if (StringUtils.isBlank((CharSequence)customDocTypeName)) {
                qualifier.put(KIM_ATTRIBUTE_DOCUMENT_TYPE_NAME, context.getDocument().getDocumentType().getName());
            } else {
                qualifier.put(KIM_ATTRIBUTE_DOCUMENT_TYPE_NAME, customDocTypeName);
            }
        }
        qualifier.put(KIM_ATTRIBUTE_ROUTE_LEVEL_NAME, context.getNodeInstance().getName());
    }
}

