/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.web.struts;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.kuali.kfs.gl.businessobject.CorrectionChangeGroup;
import org.kuali.kfs.gl.businessobject.CorrectionCriteria;
import org.kuali.kfs.gl.businessobject.OriginEntryFull;
import org.kuali.kfs.gl.document.GeneralLedgerCorrectionProcessDocument;
import org.kuali.kfs.gl.document.authorization.CorrectionDocumentAuthorizer;
import org.kuali.kfs.gl.document.service.CorrectionDocumentService;
import org.kuali.kfs.gl.document.web.CorrectionDocumentEntryMetadata;
import org.kuali.kfs.gl.document.web.struts.GeneralLedgerCorrectionProcessAction;
import org.kuali.kfs.gl.document.web.struts.GeneralLedgerCorrectionProcessForm;
import org.kuali.kfs.gl.service.GlCorrectionProcessOriginEntryService;
import org.kuali.kfs.gl.service.OriginEntryGroupService;
import org.kuali.kfs.gl.service.OriginEntryService;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.kns.web.struts.form.KualiTableRenderFormMetadata;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.businessobject.options.CorrectionLaborGroupEntriesFinder;
import org.kuali.kfs.module.ld.businessobject.options.LaborOriginEntryFieldFinder;
import org.kuali.kfs.module.ld.document.LaborCorrectionDocument;
import org.kuali.kfs.module.ld.document.service.LaborCorrectionDocumentService;
import org.kuali.kfs.module.ld.document.web.struts.LaborCorrectionForm;
import org.kuali.kfs.module.ld.service.LaborOriginEntryGroupService;
import org.kuali.kfs.module.ld.service.LaborOriginEntryService;
import org.kuali.kfs.module.ld.util.CorrectionDocumentUtils;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.api.WorkflowDocument;

public class LaborCorrectionAction
extends GeneralLedgerCorrectionProcessAction {
    LaborOriginEntryService laborOriginEntryService = (LaborOriginEntryService)SpringContext.getBean(LaborOriginEntryService.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"execute() started");
        GeneralLedgerCorrectionProcessForm generalLedgerCorrectionProcessForm = (GeneralLedgerCorrectionProcessForm)form;
        if (originEntryGroupService == null) {
            GeneralLedgerCorrectionProcessAction.originEntryGroupService = (OriginEntryGroupService)SpringContext.getBean(LaborOriginEntryGroupService.class);
            GeneralLedgerCorrectionProcessAction.originEntryService = (OriginEntryService)SpringContext.getBean(OriginEntryService.class);
            GeneralLedgerCorrectionProcessAction.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
            GeneralLedgerCorrectionProcessAction.kualiConfigurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        }
        LaborCorrectionForm rForm = (LaborCorrectionForm)form;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("execute() methodToCall: " + rForm.getMethodToCall()));
        }
        Object persistedOriginEntries = null;
        if (!"docHandler".equals(rForm.getMethodToCall()) && !"reload".equals(rForm.getMethodToCall())) {
            this.restoreSystemAndEditMethod(rForm);
            this.restoreInputGroupSelectionForDatabaseEdits(rForm);
            if (!rForm.isRestrictedFunctionalityMode() && StringUtils.isNotBlank((String)rForm.getGlcpSearchResultsSequenceNumber())) {
                rForm.setAllEntries(((GlCorrectionProcessOriginEntryService)SpringContext.getBean(GlCorrectionProcessOriginEntryService.class)).retrieveAllEntries(rForm.getGlcpSearchResultsSequenceNumber()));
                if (rForm.getAllEntries() == null) {
                    rForm.setDisplayEntries(null);
                } else {
                    rForm.setDisplayEntries(new ArrayList(rForm.getAllEntries()));
                }
                if (!"showOutputGroup".equals(rForm.getMethodToCall()) && rForm.getShowOutputFlag()) {
                    LaborCorrectionDocument document = rForm.getLaborCorrectionDocument();
                    List groups = document.getCorrectionChangeGroup();
                    this.updateEntriesFromCriteria(rForm, rForm.isRestrictedFunctionalityMode());
                }
                if (!"sort".equals(rForm.getMethodToCall())) {
                    KualiTableRenderFormMetadata originEntrySearchResultTableMetadata = rForm.getOriginEntrySearchResultTableMetadata();
                    if (originEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex() != -1) {
                        List<Column> columns = ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).getTableRenderColumnMetadata(rForm.getDocument().getDocumentNumber());
                        String propertyToSortName = columns.get(originEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex()).getPropertyName();
                        Comparator valueComparator = columns.get(originEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex()).getValueComparator();
                        this.sortList(rForm.getDisplayEntries(), propertyToSortName, valueComparator, originEntrySearchResultTableMetadata.isSortDescending());
                    }
                    if (rForm.getAllEntries() != null) {
                        int maxRowsPerPage = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordsPerPage();
                        originEntrySearchResultTableMetadata.jumpToPage(originEntrySearchResultTableMetadata.getViewedPageNumber(), rForm.getDisplayEntries().size(), maxRowsPerPage);
                        originEntrySearchResultTableMetadata.setColumnToSortIndex(originEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex());
                    }
                }
            }
        }
        ActionForward af = super.superExecute(mapping, form, request, response);
        return af;
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"save() started");
        LaborCorrectionForm laborCorrectionForm = (LaborCorrectionForm)form;
        LaborCorrectionDocument document = laborCorrectionForm.getLaborCorrectionDocument();
        if (!this.checkMainDropdown(laborCorrectionForm)) {
            return mapping.findForward("basic");
        }
        if (!this.checkRestrictedFunctionalityModeForManualEdit(laborCorrectionForm)) {
            return mapping.findForward("basic");
        }
        if (!this.validGroupsItemsForDocumentSave(laborCorrectionForm)) {
            return mapping.findForward("basic");
        }
        if (!this.validChangeGroups(laborCorrectionForm)) {
            return mapping.findForward("basic");
        }
        if (!this.checkInputGroupPersistedForDocumentSave(laborCorrectionForm)) {
            return mapping.findForward("basic");
        }
        document.setCorrectionTypeCode(laborCorrectionForm.getEditMethod());
        document.setCorrectionSelection(laborCorrectionForm.getMatchCriteriaOnly());
        document.setCorrectionFileDelete(!laborCorrectionForm.getProcessInBatch());
        document.setCorrectionInputFileName(laborCorrectionForm.getInputGroupId());
        document.setCorrectionOutputFileName(null);
        if (laborCorrectionForm.getDataLoadedFlag() || laborCorrectionForm.isRestrictedFunctionalityMode()) {
            document.setCorrectionInputFileName(laborCorrectionForm.getInputGroupId());
        } else {
            document.setCorrectionInputFileName(null);
        }
        document.setCorrectionOutputFileName(null);
        ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).persistOriginEntryGroupsForDocumentSave(document, (CorrectionDocumentEntryMetadata)laborCorrectionForm);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("save() doc type name: " + laborCorrectionForm.getDocTypeName()));
        }
        ActionForward af = super.superSave(mapping, form, request, response);
        return af;
    }

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"docHandler() started");
        LaborCorrectionForm laborCorrectionForm = (LaborCorrectionForm)form;
        String command = laborCorrectionForm.getCommand();
        if ("initiate".equals(command)) {
            laborCorrectionForm.clearForm();
            this.createDocument((KualiDocumentFormBase)laborCorrectionForm);
        } else {
            this.loadDocument((KualiDocumentFormBase)laborCorrectionForm);
            LaborCorrectionDocument laborDocument = laborCorrectionForm.getLaborCorrectionDocument();
            laborCorrectionForm.setInputGroupIdFromLastDocumentLoad(laborDocument.getCorrectionInputFileName());
            this.populateAuthorizationFields((KualiDocumentFormBase)laborCorrectionForm);
            Map documentActions = laborCorrectionForm.getDocumentActions();
            if (documentActions.containsKey("canEdit")) {
                laborCorrectionForm.setProcessInBatch(!laborDocument.getCorrectionFileDelete());
                laborCorrectionForm.setMatchCriteriaOnly(laborDocument.getCorrectionSelection());
                laborCorrectionForm.setEditMethod(laborDocument.getCorrectionTypeCode());
                if (laborDocument.getCorrectionInputFileName() != null) {
                    if ("C".equals(laborDocument.getCorrectionTypeCode())) {
                        this.loadPersistedInputGroup(laborCorrectionForm);
                        laborCorrectionForm.setDeleteFileFlag(false);
                    } else if ("M".equals(laborDocument.getCorrectionTypeCode())) {
                        this.loadPersistedOutputGroup(laborCorrectionForm, true);
                        laborCorrectionForm.setManualEditFlag(true);
                        laborCorrectionForm.setEditableFlag(false);
                        laborCorrectionForm.setDeleteFileFlag(false);
                    } else if ("R".equals(laborDocument.getCorrectionTypeCode())) {
                        this.loadPersistedInputGroup(laborCorrectionForm);
                        laborCorrectionForm.setDeleteFileFlag(true);
                    } else {
                        throw new RuntimeException("Unknown edit method " + laborDocument.getCorrectionTypeCode());
                    }
                    laborCorrectionForm.setDataLoadedFlag(true);
                } else {
                    laborCorrectionForm.setDataLoadedFlag(false);
                }
                laborCorrectionForm.setShowOutputFlag(documentActions.containsKey("canApprove"));
                if (laborCorrectionForm.getShowOutputFlag() && !laborCorrectionForm.isRestrictedFunctionalityMode()) {
                    this.updateEntriesFromCriteria(laborCorrectionForm, false);
                }
                laborCorrectionForm.setInputFileName(laborDocument.getCorrectionInputFileName());
                if (laborDocument.getCorrectionInputFileName() != null) {
                    laborCorrectionForm.setChooseSystem("U");
                } else {
                    laborCorrectionForm.setChooseSystem("D");
                }
                laborCorrectionForm.setPreviousChooseSystem(laborCorrectionForm.getChooseSystem());
                laborCorrectionForm.setPreviousEditMethod(laborCorrectionForm.getEditMethod());
                laborCorrectionForm.setPreviousInputGroupId(laborCorrectionForm.getInputGroupId());
            } else {
                laborCorrectionForm.setProcessInBatch(!laborDocument.getCorrectionFileDelete());
                laborCorrectionForm.setMatchCriteriaOnly(laborDocument.getCorrectionSelection());
                this.loadPersistedOutputGroup(laborCorrectionForm, false);
                laborCorrectionForm.setShowOutputFlag(true);
            }
            laborCorrectionForm.setInputGroupIdFromLastDocumentLoadIsMissing(!originEntryGroupService.getGroupExists(laborDocument.getCorrectionInputFileName()));
        }
        return mapping.findForward("basic");
    }

    public ActionForward uploadFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FileNotFoundException, IOException, Exception {
        String stringLine;
        PrintStream uploadedFilePrintStream;
        LOG.debug((Object)"uploadFile() started");
        LaborCorrectionForm laborCorrectionForm = (LaborCorrectionForm)form;
        LaborCorrectionDocument document = laborCorrectionForm.getLaborCorrectionDocument();
        Date now = GeneralLedgerCorrectionProcessAction.dateTimeService.getCurrentDate();
        FormFile sourceFile = laborCorrectionForm.getSourceFile();
        String llcpDirectory = ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).getLlcpDirectoryName();
        String fullFileName = llcpDirectory + File.separator + sourceFile.getFileName() + "-" + GeneralLedgerCorrectionProcessAction.dateTimeService.toDateTimeStringForFilename(now);
        BufferedReader br = new BufferedReader(new InputStreamReader(sourceFile.getInputStream()));
        File uploadedFile = new File(fullFileName);
        try {
            uploadedFilePrintStream = new PrintStream(uploadedFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int loadedCount = 0;
        while ((stringLine = br.readLine()) != null) {
            try {
                uploadedFilePrintStream.printf("%s\n", stringLine);
                ++loadedCount;
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }
        uploadedFilePrintStream.close();
        int recordCountFunctionalityLimit = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordCountFunctionalityLimit();
        if (org.kuali.kfs.gl.document.CorrectionDocumentUtils.isRestrictedFunctionalityMode((int)loadedCount, (int)recordCountFunctionalityLimit)) {
            laborCorrectionForm.setRestrictedFunctionalityMode(true);
            laborCorrectionForm.setDataLoadedFlag(false);
            document.setCorrectionInputFileName(fullFileName);
            laborCorrectionForm.setInputFileName(fullFileName);
            if ("M".equals(laborCorrectionForm.getEditMethod())) {
                if (recordCountFunctionalityLimit == 0) {
                    GlobalVariables.getMessageMap().putError("systemAndEditMethod", "error.gl.correction.unable.to.manual.edit.any.group", new String[0]);
                } else {
                    GlobalVariables.getMessageMap().putError("systemAndEditMethod", "error.gl.correction.unable.to.manual.edit.large.group", new String[]{String.valueOf(recordCountFunctionalityLimit)});
                }
            }
        } else {
            laborCorrectionForm.setRestrictedFunctionalityMode(false);
            if (loadedCount > 0) {
                ArrayList<LaborOriginEntry> originEntryList = new ArrayList<LaborOriginEntry>();
                Map loadMessageMap = this.laborOriginEntryService.getEntriesByGroupIdWithPath(uploadedFile.getAbsolutePath(), originEntryList);
                if (loadMessageMap.size() > 0) {
                    for (Integer lineNumber : loadMessageMap.keySet()) {
                        List messageList = (List)loadMessageMap.get(lineNumber);
                        if (messageList.size() <= 0) continue;
                        for (Message errorMmessage : messageList) {
                            GlobalVariables.getMessageMap().putError("fileUpload", "error.gl.InvalidFormatOriginEntryFromTextFile", new String[]{lineNumber.toString(), errorMmessage.toString()});
                        }
                    }
                    return mapping.findForward("basic");
                }
                laborCorrectionForm.setDataLoadedFlag(true);
                laborCorrectionForm.setInputFileName(fullFileName);
                document.setCorrectionInputFileName(fullFileName);
                ArrayList<LaborOriginEntry> originEntryFullList = new ArrayList<LaborOriginEntry>();
                originEntryFullList.addAll(originEntryList);
                this.loadAllEntries(originEntryFullList, laborCorrectionForm);
                if ("M".equals(laborCorrectionForm.getEditMethod())) {
                    laborCorrectionForm.setEditableFlag(false);
                    laborCorrectionForm.setManualEditFlag(true);
                }
            } else {
                GlobalVariables.getMessageMap().putError("fileUpload", "error.gl.correction.norecords", new String[0]);
            }
        }
        if (document.getCorrectionChangeGroup().isEmpty()) {
            document.addCorrectionChangeGroup(new CorrectionChangeGroup());
        }
        return mapping.findForward("basic");
    }

    protected void loadAllEntries(String fileNameWithPath, LaborCorrectionForm laborCorrectionForm) {
        block6: {
            LOG.debug((Object)"loadAllEntries() started");
            LaborCorrectionDocument document = laborCorrectionForm.getLaborCorrectionDocument();
            if (laborCorrectionForm.isRestrictedFunctionalityMode()) break block6;
            ArrayList<LaborOriginEntry> laborSearchResults = new ArrayList<LaborOriginEntry>();
            Map loadMessageMap = this.laborOriginEntryService.getEntriesByGroupIdWithPath(fileNameWithPath, laborSearchResults);
            ArrayList<LaborOriginEntry> searchResults = new ArrayList<LaborOriginEntry>();
            searchResults.addAll(laborSearchResults);
            if (loadMessageMap.size() > 0) {
                for (Integer lineNumber : loadMessageMap.keySet()) {
                    List messageList = (List)loadMessageMap.get(lineNumber);
                    for (Message errorMmessage : messageList) {
                        GlobalVariables.getMessageMap().putError("fileUpload", "error.gl.InvalidFormatOriginEntryFromTextFile", new String[]{lineNumber.toString(), errorMmessage.toString()});
                    }
                }
            } else {
                try {
                    this.loadAllEntries(searchResults, laborCorrectionForm);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public ActionForward saveManualEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"saveManualEdit() started");
        LaborCorrectionForm laborCorrectionForm = (LaborCorrectionForm)form;
        LaborCorrectionDocument document = laborCorrectionForm.getLaborCorrectionDocument();
        if (this.validLaborOriginEntry(laborCorrectionForm)) {
            int entryId = laborCorrectionForm.getLaborEntryForManualEdit().getEntryId();
            Iterator iter = laborCorrectionForm.getAllEntries().iterator();
            while (iter.hasNext()) {
                OriginEntryFull element = (OriginEntryFull)iter.next();
                if (element.getEntryId() != entryId) continue;
                iter.remove();
            }
            laborCorrectionForm.updateLaborEntryForManualEdit();
            laborCorrectionForm.getAllEntries().add(laborCorrectionForm.getLaborEntryForManualEdit());
            ((GlCorrectionProcessOriginEntryService)SpringContext.getBean(GlCorrectionProcessOriginEntryService.class)).persistAllEntries(laborCorrectionForm.getGlcpSearchResultsSequenceNumber(), laborCorrectionForm.getAllEntries());
            laborCorrectionForm.setDisplayEntries(laborCorrectionForm.getAllEntries());
            if (laborCorrectionForm.getShowOutputFlag()) {
                this.removeNonMatchingEntries(laborCorrectionForm.getDisplayEntries(), document.getCorrectionChangeGroup());
            }
            laborCorrectionForm.clearLaborEntryForManualEdit();
        }
        this.updateDocumentSummary(document, laborCorrectionForm.getAllEntries(), laborCorrectionForm.isRestrictedFunctionalityMode());
        this.applyPagingAndSortingFromPreviousPageView(laborCorrectionForm);
        return mapping.findForward("basic");
    }

    public ActionForward addManualEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"addManualEdit() started");
        LaborCorrectionForm laborCorrectionForm = (LaborCorrectionForm)form;
        LaborCorrectionDocument document = laborCorrectionForm.getLaborCorrectionDocument();
        if (this.validLaborOriginEntry(laborCorrectionForm)) {
            laborCorrectionForm.updateLaborEntryForManualEdit();
            int newEntryId = this.getMaxEntryId(laborCorrectionForm.getAllEntries()) + 1;
            laborCorrectionForm.getEntryForManualEdit().setEntryId(new Integer(newEntryId));
            laborCorrectionForm.getAllEntries().add(laborCorrectionForm.getLaborEntryForManualEdit());
            laborCorrectionForm.clearLaborEntryForManualEdit();
        }
        this.updateDocumentSummary(document, laborCorrectionForm.getAllEntries(), laborCorrectionForm.isRestrictedFunctionalityMode());
        laborCorrectionForm.setShowSummaryOutputFlag(true);
        ((GlCorrectionProcessOriginEntryService)SpringContext.getBean(GlCorrectionProcessOriginEntryService.class)).persistAllEntries(laborCorrectionForm.getGlcpSearchResultsSequenceNumber(), laborCorrectionForm.getAllEntries());
        laborCorrectionForm.setDisplayEntries(new ArrayList(laborCorrectionForm.getAllEntries()));
        if (laborCorrectionForm.getShowOutputFlag()) {
            this.removeNonMatchingEntries(laborCorrectionForm.getDisplayEntries(), document.getCorrectionChangeGroup());
        }
        this.applyPagingAndSortingFromPreviousPageView(laborCorrectionForm);
        return mapping.findForward("basic");
    }

    public ActionForward manualEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        LaborCorrectionForm laborCorrectionForm = (LaborCorrectionForm)form;
        LaborCorrectionDocument document = laborCorrectionForm.getLaborCorrectionDocument();
        laborCorrectionForm.clearLaborEntryForManualEdit();
        laborCorrectionForm.clearEntryForManualEdit();
        laborCorrectionForm.setEditableFlag(true);
        laborCorrectionForm.setManualEditFlag(false);
        if (document.getCorrectionChangeGroup().isEmpty()) {
            document.addCorrectionChangeGroup(new CorrectionChangeGroup());
        }
        return mapping.findForward("basic");
    }

    public ActionForward editManualEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"editManualEdit() started");
        LaborCorrectionForm laborCorrectionForm = (LaborCorrectionForm)form;
        LaborCorrectionDocument document = laborCorrectionForm.getLaborCorrectionDocument();
        int entryId = Integer.parseInt(this.getImageContext(request, "entryId"));
        for (LaborOriginEntry element : laborCorrectionForm.getAllEntries()) {
            if (element.getEntryId() != entryId) continue;
            laborCorrectionForm.setLaborEntryForManualEdit(element);
            laborCorrectionForm.setLaborEntryFinancialDocumentReversalDate(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getFinancialDocumentReversalDate(), (String)"Date"));
            laborCorrectionForm.setLaborEntryTransactionDate(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getTransactionDate(), (String)"Date"));
            laborCorrectionForm.setLaborEntryTransactionLedgerEntryAmount(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getTransactionLedgerEntryAmount(), (String)"KualiDecimal"));
            laborCorrectionForm.setLaborEntryTransactionLedgerEntrySequenceNumber(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getTransactionLedgerEntrySequenceNumber(), (String)"Integer"));
            laborCorrectionForm.setLaborEntryUniversityFiscalYear(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getUniversityFiscalYear(), (String)"Integer"));
            laborCorrectionForm.setLaborEntryTransactionPostingDate(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getTransactionPostingDate(), (String)"Date"));
            laborCorrectionForm.setLaborEntryPayPeriodEndDate(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getPayPeriodEndDate(), (String)"Date"));
            laborCorrectionForm.setLaborEntryTransactionTotalHours(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getTransactionTotalHours(), (String)"BigDecimal"));
            laborCorrectionForm.setLaborEntryPayrollEndDateFiscalYear(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getPayrollEndDateFiscalYear(), (String)"Integer"));
            laborCorrectionForm.setLaborEntryEmployeeRecord(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getEmployeeRecord(), (String)"Integer"));
            break;
        }
        laborCorrectionForm.setShowSummaryOutputFlag(true);
        return mapping.findForward("basic");
    }

    protected boolean validLaborOriginEntry(LaborCorrectionForm laborCorrectionForm) {
        LOG.debug((Object)"validOriginEntry() started");
        LaborOriginEntry oe = laborCorrectionForm.getLaborEntryForManualEdit();
        boolean valid = true;
        LaborOriginEntryFieldFinder loeff = new LaborOriginEntryFieldFinder();
        List fields = loeff.getKeyValues();
        for (KeyValue lkp : fields) {
            String fieldName = lkp.getKey();
            String fieldDisplayName = lkp.getValue();
            String fieldType = loeff.getFieldType(fieldName);
            int fieldLength = loeff.getFieldLength(fieldName);
            String fieldValue = null;
            if ("String".equals(fieldType)) {
                fieldValue = (String)oe.getFieldValue(fieldName);
            } else if ("financialDocumentReversalDate".equals(fieldName)) {
                fieldValue = laborCorrectionForm.getLaborEntryFinancialDocumentReversalDate();
            } else if ("transactionDate".equals(fieldName)) {
                fieldValue = laborCorrectionForm.getLaborEntryTransactionDate();
            } else if ("transactionLedgerEntrySequenceNumber".equals(fieldName)) {
                fieldValue = laborCorrectionForm.getLaborEntryTransactionLedgerEntrySequenceNumber();
            } else if ("transactionLedgerEntryAmount".equals(fieldName)) {
                fieldValue = laborCorrectionForm.getLaborEntryTransactionLedgerEntryAmount();
            } else if ("universityFiscalYear".equals(fieldName)) {
                fieldValue = laborCorrectionForm.getLaborEntryUniversityFiscalYear();
            } else if ("transactionPostingDate".equals(fieldName)) {
                fieldValue = laborCorrectionForm.getLaborEntryTransactionPostingDate();
            } else if ("payPeriodEndDate".equals(fieldName)) {
                fieldValue = laborCorrectionForm.getLaborEntryPayPeriodEndDate();
            } else if ("transactionTotalHours".equals(fieldName)) {
                fieldValue = laborCorrectionForm.getLaborEntryTransactionTotalHours();
            } else if ("payrollEndDateFiscalYear".equals(fieldName)) {
                fieldValue = laborCorrectionForm.getLaborEntryPayrollEndDateFiscalYear();
            } else if ("employeeRecord".equals(fieldName)) {
                fieldValue = laborCorrectionForm.getLaborEntryEmployeeRecord();
            }
            if (!StringUtils.isEmpty((String)fieldValue)) {
                if (loeff.isValidValue(fieldName, fieldValue)) continue;
                GlobalVariables.getMessageMap().putError("searchResults", "error.gl.correction.invalid.value", new String[]{fieldDisplayName, fieldValue});
                valid = false;
                continue;
            }
            if (loeff.allowNull(fieldName)) continue;
            GlobalVariables.getMessageMap().putError("searchResults", "error.gl.correction.invalid.value", new String[]{fieldDisplayName, fieldValue});
            valid = false;
        }
        return valid;
    }

    protected void removeNonMatchingEntries(Collection<OriginEntryFull> entries, Collection<CorrectionChangeGroup> groups) {
        Iterator<OriginEntryFull> loei = entries.iterator();
        while (loei.hasNext()) {
            OriginEntryFull oe = loei.next();
            if (CorrectionDocumentUtils.doesLaborEntryMatchAnyCriteriaGroups(oe, groups)) continue;
            loei.remove();
        }
    }

    protected boolean validChangeGroups(GeneralLedgerCorrectionProcessForm generalLedgerCorrectionProcessForm) {
        LOG.debug((Object)"validChangeGroups() started");
        LaborCorrectionForm form = (LaborCorrectionForm)generalLedgerCorrectionProcessForm;
        LaborCorrectionDocument doc = form.getLaborCorrectionDocument();
        String tab = "";
        tab = "C".equals(form.getEditMethod()) ? "editCriteria" : "manualEditCriteria";
        boolean allValid = true;
        LaborOriginEntryFieldFinder loeff = new LaborOriginEntryFieldFinder();
        List fields = loeff.getKeyValues();
        List l = doc.getCorrectionChangeGroup();
        for (CorrectionChangeGroup ccg : l) {
            for (CorrectionCriteria cc : ccg.getCorrectionCriteria()) {
                if (loeff.isValidValue(cc.getCorrectionFieldName(), cc.getCorrectionFieldValue())) continue;
                GlobalVariables.getMessageMap().putError(tab, "error.gl.correction.invalid.value", new String[]{loeff.getFieldDisplayName(cc.getCorrectionFieldName()), cc.getCorrectionFieldValue()});
                allValid = false;
            }
            for (CorrectionCriteria cc : ccg.getCorrectionChange()) {
                if (loeff.isValidValue(cc.getCorrectionFieldName(), cc.getCorrectionFieldValue())) continue;
                GlobalVariables.getMessageMap().putError(tab, "error.gl.correction.invalid.value", new String[]{loeff.getFieldDisplayName(cc.getCorrectionFieldName()), cc.getCorrectionFieldValue()});
                allValid = false;
            }
        }
        return allValid;
    }

    protected void loadPersistedInputGroup(GeneralLedgerCorrectionProcessForm generalLedgerCorrectionProcessForm) throws Exception {
        LaborCorrectionForm laborCorrectionForm = (LaborCorrectionForm)generalLedgerCorrectionProcessForm;
        LaborCorrectionDocument document = laborCorrectionForm.getLaborCorrectionDocument();
        int recordCountFunctionalityLimit = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordCountFunctionalityLimit();
        LaborCorrectionDocumentService laborCorrectionDocumentService = (LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class);
        if (!laborCorrectionDocumentService.areInputOriginEntriesPersisted(document)) {
            laborCorrectionForm.setPersistedOriginEntriesMissing(true);
            laborCorrectionForm.setRestrictedFunctionalityMode(true);
            return;
        }
        laborCorrectionForm.setPersistedOriginEntriesMissing(false);
        List<LaborOriginEntry> laborSearchResults = laborCorrectionDocumentService.retrievePersistedInputOriginEntries(document, recordCountFunctionalityLimit);
        if (laborSearchResults == null) {
            laborCorrectionForm.setRestrictedFunctionalityMode(true);
            this.updateDocumentSummary(document, null, true);
        } else {
            ArrayList<LaborOriginEntry> searchResults = new ArrayList<LaborOriginEntry>();
            searchResults.addAll(laborSearchResults);
            laborCorrectionForm.setAllEntries(searchResults);
            laborCorrectionForm.setDisplayEntries(new ArrayList(searchResults));
            this.updateDocumentSummary(document, laborCorrectionForm.getAllEntries(), false);
            SequenceAccessorService sequenceAccessorService = (SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class);
            String glcpSearchResultsSequenceNumber = String.valueOf(sequenceAccessorService.getNextAvailableSequenceNumber("KRNS_LOOKUP_RSLT_S"));
            ((GlCorrectionProcessOriginEntryService)SpringContext.getBean(GlCorrectionProcessOriginEntryService.class)).persistAllEntries(glcpSearchResultsSequenceNumber, searchResults);
            laborCorrectionForm.setGlcpSearchResultsSequenceNumber(glcpSearchResultsSequenceNumber);
            int maxRowsPerPage = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordsPerPage();
            KualiTableRenderFormMetadata originEntrySearchResultTableMetadata = laborCorrectionForm.getOriginEntrySearchResultTableMetadata();
            originEntrySearchResultTableMetadata.jumpToFirstPage(laborCorrectionForm.getDisplayEntries().size(), maxRowsPerPage);
            originEntrySearchResultTableMetadata.setColumnToSortIndex(-1);
        }
    }

    protected void loadPersistedOutputGroup(GeneralLedgerCorrectionProcessForm generalLedgerCorrectionProcessForm, boolean setSequentialIds) throws Exception {
        LaborCorrectionForm laborCorrectionForm = (LaborCorrectionForm)generalLedgerCorrectionProcessForm;
        LaborCorrectionDocument document = laborCorrectionForm.getLaborCorrectionDocument();
        LaborCorrectionDocumentService laborCorrectionDocumentService = (LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class);
        if (!laborCorrectionDocumentService.areOutputOriginEntriesPersisted(document)) {
            laborCorrectionForm.setPersistedOriginEntriesMissing(true);
            laborCorrectionForm.setRestrictedFunctionalityMode(true);
            return;
        }
        laborCorrectionForm.setPersistedOriginEntriesMissing(false);
        int recordCountFunctionalityLimit = "M".equals(laborCorrectionForm.getEditMethod()) ? -1 : org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordCountFunctionalityLimit();
        List<LaborOriginEntry> laborSearchResults = laborCorrectionDocumentService.retrievePersistedOutputOriginEntries(document, recordCountFunctionalityLimit);
        if (laborSearchResults == null) {
            laborCorrectionForm.setRestrictedFunctionalityMode(true);
            WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
            CorrectionDocumentAuthorizer correctionDocumentAuthorizer = new CorrectionDocumentAuthorizer();
        } else {
            ArrayList<LaborOriginEntry> searchResults = new ArrayList<LaborOriginEntry>();
            searchResults.addAll(laborSearchResults);
            laborCorrectionForm.setAllEntries(searchResults);
            laborCorrectionForm.setDisplayEntries(new ArrayList(searchResults));
            if (setSequentialIds) {
                org.kuali.kfs.gl.document.CorrectionDocumentUtils.setSequentialEntryIds((Collection)laborCorrectionForm.getAllEntries());
            }
            this.updateDocumentSummary(document, laborCorrectionForm.getAllEntries(), false);
            SequenceAccessorService sequenceAccessorService = (SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class);
            String glcpSearchResultsSequenceNumber = String.valueOf(sequenceAccessorService.getNextAvailableSequenceNumber("KRNS_LOOKUP_RSLT_S"));
            ((GlCorrectionProcessOriginEntryService)SpringContext.getBean(GlCorrectionProcessOriginEntryService.class)).persistAllEntries(glcpSearchResultsSequenceNumber, searchResults);
            laborCorrectionForm.setGlcpSearchResultsSequenceNumber(glcpSearchResultsSequenceNumber);
            int maxRowsPerPage = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordsPerPage();
            KualiTableRenderFormMetadata originEntrySearchResultTableMetadata = laborCorrectionForm.getOriginEntrySearchResultTableMetadata();
            originEntrySearchResultTableMetadata.jumpToFirstPage(laborCorrectionForm.getDisplayEntries().size(), maxRowsPerPage);
            originEntrySearchResultTableMetadata.setColumnToSortIndex(-1);
        }
    }

    protected boolean prepareForRoute(GeneralLedgerCorrectionProcessForm generalLedgerCorrectionProcessForm) throws Exception {
        LaborCorrectionForm laborCorrectionForm = (LaborCorrectionForm)generalLedgerCorrectionProcessForm;
        LaborCorrectionDocument document = laborCorrectionForm.getLaborCorrectionDocument();
        if (StringUtils.isEmpty((String)document.getDocumentHeader().getDocumentDescription())) {
            GlobalVariables.getMessageMap().putError("document.documentHeader.documentDescription", "error.document.noDescription", new String[0]);
            return false;
        }
        if (laborCorrectionForm.isPersistedOriginEntriesMissing()) {
            GlobalVariables.getMessageMap().putError("searchResults", "error.gl.correction.persisted.origin.entries.missing", new String[0]);
            return false;
        }
        if (!this.checkMainDropdown(laborCorrectionForm)) {
            return false;
        }
        if (laborCorrectionForm.getDataLoadedFlag() || laborCorrectionForm.isRestrictedFunctionalityMode()) {
            document.setCorrectionInputFileName(generalLedgerCorrectionProcessForm.getInputGroupId());
        } else {
            document.setCorrectionInputFileName(null);
        }
        if (!this.checkOriginEntryGroupSelectionBeforeRouting(document)) {
            return false;
        }
        if (GlobalVariables.getMessageMap().containsMessageKey("error.gl.correction.invalid.system.or.edit.method.change")) {
            return false;
        }
        if (GlobalVariables.getMessageMap().containsMessageKey("error.gl.correction.invalid.input.group.change")) {
            return false;
        }
        if (!this.validGroupsItemsForDocumentSave(laborCorrectionForm)) {
            return false;
        }
        if ("C".equals(laborCorrectionForm.getEditMethod()) && !this.validChangeGroups(laborCorrectionForm)) {
            return false;
        }
        if (!this.checkRestrictedFunctionalityModeForManualEdit(laborCorrectionForm)) {
            return false;
        }
        if (!this.checkInputGroupPersistedForDocumentSave(laborCorrectionForm)) {
            return false;
        }
        if ("C".equals(laborCorrectionForm.getEditMethod())) {
            if (!laborCorrectionForm.isRestrictedFunctionalityMode() && laborCorrectionForm.getDataLoadedFlag() && !laborCorrectionForm.getShowOutputFlag()) {
                this.updateEntriesFromCriteria(laborCorrectionForm, false);
            }
            laborCorrectionForm.setShowOutputFlag(true);
        } else {
            document.getCorrectionChangeGroup().clear();
        }
        document.setCorrectionTypeCode(laborCorrectionForm.getEditMethod());
        document.setCorrectionSelection(laborCorrectionForm.getMatchCriteriaOnly());
        document.setCorrectionFileDelete(!laborCorrectionForm.getProcessInBatch());
        document.setCorrectionInputFileName(laborCorrectionForm.getInputGroupId());
        document.setCorrectionOutputFileName(null);
        document.setCorrectionOutputFileName(null);
        ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).persistOriginEntryGroupsForDocumentSave(document, (CorrectionDocumentEntryMetadata)laborCorrectionForm);
        return true;
    }

    public ActionForward saveToDesktop(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOG.debug((Object)"saveToDesktop() started");
        LaborCorrectionForm laborCorrectionForm = (LaborCorrectionForm)form;
        if (this.checkOriginEntryGroupSelection(laborCorrectionForm)) {
            if (laborCorrectionForm.isInputGroupIdFromLastDocumentLoadIsMissing() && laborCorrectionForm.getInputGroupIdFromLastDocumentLoad() != null && laborCorrectionForm.getInputGroupIdFromLastDocumentLoad().equals(laborCorrectionForm.getInputGroupId())) {
                if (laborCorrectionForm.isPersistedOriginEntriesMissing()) {
                    GlobalVariables.getMessageMap().putError("documentsInSystem", "error.labor.correction.persisted.origin.entries.missing", new String[0]);
                    return mapping.findForward("basic");
                }
                String fileName = "llcp_archived_group_" + laborCorrectionForm.getInputGroupIdFromLastDocumentLoad().toString() + ".txt";
                response.setContentType("application/txt");
                response.setHeader("Content-disposition", "attachment; filename=" + fileName);
                response.setHeader("Expires", "0");
                response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                response.setHeader("Pragma", "public");
                BufferedOutputStream bw = new BufferedOutputStream((OutputStream)response.getOutputStream());
                ((CorrectionDocumentService)SpringContext.getBean(CorrectionDocumentService.class)).writePersistedInputOriginEntriesToStream((GeneralLedgerCorrectionProcessDocument)((LaborCorrectionDocument)laborCorrectionForm.getDocument()), (OutputStream)bw);
                bw.flush();
                bw.close();
                return null;
            }
            String batchDirectory = ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).getBatchFileDirectoryName();
            String fileNameWithPath = !laborCorrectionForm.getInputGroupId().contains(batchDirectory) ? batchDirectory + File.separator + laborCorrectionForm.getInputGroupId() : laborCorrectionForm.getInputGroupId();
            FileReader fileReader = new FileReader(fileNameWithPath);
            BufferedReader br = new BufferedReader(fileReader);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.buildTextOutputfile(baos, br);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/txt", (ByteArrayOutputStream)baos, (String)laborCorrectionForm.getInputGroupId());
            br.close();
            return null;
        }
        return mapping.findForward("basic");
    }

    public ActionForward sort(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LaborCorrectionForm correctionForm = (LaborCorrectionForm)form;
        correctionForm.registerEditableProperty("methodToCall");
        int maxRowsPerPage = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordsPerPage();
        KualiTableRenderFormMetadata originEntrySearchResultTableMetadata = correctionForm.getOriginEntrySearchResultTableMetadata();
        List<Column> columns = ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).getTableRenderColumnMetadata(correctionForm.getDocument().getDocumentNumber());
        String propertyToSortName = columns.get(originEntrySearchResultTableMetadata.getColumnToSortIndex()).getPropertyName();
        Comparator valueComparator = columns.get(originEntrySearchResultTableMetadata.getColumnToSortIndex()).getValueComparator();
        boolean sortDescending = false;
        if (originEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex() == originEntrySearchResultTableMetadata.getColumnToSortIndex()) {
            sortDescending = !originEntrySearchResultTableMetadata.isSortDescending();
            originEntrySearchResultTableMetadata.setSortDescending(sortDescending);
        }
        originEntrySearchResultTableMetadata.setSortDescending(sortDescending);
        this.sortList(correctionForm.getDisplayEntries(), propertyToSortName, valueComparator, sortDescending);
        originEntrySearchResultTableMetadata.jumpToFirstPage(correctionForm.getDisplayEntries().size(), maxRowsPerPage);
        return mapping.findForward("basic");
    }

    protected void applyPagingAndSortingFromPreviousPageView(LaborCorrectionForm laborCorrectionForm) {
        KualiTableRenderFormMetadata originEntrySearchResultTableMetadata = laborCorrectionForm.getOriginEntrySearchResultTableMetadata();
        if (originEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex() != -1) {
            List<Column> columns = ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).getTableRenderColumnMetadata(laborCorrectionForm.getDocument().getDocumentNumber());
            String propertyToSortName = columns.get(originEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex()).getPropertyName();
            Comparator valueComparator = columns.get(originEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex()).getValueComparator();
            this.sortList(laborCorrectionForm.getDisplayEntries(), propertyToSortName, valueComparator, originEntrySearchResultTableMetadata.isSortDescending());
        }
        int maxRowsPerPage = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordsPerPage();
        originEntrySearchResultTableMetadata.jumpToPage(originEntrySearchResultTableMetadata.getViewedPageNumber(), laborCorrectionForm.getDisplayEntries().size(), maxRowsPerPage);
    }

    protected boolean checkInputGroupPersistedForDocumentSave(GeneralLedgerCorrectionProcessForm generalLedgerCorrectionProcessForm) {
        LaborCorrectionForm laborCorrectionForm = (LaborCorrectionForm)generalLedgerCorrectionProcessForm;
        WorkflowDocument workflowDocument = laborCorrectionForm.getDocument().getDocumentHeader().getWorkflowDocument();
        boolean present = workflowDocument.isInitiated() || workflowDocument.isSaved() && (laborCorrectionForm.getInputGroupIdFromLastDocumentLoad() == null || !laborCorrectionForm.getInputGroupIdFromLastDocumentLoad().equals(laborCorrectionForm.getInputGroupId())) ? originEntryGroupService.getGroupExists(((LaborCorrectionDocument)laborCorrectionForm.getDocument()).getCorrectionInputFileName()) : ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).areInputOriginEntriesPersisted((LaborCorrectionDocument)laborCorrectionForm.getDocument());
        if (!present) {
            GlobalVariables.getMessageMap().putError("systemAndEditMethod", "error.gl.correction.persisted.origin.entries.missing", new String[0]);
        }
        return present;
    }

    public ActionForward selectSystemEditMethod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"selectSystemEditMethod() started");
        LaborCorrectionForm laborCorrectionForm = (LaborCorrectionForm)form;
        LaborCorrectionDocument document = laborCorrectionForm.getLaborCorrectionDocument();
        if (this.checkMainDropdown(laborCorrectionForm)) {
            document.setCorrectionInputFileName(null);
            document.setCorrectionOutputFileName(null);
            document.setCorrectionCreditTotalAmount(null);
            document.setCorrectionDebitTotalAmount(null);
            document.setCorrectionBudgetTotalAmount(null);
            document.setCorrectionRowCount(null);
            document.getCorrectionChangeGroup().clear();
            laborCorrectionForm.setDataLoadedFlag(false);
            laborCorrectionForm.setDeleteFileFlag(false);
            laborCorrectionForm.setEditableFlag(false);
            laborCorrectionForm.setManualEditFlag(false);
            laborCorrectionForm.setShowOutputFlag(false);
            laborCorrectionForm.setAllEntries(new ArrayList());
            laborCorrectionForm.setRestrictedFunctionalityMode(false);
            laborCorrectionForm.setProcessInBatch(true);
            if ("D".equals(laborCorrectionForm.getChooseSystem())) {
                CorrectionLaborGroupEntriesFinder f = new CorrectionLaborGroupEntriesFinder();
                List<KeyValue> values = f.getKeyValues();
                if (values.size() > 0) {
                    String newestScrubberErrorFileName = GeneralLedgerCorrectionProcessAction.originEntryGroupService.getNewestScrubberErrorFileName();
                    if (newestScrubberErrorFileName != null) {
                        document.setCorrectionInputFileName(newestScrubberErrorFileName);
                    } else {
                        KeyValue klp = values.get(0);
                        document.setCorrectionInputFileName(klp.getKey());
                    }
                } else {
                    GlobalVariables.getMessageMap().putError("systemAndEditMethod", "error.gl.NoOriginEntryGroups", new String[0]);
                    laborCorrectionForm.setChooseSystem("");
                }
            }
        } else {
            laborCorrectionForm.setEditMethod("");
            laborCorrectionForm.setChooseSystem("");
        }
        laborCorrectionForm.setPreviousChooseSystem(laborCorrectionForm.getChooseSystem());
        laborCorrectionForm.setPreviousEditMethod(laborCorrectionForm.getEditMethod());
        laborCorrectionForm.setPreviousInputGroupId(null);
        return mapping.findForward("basic");
    }

    public ActionForward loadGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"loadGroup() started");
        LaborCorrectionForm laborCorrectionForm = (LaborCorrectionForm)form;
        String batchDirectory = ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).getBatchFileDirectoryName();
        if (this.checkOriginEntryGroupSelection(laborCorrectionForm)) {
            LaborCorrectionDocument document;
            LaborCorrectionDocument doc = laborCorrectionForm.getLaborCorrectionDocument();
            doc.setCorrectionInputFileName(batchDirectory + File.separator + laborCorrectionForm.getInputGroupId());
            int inputGroupSize = this.laborOriginEntryService.getGroupCount(laborCorrectionForm.getInputGroupId());
            int recordCountFunctionalityLimit = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordCountFunctionalityLimit();
            laborCorrectionForm.setPersistedOriginEntriesMissing(false);
            if (org.kuali.kfs.gl.document.CorrectionDocumentUtils.isRestrictedFunctionalityMode((int)inputGroupSize, (int)recordCountFunctionalityLimit)) {
                laborCorrectionForm.setRestrictedFunctionalityMode(true);
                laborCorrectionForm.setDataLoadedFlag(false);
                this.updateDocumentSummary(laborCorrectionForm.getCorrectionDocument(), null, true);
                if ("M".equals(laborCorrectionForm.getEditMethod())) {
                    if (recordCountFunctionalityLimit == 0) {
                        GlobalVariables.getMessageMap().putError("systemAndEditMethod", "error.gl.correction.unable.to.manual.edit.any.group", new String[0]);
                    } else {
                        GlobalVariables.getMessageMap().putError("systemAndEditMethod", "error.gl.correction.unable.to.manual.edit.large.group", new String[]{String.valueOf(recordCountFunctionalityLimit)});
                    }
                }
            } else {
                laborCorrectionForm.setRestrictedFunctionalityMode(false);
                this.loadAllEntries(laborCorrectionForm.getInputGroupId(), laborCorrectionForm);
                if (laborCorrectionForm.getAllEntries().size() > 0) {
                    if ("M".equals(laborCorrectionForm.getEditMethod())) {
                        laborCorrectionForm.setManualEditFlag(true);
                        laborCorrectionForm.setEditableFlag(false);
                        laborCorrectionForm.setDeleteFileFlag(false);
                    }
                    laborCorrectionForm.setDataLoadedFlag(true);
                } else {
                    GlobalVariables.getMessageMap().putError("documentsInSystem", "error.gl.correction.norecords", new String[0]);
                }
            }
            if ((document = laborCorrectionForm.getLaborCorrectionDocument()).getCorrectionChangeGroup().isEmpty()) {
                document.addCorrectionChangeGroup(new CorrectionChangeGroup());
            }
            laborCorrectionForm.setPreviousInputGroupId(laborCorrectionForm.getInputGroupId());
        }
        laborCorrectionForm.setShowOutputFlag(false);
        return mapping.findForward("basic");
    }

    public ActionForward confirmDeleteDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"confirmDeleteDocument() started");
        LaborCorrectionForm correctionForm = (LaborCorrectionForm)form;
        if (this.checkOriginEntryGroupSelection(correctionForm)) {
            int recordCountFunctionalityLimit;
            String batchDirectory = ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).getBatchFileDirectoryName();
            String doneFileName = batchDirectory + File.separator + correctionForm.getInputGroupId();
            String dataFileName = doneFileName.replace(".done", ".data");
            int groupCount = this.laborOriginEntryService.getGroupCount(dataFileName);
            if (!org.kuali.kfs.gl.document.CorrectionDocumentUtils.isRestrictedFunctionalityMode((int)groupCount, (int)(recordCountFunctionalityLimit = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordCountFunctionalityLimit()))) {
                this.loadAllEntries(dataFileName, correctionForm);
                correctionForm.setDeleteFileFlag(true);
                correctionForm.setDataLoadedFlag(true);
                correctionForm.setRestrictedFunctionalityMode(false);
            } else {
                correctionForm.setRestrictedFunctionalityMode(true);
            }
            LaborCorrectionDocument document = (LaborCorrectionDocument)correctionForm.getDocument();
            document.setCorrectionInputFileName(dataFileName);
        }
        return mapping.findForward("basic");
    }
}

