/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.document.LaborExpenseTransferDocumentBase;
import org.kuali.kfs.module.ld.service.LaborLedgerPendingEntryService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.search.SearchOperator;

public class SalaryExpenseTransferPendingLegerEntryValidation
extends GenericValidation {
    private Document documentForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        boolean result = true;
        Document documentForValidation = this.getDocumentForValidation();
        AccountingDocument accountingDocument = (AccountingDocument)documentForValidation;
        result = !this.hasPendingLedgerEntry(accountingDocument);
        return result;
    }

    protected boolean hasPendingLedgerEntry(AccountingDocument accountingDocument) {
        boolean entriesExist = false;
        LaborExpenseTransferDocumentBase expenseTransferDocument = (LaborExpenseTransferDocumentBase)accountingDocument;
        List sourceAccountingLines = expenseTransferDocument.getSourceAccountingLines();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        for (ExpenseTransferAccountingLine sourceAccountingLine : sourceAccountingLines) {
            String payPeriodCode = sourceAccountingLine.getPayrollEndDateFiscalPeriodCode();
            String accountNumber = sourceAccountingLine.getAccountNumber();
            String objectCode = sourceAccountingLine.getFinancialObjectCode();
            String emplId = sourceAccountingLine.getEmplid();
            String documentNumber = accountingDocument.getDocumentNumber();
            fieldValues.put("payrollEndDateFiscalPeriodCode", payPeriodCode);
            fieldValues.put("accountNumber", accountNumber);
            fieldValues.put("financialObjectCode", objectCode);
            fieldValues.put("emplid", emplId);
            fieldValues.put("documentNumber", SearchOperator.NOT.op() + documentNumber);
            if (!((LaborLedgerPendingEntryService)SpringContext.getBean(LaborLedgerPendingEntryService.class)).hasPendingLaborLedgerEntry(fieldValues)) continue;
            GlobalVariables.getMessageMap().putError("document.employeeLookups", "error.labor.alreadyPendingSalaryTransferError", new String[]{emplId, payPeriodCode, accountNumber, objectCode});
            return true;
        }
        return entriesExist;
    }

    public Document getDocumentForValidation() {
        return this.documentForValidation;
    }

    public void setDocumentForValidation(Document documentForValidation) {
        this.documentForValidation = documentForValidation;
    }
}

