/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.service.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.module.ld.businessobject.AccountStatusCurrentFunds;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.businessobject.LedgerEntry;
import org.kuali.kfs.module.ld.service.LaborInquiryOptionsService;
import org.kuali.kfs.module.ld.service.LaborLedgerBalanceService;
import org.kuali.kfs.module.ld.service.LaborLedgerPendingEntryService;
import org.kuali.kfs.sys.ObjectUtil;

public class LaborInquiryOptionsServiceImpl
implements LaborInquiryOptionsService {
    private static Logger LOG = Logger.getLogger(LaborInquiryOptionsServiceImpl.class);
    private LaborLedgerPendingEntryService laborLedgerPendingEntryService;
    private LaborLedgerBalanceService laborLedgerBalanceService;

    @Override
    public String getConsolidationFieldName() {
        return "dummyBusinessObject.consolidationOption";
    }

    @Override
    public Field getConsolidationField(Collection<Row> rows) {
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!field.getPropertyName().equals(this.getConsolidationFieldName())) continue;
                return field;
            }
        }
        return null;
    }

    @Override
    public String getSelectedPendingEntryOption(Map fieldValues) {
        String pendingEntryOption = (String)fieldValues.get("dummyBusinessObject.pendingEntryOption");
        fieldValues.remove("dummyBusinessObject.pendingEntryOption");
        return pendingEntryOption;
    }

    @Override
    public boolean isCgBeginningBalanceOnlyExcluded(Map fieldValues) {
        String cgBeginningBalanceExcludeOption = (String)fieldValues.get("dummyBusinessObject.cgBeginningBalanceExcludeOption");
        fieldValues.remove("dummyBusinessObject.cgBeginningBalanceExcludeOption");
        return "Y".equalsIgnoreCase(cgBeginningBalanceExcludeOption);
    }

    @Override
    public String getConsolidationOption(Map fieldValues) {
        String consolidationOption = (String)fieldValues.get(this.getConsolidationFieldName());
        fieldValues.remove(this.getConsolidationFieldName());
        return consolidationOption;
    }

    @Override
    public boolean isConsolidationSelected(Map fieldValues, Collection<Row> rows) {
        boolean isConsolidationSelected = this.isConsolidationSelected(fieldValues);
        if (!isConsolidationSelected) {
            Field consolidationField = this.getConsolidationField(rows);
            consolidationField.setPropertyValue("Detail");
        }
        return isConsolidationSelected;
    }

    @Override
    public boolean isConsolidationSelected(Map fieldValues) {
        String consolidationOption = this.getConsolidationOption(fieldValues);
        if ("Detail".equals(consolidationOption)) {
            return false;
        }
        return !this.isDetailDefaultFieldUsed(fieldValues, "subAccountNumber") && !this.isDetailDefaultFieldUsed(fieldValues, "subObjectCode") && !this.isDetailDefaultFieldUsed(fieldValues, "objectTypeCode");
    }

    @Override
    public void updateLedgerBalanceByPendingLedgerEntry(Collection<LedgerBalance> balanceCollection, Map fieldValues, String pendingEntryOption, boolean isConsolidated) {
        if ("All".equals(pendingEntryOption)) {
            this.updateCollection(balanceCollection, fieldValues, false, isConsolidated, LedgerBalance.class);
        } else if ("Approved".equals(pendingEntryOption)) {
            this.updateCollection(balanceCollection, fieldValues, true, isConsolidated, LedgerBalance.class);
        }
    }

    @Override
    public void updateCurrentFundsByPendingLedgerEntry(Collection<AccountStatusCurrentFunds> balanceCollection, Map fieldValues, String pendingEntryOption, boolean isConsolidated) {
        if ("All".equals(pendingEntryOption)) {
            this.updateCollection(balanceCollection, fieldValues, false, isConsolidated, AccountStatusCurrentFunds.class);
        } else if ("Approved".equals(pendingEntryOption)) {
            this.updateCollection(balanceCollection, fieldValues, true, isConsolidated, AccountStatusCurrentFunds.class);
        }
    }

    @Override
    public void updateLedgerEntryByPendingLedgerEntry(Collection<LedgerEntry> entryCollection, Map fieldValues, String pendingEntryOption) {
        if ("All".equals(pendingEntryOption)) {
            this.updateCollection(entryCollection, fieldValues, false, false, LedgerEntry.class);
        } else if ("Approved".equals(pendingEntryOption)) {
            this.updateCollection(entryCollection, fieldValues, true, false, LedgerEntry.class);
        }
    }

    protected void updateCollection(Collection entryCollection, Map fieldValues, boolean isApproved, boolean isConsolidated, Class clazz) {
        Iterator pendingEntryIterator = this.laborLedgerPendingEntryService.findPendingLedgerEntriesForLedgerBalance(fieldValues, isApproved);
        while (pendingEntryIterator.hasNext()) {
            LaborLedgerPendingEntry pendingEntry = (LaborLedgerPendingEntry)pendingEntryIterator.next();
            if (isConsolidated) {
                pendingEntry.setSubAccountNumber("*ALL*");
                pendingEntry.setFinancialSubObjectCode("*ALL*");
                pendingEntry.setFinancialObjectTypeCode("*ALL*");
            }
            if (LedgerBalance.class.isAssignableFrom(clazz)) {
                try {
                    Object ledgerBalance = this.laborLedgerBalanceService.findLedgerBalance(entryCollection, pendingEntry);
                    if (ledgerBalance == null) {
                        Object newLedgerBalance = clazz.newInstance();
                        ObjectUtil.buildObject(newLedgerBalance, (Object)pendingEntry);
                        ledgerBalance = (LedgerBalance)((Object)newLedgerBalance);
                        entryCollection.add(ledgerBalance);
                    }
                    this.laborLedgerBalanceService.updateLedgerBalance(ledgerBalance, pendingEntry);
                    ledgerBalance.getDummyBusinessObject().setConsolidationOption(isConsolidated ? "Consolidation" : "Detail");
                    ledgerBalance.getDummyBusinessObject().setPendingEntryOption(isApproved ? "Approved" : "All");
                }
                catch (Exception e) {
                    LOG.error((Object)("cannot create a new object of type: " + clazz.getName() + "/n" + e));
                }
                continue;
            }
            if (LedgerEntry.class.isAssignableFrom(clazz)) {
                LedgerEntry ledgerEntry = new LedgerEntry();
                ObjectUtil.buildObject((Object)((Object)ledgerEntry), (Object)pendingEntry);
                ledgerEntry.getDummyBusinessObject().setConsolidationOption(isConsolidated ? "Consolidation" : "Detail");
                ledgerEntry.getDummyBusinessObject().setPendingEntryOption(isApproved ? "Approved" : "All");
                entryCollection.add(ledgerEntry);
                continue;
            }
            LOG.warn((Object)("The class, " + clazz.getName() + ", is unregistered with the method."));
            return;
        }
    }

    protected boolean isDetailDefaultFieldUsed(Map fieldValues, String fieldName) {
        return StringUtils.isNotBlank((String)((String)fieldValues.get(fieldName)));
    }

    public void setLaborLedgerBalanceService(LaborLedgerBalanceService laborLedgerBalanceService) {
        this.laborLedgerBalanceService = laborLedgerBalanceService;
    }

    public void setLaborLedgerPendingEntryService(LaborLedgerPendingEntryService laborLedgerPendingEntryService) {
        this.laborLedgerPendingEntryService = laborLedgerPendingEntryService;
    }
}

