/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.service.ChartService;
import org.kuali.kfs.module.ld.service.LaborLedgerEntryService;
import org.kuali.kfs.sys.batch.AbstractStep;

public class LaborPurgeEntryStep
extends AbstractStep {
    private static Logger LOG = Logger.getLogger(LaborPurgeEntryStep.class);
    private ChartService chartService;
    private LaborLedgerEntryService laborLedgerEntryService;

    public boolean execute(String jobName, Date jobRunDate) throws InterruptedException {
        String fiscalYearAsString = this.getParameterService().getParameterValueAsString(((Object)((Object)this)).getClass(), "PRIOR_TO_YEAR");
        LOG.info((Object)("Purge labor entries posted before the year: " + fiscalYearAsString));
        Integer fiscalYear = Integer.parseInt(StringUtils.trim((String)fiscalYearAsString));
        List allChartOfAccountsCode = this.chartService.getAllChartCodes();
        for (String chartOfAccountsCode : allChartOfAccountsCode) {
            this.laborLedgerEntryService.deleteLedgerEntriesPriorToYear(fiscalYear, chartOfAccountsCode);
        }
        return true;
    }

    public void setChartService(ChartService chartService) {
        this.chartService = chartService;
    }

    public void setLaborLedgerEntryService(LaborLedgerEntryService laborLedgerEntryService) {
        this.laborLedgerEntryService = laborLedgerEntryService;
    }
}

