/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.batch.PosterSummaryReportStep;
import org.kuali.kfs.gl.businessobject.GlSummary;
import org.kuali.kfs.gl.businessobject.OriginEntryInformation;
import org.kuali.kfs.gl.report.PosterOutputSummaryReport;
import org.kuali.kfs.module.ld.batch.service.LaborBalanceSummaryReportService;
import org.kuali.kfs.module.ld.businessobject.LaborBalanceSummary;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.service.LaborLedgerBalanceService;
import org.kuali.kfs.module.ld.util.LaborOriginEntryFileIterator;
import org.kuali.kfs.sys.FileUtil;
import org.kuali.kfs.sys.batch.service.WrappingBatchService;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.service.FiscalYearAwareReportWriterService;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.ReportWriterService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.bo.BusinessObject;

public class LaborBalanceSummaryReportServiceImpl
implements LaborBalanceSummaryReportService {
    private static Logger LOG = Logger.getLogger(LaborBalanceSummaryReportServiceImpl.class);
    private DateTimeService dateTimeService;
    private OptionsService optionsService;
    private ParameterService parameterService;
    private LaborLedgerBalanceService laborLedgerBalanceService;
    private ReportWriterService laborPosterOutputSummaryReportWriterService;
    private FiscalYearAwareReportWriterService laborActualBalanceSummaryReportWriterService;
    private FiscalYearAwareReportWriterService laborBudgetBalanceSummaryReportWriterService;
    private FiscalYearAwareReportWriterService laborEncumbranceSummaryReportWriterService;
    private String batchFileDirectoryName;

    @Override
    public void generateBalanceSummaryReports() {
        LOG.debug((Object)"generateBalanceSummaryReports() started");
        Date runDate = this.dateTimeService.getCurrentSqlDate();
        this.generatePosterOutputSummaryReport(runDate);
        this.generateBalanceSummaryReports(runDate);
    }

    @Override
    public void generateBalanceSummaryReports(Date runDate) {
        LOG.debug((Object)"generateBalanceSummaryReports(Date) started");
        String yearEndPeriodLowerBound = this.parameterService.getParameterValueAsString(PosterSummaryReportStep.class, "CURRENT_YEAR_LOWER");
        String lastDayOfFiscalYear = this.parameterService.getParameterValueAsString(PosterSummaryReportStep.class, "CURRENT_AND_LAST_YEAR");
        String yearEndPeriodUpperBound = this.parameterService.getParameterValueAsString(PosterSummaryReportStep.class, "CURRENT_YEAR_UPPER");
        Integer currentYear = this.optionsService.getCurrentYearOptions().getUniversityFiscalYear();
        this.generateBalanceSummaryReports(currentYear, runDate);
        if (this.isInYearEndLowerBound(runDate, yearEndPeriodLowerBound, lastDayOfFiscalYear)) {
            this.generateBalanceSummaryReports(currentYear + 1, runDate);
        }
        if (this.isInYearEndUpperBound(runDate, yearEndPeriodUpperBound, lastDayOfFiscalYear)) {
            this.generateBalanceSummaryReports(currentYear - 1, runDate);
        }
    }

    protected void generateBalanceSummaryReports(Integer fiscalYear, Date runDate) {
        SystemOptions options = this.optionsService.getOptions(fiscalYear);
        if (options == null) {
            LOG.fatal((Object)("The data for " + fiscalYear + "have NOT been setup."));
            return;
        }
        List<String> actualsBalanceTypes = this.getActualBalanceTypes(fiscalYear);
        this.writeSummaryReport(fiscalYear, actualsBalanceTypes, this.laborActualBalanceSummaryReportWriterService);
        List<String> budgetBalanceTypes = this.getBudgetBalanceTypes(fiscalYear);
        this.writeSummaryReport(fiscalYear, budgetBalanceTypes, this.laborBudgetBalanceSummaryReportWriterService);
        List<String> encumbranceBalanceTypes = this.getEncumbranceBalanceTypes(fiscalYear);
        this.writeSummaryReport(fiscalYear, encumbranceBalanceTypes, this.laborEncumbranceSummaryReportWriterService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeSummaryReport(Integer fiscalYear, List<String> balanceTypes, FiscalYearAwareReportWriterService reportWriterService) {
        List<LaborBalanceSummary> balanceSummary = this.laborLedgerBalanceService.findBalanceSummary(fiscalYear, balanceTypes);
        ArrayList<LaborBalanceSummary> summaryList = new ArrayList<LaborBalanceSummary>(balanceSummary);
        LaborBalanceSummary totals = new LaborBalanceSummary();
        for (GlSummary glSummary : summaryList) {
            totals.add(glSummary);
        }
        totals.setFundGroup("Total");
        try {
            reportWriterService.setFiscalYear(fiscalYear);
            ((WrappingBatchService)reportWriterService).initialize();
            reportWriterService.writeSubTitle("Balance Type of " + balanceTypes + " for Fiscal Year " + fiscalYear);
            reportWriterService.writeNewLines(1);
            reportWriterService.writeTableRowSeparationLine((BusinessObject)totals);
            reportWriterService.writeTable(summaryList, true, false);
            reportWriterService.writeTableRowSeparationLine((BusinessObject)totals);
            reportWriterService.writeTableRow((BusinessObject)totals);
        }
        finally {
            ((WrappingBatchService)reportWriterService).destroy();
        }
    }

    protected void generatePosterOutputSummaryReport(Date runDate) {
        PosterOutputSummaryReport posterOutputSummaryReport = new PosterOutputSummaryReport();
        File mainPosterFile = FileUtil.getNewestFile((File)new File(this.batchFileDirectoryName), (FilenameFilter)new RegexFileFilter("ld_sortpost\\.[0-9_\\-]+\\.data"));
        if (mainPosterFile != null && mainPosterFile.exists()) {
            LaborOriginEntryFileIterator mainPosterIterator = new LaborOriginEntryFileIterator(mainPosterFile);
            while (mainPosterIterator.hasNext()) {
                LaborOriginEntry originEntry = mainPosterIterator.next();
                posterOutputSummaryReport.summarize((OriginEntryInformation)originEntry);
            }
        } else {
            LOG.warn((Object)"Could not Main Poster Input file, ld_sortpost, for tabulation in the Poster Output Summary Report");
        }
        posterOutputSummaryReport.writeReport(this.laborPosterOutputSummaryReportWriterService);
    }

    protected List<String> getEncumbranceBalanceTypes(Integer fiscalYear) {
        SystemOptions options = this.optionsService.getOptions(fiscalYear);
        ArrayList<String> balanceTypes = new ArrayList<String>();
        balanceTypes.add(options.getExtrnlEncumFinBalanceTypCd());
        balanceTypes.add(options.getIntrnlEncumFinBalanceTypCd());
        balanceTypes.add(options.getPreencumbranceFinBalTypeCd());
        balanceTypes.add(options.getCostShareEncumbranceBalanceTypeCd());
        return balanceTypes;
    }

    protected List<String> getActualBalanceTypes(Integer fiscalYear) {
        SystemOptions options = this.optionsService.getOptions(fiscalYear);
        ArrayList<String> balanceTypes = new ArrayList<String>();
        balanceTypes.add(options.getActualFinancialBalanceTypeCd());
        return balanceTypes;
    }

    protected List<String> getBudgetBalanceTypes(Integer fiscalYear) {
        SystemOptions options = this.optionsService.getOptions(fiscalYear);
        ArrayList<String> balanceTypes = new ArrayList<String>();
        balanceTypes.add(options.getBudgetCheckingBalanceTypeCd());
        balanceTypes.add(options.getBaseBudgetFinancialBalanceTypeCd());
        balanceTypes.add(options.getMonthlyBudgetFinancialBalanceTypeCd());
        return balanceTypes;
    }

    protected boolean isInYearEndPeriod(Date runDate, String yearEndPeriodLowerBound, String yearEndPeriodUpperBound, String lastDayOfFiscalYear) {
        return this.isInYearEndLowerBound(runDate, yearEndPeriodLowerBound, lastDayOfFiscalYear) || this.isInYearEndUpperBound(runDate, yearEndPeriodUpperBound, lastDayOfFiscalYear);
    }

    protected boolean isInYearEndLowerBound(Date runDate, String yearEndPeriodLowerBound, String lastDayOfFiscalYear) {
        SimpleDateFormat sdf = new SimpleDateFormat("MMdd");
        String today = sdf.format(runDate);
        return today.compareTo(yearEndPeriodLowerBound) >= 0 && today.compareTo(lastDayOfFiscalYear) <= 0;
    }

    protected boolean isInYearEndUpperBound(Date runDate, String yearEndPeriodUpperBound, String lastDayOfFiscalYear) {
        SimpleDateFormat sdf = new SimpleDateFormat("MMdd");
        String today = sdf.format(runDate);
        String month = StringUtils.mid((String)lastDayOfFiscalYear, (int)0, (int)2);
        String date = StringUtils.mid((String)lastDayOfFiscalYear, (int)2, (int)2);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, Integer.parseInt(month) - 1);
        calendar.set(5, Integer.parseInt(date));
        calendar.add(5, 1);
        String firstDayOfNewFiscalYear = sdf.format(calendar.getTime());
        return today.compareTo(yearEndPeriodUpperBound) <= 0 && today.compareTo(firstDayOfNewFiscalYear) >= 0;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setLaborLedgerBalanceService(LaborLedgerBalanceService laborLedgerBalanceService) {
        this.laborLedgerBalanceService = laborLedgerBalanceService;
    }

    public void setLaborActualBalanceSummaryReportWriterService(FiscalYearAwareReportWriterService laborActualBalanceSummaryReportWriterService) {
        this.laborActualBalanceSummaryReportWriterService = laborActualBalanceSummaryReportWriterService;
    }

    public void setLaborBudgetBalanceSummaryReportWriterService(FiscalYearAwareReportWriterService laborBudgetBalanceSummaryReportWriterService) {
        this.laborBudgetBalanceSummaryReportWriterService = laborBudgetBalanceSummaryReportWriterService;
    }

    public void setLaborEncumbranceSummaryReportWriterService(FiscalYearAwareReportWriterService laborEncumbranceSummaryReportWriterService) {
        this.laborEncumbranceSummaryReportWriterService = laborEncumbranceSummaryReportWriterService;
    }

    public void setLaborPosterOutputSummaryReportWriterService(ReportWriterService laborPosterOutputSummaryReportWriterService) {
        this.laborPosterOutputSummaryReportWriterService = laborPosterOutputSummaryReportWriterService;
    }

    public void setBatchFileDirectoryName(String batchFileDirectoryName) {
        this.batchFileDirectoryName = batchFileDirectoryName;
    }
}

