/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.authorization;

import java.util.HashMap;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.authorization.LaborExpenseTransferAccountingLineAuthorizer;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.rice.kew.api.WorkflowDocument;

public class SalaryExpenseTransferAccountingLineAuthorizer
extends LaborExpenseTransferAccountingLineAuthorizer {
    @Override
    public boolean determineEditPermissionOnField(AccountingDocument accountingDocument, AccountingLine accountingLine, String accountingLineCollectionProperty, String fieldName, boolean editablePage) {
        if (accountingLine.isTargetAccountingLine()) {
            SalaryExpenseTransferDocument expenseTransferDocument = (SalaryExpenseTransferDocument)accountingDocument;
            WorkflowDocument workflowDocument = expenseTransferDocument.getDocumentHeader().getWorkflowDocument();
            if ("financialObjectCode".equals(fieldName)) {
                return this.hasEditPermissionOnObjectCode(expenseTransferDocument, workflowDocument);
            }
        }
        return super.determineEditPermissionOnField(accountingDocument, accountingLine, accountingLineCollectionProperty, fieldName, editablePage);
    }

    protected boolean hasEditPermissionOnObjectCode(SalaryExpenseTransferDocument expenseTransferDocument, WorkflowDocument workflowDocument) {
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        DocumentAuthorizer documentAuthorizer = ((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)expenseTransferDocument);
        String templateName = KFSConstants.PermissionTemplate.MODIFY_ACCOUNTING_LINES.name;
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("documentTypeName", workflowDocument.getDocumentTypeName());
        additionalPermissionDetails.put("propertyName", "targetAccountingLines.financialObjectCode");
        return documentAuthorizer.isAuthorizedByTemplate((Object)expenseTransferDocument, "KFS-SYS", templateName, principalId, additionalPermissionDetails, null);
    }
}

