/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;

public class SalaryExpenseTransferValidAmountTransferredByObjectCodeValidation
extends GenericValidation {
    private Document documentForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        SalaryExpenseTransferDocument expenseTransferDocument = (SalaryExpenseTransferDocument)this.documentForValidation;
        WorkflowDocument workflowDocument = expenseTransferDocument.getDocumentHeader().getWorkflowDocument();
        if (this.hasEditPermissionOnObjectCode(expenseTransferDocument, workflowDocument)) {
            return true;
        }
        boolean isValid = true;
        if (workflowDocument.isApprovalRequested()) {
            if (!this.isObjectCodeBalancesUnchanged(expenseTransferDocument)) {
                GlobalVariables.getMessageMap().putError("targetAccountingLines", "error.labor.transferAmountByObjectApprovalChange", new String[0]);
                isValid = false;
            }
        } else if (!expenseTransferDocument.getUnbalancedObjectCodes().isEmpty()) {
            GlobalVariables.getMessageMap().putError("targetAccountingLines", "error.labor.transferAmountNotBalancedByObject", new String[0]);
            isValid = false;
        }
        return isValid;
    }

    protected boolean hasEditPermissionOnObjectCode(SalaryExpenseTransferDocument expenseTransferDocument, WorkflowDocument workflowDocument) {
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        DocumentAuthorizer documentAuthorizer = ((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)expenseTransferDocument);
        String templateName = KFSConstants.PermissionTemplate.MODIFY_ACCOUNTING_LINES.name;
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("documentTypeName", workflowDocument.getDocumentTypeName());
        additionalPermissionDetails.put("propertyName", "targetAccountingLines.financialObjectCode");
        return documentAuthorizer.isAuthorizedByTemplate((Object)expenseTransferDocument, "KFS-SYS", templateName, principalId, additionalPermissionDetails, null);
    }

    protected boolean isObjectCodeBalancesUnchanged(AccountingDocument accountingDocument) {
        boolean isUnchanged = true;
        Map<String, KualiDecimal> initiatedObjectCodeBalances = ((SalaryExpenseTransferDocument)accountingDocument).getApprovalObjectCodeBalances();
        Map<String, KualiDecimal> currentObjectCodeBalances = ((SalaryExpenseTransferDocument)accountingDocument).getUnbalancedObjectCodes();
        Set<Map.Entry<String, KualiDecimal>> initiatedObjectCodes = initiatedObjectCodeBalances.entrySet();
        Set<Map.Entry<String, KualiDecimal>> currentObjectCodes = currentObjectCodeBalances.entrySet();
        if (initiatedObjectCodes == null) {
            if (currentObjectCodes != null) {
                isUnchanged = false;
            }
        } else if (!initiatedObjectCodes.equals(currentObjectCodes)) {
            isUnchanged = false;
        }
        return isUnchanged;
    }

    public void setDocumentForValidation(Document documentForValidation) {
        this.documentForValidation = documentForValidation;
    }
}

