/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.web.struts;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.kuali.kfs.gl.businessobject.CorrectionChangeGroup;
import org.kuali.kfs.gl.businessobject.CorrectionCriteria;
import org.kuali.kfs.gl.businessobject.OriginEntryFull;
import org.kuali.kfs.gl.document.GeneralLedgerCorrectionProcessDocument;
import org.kuali.kfs.gl.document.authorization.CorrectionDocumentAuthorizer;
import org.kuali.kfs.gl.document.service.CorrectionDocumentService;
import org.kuali.kfs.gl.document.web.CorrectionDocumentEntryMetadata;
import org.kuali.kfs.gl.document.web.struts.GeneralLedgerCorrectionProcessAction;
import org.kuali.kfs.gl.document.web.struts.GeneralLedgerCorrectionProcessForm;
import org.kuali.kfs.gl.service.GlCorrectionProcessOriginEntryService;
import org.kuali.kfs.gl.service.OriginEntryGroupService;
import org.kuali.kfs.gl.service.OriginEntryService;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.kns.web.struts.form.KualiTableRenderFormMetadata;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.businessobject.options.CorrectionLaborGroupEntriesFinder;
import org.kuali.kfs.module.ld.businessobject.options.LaborOriginEntryFieldFinder;
import org.kuali.kfs.module.ld.document.LedgerCorrectionDocument;
import org.kuali.kfs.module.ld.document.service.LaborCorrectionDocumentService;
import org.kuali.kfs.module.ld.document.web.struts.LedgerCorrectionForm;
import org.kuali.kfs.module.ld.service.LaborOriginEntryGroupService;
import org.kuali.kfs.module.ld.service.LaborOriginEntryService;
import org.kuali.kfs.module.ld.util.CorrectionDocumentUtils;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.api.WorkflowDocument;

public class LedgerCorrectionAction
extends GeneralLedgerCorrectionProcessAction {
    LaborOriginEntryService laborOriginEntryService = (LaborOriginEntryService)SpringContext.getBean(LaborOriginEntryService.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"execute() started");
        GeneralLedgerCorrectionProcessForm generalLedgerCorrectionProcessForm = (GeneralLedgerCorrectionProcessForm)form;
        if (originEntryGroupService == null) {
            GeneralLedgerCorrectionProcessAction.originEntryGroupService = (OriginEntryGroupService)SpringContext.getBean(LaborOriginEntryGroupService.class);
            GeneralLedgerCorrectionProcessAction.originEntryService = (OriginEntryService)SpringContext.getBean(OriginEntryService.class);
            GeneralLedgerCorrectionProcessAction.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
            GeneralLedgerCorrectionProcessAction.kualiConfigurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        }
        LedgerCorrectionForm rForm = (LedgerCorrectionForm)form;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("execute() methodToCall: " + rForm.getMethodToCall()));
        }
        Object persistedOriginEntries = null;
        if (!"docHandler".equals(rForm.getMethodToCall()) && !"reload".equals(rForm.getMethodToCall())) {
            this.restoreSystemAndEditMethod(rForm);
            this.restoreInputGroupSelectionForDatabaseEdits(rForm);
            if (!rForm.isRestrictedFunctionalityMode() && StringUtils.isNotBlank((String)rForm.getGlcpSearchResultsSequenceNumber())) {
                rForm.setAllEntries(((GlCorrectionProcessOriginEntryService)SpringContext.getBean(GlCorrectionProcessOriginEntryService.class)).retrieveAllEntries(rForm.getGlcpSearchResultsSequenceNumber()));
                if (rForm.getAllEntries() == null) {
                    rForm.setDisplayEntries(null);
                } else {
                    rForm.setDisplayEntries(new ArrayList(rForm.getAllEntries()));
                }
                if (!"showOutputGroup".equals(rForm.getMethodToCall()) && rForm.getShowOutputFlag()) {
                    LedgerCorrectionDocument document = rForm.getLaborCorrectionDocument();
                    List groups = document.getCorrectionChangeGroup();
                    this.updateEntriesFromCriteria(rForm, rForm.isRestrictedFunctionalityMode());
                }
                if (!"sort".equals(rForm.getMethodToCall())) {
                    KualiTableRenderFormMetadata originEntrySearchResultTableMetadata = rForm.getOriginEntrySearchResultTableMetadata();
                    if (originEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex() != -1) {
                        List<Column> columns = ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).getTableRenderColumnMetadata(rForm.getDocument().getDocumentNumber());
                        String propertyToSortName = columns.get(originEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex()).getPropertyName();
                        Comparator valueComparator = columns.get(originEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex()).getValueComparator();
                        this.sortList(rForm.getDisplayEntries(), propertyToSortName, valueComparator, originEntrySearchResultTableMetadata.isSortDescending());
                    }
                    if (rForm.getAllEntries() != null) {
                        int maxRowsPerPage = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordsPerPage();
                        originEntrySearchResultTableMetadata.jumpToPage(originEntrySearchResultTableMetadata.getViewedPageNumber(), rForm.getDisplayEntries().size(), maxRowsPerPage);
                        originEntrySearchResultTableMetadata.setColumnToSortIndex(originEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex());
                    }
                }
            }
        }
        ActionForward af = super.superExecute(mapping, form, request, response);
        return af;
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"save() started");
        LedgerCorrectionForm ledgerCorrectionForm = (LedgerCorrectionForm)form;
        LedgerCorrectionDocument document = ledgerCorrectionForm.getLaborCorrectionDocument();
        if (!this.checkMainDropdown(ledgerCorrectionForm)) {
            return mapping.findForward("basic");
        }
        if (!this.checkRestrictedFunctionalityModeForManualEdit(ledgerCorrectionForm)) {
            return mapping.findForward("basic");
        }
        if (!this.validGroupsItemsForDocumentSave(ledgerCorrectionForm)) {
            return mapping.findForward("basic");
        }
        if (!this.validChangeGroups(ledgerCorrectionForm)) {
            return mapping.findForward("basic");
        }
        if (!this.checkInputGroupPersistedForDocumentSave(ledgerCorrectionForm)) {
            return mapping.findForward("basic");
        }
        document.setCorrectionTypeCode(ledgerCorrectionForm.getEditMethod());
        document.setCorrectionSelection(ledgerCorrectionForm.getMatchCriteriaOnly());
        document.setCorrectionFileDelete(!ledgerCorrectionForm.getProcessInBatch());
        document.setCorrectionInputFileName(ledgerCorrectionForm.getInputGroupId());
        document.setCorrectionOutputFileName(null);
        if (ledgerCorrectionForm.getDataLoadedFlag() || ledgerCorrectionForm.isRestrictedFunctionalityMode()) {
            document.setCorrectionInputFileName(ledgerCorrectionForm.getInputGroupId());
        } else {
            document.setCorrectionInputFileName(null);
        }
        document.setCorrectionOutputFileName(null);
        ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).persistOriginEntryGroupsForDocumentSave(document, (CorrectionDocumentEntryMetadata)ledgerCorrectionForm);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("save() doc type name: " + ledgerCorrectionForm.getDocTypeName()));
        }
        ActionForward af = super.superSave(mapping, form, request, response);
        return af;
    }

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"docHandler() started");
        LedgerCorrectionForm ledgerCorrectionForm = (LedgerCorrectionForm)form;
        String command = ledgerCorrectionForm.getCommand();
        if ("initiate".equals(command)) {
            ledgerCorrectionForm.clearForm();
            this.createDocument((KualiDocumentFormBase)ledgerCorrectionForm);
        } else {
            this.loadDocument((KualiDocumentFormBase)ledgerCorrectionForm);
            LedgerCorrectionDocument laborDocument = ledgerCorrectionForm.getLaborCorrectionDocument();
            ledgerCorrectionForm.setInputGroupIdFromLastDocumentLoad(laborDocument.getCorrectionInputFileName());
            this.populateAuthorizationFields((KualiDocumentFormBase)ledgerCorrectionForm);
            Map documentActions = ledgerCorrectionForm.getDocumentActions();
            if (documentActions.containsKey("canEdit")) {
                ledgerCorrectionForm.setProcessInBatch(!laborDocument.getCorrectionFileDelete());
                ledgerCorrectionForm.setMatchCriteriaOnly(laborDocument.getCorrectionSelection());
                ledgerCorrectionForm.setEditMethod(laborDocument.getCorrectionTypeCode());
                if (laborDocument.getCorrectionInputFileName() != null) {
                    if ("C".equals(laborDocument.getCorrectionTypeCode())) {
                        this.loadPersistedInputGroup(ledgerCorrectionForm);
                        ledgerCorrectionForm.setDeleteFileFlag(false);
                    } else if ("M".equals(laborDocument.getCorrectionTypeCode())) {
                        this.loadPersistedOutputGroup(ledgerCorrectionForm, true);
                        ledgerCorrectionForm.setManualEditFlag(true);
                        ledgerCorrectionForm.setEditableFlag(false);
                        ledgerCorrectionForm.setDeleteFileFlag(false);
                    } else if ("R".equals(laborDocument.getCorrectionTypeCode())) {
                        this.loadPersistedInputGroup(ledgerCorrectionForm);
                        ledgerCorrectionForm.setDeleteFileFlag(true);
                    } else {
                        throw new RuntimeException("Unknown edit method " + laborDocument.getCorrectionTypeCode());
                    }
                    ledgerCorrectionForm.setDataLoadedFlag(true);
                } else {
                    ledgerCorrectionForm.setDataLoadedFlag(false);
                }
                ledgerCorrectionForm.setShowOutputFlag(documentActions.containsKey("canApprove"));
                if (ledgerCorrectionForm.getShowOutputFlag() && !ledgerCorrectionForm.isRestrictedFunctionalityMode()) {
                    this.updateEntriesFromCriteria(ledgerCorrectionForm, false);
                }
                ledgerCorrectionForm.setInputFileName(laborDocument.getCorrectionInputFileName());
                if (laborDocument.getCorrectionInputFileName() != null) {
                    ledgerCorrectionForm.setChooseSystem("U");
                } else {
                    ledgerCorrectionForm.setChooseSystem("D");
                }
                ledgerCorrectionForm.setPreviousChooseSystem(ledgerCorrectionForm.getChooseSystem());
                ledgerCorrectionForm.setPreviousEditMethod(ledgerCorrectionForm.getEditMethod());
                ledgerCorrectionForm.setPreviousInputGroupId(ledgerCorrectionForm.getInputGroupId());
            } else {
                ledgerCorrectionForm.setProcessInBatch(!laborDocument.getCorrectionFileDelete());
                ledgerCorrectionForm.setMatchCriteriaOnly(laborDocument.getCorrectionSelection());
                this.loadPersistedOutputGroup(ledgerCorrectionForm, false);
                ledgerCorrectionForm.setShowOutputFlag(true);
            }
            ledgerCorrectionForm.setInputGroupIdFromLastDocumentLoadIsMissing(!originEntryGroupService.getGroupExists(laborDocument.getCorrectionInputFileName()));
        }
        return mapping.findForward("basic");
    }

    public ActionForward uploadFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FileNotFoundException, IOException, Exception {
        String stringLine;
        PrintStream uploadedFilePrintStream;
        LOG.debug((Object)"uploadFile() started");
        LedgerCorrectionForm ledgerCorrectionForm = (LedgerCorrectionForm)form;
        LedgerCorrectionDocument document = ledgerCorrectionForm.getLaborCorrectionDocument();
        Date now = GeneralLedgerCorrectionProcessAction.dateTimeService.getCurrentDate();
        FormFile sourceFile = ledgerCorrectionForm.getSourceFile();
        String llcpDirectory = ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).getLlcpDirectoryName();
        String fullFileName = llcpDirectory + File.separator + sourceFile.getFileName() + "-" + GeneralLedgerCorrectionProcessAction.dateTimeService.toDateTimeStringForFilename(now);
        BufferedReader br = new BufferedReader(new InputStreamReader(sourceFile.getInputStream()));
        File uploadedFile = new File(fullFileName);
        try {
            uploadedFilePrintStream = new PrintStream(uploadedFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int loadedCount = 0;
        while ((stringLine = br.readLine()) != null) {
            try {
                uploadedFilePrintStream.printf("%s\n", stringLine);
                ++loadedCount;
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }
        uploadedFilePrintStream.close();
        int recordCountFunctionalityLimit = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordCountFunctionalityLimit();
        if (org.kuali.kfs.gl.document.CorrectionDocumentUtils.isRestrictedFunctionalityMode((int)loadedCount, (int)recordCountFunctionalityLimit)) {
            ledgerCorrectionForm.setRestrictedFunctionalityMode(true);
            ledgerCorrectionForm.setDataLoadedFlag(false);
            document.setCorrectionInputFileName(fullFileName);
            ledgerCorrectionForm.setInputFileName(fullFileName);
            if ("M".equals(ledgerCorrectionForm.getEditMethod())) {
                if (recordCountFunctionalityLimit == 0) {
                    GlobalVariables.getMessageMap().putError("systemAndEditMethod", "error.gl.correction.unable.to.manual.edit.any.group", new String[0]);
                } else {
                    GlobalVariables.getMessageMap().putError("systemAndEditMethod", "error.gl.correction.unable.to.manual.edit.large.group", new String[]{String.valueOf(recordCountFunctionalityLimit)});
                }
            }
        } else {
            ledgerCorrectionForm.setRestrictedFunctionalityMode(false);
            if (loadedCount > 0) {
                ArrayList<LaborOriginEntry> originEntryList = new ArrayList<LaborOriginEntry>();
                Map loadMessageMap = this.laborOriginEntryService.getEntriesByGroupIdWithPath(uploadedFile.getAbsolutePath(), originEntryList);
                if (loadMessageMap.size() > 0) {
                    for (Integer lineNumber : loadMessageMap.keySet()) {
                        List messageList = (List)loadMessageMap.get(lineNumber);
                        if (messageList.size() <= 0) continue;
                        for (Message errorMmessage : messageList) {
                            GlobalVariables.getMessageMap().putError("fileUpload", "error.gl.InvalidFormatOriginEntryFromTextFile", new String[]{lineNumber.toString(), errorMmessage.toString()});
                        }
                    }
                    return mapping.findForward("basic");
                }
                ledgerCorrectionForm.setDataLoadedFlag(true);
                ledgerCorrectionForm.setInputFileName(fullFileName);
                document.setCorrectionInputFileName(fullFileName);
                ArrayList<LaborOriginEntry> originEntryFullList = new ArrayList<LaborOriginEntry>();
                originEntryFullList.addAll(originEntryList);
                this.loadAllEntries(originEntryFullList, ledgerCorrectionForm);
                if ("M".equals(ledgerCorrectionForm.getEditMethod())) {
                    ledgerCorrectionForm.setEditableFlag(false);
                    ledgerCorrectionForm.setManualEditFlag(true);
                }
            } else {
                GlobalVariables.getMessageMap().putError("fileUpload", "error.gl.correction.norecords", new String[0]);
            }
        }
        if (document.getCorrectionChangeGroup().isEmpty()) {
            document.addCorrectionChangeGroup(new CorrectionChangeGroup());
        }
        return mapping.findForward("basic");
    }

    protected void loadAllEntries(String fileNameWithPath, LedgerCorrectionForm ledgerCorrectionForm) {
        block6: {
            LOG.debug((Object)"loadAllEntries() started");
            LedgerCorrectionDocument document = ledgerCorrectionForm.getLaborCorrectionDocument();
            if (ledgerCorrectionForm.isRestrictedFunctionalityMode()) break block6;
            ArrayList<LaborOriginEntry> laborSearchResults = new ArrayList<LaborOriginEntry>();
            Map loadMessageMap = this.laborOriginEntryService.getEntriesByGroupIdWithPath(fileNameWithPath, laborSearchResults);
            ArrayList<LaborOriginEntry> searchResults = new ArrayList<LaborOriginEntry>();
            searchResults.addAll(laborSearchResults);
            if (loadMessageMap.size() > 0) {
                for (Integer lineNumber : loadMessageMap.keySet()) {
                    List messageList = (List)loadMessageMap.get(lineNumber);
                    for (Message errorMmessage : messageList) {
                        GlobalVariables.getMessageMap().putError("fileUpload", "error.gl.InvalidFormatOriginEntryFromTextFile", new String[]{lineNumber.toString(), errorMmessage.toString()});
                    }
                }
            } else {
                try {
                    this.loadAllEntries(searchResults, ledgerCorrectionForm);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public ActionForward saveManualEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"saveManualEdit() started");
        LedgerCorrectionForm ledgerCorrectionForm = (LedgerCorrectionForm)form;
        LedgerCorrectionDocument document = ledgerCorrectionForm.getLaborCorrectionDocument();
        if (this.validLaborOriginEntry(ledgerCorrectionForm)) {
            int entryId = ledgerCorrectionForm.getLaborEntryForManualEdit().getEntryId();
            Iterator iter = ledgerCorrectionForm.getAllEntries().iterator();
            while (iter.hasNext()) {
                OriginEntryFull element = (OriginEntryFull)iter.next();
                if (element.getEntryId() != entryId) continue;
                iter.remove();
            }
            ledgerCorrectionForm.updateLaborEntryForManualEdit();
            ledgerCorrectionForm.getAllEntries().add(ledgerCorrectionForm.getLaborEntryForManualEdit());
            ((GlCorrectionProcessOriginEntryService)SpringContext.getBean(GlCorrectionProcessOriginEntryService.class)).persistAllEntries(ledgerCorrectionForm.getGlcpSearchResultsSequenceNumber(), ledgerCorrectionForm.getAllEntries());
            ledgerCorrectionForm.setDisplayEntries(ledgerCorrectionForm.getAllEntries());
            if (ledgerCorrectionForm.getShowOutputFlag()) {
                this.removeNonMatchingEntries(ledgerCorrectionForm.getDisplayEntries(), document.getCorrectionChangeGroup());
            }
            ledgerCorrectionForm.clearLaborEntryForManualEdit();
        }
        this.updateDocumentSummary(document, ledgerCorrectionForm.getAllEntries(), ledgerCorrectionForm.isRestrictedFunctionalityMode());
        this.applyPagingAndSortingFromPreviousPageView(ledgerCorrectionForm);
        return mapping.findForward("basic");
    }

    public ActionForward addManualEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"addManualEdit() started");
        LedgerCorrectionForm ledgerCorrectionForm = (LedgerCorrectionForm)form;
        LedgerCorrectionDocument document = ledgerCorrectionForm.getLaborCorrectionDocument();
        if (this.validLaborOriginEntry(ledgerCorrectionForm)) {
            ledgerCorrectionForm.updateLaborEntryForManualEdit();
            int newEntryId = this.getMaxEntryId(ledgerCorrectionForm.getAllEntries()) + 1;
            ledgerCorrectionForm.getEntryForManualEdit().setEntryId(new Integer(newEntryId));
            ledgerCorrectionForm.getAllEntries().add(ledgerCorrectionForm.getLaborEntryForManualEdit());
            ledgerCorrectionForm.clearLaborEntryForManualEdit();
        }
        this.updateDocumentSummary(document, ledgerCorrectionForm.getAllEntries(), ledgerCorrectionForm.isRestrictedFunctionalityMode());
        ledgerCorrectionForm.setShowSummaryOutputFlag(true);
        ((GlCorrectionProcessOriginEntryService)SpringContext.getBean(GlCorrectionProcessOriginEntryService.class)).persistAllEntries(ledgerCorrectionForm.getGlcpSearchResultsSequenceNumber(), ledgerCorrectionForm.getAllEntries());
        ledgerCorrectionForm.setDisplayEntries(new ArrayList(ledgerCorrectionForm.getAllEntries()));
        if (ledgerCorrectionForm.getShowOutputFlag()) {
            this.removeNonMatchingEntries(ledgerCorrectionForm.getDisplayEntries(), document.getCorrectionChangeGroup());
        }
        this.applyPagingAndSortingFromPreviousPageView(ledgerCorrectionForm);
        return mapping.findForward("basic");
    }

    public ActionForward manualEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        LedgerCorrectionForm ledgerCorrectionForm = (LedgerCorrectionForm)form;
        LedgerCorrectionDocument document = ledgerCorrectionForm.getLaborCorrectionDocument();
        ledgerCorrectionForm.clearLaborEntryForManualEdit();
        ledgerCorrectionForm.clearEntryForManualEdit();
        ledgerCorrectionForm.setEditableFlag(true);
        ledgerCorrectionForm.setManualEditFlag(false);
        if (document.getCorrectionChangeGroup().isEmpty()) {
            document.addCorrectionChangeGroup(new CorrectionChangeGroup());
        }
        return mapping.findForward("basic");
    }

    public ActionForward editManualEntry(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"editManualEdit() started");
        LedgerCorrectionForm ledgerCorrectionForm = (LedgerCorrectionForm)form;
        LedgerCorrectionDocument document = ledgerCorrectionForm.getLaborCorrectionDocument();
        int entryId = Integer.parseInt(this.getImageContext(request, "entryId"));
        for (LaborOriginEntry element : ledgerCorrectionForm.getAllEntries()) {
            if (element.getEntryId() != entryId) continue;
            ledgerCorrectionForm.setLaborEntryForManualEdit(element);
            ledgerCorrectionForm.setLaborEntryFinancialDocumentReversalDate(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getFinancialDocumentReversalDate(), (String)"Date"));
            ledgerCorrectionForm.setLaborEntryTransactionDate(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getTransactionDate(), (String)"Date"));
            ledgerCorrectionForm.setLaborEntryTransactionLedgerEntryAmount(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getTransactionLedgerEntryAmount(), (String)"KualiDecimal"));
            ledgerCorrectionForm.setLaborEntryTransactionLedgerEntrySequenceNumber(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getTransactionLedgerEntrySequenceNumber(), (String)"Integer"));
            ledgerCorrectionForm.setLaborEntryUniversityFiscalYear(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getUniversityFiscalYear(), (String)"Integer"));
            ledgerCorrectionForm.setLaborEntryTransactionPostingDate(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getTransactionPostingDate(), (String)"Date"));
            ledgerCorrectionForm.setLaborEntryPayPeriodEndDate(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getPayPeriodEndDate(), (String)"Date"));
            ledgerCorrectionForm.setLaborEntryTransactionTotalHours(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getTransactionTotalHours(), (String)"BigDecimal"));
            ledgerCorrectionForm.setLaborEntryPayrollEndDateFiscalYear(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getPayrollEndDateFiscalYear(), (String)"Integer"));
            ledgerCorrectionForm.setLaborEntryEmployeeRecord(org.kuali.kfs.gl.document.CorrectionDocumentUtils.convertToString((Object)element.getEmployeeRecord(), (String)"Integer"));
            break;
        }
        ledgerCorrectionForm.setShowSummaryOutputFlag(true);
        return mapping.findForward("basic");
    }

    protected boolean validLaborOriginEntry(LedgerCorrectionForm ledgerCorrectionForm) {
        LOG.debug((Object)"validOriginEntry() started");
        LaborOriginEntry oe = ledgerCorrectionForm.getLaborEntryForManualEdit();
        boolean valid = true;
        LaborOriginEntryFieldFinder loeff = new LaborOriginEntryFieldFinder();
        List fields = loeff.getKeyValues();
        for (KeyValue lkp : fields) {
            String fieldName = lkp.getKey();
            String fieldDisplayName = lkp.getValue();
            String fieldType = loeff.getFieldType(fieldName);
            int fieldLength = loeff.getFieldLength(fieldName);
            String fieldValue = null;
            if ("String".equals(fieldType)) {
                fieldValue = (String)oe.getFieldValue(fieldName);
            } else if ("financialDocumentReversalDate".equals(fieldName)) {
                fieldValue = ledgerCorrectionForm.getLaborEntryFinancialDocumentReversalDate();
            } else if ("transactionDate".equals(fieldName)) {
                fieldValue = ledgerCorrectionForm.getLaborEntryTransactionDate();
            } else if ("transactionLedgerEntrySequenceNumber".equals(fieldName)) {
                fieldValue = ledgerCorrectionForm.getLaborEntryTransactionLedgerEntrySequenceNumber();
            } else if ("transactionLedgerEntryAmount".equals(fieldName)) {
                fieldValue = ledgerCorrectionForm.getLaborEntryTransactionLedgerEntryAmount();
            } else if ("universityFiscalYear".equals(fieldName)) {
                fieldValue = ledgerCorrectionForm.getLaborEntryUniversityFiscalYear();
            } else if ("transactionPostingDate".equals(fieldName)) {
                fieldValue = ledgerCorrectionForm.getLaborEntryTransactionPostingDate();
            } else if ("payPeriodEndDate".equals(fieldName)) {
                fieldValue = ledgerCorrectionForm.getLaborEntryPayPeriodEndDate();
            } else if ("transactionTotalHours".equals(fieldName)) {
                fieldValue = ledgerCorrectionForm.getLaborEntryTransactionTotalHours();
            } else if ("payrollEndDateFiscalYear".equals(fieldName)) {
                fieldValue = ledgerCorrectionForm.getLaborEntryPayrollEndDateFiscalYear();
            } else if ("employeeRecord".equals(fieldName)) {
                fieldValue = ledgerCorrectionForm.getLaborEntryEmployeeRecord();
            }
            if (!StringUtils.isEmpty((String)fieldValue)) {
                if (loeff.isValidValue(fieldName, fieldValue)) continue;
                GlobalVariables.getMessageMap().putError("searchResults", "error.gl.correction.invalid.value", new String[]{fieldDisplayName, fieldValue});
                valid = false;
                continue;
            }
            if (loeff.allowNull(fieldName)) continue;
            GlobalVariables.getMessageMap().putError("searchResults", "error.gl.correction.invalid.value", new String[]{fieldDisplayName, fieldValue});
            valid = false;
        }
        return valid;
    }

    protected void removeNonMatchingEntries(Collection<OriginEntryFull> entries, Collection<CorrectionChangeGroup> groups) {
        Iterator<OriginEntryFull> loei = entries.iterator();
        while (loei.hasNext()) {
            OriginEntryFull oe = loei.next();
            if (CorrectionDocumentUtils.doesLaborEntryMatchAnyCriteriaGroups(oe, groups)) continue;
            loei.remove();
        }
    }

    protected boolean validChangeGroups(GeneralLedgerCorrectionProcessForm generalLedgerCorrectionProcessForm) {
        LOG.debug((Object)"validChangeGroups() started");
        LedgerCorrectionForm form = (LedgerCorrectionForm)generalLedgerCorrectionProcessForm;
        LedgerCorrectionDocument doc = form.getLaborCorrectionDocument();
        String tab = "";
        tab = "C".equals(form.getEditMethod()) ? "editCriteria" : "manualEditCriteria";
        boolean allValid = true;
        LaborOriginEntryFieldFinder loeff = new LaborOriginEntryFieldFinder();
        List fields = loeff.getKeyValues();
        List l = doc.getCorrectionChangeGroup();
        for (CorrectionChangeGroup ccg : l) {
            for (CorrectionCriteria cc : ccg.getCorrectionCriteria()) {
                if (loeff.isValidValue(cc.getCorrectionFieldName(), cc.getCorrectionFieldValue())) continue;
                GlobalVariables.getMessageMap().putError(tab, "error.gl.correction.invalid.value", new String[]{loeff.getFieldDisplayName(cc.getCorrectionFieldName()), cc.getCorrectionFieldValue()});
                allValid = false;
            }
            for (CorrectionCriteria cc : ccg.getCorrectionChange()) {
                if (loeff.isValidValue(cc.getCorrectionFieldName(), cc.getCorrectionFieldValue())) continue;
                GlobalVariables.getMessageMap().putError(tab, "error.gl.correction.invalid.value", new String[]{loeff.getFieldDisplayName(cc.getCorrectionFieldName()), cc.getCorrectionFieldValue()});
                allValid = false;
            }
        }
        return allValid;
    }

    protected void loadPersistedInputGroup(GeneralLedgerCorrectionProcessForm generalLedgerCorrectionProcessForm) throws Exception {
        LedgerCorrectionForm ledgerCorrectionForm = (LedgerCorrectionForm)generalLedgerCorrectionProcessForm;
        LedgerCorrectionDocument document = ledgerCorrectionForm.getLaborCorrectionDocument();
        int recordCountFunctionalityLimit = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordCountFunctionalityLimit();
        LaborCorrectionDocumentService laborCorrectionDocumentService = (LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class);
        if (!laborCorrectionDocumentService.areInputOriginEntriesPersisted(document)) {
            ledgerCorrectionForm.setPersistedOriginEntriesMissing(true);
            ledgerCorrectionForm.setRestrictedFunctionalityMode(true);
            return;
        }
        ledgerCorrectionForm.setPersistedOriginEntriesMissing(false);
        List<LaborOriginEntry> laborSearchResults = laborCorrectionDocumentService.retrievePersistedInputOriginEntries(document, recordCountFunctionalityLimit);
        if (laborSearchResults == null) {
            ledgerCorrectionForm.setRestrictedFunctionalityMode(true);
            this.updateDocumentSummary(document, null, true);
        } else {
            ArrayList<LaborOriginEntry> searchResults = new ArrayList<LaborOriginEntry>();
            searchResults.addAll(laborSearchResults);
            ledgerCorrectionForm.setAllEntries(searchResults);
            ledgerCorrectionForm.setDisplayEntries(new ArrayList(searchResults));
            this.updateDocumentSummary(document, ledgerCorrectionForm.getAllEntries(), false);
            SequenceAccessorService sequenceAccessorService = (SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class);
            String glcpSearchResultsSequenceNumber = String.valueOf(sequenceAccessorService.getNextAvailableSequenceNumber("KRNS_LOOKUP_RSLT_S"));
            ((GlCorrectionProcessOriginEntryService)SpringContext.getBean(GlCorrectionProcessOriginEntryService.class)).persistAllEntries(glcpSearchResultsSequenceNumber, searchResults);
            ledgerCorrectionForm.setGlcpSearchResultsSequenceNumber(glcpSearchResultsSequenceNumber);
            int maxRowsPerPage = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordsPerPage();
            KualiTableRenderFormMetadata originEntrySearchResultTableMetadata = ledgerCorrectionForm.getOriginEntrySearchResultTableMetadata();
            originEntrySearchResultTableMetadata.jumpToFirstPage(ledgerCorrectionForm.getDisplayEntries().size(), maxRowsPerPage);
            originEntrySearchResultTableMetadata.setColumnToSortIndex(-1);
        }
    }

    protected void loadPersistedOutputGroup(GeneralLedgerCorrectionProcessForm generalLedgerCorrectionProcessForm, boolean setSequentialIds) throws Exception {
        LedgerCorrectionForm ledgerCorrectionForm = (LedgerCorrectionForm)generalLedgerCorrectionProcessForm;
        LedgerCorrectionDocument document = ledgerCorrectionForm.getLaborCorrectionDocument();
        LaborCorrectionDocumentService laborCorrectionDocumentService = (LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class);
        if (!laborCorrectionDocumentService.areOutputOriginEntriesPersisted(document)) {
            ledgerCorrectionForm.setPersistedOriginEntriesMissing(true);
            ledgerCorrectionForm.setRestrictedFunctionalityMode(true);
            return;
        }
        ledgerCorrectionForm.setPersistedOriginEntriesMissing(false);
        int recordCountFunctionalityLimit = "M".equals(ledgerCorrectionForm.getEditMethod()) ? -1 : org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordCountFunctionalityLimit();
        List<LaborOriginEntry> laborSearchResults = laborCorrectionDocumentService.retrievePersistedOutputOriginEntries(document, recordCountFunctionalityLimit);
        if (laborSearchResults == null) {
            ledgerCorrectionForm.setRestrictedFunctionalityMode(true);
            WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
            CorrectionDocumentAuthorizer correctionDocumentAuthorizer = new CorrectionDocumentAuthorizer();
        } else {
            ArrayList<LaborOriginEntry> searchResults = new ArrayList<LaborOriginEntry>();
            searchResults.addAll(laborSearchResults);
            ledgerCorrectionForm.setAllEntries(searchResults);
            ledgerCorrectionForm.setDisplayEntries(new ArrayList(searchResults));
            if (setSequentialIds) {
                org.kuali.kfs.gl.document.CorrectionDocumentUtils.setSequentialEntryIds((Collection)ledgerCorrectionForm.getAllEntries());
            }
            this.updateDocumentSummary(document, ledgerCorrectionForm.getAllEntries(), false);
            SequenceAccessorService sequenceAccessorService = (SequenceAccessorService)SpringContext.getBean(SequenceAccessorService.class);
            String glcpSearchResultsSequenceNumber = String.valueOf(sequenceAccessorService.getNextAvailableSequenceNumber("KRNS_LOOKUP_RSLT_S"));
            ((GlCorrectionProcessOriginEntryService)SpringContext.getBean(GlCorrectionProcessOriginEntryService.class)).persistAllEntries(glcpSearchResultsSequenceNumber, searchResults);
            ledgerCorrectionForm.setGlcpSearchResultsSequenceNumber(glcpSearchResultsSequenceNumber);
            int maxRowsPerPage = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordsPerPage();
            KualiTableRenderFormMetadata originEntrySearchResultTableMetadata = ledgerCorrectionForm.getOriginEntrySearchResultTableMetadata();
            originEntrySearchResultTableMetadata.jumpToFirstPage(ledgerCorrectionForm.getDisplayEntries().size(), maxRowsPerPage);
            originEntrySearchResultTableMetadata.setColumnToSortIndex(-1);
        }
    }

    protected boolean prepareForRoute(GeneralLedgerCorrectionProcessForm generalLedgerCorrectionProcessForm) throws Exception {
        LedgerCorrectionForm ledgerCorrectionForm = (LedgerCorrectionForm)generalLedgerCorrectionProcessForm;
        LedgerCorrectionDocument document = ledgerCorrectionForm.getLaborCorrectionDocument();
        if (StringUtils.isEmpty((String)document.getDocumentHeader().getDocumentDescription())) {
            GlobalVariables.getMessageMap().putError("document.documentHeader.documentDescription", "error.document.noDescription", new String[0]);
            return false;
        }
        if (ledgerCorrectionForm.isPersistedOriginEntriesMissing()) {
            GlobalVariables.getMessageMap().putError("searchResults", "error.gl.correction.persisted.origin.entries.missing", new String[0]);
            return false;
        }
        if (!this.checkMainDropdown(ledgerCorrectionForm)) {
            return false;
        }
        if (ledgerCorrectionForm.getDataLoadedFlag() || ledgerCorrectionForm.isRestrictedFunctionalityMode()) {
            document.setCorrectionInputFileName(generalLedgerCorrectionProcessForm.getInputGroupId());
        } else {
            document.setCorrectionInputFileName(null);
        }
        if (!this.checkOriginEntryGroupSelectionBeforeRouting(document)) {
            return false;
        }
        if (GlobalVariables.getMessageMap().containsMessageKey("error.gl.correction.invalid.system.or.edit.method.change")) {
            return false;
        }
        if (GlobalVariables.getMessageMap().containsMessageKey("error.gl.correction.invalid.input.group.change")) {
            return false;
        }
        if (!this.validGroupsItemsForDocumentSave(ledgerCorrectionForm)) {
            return false;
        }
        if ("C".equals(ledgerCorrectionForm.getEditMethod()) && !this.validChangeGroups(ledgerCorrectionForm)) {
            return false;
        }
        if (!this.checkRestrictedFunctionalityModeForManualEdit(ledgerCorrectionForm)) {
            return false;
        }
        if (!this.checkInputGroupPersistedForDocumentSave(ledgerCorrectionForm)) {
            return false;
        }
        if ("C".equals(ledgerCorrectionForm.getEditMethod())) {
            if (!ledgerCorrectionForm.isRestrictedFunctionalityMode() && ledgerCorrectionForm.getDataLoadedFlag() && !ledgerCorrectionForm.getShowOutputFlag()) {
                this.updateEntriesFromCriteria(ledgerCorrectionForm, false);
            }
            ledgerCorrectionForm.setShowOutputFlag(true);
        } else {
            document.getCorrectionChangeGroup().clear();
        }
        document.setCorrectionTypeCode(ledgerCorrectionForm.getEditMethod());
        document.setCorrectionSelection(ledgerCorrectionForm.getMatchCriteriaOnly());
        document.setCorrectionFileDelete(!ledgerCorrectionForm.getProcessInBatch());
        document.setCorrectionInputFileName(ledgerCorrectionForm.getInputGroupId());
        document.setCorrectionOutputFileName(null);
        document.setCorrectionOutputFileName(null);
        ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).persistOriginEntryGroupsForDocumentSave(document, (CorrectionDocumentEntryMetadata)ledgerCorrectionForm);
        return true;
    }

    public ActionForward saveToDesktop(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOG.debug((Object)"saveToDesktop() started");
        LedgerCorrectionForm ledgerCorrectionForm = (LedgerCorrectionForm)form;
        if (this.checkOriginEntryGroupSelection(ledgerCorrectionForm)) {
            if (ledgerCorrectionForm.isInputGroupIdFromLastDocumentLoadIsMissing() && ledgerCorrectionForm.getInputGroupIdFromLastDocumentLoad() != null && ledgerCorrectionForm.getInputGroupIdFromLastDocumentLoad().equals(ledgerCorrectionForm.getInputGroupId())) {
                if (ledgerCorrectionForm.isPersistedOriginEntriesMissing()) {
                    GlobalVariables.getMessageMap().putError("documentsInSystem", "error.labor.correction.persisted.origin.entries.missing", new String[0]);
                    return mapping.findForward("basic");
                }
                String fileName = "llcp_archived_group_" + ledgerCorrectionForm.getInputGroupIdFromLastDocumentLoad().toString() + ".txt";
                response.setContentType("application/txt");
                response.setHeader("Content-disposition", "attachment; filename=" + fileName);
                response.setHeader("Expires", "0");
                response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                response.setHeader("Pragma", "public");
                BufferedOutputStream bw = new BufferedOutputStream((OutputStream)response.getOutputStream());
                ((CorrectionDocumentService)SpringContext.getBean(CorrectionDocumentService.class)).writePersistedInputOriginEntriesToStream((GeneralLedgerCorrectionProcessDocument)((LedgerCorrectionDocument)ledgerCorrectionForm.getDocument()), (OutputStream)bw);
                bw.flush();
                bw.close();
                return null;
            }
            String batchDirectory = ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).getBatchFileDirectoryName();
            String fileNameWithPath = !ledgerCorrectionForm.getInputGroupId().contains(batchDirectory) ? batchDirectory + File.separator + ledgerCorrectionForm.getInputGroupId() : ledgerCorrectionForm.getInputGroupId();
            FileReader fileReader = new FileReader(fileNameWithPath);
            BufferedReader br = new BufferedReader(fileReader);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.buildTextOutputfile(baos, br);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/txt", (ByteArrayOutputStream)baos, (String)ledgerCorrectionForm.getInputGroupId());
            br.close();
            return null;
        }
        return mapping.findForward("basic");
    }

    public ActionForward sort(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LedgerCorrectionForm correctionForm = (LedgerCorrectionForm)form;
        correctionForm.registerEditableProperty("methodToCall");
        int maxRowsPerPage = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordsPerPage();
        KualiTableRenderFormMetadata originEntrySearchResultTableMetadata = correctionForm.getOriginEntrySearchResultTableMetadata();
        List<Column> columns = ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).getTableRenderColumnMetadata(correctionForm.getDocument().getDocumentNumber());
        String propertyToSortName = columns.get(originEntrySearchResultTableMetadata.getColumnToSortIndex()).getPropertyName();
        Comparator valueComparator = columns.get(originEntrySearchResultTableMetadata.getColumnToSortIndex()).getValueComparator();
        boolean sortDescending = false;
        if (originEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex() == originEntrySearchResultTableMetadata.getColumnToSortIndex()) {
            sortDescending = !originEntrySearchResultTableMetadata.isSortDescending();
            originEntrySearchResultTableMetadata.setSortDescending(sortDescending);
        }
        originEntrySearchResultTableMetadata.setSortDescending(sortDescending);
        this.sortList(correctionForm.getDisplayEntries(), propertyToSortName, valueComparator, sortDescending);
        originEntrySearchResultTableMetadata.jumpToFirstPage(correctionForm.getDisplayEntries().size(), maxRowsPerPage);
        return mapping.findForward("basic");
    }

    protected void applyPagingAndSortingFromPreviousPageView(LedgerCorrectionForm ledgerCorrectionForm) {
        KualiTableRenderFormMetadata originEntrySearchResultTableMetadata = ledgerCorrectionForm.getOriginEntrySearchResultTableMetadata();
        if (originEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex() != -1) {
            List<Column> columns = ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).getTableRenderColumnMetadata(ledgerCorrectionForm.getDocument().getDocumentNumber());
            String propertyToSortName = columns.get(originEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex()).getPropertyName();
            Comparator valueComparator = columns.get(originEntrySearchResultTableMetadata.getPreviouslySortedColumnIndex()).getValueComparator();
            this.sortList(ledgerCorrectionForm.getDisplayEntries(), propertyToSortName, valueComparator, originEntrySearchResultTableMetadata.isSortDescending());
        }
        int maxRowsPerPage = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordsPerPage();
        originEntrySearchResultTableMetadata.jumpToPage(originEntrySearchResultTableMetadata.getViewedPageNumber(), ledgerCorrectionForm.getDisplayEntries().size(), maxRowsPerPage);
    }

    protected boolean checkInputGroupPersistedForDocumentSave(GeneralLedgerCorrectionProcessForm generalLedgerCorrectionProcessForm) {
        LedgerCorrectionForm ledgerCorrectionForm = (LedgerCorrectionForm)generalLedgerCorrectionProcessForm;
        WorkflowDocument workflowDocument = ledgerCorrectionForm.getDocument().getDocumentHeader().getWorkflowDocument();
        boolean present = workflowDocument.isInitiated() || workflowDocument.isSaved() && (ledgerCorrectionForm.getInputGroupIdFromLastDocumentLoad() == null || !ledgerCorrectionForm.getInputGroupIdFromLastDocumentLoad().equals(ledgerCorrectionForm.getInputGroupId())) ? originEntryGroupService.getGroupExists(((LedgerCorrectionDocument)ledgerCorrectionForm.getDocument()).getCorrectionInputFileName()) : ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).areInputOriginEntriesPersisted((LedgerCorrectionDocument)ledgerCorrectionForm.getDocument());
        if (!present) {
            GlobalVariables.getMessageMap().putError("systemAndEditMethod", "error.gl.correction.persisted.origin.entries.missing", new String[0]);
        }
        return present;
    }

    public ActionForward selectSystemEditMethod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"selectSystemEditMethod() started");
        LedgerCorrectionForm ledgerCorrectionForm = (LedgerCorrectionForm)form;
        LedgerCorrectionDocument document = ledgerCorrectionForm.getLaborCorrectionDocument();
        if (this.checkMainDropdown(ledgerCorrectionForm)) {
            document.setCorrectionInputFileName(null);
            document.setCorrectionOutputFileName(null);
            document.setCorrectionCreditTotalAmount(null);
            document.setCorrectionDebitTotalAmount(null);
            document.setCorrectionBudgetTotalAmount(null);
            document.setCorrectionRowCount(null);
            document.getCorrectionChangeGroup().clear();
            ledgerCorrectionForm.setDataLoadedFlag(false);
            ledgerCorrectionForm.setDeleteFileFlag(false);
            ledgerCorrectionForm.setEditableFlag(false);
            ledgerCorrectionForm.setManualEditFlag(false);
            ledgerCorrectionForm.setShowOutputFlag(false);
            ledgerCorrectionForm.setAllEntries(new ArrayList());
            ledgerCorrectionForm.setRestrictedFunctionalityMode(false);
            ledgerCorrectionForm.setProcessInBatch(true);
            if ("D".equals(ledgerCorrectionForm.getChooseSystem())) {
                CorrectionLaborGroupEntriesFinder f = new CorrectionLaborGroupEntriesFinder();
                List<KeyValue> values = f.getKeyValues();
                if (values.size() > 0) {
                    String newestScrubberErrorFileName = GeneralLedgerCorrectionProcessAction.originEntryGroupService.getNewestScrubberErrorFileName();
                    if (newestScrubberErrorFileName != null) {
                        document.setCorrectionInputFileName(newestScrubberErrorFileName);
                    } else {
                        KeyValue klp = values.get(0);
                        document.setCorrectionInputFileName(klp.getKey());
                    }
                } else {
                    GlobalVariables.getMessageMap().putError("systemAndEditMethod", "error.gl.NoOriginEntryGroups", new String[0]);
                    ledgerCorrectionForm.setChooseSystem("");
                }
            }
        } else {
            ledgerCorrectionForm.setEditMethod("");
            ledgerCorrectionForm.setChooseSystem("");
        }
        ledgerCorrectionForm.setPreviousChooseSystem(ledgerCorrectionForm.getChooseSystem());
        ledgerCorrectionForm.setPreviousEditMethod(ledgerCorrectionForm.getEditMethod());
        ledgerCorrectionForm.setPreviousInputGroupId(null);
        return mapping.findForward("basic");
    }

    public ActionForward loadGroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"loadGroup() started");
        LedgerCorrectionForm ledgerCorrectionForm = (LedgerCorrectionForm)form;
        String batchDirectory = ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).getBatchFileDirectoryName();
        if (this.checkOriginEntryGroupSelection(ledgerCorrectionForm)) {
            LedgerCorrectionDocument document;
            LedgerCorrectionDocument doc = ledgerCorrectionForm.getLaborCorrectionDocument();
            doc.setCorrectionInputFileName(batchDirectory + File.separator + ledgerCorrectionForm.getInputGroupId());
            int inputGroupSize = this.laborOriginEntryService.getGroupCount(ledgerCorrectionForm.getInputGroupId());
            int recordCountFunctionalityLimit = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordCountFunctionalityLimit();
            ledgerCorrectionForm.setPersistedOriginEntriesMissing(false);
            if (org.kuali.kfs.gl.document.CorrectionDocumentUtils.isRestrictedFunctionalityMode((int)inputGroupSize, (int)recordCountFunctionalityLimit)) {
                ledgerCorrectionForm.setRestrictedFunctionalityMode(true);
                ledgerCorrectionForm.setDataLoadedFlag(false);
                this.updateDocumentSummary(ledgerCorrectionForm.getCorrectionDocument(), null, true);
                if ("M".equals(ledgerCorrectionForm.getEditMethod())) {
                    if (recordCountFunctionalityLimit == 0) {
                        GlobalVariables.getMessageMap().putError("systemAndEditMethod", "error.gl.correction.unable.to.manual.edit.any.group", new String[0]);
                    } else {
                        GlobalVariables.getMessageMap().putError("systemAndEditMethod", "error.gl.correction.unable.to.manual.edit.large.group", new String[]{String.valueOf(recordCountFunctionalityLimit)});
                    }
                }
            } else {
                ledgerCorrectionForm.setRestrictedFunctionalityMode(false);
                this.loadAllEntries(ledgerCorrectionForm.getInputGroupId(), ledgerCorrectionForm);
                if (ledgerCorrectionForm.getAllEntries().size() > 0) {
                    if ("M".equals(ledgerCorrectionForm.getEditMethod())) {
                        ledgerCorrectionForm.setManualEditFlag(true);
                        ledgerCorrectionForm.setEditableFlag(false);
                        ledgerCorrectionForm.setDeleteFileFlag(false);
                    }
                    ledgerCorrectionForm.setDataLoadedFlag(true);
                } else {
                    GlobalVariables.getMessageMap().putError("documentsInSystem", "error.gl.correction.norecords", new String[0]);
                }
            }
            if ((document = ledgerCorrectionForm.getLaborCorrectionDocument()).getCorrectionChangeGroup().isEmpty()) {
                document.addCorrectionChangeGroup(new CorrectionChangeGroup());
            }
            ledgerCorrectionForm.setPreviousInputGroupId(ledgerCorrectionForm.getInputGroupId());
        }
        ledgerCorrectionForm.setShowOutputFlag(false);
        return mapping.findForward("basic");
    }

    public ActionForward confirmDeleteDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"confirmDeleteDocument() started");
        LedgerCorrectionForm correctionForm = (LedgerCorrectionForm)form;
        if (this.checkOriginEntryGroupSelection(correctionForm)) {
            int recordCountFunctionalityLimit;
            String batchDirectory = ((LaborCorrectionDocumentService)SpringContext.getBean(LaborCorrectionDocumentService.class)).getBatchFileDirectoryName();
            String doneFileName = batchDirectory + File.separator + correctionForm.getInputGroupId();
            String dataFileName = doneFileName.replace(".done", ".data");
            int groupCount = this.laborOriginEntryService.getGroupCount(dataFileName);
            if (!org.kuali.kfs.gl.document.CorrectionDocumentUtils.isRestrictedFunctionalityMode((int)groupCount, (int)(recordCountFunctionalityLimit = org.kuali.kfs.gl.document.CorrectionDocumentUtils.getRecordCountFunctionalityLimit()))) {
                this.loadAllEntries(dataFileName, correctionForm);
                correctionForm.setDeleteFileFlag(true);
                correctionForm.setDataLoadedFlag(true);
                correctionForm.setRestrictedFunctionalityMode(false);
            } else {
                correctionForm.setRestrictedFunctionalityMode(true);
            }
            LedgerCorrectionDocument document = (LedgerCorrectionDocument)correctionForm.getDocument();
            document.setCorrectionInputFileName(dataFileName);
        }
        return mapping.findForward("basic");
    }
}

