/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.kfs.gl.OJBUtility;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.businessobject.lookup.LedgerBalanceForExpenseTransferLookupableHelperServiceImpl;
import org.kuali.kfs.module.ld.util.ConsolidationUtil;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.rice.krad.bo.BusinessObject;

public class LedgerBalanceForSalaryExpenseTransferLookupableHelperServiceImpl
extends LedgerBalanceForExpenseTransferLookupableHelperServiceImpl {
    private static final Logger LOG = Logger.getLogger(LedgerBalanceForSalaryExpenseTransferLookupableHelperServiceImpl.class);
    private OptionsService optionsService;

    @Override
    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        LOG.debug((Object)"Start getSearchResults()");
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        String fiscalYearString = fieldValues.get("universityFiscalYear");
        SystemOptions options = this.getOptions(fiscalYearString);
        if (ObjectUtils.isNull((Object)options)) {
            return new CollectionIncomplete(new ArrayList(), new Long(0L));
        }
        fieldValues.put("financialObjectTypeCode", options.getFinObjTypeExpenditureexpCd());
        fieldValues.put("laborObject.financialObjectFringeOrSalaryCode", "S");
        fieldValues.put("financialBalanceTypeCode", options.getActualFinancialBalanceTypeCd());
        Collection actualBalances = this.buildDetailedBalanceCollection(this.getBalanceService().findBalance(fieldValues, false, this.getEncumbranceBalanceTypes(fieldValues), true), "No");
        fieldValues.put("financialBalanceTypeCode", "A2");
        Collection effortBalances = this.buildDetailedBalanceCollection(this.getBalanceService().findBalance(fieldValues, false, this.getEncumbranceBalanceTypes(fieldValues), true), "No");
        List<String> consolidationKeyList = LedgerBalance.getPrimaryKeyList();
        Collection<LedgerBalance> consolidatedBalances = ConsolidationUtil.consolidateA2Balances(actualBalances, effortBalances, options.getActualFinancialBalanceTypeCd(), consolidationKeyList);
        Integer recordCount = this.getBalanceService().getBalanceRecordCount(fieldValues, true, this.getEncumbranceBalanceTypes(fieldValues), true);
        Long actualSize = OJBUtility.getResultActualSize(consolidatedBalances, (Integer)recordCount, fieldValues, (Object)((Object)new LedgerBalance()));
        return this.buildSearchResultList(consolidatedBalances, actualSize);
    }

    public void validateSearchParameters(Map fieldValues) {
        String fiscalYearString = (String)fieldValues.get("universityFiscalYear");
        SystemOptions options = this.getOptions(fiscalYearString);
        if (ObjectUtils.isNull((Object)options)) {
            DataDictionaryService dictionaryService = (DataDictionaryService)SpringContext.getBean(DataDictionaryService.class);
            String label = dictionaryService.getAttributeLabel(LedgerBalance.class, "universityFiscalYear");
            GlobalVariables.getMessageMap().putError("universityFiscalYear", "error.existence", new String[]{label});
        }
    }

    private SystemOptions getOptions(String fiscalYearString) {
        SystemOptions options;
        if (fiscalYearString == null) {
            options = this.optionsService.getCurrentYearOptions();
        } else {
            Integer fiscalYear = Integer.valueOf(fiscalYearString.trim());
            options = this.optionsService.getOptions(fiscalYear);
        }
        return options;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }
}

