/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.document.LaborExpenseTransferDocumentBase;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class LaborExpenseTransferValidAccountValidation
extends GenericValidation {
    private Document documentForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        boolean result = true;
        Document documentForValidation = this.getDocumentForValidation();
        LaborExpenseTransferDocumentBase expenseTransferDocument = (LaborExpenseTransferDocumentBase)documentForValidation;
        if (!this.isValidAccount(expenseTransferDocument)) {
            return false;
        }
        return result;
    }

    public boolean isValidAccount(LaborExpenseTransferDocumentBase expenseTransferDocument) {
        AccountingLine line;
        for (Object sourceAccountingLine : expenseTransferDocument.getSourceAccountingLines()) {
            line = (AccountingLine)sourceAccountingLine;
            if (!ObjectUtils.isNull((Object)line.getAccount())) continue;
            GlobalVariables.getMessageMap().putError("sourceAccountingLines", "error.document.accountGlobalDetails.invalidAccount", new String[]{line.getChartOfAccountsCode(), line.getAccountNumber()});
            return false;
        }
        for (Object targetAccountingLine : expenseTransferDocument.getTargetAccountingLines()) {
            line = (AccountingLine)targetAccountingLine;
            if (!ObjectUtils.isNull((Object)line.getAccount())) continue;
            GlobalVariables.getMessageMap().putError("targetAccountingLines", "error.document.accountGlobalDetails.invalidAccount", new String[]{line.getChartOfAccountsCode(), line.getAccountNumber()});
            return false;
        }
        return true;
    }

    public Document getDocumentForValidation() {
        return this.documentForValidation;
    }

    public void setDocumentForValidation(Document documentForValidation) {
        this.documentForValidation = documentForValidation;
    }
}

