/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.inquiry;

import java.util.Properties;
import org.kuali.kfs.kns.inquiry.KualiInquirableImpl;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferSourceAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferTargetAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.bo.BusinessObject;

public class ExpenseTransferAccountingLineInquirable
extends KualiInquirableImpl {
    protected static final String FRINGE_BENEFIT_METHOD_TO_CALL = "calculateFringeBenefit";
    protected static final String FRINGE_BENEFIT_INQUIRY_PAGE_NAME = "/fringeBenefitInquiry.do";

    public HtmlData getInquiryUrl(BusinessObject businessObject, String attributeName, boolean forceInquiry) {
        if ((businessObject instanceof ExpenseTransferSourceAccountingLine || businessObject instanceof ExpenseTransferTargetAccountingLine) && attributeName.equalsIgnoreCase("fringeBenefitView")) {
            Object objFieldValue = ObjectUtils.getPropertyValue((Object)businessObject, (String)attributeName);
            Properties parameters = new Properties();
            if (businessObject instanceof ExpenseTransferSourceAccountingLine) {
                ExpenseTransferSourceAccountingLine sourceAccountingLine = (ExpenseTransferSourceAccountingLine)businessObject;
                parameters.put("chartOfAccountsCode", sourceAccountingLine.getChartOfAccountsCode());
                parameters.put("accountNumber", sourceAccountingLine.getAccountNumber());
                parameters.put("subAccountNumber", ObjectUtils.isNotNull((Object)sourceAccountingLine.getSubAccountNumber()) ? sourceAccountingLine.getSubAccountNumber() : "");
                parameters.put("financialObjectCode", sourceAccountingLine.getObjectCode().getFinancialObjectCode());
                parameters.put("payrollEndDateFiscalYear", sourceAccountingLine.getPayrollEndDateFiscalYear().toString());
                parameters.put("amount", sourceAccountingLine.getAmount().toString());
                parameters.put("methodToCall", FRINGE_BENEFIT_METHOD_TO_CALL);
            } else if (businessObject instanceof ExpenseTransferTargetAccountingLine) {
                ExpenseTransferTargetAccountingLine targetAccountingLine = (ExpenseTransferTargetAccountingLine)businessObject;
                parameters.put("chartOfAccountsCode", targetAccountingLine.getChartOfAccountsCode());
                parameters.put("accountNumber", targetAccountingLine.getAccountNumber());
                parameters.put("subAccountNumber", ObjectUtils.isNotNull((Object)targetAccountingLine.getSubAccountNumber()) ? targetAccountingLine.getSubAccountNumber() : "");
                parameters.put("financialObjectCode", targetAccountingLine.getObjectCode().getFinancialObjectCode());
                parameters.put("payrollEndDateFiscalYear", targetAccountingLine.getPayrollEndDateFiscalYear().toString());
                parameters.put("amount", targetAccountingLine.getAmount().toString());
                parameters.put("methodToCall", FRINGE_BENEFIT_METHOD_TO_CALL);
            }
            String fieldValue = objFieldValue == null ? "" : objFieldValue.toString();
            String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
            String url = UrlFactory.parameterizeUrl((String)(basePath + FRINGE_BENEFIT_INQUIRY_PAGE_NAME), (Properties)parameters);
            return new HtmlData.AnchorHtmlData(url, "");
        }
        return super.getInquiryUrl(businessObject, attributeName, forceInquiry);
    }
}

