/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.document.LaborExpenseTransferDocumentBase;
import org.kuali.kfs.module.ld.util.LaborPendingEntryGenerator;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.context.SpringContext;

public class BenefitExpenseTransferDocument
extends LaborExpenseTransferDocumentBase {
    protected static final Log LOG = LogFactory.getLog(BenefitExpenseTransferDocument.class);
    protected transient String chartOfAccountsCode;
    protected transient String accountNumber;
    protected transient Account account;

    @Override
    public boolean generateLaborLedgerPendingEntries(AccountingLine accountingLine, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        LOG.debug((Object)"started processGenerateLaborLedgerPendingEntries()");
        boolean isSuccessful = true;
        ExpenseTransferAccountingLine expenseTransferAccountingLine = (ExpenseTransferAccountingLine)accountingLine;
        List<LaborLedgerPendingEntry> expensePendingEntries = LaborPendingEntryGenerator.generateExpensePendingEntries(this, expenseTransferAccountingLine, sequenceHelper);
        if (expensePendingEntries != null && !expensePendingEntries.isEmpty()) {
            isSuccessful &= this.getLaborLedgerPendingEntries().addAll(expensePendingEntries);
        }
        return isSuccessful;
    }

    @Override
    public boolean generateLaborLedgerBenefitClearingPendingEntries(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        return true;
    }

    @Override
    public List getLaborLedgerPendingEntriesForSearching() {
        return super.getLaborLedgerPendingEntries();
    }

    public String getChartOfAccountsCode() {
        AccountService accountService = (AccountService)SpringContext.getBean(AccountService.class);
        if (!accountService.accountsCanCrossCharts() && ObjectUtils.isNotNull((Object)this.account)) {
            this.chartOfAccountsCode = this.account.getChartOfAccountsCode();
        }
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        AccountService accountService;
        this.accountNumber = accountNumber;
        if (StringUtils.isNotEmpty((String)accountNumber) && !(accountService = (AccountService)SpringContext.getBean(AccountService.class)).accountsCanCrossCharts()) {
            Account acct = accountService.getUniqueAccountForAccountNumber(accountNumber);
            this.setChartOfAccountsCode(acct.getChartOfAccountsCode());
            this.setAccount(acct);
        }
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }
}

