/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.module.ld.businessobject.ErrorCertification;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.document.ErrorCertifiable;
import org.kuali.kfs.module.ld.document.LaborExpenseTransferDocumentBase;
import org.kuali.kfs.module.ld.util.LaborPendingEntryGenerator;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.businessobject.TargetAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class SalaryExpenseTransferDocument
extends LaborExpenseTransferDocumentBase
implements ErrorCertifiable {
    protected static final Log LOG = LogFactory.getLog(SalaryExpenseTransferDocument.class);
    protected Map<String, KualiDecimal> approvalObjectCodeBalances = new HashMap<String, KualiDecimal>();
    protected ErrorCertification errorCertification;

    public Map<String, KualiDecimal> getApprovalObjectCodeBalances() {
        return this.approvalObjectCodeBalances;
    }

    public void setApprovalObjectCodeBalances(Map<String, KualiDecimal> approvalObjectCodeBalances) {
        this.approvalObjectCodeBalances = approvalObjectCodeBalances;
    }

    @Override
    public ErrorCertification getErrorCertification() {
        return this.errorCertification;
    }

    @Override
    public void setErrorCertification(ErrorCertification errorCertification) {
        this.errorCertification = errorCertification;
    }

    @Override
    public boolean generateLaborLedgerPendingEntries(AccountingLine accountingLine, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        List<LaborLedgerPendingEntry> benefitPendingEntries;
        LOG.debug((Object)"started generateLaborLedgerPendingEntries()");
        boolean isSuccessful = true;
        ExpenseTransferAccountingLine expenseTransferAccountingLine = (ExpenseTransferAccountingLine)accountingLine;
        List<LaborLedgerPendingEntry> expensePendingEntries = LaborPendingEntryGenerator.generateExpensePendingEntries(this, expenseTransferAccountingLine, sequenceHelper);
        if (expensePendingEntries != null && !expensePendingEntries.isEmpty()) {
            isSuccessful &= this.getLaborLedgerPendingEntries().addAll(expensePendingEntries);
        }
        if ((benefitPendingEntries = LaborPendingEntryGenerator.generateBenefitPendingEntries(this, expenseTransferAccountingLine, sequenceHelper)) != null && !benefitPendingEntries.isEmpty()) {
            isSuccessful &= this.getLaborLedgerPendingEntries().addAll(benefitPendingEntries);
        }
        return isSuccessful;
    }

    @Override
    public boolean generateLaborLedgerBenefitClearingPendingEntries(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        LOG.debug((Object)"started generateLaborLedgerBenefitClearingPendingEntries()");
        String chartOfAccountsCode = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(SalaryExpenseTransferDocument.class, "BENEFIT_CLEARING_CHART_OF_ACCOUNTS");
        String accountNumber = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(SalaryExpenseTransferDocument.class, "BENEFIT_CLEARING_ACCOUNT_NUMBER");
        List<LaborLedgerPendingEntry> benefitClearingPendingEntries = LaborPendingEntryGenerator.generateBenefitClearingPendingEntries(this, sequenceHelper, accountNumber, chartOfAccountsCode);
        if (benefitClearingPendingEntries != null && !benefitClearingPendingEntries.isEmpty()) {
            return this.getLaborLedgerPendingEntries().addAll(benefitClearingPendingEntries);
        }
        return true;
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (nodeName.equals("RequiresWorkstudyReview")) {
            return this.checkOjbectCodeForWorkstudy();
        }
        return super.answerSplitNodeQuestion(nodeName);
    }

    protected boolean checkOjbectCodeForWorkstudy() {
        Collection workstudyRouteObjectcodes = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(KfsParameterConstants.FINANCIAL_SYSTEM_DOCUMENT.class, "WORKSTUDY_ROUTE_OBJECT_CODES");
        List sourceAccountingLines = this.getSourceAccountingLines();
        List targetAccountingLines = this.getTargetAccountingLines();
        for (SourceAccountingLine sourceLine : sourceAccountingLines) {
            if (!workstudyRouteObjectcodes.contains(sourceLine.getFinancialObjectCode())) continue;
            return true;
        }
        for (TargetAccountingLine targetLine : targetAccountingLines) {
            if (!workstudyRouteObjectcodes.contains(targetLine.getFinancialObjectCode())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void prepareForSave(KualiDocumentEvent event) {
        super.prepareForSave(event);
        for (LaborLedgerPendingEntry laborLedgerPendingEntry : this.getLaborLedgerPendingEntries()) {
            String personName = ((FinancialSystemUserService)SpringContext.getBean(FinancialSystemUserService.class)).getPersonNameByEmployeeId(this.getEmplid());
            BusinessObjectEntry laborLedgerPendingEntryBusinessObjectEntry = SalaryExpenseTransferDocument.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(LaborLedgerPendingEntry.class.getName());
            AttributeDefinition laborLedgerPendingEntryAttribute = laborLedgerPendingEntryBusinessObjectEntry.getAttributeDefinition("transactionLedgerEntryDescription");
            int descriptionLength = laborLedgerPendingEntryAttribute.getMaxLength();
            laborLedgerPendingEntry.setTransactionLedgerEntryDescription(personName.length() > descriptionLength ? personName.substring(0, descriptionLength - 1) : personName);
        }
        if (this.errorCertification != null) {
            this.errorCertification.setDocumentNumber(this.documentNumber);
        }
    }

    @Override
    public List getLaborLedgerPendingEntriesForSearching() {
        return super.getLaborLedgerPendingEntries();
    }
}

