/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.web.struts;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.web.struts.ExpenseTransferDocumentFormBase;
import org.kuali.rice.core.web.format.CurrencyFormatter;

public class SalaryExpenseTransferForm
extends ExpenseTransferDocumentFormBase {
    protected static Log LOG = LogFactory.getLog(SalaryExpenseTransferForm.class);
    protected String balanceTypeCode;

    public SalaryExpenseTransferForm() {
        this.setFinancialBalanceTypeCode("AC");
        this.setLookupResultsBOClassName(LedgerBalance.class.getName());
        this.setFormatterType("document.approvalObjectCodeBalances", CurrencyFormatter.class);
    }

    protected String getDefaultDocumentTypeName() {
        return "ST";
    }

    public String getFinancialBalanceTypeCode() {
        return this.balanceTypeCode;
    }

    public void setFinancialBalanceTypeCode(String balanceTypeCode) {
        this.balanceTypeCode = balanceTypeCode;
    }

    public void populate(HttpServletRequest request) {
        super.populate(request);
    }

    public SalaryExpenseTransferDocument getSalaryExpenseTransferDocument() {
        return (SalaryExpenseTransferDocument)this.getDocument();
    }

    @Override
    public Map getForcedReadOnlyTargetFields() {
        Map map = this.getForcedReadOnlySourceFields();
        map.remove("chartOfAccountsCode");
        map.remove("accountNumber");
        map.remove("subAccountNumber");
        map.remove("financialSubObjectCode");
        map.remove("projectCode");
        map.remove("organizationReferenceId");
        map.remove("amount");
        return map;
    }

    @Override
    public void populateSearchFields() {
        List sourceAccoutingLines = this.getSalaryExpenseTransferDocument().getSourceAccountingLines();
        if (sourceAccoutingLines != null && !sourceAccoutingLines.isEmpty()) {
            ExpenseTransferAccountingLine sourceAccountingLine = (ExpenseTransferAccountingLine)sourceAccoutingLines.get(0);
            this.setUniversityFiscalYear(sourceAccountingLine.getPostingYear());
        }
    }
}

