/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.fp.document.JournalVoucherDocument;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.datadictionary.AttributeDefinition;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntry;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.document.validation.impl.LaborJournalVoucherAccountingPeriodValidation;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.util.AutoPopulatingList;

public class LaborJournalVoucherAccountingPeriodValidationTest {
    private LaborJournalVoucherAccountingPeriodValidation cut;
    @Mock
    private AccountingPeriod accountingPeriodMock;
    @Mock
    private AttributeDefinition attributeDefinitionMock;
    @Mock
    private DataDictionary dataDictionaryMock;
    @Mock
    private DataDictionaryEntry dataDictionaryEntryMock;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private JournalVoucherDocument journalVoucherDocMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.setupDataDictionaryMocking();
        this.setupAccountingPeriodMocking();
        this.cut = new LaborJournalVoucherAccountingPeriodValidation();
        this.cut.setDataDictionaryService(this.dataDictionarySvcMock);
        this.cut.setJournalVoucherForValidation(this.journalVoucherDocMock);
    }

    private void setupDataDictionaryMocking() {
        Mockito.when((Object)this.attributeDefinitionMock.getLabel()).thenReturn((Object)"Accounting Period");
        Mockito.when((Object)this.dataDictionaryEntryMock.getAttributeDefinition("accountingPeriod")).thenReturn((Object)this.attributeDefinitionMock);
        Mockito.when((Object)this.dataDictionaryMock.getDictionaryObjectEntry(JournalVoucherDocument.class.getName())).thenReturn((Object)this.dataDictionaryEntryMock);
        Mockito.when((Object)this.dataDictionarySvcMock.getDataDictionary()).thenReturn((Object)this.dataDictionaryMock);
    }

    private void setupAccountingPeriodMocking() {
        Mockito.when((Object)this.accountingPeriodMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)this.journalVoucherDocMock.getAccountingPeriod()).thenReturn((Object)this.accountingPeriodMock);
    }

    @Test
    public void validate_VALID() {
        Assert.assertTrue((boolean)this.cut.validate(null));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void validate_nullAccountingPeriod_INVALID() {
        Mockito.when((Object)this.journalVoucherDocMock.getAccountingPeriod()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.validate(null));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.selectedAccountingPeriod")).get(0);
        Assert.assertEquals((Object)"error.existence", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)1L, (long)errorMessage.getMessageParameters().length);
        Assert.assertEquals((Object)"Accounting Period", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    public void validate_inactiveAccountingPeriod_INVALID() {
        Mockito.when((Object)this.accountingPeriodMock.isActive()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.cut.validate(null));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.selectedAccountingPeriod")).get(0);
        Assert.assertEquals((Object)"error.document.accountingPeriod.closed", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void validate_inactiveAccountingPeriod_A21BalanceType_VALID() {
        Mockito.when((Object)this.journalVoucherDocMock.getBalanceTypeCode()).thenReturn((Object)"A2");
        Mockito.when((Object)this.accountingPeriodMock.isActive()).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.cut.validate(null));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }
}

