/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.LateAdjustment;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.validation.impl.LateAdjustmentValidation;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;

@ConfigureContext
public class LateAdjustmentValidationTest
extends KualiTestBase {
    private LateAdjustmentValidation lateAdjustmentTabValidation;
    private MyAttributedDocumentEvent event;
    private LateAdjustment lateAdjustment;

    public void setUp() throws Exception {
        super.setUp();
        SalaryExpenseTransferDocument stDocument = new SalaryExpenseTransferDocument();
        this.event = new MyAttributedDocumentEvent(stDocument);
        this.lateAdjustmentTabValidation = new LateAdjustmentValidation();
        this.lateAdjustment = new LateAdjustment();
        this.lateAdjustment.setDocumentNumber("1");
        stDocument.setLateAdjustment(this.lateAdjustment);
    }

    public void testPartiallyFullLateAdjustment() {
        this.setUpLateAdjustment(false);
        this.lateAdjustmentTabValidation.validate((AttributedDocumentEvent)this.event);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.lateAdjustment");
        LateAdjustmentValidationTest.assertTrue((String)"Late Adjustment Tab isn't required, but should be.", (boolean)hasError);
    }

    public void testFullLateAdjustment() {
        this.setUpLateAdjustment(true);
        this.lateAdjustmentTabValidation.validate((AttributedDocumentEvent)this.event);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.lateAdjustment");
        LateAdjustmentValidationTest.assertFalse((String)"Unexpected requirement of Late Adjustment Tab.", (boolean)hasError);
    }

    protected void setUpLateAdjustment(boolean isCompleted) {
        if (isCompleted) {
            this.lateAdjustment.setLateAdjustmentReason("test reason");
            this.lateAdjustment.setLateAdjustmentDescription("test desc");
            this.lateAdjustment.setExpenditureDescription("test description");
            this.lateAdjustment.setExpenditureProjectBenefit("test benefit");
        } else {
            this.lateAdjustment.setLateAdjustmentReason("test reason");
            this.lateAdjustment.setLateAdjustmentDescription("test desc");
            this.lateAdjustment.setExpenditureDescription("");
            this.lateAdjustment.setExpenditureProjectBenefit("");
        }
    }

    static class MyAttributedDocumentEvent
    extends AttributedDocumentEventBase {
        MyAttributedDocumentEvent(SalaryExpenseTransferDocument d) {
            super("", "", (Document)d);
        }
    }
}

