/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.util;

import java.util.ArrayList;
import java.util.Properties;
import org.junit.Assert;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.testdata.LaborTestDataPropertyConstants;
import org.kuali.kfs.module.ld.util.LaborLedgerUnitOfWork;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class LaborLedgerUnitOfWorkTest
extends KualiTestBase {
    private LaborOriginEntry laborOriginEntry;
    private LaborLedgerUnitOfWork laborLedgerUnitOfWork;

    public void setUp() throws Exception {
        super.setUp();
        String propertiesFileName = LaborTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/laborLedgerUnitOfWork.properties";
        Properties properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.laborOriginEntry = (LaborOriginEntry)TestDataPreparator.buildTestDataObject(LaborOriginEntry.class, (Properties)properties);
    }

    public void testLaborLedgerUnitOfWork() {
        this.laborLedgerUnitOfWork = new LaborLedgerUnitOfWork(this.laborOriginEntry);
        String charAccountsCode = this.laborLedgerUnitOfWork.getWorkingEntry().getChartOfAccountsCode();
        LaborLedgerUnitOfWorkTest.assertEquals((String)charAccountsCode, (String)this.laborOriginEntry.getChartOfAccountsCode());
    }

    public void testResetLaborLedgerUnitOfWork() {
        this.laborLedgerUnitOfWork = new LaborLedgerUnitOfWork();
        this.laborLedgerUnitOfWork.resetLaborLedgerUnitOfWork(this.laborOriginEntry);
        String charAccountsCode = this.laborLedgerUnitOfWork.getWorkingEntry().getChartOfAccountsCode();
        LaborLedgerUnitOfWorkTest.assertEquals((String)charAccountsCode, (String)this.laborOriginEntry.getChartOfAccountsCode());
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.add("financialObjectCode");
        this.laborLedgerUnitOfWork.resetLaborLedgerUnitOfWork(this.laborOriginEntry, keyList);
        charAccountsCode = this.laborLedgerUnitOfWork.getWorkingEntry().getChartOfAccountsCode();
        Assert.assertNotEquals((Object)charAccountsCode, (Object)this.laborOriginEntry.getChartOfAccountsCode());
        String objectCode = this.laborLedgerUnitOfWork.getWorkingEntry().getFinancialObjectCode();
        LaborLedgerUnitOfWorkTest.assertEquals((String)objectCode, (String)this.laborOriginEntry.getFinancialObjectCode());
    }

    public void testAddEntryIntoUnit() {
        this.laborLedgerUnitOfWork = new LaborLedgerUnitOfWork(this.laborOriginEntry);
        LaborLedgerUnitOfWorkTest.assertEquals((int)1, (int)this.laborLedgerUnitOfWork.getNumOfMember());
        LaborLedgerUnitOfWorkTest.assertTrue((boolean)this.laborLedgerUnitOfWork.addEntryIntoUnit(this.laborOriginEntry));
        LaborLedgerUnitOfWorkTest.assertEquals((int)2, (int)this.laborLedgerUnitOfWork.getNumOfMember());
        LaborLedgerUnitOfWorkTest.assertTrue((boolean)this.laborLedgerUnitOfWork.addEntryIntoUnit(this.laborOriginEntry));
        LaborLedgerUnitOfWorkTest.assertEquals((int)3, (int)this.laborLedgerUnitOfWork.getNumOfMember());
        this.laborOriginEntry.setUniversityFiscalYear(Integer.valueOf(1000));
        LaborLedgerUnitOfWorkTest.assertFalse((boolean)this.laborLedgerUnitOfWork.addEntryIntoUnit(this.laborOriginEntry));
        LaborLedgerUnitOfWorkTest.assertFalse((this.laborLedgerUnitOfWork.getNumOfMember() == 4 ? 1 : 0) != 0);
    }

    public void testCanContain() {
        this.laborLedgerUnitOfWork = new LaborLedgerUnitOfWork();
        LaborLedgerUnitOfWorkTest.assertFalse((boolean)this.laborLedgerUnitOfWork.canContain(this.laborOriginEntry));
        this.laborLedgerUnitOfWork.resetLaborLedgerUnitOfWork(this.laborOriginEntry);
        LaborLedgerUnitOfWorkTest.assertTrue((boolean)this.laborLedgerUnitOfWork.canContain(this.laborOriginEntry));
        this.laborOriginEntry.setUniversityFiscalYear(Integer.valueOf(1000));
        LaborLedgerUnitOfWorkTest.assertFalse((boolean)this.laborLedgerUnitOfWork.canContain(this.laborOriginEntry));
    }

    public void testHasSameKey() {
        this.laborLedgerUnitOfWork = new LaborLedgerUnitOfWork();
        LaborLedgerUnitOfWorkTest.assertFalse((boolean)this.laborLedgerUnitOfWork.hasSameKey(this.laborOriginEntry));
        this.laborLedgerUnitOfWork.resetLaborLedgerUnitOfWork(this.laborOriginEntry);
        LaborLedgerUnitOfWorkTest.assertTrue((boolean)this.laborLedgerUnitOfWork.hasSameKey(this.laborOriginEntry));
        this.laborOriginEntry.setUniversityFiscalYear(Integer.valueOf(1000));
        LaborLedgerUnitOfWorkTest.assertFalse((boolean)this.laborLedgerUnitOfWork.hasSameKey(this.laborOriginEntry));
    }
}

